/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.powergoggles.PowerGogglesMeasurement;
import gregtech.common.powergoggles.handlers.PowerGogglesHudHandler;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import net.minecraft.world.IBlockAccess;

public class GTPacketOverwritePowerGogglesMeasurements
extends GTPacket {
    LinkedList<PowerGogglesMeasurement> measurements;

    public GTPacketOverwritePowerGogglesMeasurements() {
    }

    public GTPacketOverwritePowerGogglesMeasurements(LinkedList<PowerGogglesMeasurement> measurements) {
        this.measurements = measurements;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.OVERWRITE_POWER_GOGGLES_MEASUREMENTS.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.measurements.size());
        for (PowerGogglesMeasurement measurement : this.measurements) {
            buffer.writeBoolean(measurement.isWireless());
            byte[] measurementBytes = measurement.getMeasurement().toByteArray();
            buffer.writeInt(measurementBytes.length);
            buffer.writeBytes(measurementBytes);
            if (measurement.isWireless()) continue;
            buffer.writeLong(measurement.getCapacity());
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        LinkedList<PowerGogglesMeasurement> measurements = new LinkedList<PowerGogglesMeasurement>();
        int measurementCount = buffer.readInt();
        for (int i = 0; i < measurementCount; ++i) {
            boolean isWireless = buffer.readBoolean();
            BigInteger measurement = this.decodeMeasurement(buffer);
            if (isWireless) {
                measurements.add(new PowerGogglesMeasurement(true, measurement));
                continue;
            }
            long capacity = buffer.readLong();
            measurements.add(new PowerGogglesMeasurement(false, measurement, capacity));
        }
        return new GTPacketOverwritePowerGogglesMeasurements(measurements);
    }

    private BigInteger decodeMeasurement(ByteArrayDataInput buffer) {
        int byteCount = buffer.readInt();
        byte[] result = new byte[byteCount];
        for (int i = 0; i < byteCount; ++i) {
            result[i] = buffer.readByte();
        }
        return new BigInteger(result);
    }

    @Override
    public void process(IBlockAccess world) {
        PowerGogglesHudHandler.clear();
        PowerGogglesHudHandler.measurements = new LinkedList(this.measurements.stream().map(PowerGogglesMeasurement::getMeasurement).collect(Collectors.toList()));
        Collections.reverse(PowerGogglesHudHandler.measurements);
        if (!this.measurements.isEmpty()) {
            PowerGogglesHudHandler.capacity = this.measurements.getLast().getCapacity();
        }
        PowerGogglesHudHandler.updateClient = true;
    }
}

