/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.GTMod;
import gregtech.api.enums.ChatMessage;
import gregtech.api.enums.Mods;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.util.GTUtility;
import gregtech.common.config.Client;
import gregtech.common.data.GTPowerfailTracker;
import gregtech.crossmod.navigator.PowerfailLayerManager;
import io.netty.buffer.ByteBuf;
import java.util.Date;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;

public class GTPacketOnPowerfail
extends GTPacket {
    private GTPowerfailTracker.Powerfail powerfail;
    private static boolean printedHelpMessage = false;

    GTPacketOnPowerfail() {
    }

    public GTPacketOnPowerfail(GTPowerfailTracker.Powerfail powerfail) {
        this.powerfail = powerfail.copy();
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.ON_POWERFAIL.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.powerfail.dim);
        buffer.writeInt(this.powerfail.x);
        buffer.writeInt(this.powerfail.y);
        buffer.writeInt(this.powerfail.z);
        buffer.writeInt(this.powerfail.mteId);
        buffer.writeInt(this.powerfail.count);
        buffer.writeLong(this.powerfail.lastOccurrence.getTime());
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        GTPowerfailTracker.Powerfail powerfail = new GTPowerfailTracker.Powerfail();
        powerfail.dim = buffer.readInt();
        powerfail.x = buffer.readInt();
        powerfail.y = buffer.readInt();
        powerfail.z = buffer.readInt();
        powerfail.mteId = buffer.readInt();
        powerfail.count = buffer.readInt();
        powerfail.lastOccurrence = new Date(buffer.readLong());
        return new GTPacketOnPowerfail(powerfail);
    }

    @Override
    public void process(IBlockAccess blockAccess) {
        EntityPlayer player = GTMod.proxy.getThePlayer();
        GTPowerfailTracker.Powerfail previous = (GTPowerfailTracker.Powerfail)GTMod.clientProxy().powerfailRenderer.powerfails.put(this.powerfail.getCoord(), (Object)this.powerfail);
        if (Client.chat.powerfailNotifications && (previous == null || previous.getSecs() > 60.0f)) {
            GTUtility.sendChatToPlayer(player, this.powerfail.toDescription().toString());
            if (Client.chat.printPowerfailHelpText && !printedHelpMessage) {
                printedHelpMessage = true;
                Client.save();
                ChatMessage.PowerfailCommandHint.send(player, new Object[0]);
            }
        }
        if (Mods.Navigator.isModLoaded()) {
            PowerfailLayerManager.INSTANCE.clearFullCache();
        }
    }
}

