/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.casing;

import gregtech.api.casing.ICasing;

public interface ICasingGroup {
    public static ICasingGroup ofCasing(ICasing casing) {
        return new AllCasingsOfType(casing);
    }

    public static ICasingGroup ofCharacter(char c) {
        return new SpecificCasingChar(c);
    }

    public static final class AllCasingsOfType
    implements ICasingGroup {
        private final ICasing casing;

        public AllCasingsOfType(ICasing casing) {
            this.casing = casing;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AllCasingsOfType)) {
                return false;
            }
            AllCasingsOfType other = (AllCasingsOfType)obj;
            return this.casing == other.casing;
        }

        public String toString() {
            return "AllCasingsOfType[" + "casing=" + this.casing + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.casing != null ? this.casing.hashCode() : 0);
            return result;
        }

        public ICasing casing() {
            return this.casing;
        }
    }

    public static final class SpecificCasingChar
    implements ICasingGroup {
        private final char c;

        public SpecificCasingChar(char c) {
            this.c = c;
        }

        public int hashCode() {
            return Character.hashCode(this.c);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpecificCasingChar)) {
                return false;
            }
            SpecificCasingChar other = (SpecificCasingChar)obj;
            return this.c == other.c;
        }

        public String toString() {
            return "SpecificCasingChar[" + "c=" + this.c + "]";
        }

        public char c() {
            return this.c;
        }
    }
}

