/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.pipe;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import it.unimi.dsi.fastutil.ints.IntBooleanPair;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tectech.loader.NetworkDispatcher;
import tectech.mechanics.pipe.BatchedPipeActivityMessage;
import tectech.mechanics.pipe.IActivePipe;

public class PipeActivity {
    public static final PipeActivity INSTANCE = new PipeActivity();
    private static final Map<IntBooleanPair, LongArrayList> updates = new HashMap<IntBooleanPair, LongArrayList>();
    private static final Function<IntBooleanPair, LongArrayList> CTOR = x -> new LongArrayList();
    private static final int MAX_UPDATES_PER_PACKET = 3750;

    private PipeActivity() {
    }

    public static synchronized <TPipe extends IMetaTileEntity & IActivePipe> void enqueueUpdate(TPipe pipe) {
        IGregTechTileEntity base = pipe.getBaseMetaTileEntity();
        if (base != null && !base.isDead()) {
            PipeActivity.enqueueUpdate(base.getWorld(), base.getXCoord(), base.getYCoord(), base.getZCoord(), ((IActivePipe)pipe).getActive());
        }
    }

    public static synchronized void enqueueUpdate(World world, int x, int y, int z, boolean isActive) {
        LongArrayList coords = updates.computeIfAbsent(IntBooleanPair.of((int)world.field_73011_w.field_76574_g, (boolean)isActive), CTOR);
        coords.add(CoordinatePacker.pack((int)x, (int)y, (int)z));
    }

    public static synchronized void sendUpdates() {
        Iterator<Map.Entry<IntBooleanPair, LongArrayList>> iter = updates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<IntBooleanPair, LongArrayList> e = iter.next();
            int worldId = e.getKey().leftInt();
            boolean isActive = e.getKey().rightBoolean();
            LongArrayList coords = e.getValue();
            for (int i = 0; i < coords.size(); i += 3750) {
                LongList forPacket = coords.subList(i, Math.min(coords.size(), i + 3750));
                BatchedPipeActivityMessage message = new BatchedPipeActivityMessage();
                message.worldId = worldId;
                message.isActive = isActive;
                message.pipes = forPacket.toLongArray();
                NetworkDispatcher.INSTANCE.sendToDimension(message, worldId);
            }
            iter.remove();
        }
    }

    public static void init() {
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent tickEvent) {
        if (tickEvent.side == Side.SERVER && tickEvent.type == TickEvent.Type.SERVER && tickEvent.phase == TickEvent.Phase.END) {
            PipeActivity.sendUpdates();
        }
    }

    public static class Handler
    extends AbstractClientMessageHandler<BatchedPipeActivityMessage> {
        public IMessage handleClientMessage(EntityPlayer player, BatchedPipeActivityMessage message, MessageContext ctx) {
            World world = player.field_70170_p;
            if (message.worldId != world.field_73011_w.field_76574_g) {
                return null;
            }
            Integer lastChunkX = null;
            Integer lastChunkZ = null;
            for (long coord : message.pipes) {
                IGregTechTileEntity igte;
                IMetaTileEntity iMetaTileEntity;
                TileEntity tileEntity;
                int x = CoordinatePacker.unpackX((long)coord);
                int y = CoordinatePacker.unpackY((long)coord);
                int z = CoordinatePacker.unpackZ((long)coord);
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                if (!Objects.equals(chunkX, lastChunkX) || !Objects.equals(chunkZ, lastChunkZ)) {
                    if (!world.func_72863_F().func_73149_a(chunkX, chunkZ)) continue;
                    lastChunkX = chunkX;
                    lastChunkZ = chunkZ;
                }
                if (!((tileEntity = world.func_147438_o(x, y, z)) instanceof IGregTechTileEntity) || !((iMetaTileEntity = (igte = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof IActivePipe)) continue;
                IActivePipe pipe = (IActivePipe)iMetaTileEntity;
                pipe.setActive(message.isActive);
            }
            return null;
        }
    }
}

