/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.event.RitualRunEvent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectWellOfSuffering;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.kuba6000.mobsinfo.api.utils.FastRandom;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.GTStructureChannels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import kubatech.api.gui.KubaTechUITextures;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.api.tileentity.CustomTileEntityPacketHandler;
import kubatech.api.utils.ModUtils;
import kubatech.client.effect.EntityRenderer;
import kubatech.config.Config;
import kubatech.loaders.MobHandlerLoader;
import kubatech.network.CustomTileEntityPacket;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MTEExtremeEntityCrusher
extends KubaTechGTMultiBlockBase<MTEExtremeEntityCrusher>
implements CustomTileEntityPacketHandler,
ISurvivalConstructable {
    public static final int MOB_SPAWN_INTERVAL = 55;
    public static final int MAX_LOOTING_LEVEL = 4;
    public static final double DIAMOND_SPIKES_DAMAGE = 9.0;
    public final Random rand = new FastRandom();
    private final WeaponCache weaponCache = new WeaponCache(this.mInventory);
    private EECEventHandler eventHandler;
    private static final String WellOfSufferingRitualName = "AW013Suffering";
    private static final Item poweredSpawnerItem = Item.func_150898_a((Block)EnderIO.blockPoweredSpawner);
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEExtremeEntityCrusher> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "gsssg", "gsssg", "gsssg", "fgggf"}, {"CC~CC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement('c', StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0))).addElement('C', GTStructureUtility.buildHatchAdder(MTEExtremeEntityCrusher.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy, HatchElement.Maintenance).casingIndex(16).dot(1).buildAndChain(StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)))).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('f', GTStructureUtility.ofFrame(Materials.Steel)).addElement('s', Mods.ExtraUtilities.isModLoaded() ? StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ExtraUtilities:spike_base_diamond"), (int)0) : StructureUtility.isAir()).build();
    private static final int[][] VALID_RITUAL_POSITIONS = new int[][]{{0, -8, 2}, {0, -7, 2}};
    private TileEntity masterStoneRitual = null;
    private TileEntity tileAltar = null;
    private boolean isInRitualMode = false;
    private int mCasing = 0;
    private int glassTier = -1;
    private boolean mAnimationEnabled = true;
    private boolean mIsProducingInfernalDrops = true;
    private boolean voidAllDamagedAndEnchantedItems = false;
    private boolean mPreserveWeapon;
    private boolean mCycleWeapons;
    private boolean mIsRitualValid;
    private boolean mIsPreventingGUIWeaponUse;
    private EntityRenderer entityRenderer = null;
    private boolean renderEntity = false;
    public EECFakePlayer EECPlayer = null;
    private CustomTileEntityPacket mobPacket = null;

    public MTEExtremeEntityCrusher(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEExtremeEntityCrusher(String aName) {
        super(aName);
        if (Mods.BloodMagic.isModLoaded() && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.eventHandler = new EECEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        }
    }

    @Override
    public void onRemoval() {
        if (this.eventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.eventHandler);
        }
        if (this.getBaseMetaTileEntity().isClientSide() && this.entityRenderer != null) {
            this.entityRenderer.func_70106_y();
        }
    }

    @Override
    public void onUnload() {
        if (this.eventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.eventHandler);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isInRitualMode", this.isInRitualMode);
        aNBT.func_74757_a("mAnimationEnabled", this.mAnimationEnabled);
        aNBT.func_74757_a("mIsProducingInfernalDrops", this.mIsProducingInfernalDrops);
        aNBT.func_74757_a("voidAllDamagedAndEnchantedItems", this.voidAllDamagedAndEnchantedItems);
        aNBT.func_74757_a("mPreserveWeapon", this.mPreserveWeapon);
        aNBT.func_74757_a("mCycleWeapons", this.mCycleWeapons);
        if (this.weaponCache.getStackInSlot(0) != null) {
            aNBT.func_74782_a("weaponCache", (NBTBase)this.weaponCache.getStackInSlot(0).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isInRitualMode = aNBT.func_74767_n("isInRitualMode");
        this.mAnimationEnabled = !aNBT.func_74764_b("mAnimationEnabled") || aNBT.func_74767_n("mAnimationEnabled");
        this.mIsProducingInfernalDrops = !aNBT.func_74764_b("mIsProducingInfernalDrops") || aNBT.func_74767_n("mIsProducingInfernalDrops");
        this.voidAllDamagedAndEnchantedItems = aNBT.func_74767_n("voidAllDamagedAndEnchantedItems");
        this.mPreserveWeapon = aNBT.func_74767_n("mPreserveWeapon");
        boolean bl = this.mCycleWeapons = !aNBT.func_74764_b("mCycleWeapons") || aNBT.func_74767_n("mCycleWeapons");
        if (aNBT.func_74764_b("weaponCache")) {
            this.weaponCache.setStackInSlot(0, ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("weaponCache")));
        }
    }

    @Override
    public boolean isOverclockingInfinite() {
        return true;
    }

    @Override
    protected int getOverclockTimeLimit() {
        return (this.batchMode ? 16 : 1) * 20;
    }

    @Override
    public IStructureDefinition<MTEExtremeEntityCrusher> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Powered Spawner, EEC").addInfo("Spawns and kills monsters for you!").addInfo("Produces " + EnumChatFormatting.GREEN + "120 Liquid XP" + EnumChatFormatting.GRAY + " per operation").addInfo("Powered Spawner goes in Controller Slot").addInfo("Base energy usage: " + EnumChatFormatting.AQUA + "1920" + EnumChatFormatting.GRAY + " EU/t").addInfo("Supports " + EnumChatFormatting.LIGHT_PURPLE + "perfect OC!").addSeparator().addInfo("Has a minimum recipe time of 20 ticks, further overclocks multiply outputs by 4x").addInfo("Recipe time is based on mob health").addInfo("You can additionally put a weapon inside the GUI").addInfo("It will speed up the process and apply the looting level from the weapon (maximum 4 levels)").addInfo("Enable Weapon Preservation to prevent the weapon from breaking on it's last hit").addInfo("Enable Weapon Cycling to pull a weapon from input when the current one breaks or is moved to an output").addInfo(EnumChatFormatting.RED + "Enchanting the spikes inside the structure does nothing!").addSeparator().addInfo("If the mob spawns " + EnumChatFormatting.RED + "infernal" + EnumChatFormatting.GRAY + ", it will drain 8 times more power!").addInfo("You can prevent " + EnumChatFormatting.RED + "infernal" + EnumChatFormatting.GRAY + " spawns by shift clicking with a screwdriver").addInfo("Mobs who are always " + EnumChatFormatting.RED + "infernal" + EnumChatFormatting.GRAY + " will ignore this factor").addSeparator().addInfo("You can enable ritual mode with a screwdriver").addInfo("When in ritual mode, can link to above Well of Suffering rituals").addInfo("The Ritual must be built directly centered above the machine").addInfo("When linked, mobs will start to buffer and die very slowly, providing blood to the linked altar").addSeparator().addInfo("You can disable mob animation with a soldering iron").addInfo("You can enable batch mode with wire cutters. Providing " + EnumChatFormatting.BLUE + " 16x Time, Output, Weapon Damage").addGlassEnergyLimitInfo(8).beginStructureBlock(5, 7, 5, true).addController("Front Bottom Center").addCasingInfoMin("Solid Steel Machine Casing", 35, false).addCasingInfoExactly("Any Tiered Glass", 60, false).addCasingInfoExactly("Steel Frame Box", 20, false).addCasingInfoExactly("Diamond Spike", 9, false).addOutputBus("Any bottom casing", 1).addOutputHatch("Any bottom casing", 1).addEnergyHatch("Any bottom casing", 1).addMaintenanceHatch("Any bottom casing", 1).addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(GTValues.AuthorKuba);
        return tt;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 6, 0, elementBudget, env, true, true);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEExtremeEntityCrusher(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16)};
    }

    @SideOnly(value=Side.CLIENT)
    private void setupEntityRenderer(IGregTechTileEntity aBaseMetaTileEntity, int time) {
        if (this.entityRenderer == null) {
            ChunkCoordinates coords = this.getBaseMetaTileEntity().getCoords();
            int[] abc = new int[]{0, -2, 2};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + coords.field_71574_a;
            xyz[1] = xyz[1] + coords.field_71572_b;
            xyz[2] = xyz[2] + coords.field_71573_c;
            this.entityRenderer = new EntityRenderer(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], time);
        } else {
            this.entityRenderer.func_70106_y();
            this.entityRenderer = new EntityRenderer(this.entityRenderer, time);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)this.entityRenderer);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.renderEntity && aBaseMetaTileEntity.isActive() && aTick % 40L == 0L) {
            this.setupEntityRenderer(aBaseMetaTileEntity, 40);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void HandleCustomPacket(CustomTileEntityPacket message) {
        if (message.getDataBoolean() && Mods.MobsInfo.isModLoaded()) {
            this.renderEntity = true;
            String mobType = message.getDataString();
            MobHandlerLoader.MobEECRecipe r = MobHandlerLoader.recipeMap.get(mobType);
            if (r != null) {
                if (this.entityRenderer == null) {
                    this.setupEntityRenderer(this.getBaseMetaTileEntity(), 40);
                }
                this.entityRenderer.setEntity(r.entityCopy);
            } else {
                this.entityRenderer.setEntity(null);
            }
        } else {
            this.renderEntity = false;
            if (this.entityRenderer != null) {
                this.entityRenderer.func_70106_y();
                this.entityRenderer = null;
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"kubatech.chat.forbidden_while_running"));
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (!Mods.InfernalMobs.isModLoaded()) {
                return;
            }
            this.mIsProducingInfernalDrops = !this.mIsProducingInfernalDrops;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("kubatech.chat.eec.infernal_drops_" + (this.mIsProducingInfernalDrops ? "enabled" : "disabled"))));
        } else {
            if (!Mods.BloodMagic.isModLoaded()) {
                return;
            }
            this.isInRitualMode = !this.isInRitualMode;
            this.checkRitualConnection();
            if (!this.isInRitualMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"kubatech.chat.eec.ritual_mode_disabled"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"kubatech.chat.eec.ritual_mode_enabled"));
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("kubatech.chat.eec.ritual_mode_" + (this.mIsRitualValid ? "connected" : "error"))));
            }
        }
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (wrenchingSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mAnimationEnabled = !this.mAnimationEnabled;
            GTUtility.sendChatToPlayer(aPlayer, "Animations are " + (this.mAnimationEnabled ? "enabled" : "disabled"));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.batchMode = !this.batchMode;
        GTUtility.sendChatToPlayer(aPlayer, "Batch Mode: " + (this.batchMode ? "Enabled" : "Disabled"));
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex >= 0;
    }

    @Override
    public void onSetActive(boolean active) {
        super.onSetActive(active);
        if (active) {
            return;
        }
        this.checkRitualConnection();
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        MobHandlerLoader.MobEECRecipe recipe;
        if (this.getBaseMetaTileEntity().isClientSide()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.mIsPreventingGUIWeaponUse = false;
        ItemStack aStack = this.mInventory[1];
        if (aStack == null) {
            return SimpleCheckRecipeResult.ofFailure("EEC_nospawner");
        }
        if (aStack.func_77973_b() != poweredSpawnerItem) {
            return SimpleCheckRecipeResult.ofFailure("EEC_nospawner");
        }
        if (aStack.func_77978_p() == null) {
            return SimpleCheckRecipeResult.ofFailure("EEC_invalidspawner");
        }
        String mobType = aStack.func_77978_p().func_74779_i("mobType");
        if (mobType.isEmpty()) {
            return SimpleCheckRecipeResult.ofFailure("EEC_invalidspawner");
        }
        if (mobType.equals("Skeleton") && this.getBaseMetaTileEntity().getWorld().field_73011_w instanceof WorldProviderHell && this.rand.nextInt(5) > 0) {
            mobType = "witherSkeleton";
        }
        if ((recipe = MobHandlerLoader.recipeMap.get(mobType)) == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (!recipe.recipe.isPeacefulAllowed && this.getBaseMetaTileEntity().getWorld().field_73013_u == EnumDifficulty.PEACEFUL && !Config.MobHandler.ignorePeacefulCheck) {
            return SimpleCheckRecipeResult.ofFailure("EEC_peaceful");
        }
        if (this.checkRitualConnection()) {
            if (this.getMaxInputEu() < (long)(recipe.mEUt / 4)) {
                return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt / 4);
            }
            this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"xpjuice", (int)5000)};
            this.mOutputItems = recipe.generateOutputs(this.rand, this, 3.0, 0, this.mIsProducingInfernalDrops, this.voidAllDamagedAndEnchantedItems);
            this.lEUt /= 4L;
            this.mMaxProgresstime = 400;
        } else {
            Objects.requireNonNull(recipe);
            long tRecipeEUt = 1920L;
            if (recipe.recipe.alwaysinfernal) {
                tRecipeEUt *= 8L;
            }
            if (this.getMaxInputEu() < tRecipeEUt) {
                return CheckRecipeResultRegistry.insufficientPower(tRecipeEUt);
            }
            double tAttackDamage = 9.0;
            int tLootingLevel = 0;
            int tBatchMultiplier = this.batchMode ? 16 : 1;
            int tMaxTries = 2;
            ItemStack tWeaponToUse = this.cycleWeaponsUntilNoBreakage(recipe, tBatchMultiplier, 2);
            if (this.mCycleWeapons && this.weaponCache.getStackInSlot(0) == null) {
                this.moveWeaponFromInputToCache();
            }
            ItemStack tWeaponInCache = this.weaponCache.getStackInSlot(0);
            if (tWeaponToUse != null) {
                if (tWeaponToUse == tWeaponInCache) {
                    tAttackDamage += this.weaponCache.attackDamage;
                    tLootingLevel += this.weaponCache.looting;
                } else {
                    tAttackDamage += MTEExtremeEntityCrusher.getWeaponAttackDamage(tWeaponToUse);
                    tLootingLevel += MTEExtremeEntityCrusher.getWeaponLooting(tWeaponToUse);
                }
            } else if (tWeaponInCache != null) {
                this.mIsPreventingGUIWeaponUse = true;
            }
            if (this.EECPlayer == null) {
                this.EECPlayer = new EECFakePlayer(this);
            }
            this.EECPlayer.currentWeapon = tWeaponToUse;
            this.mOutputItems = recipe.generateOutputs(this.rand, this, tAttackDamage, Math.min(tLootingLevel, 4), this.mIsProducingInfernalDrops, this.voidAllDamagedAndEnchantedItems);
            this.EECPlayer.currentWeapon = null;
            if (this.batchMode) {
                for (ItemStack item : this.mOutputItems) {
                    item.field_77994_a *= tBatchMultiplier;
                }
            }
            this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"xpjuice", (int)(120 * tBatchMultiplier))};
            this.mMaxProgresstime *= tBatchMultiplier;
            this.calculatePerfectOverclock(this.lEUt, this.mMaxProgresstime);
        }
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mobPacket == null) {
            this.mobPacket = new CustomTileEntityPacket((TileEntity)this.getBaseMetaTileEntity(), null);
        }
        this.mobPacket.resetHelperData();
        this.mobPacket.addData(this.mAnimationEnabled);
        if (this.mAnimationEnabled) {
            this.mobPacket.addData(mobType);
        }
        this.mobPacket.sendToAllAround(16);
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private ItemStack cycleWeaponsUntilNoBreakage(MobHandlerLoader.MobEECRecipe aRecipe, int aBatchModeMultiplier, int aMaxTries) {
        int tBusCount = this.mInputBusses.size();
        int tCurrentInputBus = 0;
        int tCurrentInputBusSlot = 0;
        ItemStack tWeapon = this.weaponCache.getStackInSlot(0);
        if (!this.weaponCache.isValid) {
            if (!this.mCycleWeapons) {
                return null;
            }
            --aMaxTries;
        }
        for (int i = 0; i < aMaxTries; ++i) {
            ItemStack tWeaponResult;
            if (!this.weaponCache.isValid) {
                if (tBusCount == 0) {
                    return null;
                }
                for (int tBusIndex = tCurrentInputBus; tBusIndex < tBusCount; ++tBusIndex) {
                    MTEHatchInputBus tBus = (MTEHatchInputBus)this.mInputBusses.get(tBusIndex);
                    for (int tSlotIndex = tCurrentInputBusSlot; tSlotIndex < tBus.mInventory.length; ++tSlotIndex) {
                        ItemStack tItem;
                        ++tCurrentInputBusSlot;
                        if (!tBus.isValidSlot(tSlotIndex) || (tItem = tBus.mInventory[tSlotIndex]) == null || tItem.field_77994_a == 0 || !MTEExtremeEntityCrusher.isUsableWeapon(tItem)) continue;
                        tWeapon = tItem;
                        this.weaponCache.setStackInSlot(0, tItem);
                        tBus.mInventory[tSlotIndex] = null;
                        break;
                    }
                    if (this.weaponCache.isValid) break;
                    tCurrentInputBusSlot = 0;
                    ++tCurrentInputBus;
                }
                if (!this.weaponCache.isValid) {
                    this.weaponCache.setStackInSlot(0, null);
                    return null;
                }
            }
            if ((tWeaponResult = this.runWeaponHitSimulation(tWeapon, aRecipe.recipe.entity, aBatchModeMultiplier, this.mPreserveWeapon)) != null) {
                this.weaponCache.setStackInSlot(0, tWeaponResult);
                return tWeaponResult;
            }
            if (!this.mPreserveWeapon) {
                this.weaponCache.setStackInSlot(0, null);
                this.playWeaponBreakSound();
                return tWeapon;
            }
            if (!this.mCycleWeapons || !this.addOutputPartial(tWeapon, false)) {
                return null;
            }
            this.weaponCache.setStackInSlot(0, null);
            tWeapon = null;
        }
        return null;
    }

    private ItemStack runWeaponHitSimulation(ItemStack aWeapon, EntityLiving aTarget, int aBatchModeMultiplier, boolean aPreventPerfectUnbreaking) {
        if (aWeapon == null || !aWeapon.func_77984_f()) {
            return aWeapon;
        }
        if (this.EECPlayer == null) {
            this.EECPlayer = new EECFakePlayer(this);
        }
        ItemStack tWeaponCopy = aWeapon.func_77946_l();
        Item tItem = tWeaponCopy.func_77973_b();
        this.EECPlayer.currentWeapon = tWeaponCopy;
        for (int i = 0; i < aBatchModeMultiplier; ++i) {
            if (aPreventPerfectUnbreaking && tWeaponCopy.func_77960_j() == tWeaponCopy.func_77958_k()) {
                this.EECPlayer.currentWeapon = null;
                return null;
            }
            if (!tItem.func_77644_a(tWeaponCopy, (EntityLivingBase)aTarget, (EntityLivingBase)this.EECPlayer)) break;
            if (tWeaponCopy.field_77994_a != 0) continue;
            this.EECPlayer.currentWeapon = null;
            return null;
        }
        this.EECPlayer.currentWeapon = null;
        return tWeaponCopy;
    }

    private void moveWeaponFromInputToCache() {
        if (this.weaponCache.isValid) {
            return;
        }
        for (MTEHatchInputBus tBus : this.mInputBusses) {
            for (int tSlotIndex = 0; tSlotIndex < tBus.mInventory.length; ++tSlotIndex) {
                ItemStack tItem;
                if (!tBus.isValidSlot(tSlotIndex) || (tItem = tBus.mInventory[tSlotIndex]) == null || tItem.field_77994_a == 0 || !MTEExtremeEntityCrusher.isUsableWeapon(tItem)) continue;
                this.weaponCache.setStackInSlot(0, tItem);
                tBus.mInventory[tSlotIndex] = null;
                return;
            }
        }
    }

    private static boolean isUsableWeapon(ItemStack aWeapon) {
        return Enchantment.field_77335_o.func_92089_a(aWeapon);
    }

    private static double getWeaponAttackDamage(ItemStack aWeapon) {
        return aWeapon.func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).stream().mapToDouble(attr -> attr.func_111164_d() + (double)EnchantmentHelper.func_152377_a((ItemStack)aWeapon, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)).sum();
    }

    private static int getWeaponLooting(ItemStack aWeapon) {
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)aWeapon);
    }

    private void playWeaponBreakSound() {
        IGregTechTileEntity tMTE = this.getBaseMetaTileEntity();
        if (tMTE == null || tMTE.isMuffled()) {
            return;
        }
        GTUtility.sendSoundToPlayers(tMTE.getWorld(), SoundResource.RANDOM_BREAK, 0.5f, 0.9f, tMTE.getXCoord(), (int)tMTE.getYCoord(), tMTE.getZCoord());
    }

    private boolean checkRitualConnection() {
        this.mIsRitualValid = this.isInRitualMode && this.connectToRitual();
        return this.mIsRitualValid;
    }

    private boolean connectToRitual() {
        if (this.masterStoneRitual == null) {
            if (!Mods.BloodMagic.isModLoaded()) {
                return false;
            }
            for (int[] ritualRelativePos : VALID_RITUAL_POSITIONS) {
                this.masterStoneRitual = this.getTileEntityAtRelativePosition(ritualRelativePos);
                if (!MTEExtremeEntityCrusher.isWellOfSufferingRitual(this.masterStoneRitual)) continue;
                return true;
            }
        } else if (Mods.BloodMagic.isModLoaded() && MTEExtremeEntityCrusher.isWellOfSufferingRitual(this.masterStoneRitual)) {
            return true;
        }
        this.masterStoneRitual = null;
        return false;
    }

    @Nullable
    private TileEntity getTileEntityAtRelativePosition(int @NotNull [] relativePosition) {
        if (relativePosition.length < 3) {
            return null;
        }
        int[] relativeCoords = new int[]{0, 0, 0};
        this.getExtendedFacing().getWorldOffset(relativePosition, relativeCoords);
        ChunkCoordinates worldCoords = this.getBaseMetaTileEntity().getCoords();
        return this.getBaseMetaTileEntity().getTileEntity(worldCoords.field_71574_a + relativeCoords[0], worldCoords.field_71572_b + relativeCoords[1], worldCoords.field_71573_c + relativeCoords[2]);
    }

    private static boolean isWellOfSufferingRitual(@Nullable TileEntity tileEntity) {
        TEMasterStone ritualTE;
        return tileEntity != null && !tileEntity.func_145837_r() && tileEntity instanceof TEMasterStone && (ritualTE = (TEMasterStone)tileEntity).getCurrentRitual().equals(WellOfSufferingRitualName);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glassTier = -1;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 6, 0)) {
            return false;
        }
        if (this.mCasing < 35 || this.mEnergyHatches.isEmpty()) {
            return false;
        }
        if (this.glassTier < 8) {
            for (MTEHatchEnergy hatch : this.mEnergyHatches) {
                if (hatch.mTier <= this.glassTier) continue;
                return false;
            }
        }
        this.checkRitualConnection();
        return true;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.widget(new TextWidget().setTextSupplier(() -> this.mIsRitualValid ? new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.eec.ritual_mode_connected")).color(Color.WHITE.normal) : new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.eec.ritual_mode_error")).color(Color.RED.dark(3))).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.isInRitualMode));
        screenElements.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.isInRitualMode, val -> {
            this.isInRitualMode = val;
        }));
        screenElements.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mIsRitualValid, val -> {
            this.mIsRitualValid = val;
        }));
        screenElements.widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.eec.preserve_weapon_warning"))).setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.YELLOW).setEnabled(widget -> this.mIsPreventingGUIWeaponUse && !this.isInRitualMode && this.mMaxProgresstime > 0));
        screenElements.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mIsPreventingGUIWeaponUse, val -> {
            this.mIsPreventingGUIWeaponUse = val;
        }));
        super.drawTexts(screenElements, inventorySlot);
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        String mobName = this.getCurrentMob();
        info.add(mobName != null ? StatCollector.func_74837_a((String)"kubatech.infodata.eec.current_mob", (Object[])new Object[]{mobName}) : StatCollector.func_74838_a((String)"kubatech.infodata.eec.current_mob.none"));
        info.add(this.mAnimationEnabled ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.animations.enabled") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.animations.disabled"));
        info.add(this.mIsProducingInfernalDrops ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.produce_infernal_drops.allowed") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.produce_infernal_drops.not_allowed"));
        info.add(this.voidAllDamagedAndEnchantedItems ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.void_damaged.yes") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.void_damaged.no"));
        info.add(this.isInRitualMode ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.in_ritual_mode.yes") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.in_ritual_mode.no"));
        if (this.isInRitualMode) {
            info.add(this.mIsRitualValid ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.connected_to_ritual.yes") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.connected_to_ritual.no"));
        } else {
            info.add(this.mCycleWeapons ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.cycle_weapons.yes") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.cycle_weapons.no"));
            info.add(this.mPreserveWeapon ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.weapon_preservation.yes") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.weapon_preservation.no"));
            info.add(this.weaponCache.isValid ? StatCollector.func_74838_a((String)"kubatech.infodata.eec.inserted_weapon.yes") : StatCollector.func_74838_a((String)"kubatech.infodata.eec.inserted_weapon.no"));
            double tAttackDamage = 9.0;
            if (this.weaponCache.isValid) {
                tAttackDamage += this.weaponCache.attackDamage;
                info.add(StatCollector.func_74837_a((String)"kubatech.infodata.eec.weapon.damage", (Object[])new Object[]{this.weaponCache.attackDamage}));
                info.add(StatCollector.func_74837_a((String)"kubatech.infodata.eec.weapon.looting_level", (Object[])new Object[]{this.weaponCache.looting}));
            }
            info.add(StatCollector.func_74837_a((String)"kubatech.infodata.eec.total_damage", (Object[])new Object[]{tAttackDamage}));
        }
        return info.toArray(new String[0]);
    }

    @Override
    protected void addConfigurationWidgets(DynamicPositionedRow configurationElements, UIBuildContext buildContext) {
        configurationElements.setSynced(true);
        CycleButtonWidget tWidgetPreserveWeapon = MTEExtremeEntityCrusher.createEECSimpleWidget((IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_WEAPON_PRESERVATION_ON, (IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_WEAPON_PRESERVATION_OFF);
        configurationElements.widget(tWidgetPreserveWeapon.setToggle(() -> this.mPreserveWeapon, v -> {
            this.mPreserveWeapon = v;
            tWidgetPreserveWeapon.notifyTooltipChange();
        }).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74838_a((String)("kubatech.gui.text.eec.preserve_weapon" + (this.mPreserveWeapon ? "_on" : "_off"))))));
        CycleButtonWidget tWidgetCycleWeapons = MTEExtremeEntityCrusher.createEECSimpleWidget((IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_WEAPON_CYCLING_ON, (IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_WEAPON_CYCLING_OFF);
        configurationElements.widget(tWidgetCycleWeapons.setToggle(() -> this.mCycleWeapons, v -> {
            this.mCycleWeapons = v;
            tWidgetCycleWeapons.notifyTooltipChange();
        }).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74838_a((String)("kubatech.gui.text.eec.cycle_weapons" + (this.mCycleWeapons ? "_on" : "_off"))))).addTooltip(new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.eec.cycle_weapons.info")).color(Color.GRAY.normal)));
        EECMachineStatusWidget tWidgetVoidDamagedAndEnchanted = this.createEECMachineStatusWidget((IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_VOID_DAMAGED_AND_ENCHANTED_ON, (IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_VOID_DAMAGED_AND_ENCHANTED_OFF);
        configurationElements.widget(tWidgetVoidDamagedAndEnchanted.setToggle(() -> this.voidAllDamagedAndEnchantedItems, v -> {
            if (this.mMaxProgresstime > 0) {
                return;
            }
            this.voidAllDamagedAndEnchantedItems = v;
            tWidgetVoidDamagedAndEnchanted.notifyTooltipChange();
        }).dynamicTooltip(this.createNoChangeWhenRunningTooltip("kubatech.gui.text.eec.void_all_damaged", () -> this.voidAllDamagedAndEnchantedItems)).addTooltip(new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.eec.void_all_damaged.warning")).color(Color.GRAY.normal)));
        EECMachineStatusWidget tWidgetAllowInfernals = this.createEECMachineStatusWidget((IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_SPAWN_INFERNALS_ON, (IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_SPAWN_INFERNALS_OFF);
        configurationElements.widget(tWidgetAllowInfernals.setToggle(() -> this.mIsProducingInfernalDrops, v -> {
            if (this.mMaxProgresstime > 0) {
                return;
            }
            this.mIsProducingInfernalDrops = v;
            tWidgetAllowInfernals.notifyTooltipChange();
        }).dynamicTooltip(this.createNoChangeWhenRunningTooltip("kubatech.gui.text.eec.infernal_drop", () -> this.mIsProducingInfernalDrops)).addTooltip(new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.eec.infernal_drop_always")).color(Color.GRAY.normal)));
        EECMachineStatusWidget tWidgetRitualMode = this.createEECMachineStatusWidget((IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_RITUAL_MODE_ON, (IDrawable)KubaTechUITextures.OVERLAY_BUTTON_EEC_RITUAL_MODE_OFF);
        configurationElements.widget(tWidgetRitualMode.setToggle(() -> this.isInRitualMode, v -> {
            if (this.mMaxProgresstime > 0) {
                return;
            }
            this.isInRitualMode = v;
            this.checkRitualConnection();
            tWidgetRitualMode.notifyTooltipChange();
        }).dynamicTooltip(this.createNoChangeWhenRunningTooltip("kubatech.gui.text.eec.ritual_mode", () -> this.isInRitualMode)));
    }

    private static CycleButtonWidget createEECSimpleWidget(IDrawable aOnTex, IDrawable aOffTex) {
        CycleButtonWidget tButton = new CycleButtonWidget();
        tButton.setTextureGetter(val -> val == 0 ? aOffTex : aOnTex).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(16, 16).setTooltipShowUpDelay(5);
        return tButton;
    }

    private EECMachineStatusWidget createEECMachineStatusWidget(IDrawable aOnTex, IDrawable aOffTex) {
        EECMachineStatusWidget tButton = new EECMachineStatusWidget(this, aOnTex, aOffTex);
        tButton.setSize(16, 16).setTooltipShowUpDelay(5);
        return tButton;
    }

    private Supplier<List<String>> createNoChangeWhenRunningTooltip(String aTooltipLocPrefix, Supplier<Boolean> aStatusGetter) {
        return () -> {
            String tTooltipTitle = StatCollector.func_74838_a((String)(aTooltipLocPrefix + ((Boolean)aStatusGetter.get() != false ? "_on" : "_off")));
            if (this.mMaxProgresstime <= 0) {
                return ImmutableList.of((Object)tTooltipTitle);
            }
            return ImmutableList.of((Object)tTooltipTitle, (Object)(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden_while_running")));
        };
    }

    @Override
    public void createInventorySlots() {
        SlotWidget spawnerSlot = new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1);
        spawnerSlot.setBackground(new IDrawable[]{GTUITextures.SLOT_DARK_GRAY, KubaTechUITextures.SLOT_EEC_SPAWNER.withFixedSize(16.0f, 16.0f).withOffset(1.0f, 1.0f)});
        spawnerSlot.setFilter(stack -> stack.func_77973_b() == poweredSpawnerItem);
        this.slotWidgets.add(spawnerSlot);
        SlotWidget weaponSlot = new SlotWidget((IItemHandlerModifiable)this.weaponCache, 0);
        weaponSlot.setBackground(new IDrawable[]{GTUITextures.SLOT_DARK_GRAY, KubaTechUITextures.SLOT_EEC_SWORD.withFixedSize(16.0f, 16.0f).withOffset(1.0f, 1.0f)});
        this.slotWidgets.add(weaponSlot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_EXTREME_ENTITY_CRUSHER_LOOP;
    }

    private String getCurrentMob() {
        ItemStack spawner = this.mInventory[1];
        if (spawner != null && spawner.func_77978_p() != null) {
            return spawner.func_77978_p().func_74779_i("mobType");
        }
        return null;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        String mob = this.getCurrentMob();
        if (mob != null) {
            tag.func_74778_a("eecMobType", mob);
        }
        if (this.isInRitualMode) {
            tag.func_74757_a("isInRitualMode", true);
            tag.func_74757_a("isRitualValid", this.mIsRitualValid);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_150297_b("eecMobType", 8)) {
            String mob = tag.func_74779_i("eecMobType");
            String mobKey = "entity." + mob + ".name";
            if (StatCollector.func_94522_b((String)mobKey)) {
                currentTip.add(StatCollector.func_74837_a((String)"kubatech.waila.eec.mob_type", (Object[])new Object[]{StatCollector.func_74838_a((String)mobKey)}));
            } else {
                currentTip.add(StatCollector.func_74837_a((String)"kubatech.waila.eec.mob_type", (Object[])new Object[]{mob}));
            }
        } else {
            currentTip.add(StatCollector.func_74837_a((String)"kubatech.waila.eec.mob_type", (Object[])new Object[]{StatCollector.func_74838_a((String)"kubatech.waila.eec.no_mob")}));
        }
        if (tag.func_74764_b("isInRitualMode") && tag.func_74767_n("isInRitualMode")) {
            if (tag.func_74764_b("isRitualValid") && tag.func_74767_n("isRitualValid")) {
                currentTip.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"kubatech.waila.eec.ritual_mode_connected"));
            } else {
                currentTip.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"kubatech.waila.eec.ritual_mode_error"));
            }
        }
    }

    @Override
    public final boolean supportsBatchMode() {
        return true;
    }

    private static class EECFakePlayer
    extends FakePlayer {
        MTEExtremeEntityCrusher mte;
        ItemStack currentWeapon;

        public EECFakePlayer(MTEExtremeEntityCrusher mte) {
            super((WorldServer)mte.getBaseMetaTileEntity().getWorld(), new GameProfile(UUID.nameUUIDFromBytes("[EEC Fake Player]".getBytes(StandardCharsets.UTF_8)), "[EEC Fake Player]"));
            this.mte = mte;
        }

        public void func_70669_a(ItemStack p_70669_1_) {
        }

        public Random func_70681_au() {
            return this.mte.rand;
        }

        public void func_71028_bD() {
        }

        public ItemStack func_71045_bC() {
            return this.currentWeapon;
        }

        public ItemStack func_70694_bm() {
            return this.currentWeapon;
        }
    }

    private static class WeaponCache
    extends ItemStackHandler {
        boolean isValid = false;
        int looting = 0;
        double attackDamage = 0.0;

        public WeaponCache(ItemStack[] inventory) {
            super(inventory);
        }

        protected final void onContentsChanged(int slot) {
            if (slot != 0) {
                return;
            }
            if (ModUtils.isClientThreaded()) {
                return;
            }
            ItemStack stack = this.getStackInSlot(0);
            if (stack == null) {
                this.isValid = false;
                return;
            }
            this.attackDamage = MTEExtremeEntityCrusher.getWeaponAttackDamage(stack);
            this.looting = MTEExtremeEntityCrusher.getWeaponLooting(stack);
            this.isValid = true;
        }

        public final boolean isItemValid(int aSlot, ItemStack aStack) {
            return aSlot == 0 && MTEExtremeEntityCrusher.isUsableWeapon(aStack);
        }
    }

    public class EECEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onRitualPerform(RitualRunEvent event) {
            RitualEffect ritualEffect;
            Rituals ritual;
            if (!MTEExtremeEntityCrusher.this.isInRitualMode) {
                return;
            }
            if (MTEExtremeEntityCrusher.this.masterStoneRitual == null) {
                return;
            }
            if (MTEExtremeEntityCrusher.this.mMaxProgresstime == 0) {
                return;
            }
            if (event.mrs.equals(MTEExtremeEntityCrusher.this.masterStoneRitual) && (ritual = (Rituals)Rituals.ritualMap.get(MTEExtremeEntityCrusher.WellOfSufferingRitualName)) != null && (ritualEffect = ritual.effect) instanceof RitualEffectWellOfSuffering) {
                RitualEffectWellOfSuffering effect = (RitualEffectWellOfSuffering)ritualEffect;
                event.setCanceled(true);
                String owner = event.mrs.getOwner();
                int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
                World world = event.mrs.getWorld();
                int x = event.mrs.getXCoord();
                int y = event.mrs.getYCoord();
                int z = event.mrs.getZCoord();
                if (world.func_72820_D() % 25L != 0L) {
                    return;
                }
                if (MTEExtremeEntityCrusher.this.tileAltar == null || MTEExtremeEntityCrusher.this.tileAltar.func_145837_r()) {
                    MTEExtremeEntityCrusher.this.tileAltar = null;
                    for (int i = -5; i <= 5; ++i) {
                        for (int j = -5; j <= 5; ++j) {
                            for (int k = -10; k <= 10; ++k) {
                                if (!(world.func_147438_o(x + i, y + k, z + j) instanceof IBloodAltar)) continue;
                                MTEExtremeEntityCrusher.this.tileAltar = world.func_147438_o(x + i, y + k, z + j);
                            }
                        }
                    }
                }
                if (MTEExtremeEntityCrusher.this.tileAltar == null) {
                    return;
                }
                if (currentEssence < effect.getCostPerRefresh() * 100) {
                    SoulNetworkHandler.causeNauseaToPlayer((String)owner);
                    return;
                }
                ((IBloodAltar)MTEExtremeEntityCrusher.this.tileAltar).sacrificialDaggerCall(100 * RitualEffectWellOfSuffering.amount * (effect.canDrainReagent(event.mrs, ReagentRegistry.offensaReagent, 3, true) ? 2 : 1) * (effect.canDrainReagent(event.mrs, ReagentRegistry.tenebraeReagent, 5, true) ? 2 : 1), true);
                SoulNetworkHandler.syphonFromNetwork((String)owner, (int)(effect.getCostPerRefresh() * 100));
            }
        }
    }

    private static final class EECMachineStatusWidget
    extends CycleButtonWidget {
        private final MTEExtremeEntityCrusher mEEC;
        private final IDrawable[] mEnabledBG;
        private final IDrawable[] mDisabledBG;
        private boolean mWorkingStatus;

        private EECMachineStatusWidget(MTEExtremeEntityCrusher aEEC, IDrawable aEnabledTexture, IDrawable aDisabledTexture) {
            this.mEEC = aEEC;
            this.mEnabledBG = new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, aEnabledTexture};
            this.mDisabledBG = new IDrawable[]{GTUITextures.BUTTON_STANDARD, aDisabledTexture};
            this.backgroundGetter = val -> val == 0 ? this.mDisabledBG : this.mEnabledBG;
            this.mWorkingStatus = this.mEEC.mMaxProgresstime > 0;
            this.textureGetter = val -> this.mWorkingStatus ? GTUITextures.OVERLAY_BUTTON_FORBIDDEN : IDrawable.EMPTY;
        }

        @SideOnly(value=Side.CLIENT)
        public void onScreenUpdate() {
            boolean tWorkingStatus;
            super.onScreenUpdate();
            boolean bl = tWorkingStatus = this.mEEC.mMaxProgresstime > 0;
            if (this.mWorkingStatus == tWorkingStatus) {
                return;
            }
            this.mWorkingStatus = tWorkingStatus;
            this.notifyTooltipChange();
            this.setState((Integer)this.getter.get(), false, false);
            this.markForUpdate();
        }

        public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
            if (this.mWorkingStatus) {
                return Interactable.ClickResult.ACKNOWLEDGED;
            }
            return super.onClick(buttonId, doubleClick);
        }
    }
}

