/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe.common;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.ExternalMaterials;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import ic2.core.Ic2Items;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CI {
    public static long bits = GTModHandler.RecipeBits.NOT_REMOVABLE | GTModHandler.RecipeBits.REVERSIBLE | GTModHandler.RecipeBits.BUFFERED;
    public static long bitsd = GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.NOT_REMOVABLE | GTModHandler.RecipeBits.REVERSIBLE | GTModHandler.RecipeBits.BUFFERED;
    public static ItemStack gearboxCasing_Tier_1;
    public static ItemStack gearboxCasing_Tier_2;
    public static ItemStack gearboxCasing_Tier_3;
    public static ItemStack gearboxCasing_Tier_4;
    public static String[] component_Plate;
    public static String[] component_Rod;
    public static String[] component_Ingot;
    public static ItemStack explosivePowderKeg;
    public static ItemStack explosiveTNT;
    public static ItemStack explosiveITNT;
    public static Materials[] tieredMaterials;
    public static final String[] circuits;
    private static final Material[] aMaterial_Main;
    private static final Material[] aMaterial_Secondary;
    private static final Material[] aMaterial_Tertiary;
    private static final Materials[] aMaterial_Cables;
    private static final Materials[] aMaterial_Circuits;
    private static final Material[][] aMaster;

    public static void preInit() {
        component_Plate = new String[]{CI.getTieredComponent(OrePrefixes.plate, 0), CI.getTieredComponent(OrePrefixes.plate, 1), CI.getTieredComponent(OrePrefixes.plate, 2), CI.getTieredComponent(OrePrefixes.plate, 3), CI.getTieredComponent(OrePrefixes.plate, 4), CI.getTieredComponent(OrePrefixes.plate, 5), CI.getTieredComponent(OrePrefixes.plate, 6), CI.getTieredComponent(OrePrefixes.plate, 7), CI.getTieredComponent(OrePrefixes.plate, 8), CI.getTieredComponent(OrePrefixes.plate, 9), CI.getTieredComponent(OrePrefixes.plate, 10), CI.getTieredComponent(OrePrefixes.plate, 11)};
        component_Rod = new String[]{CI.getTieredComponent(OrePrefixes.stick, 0), CI.getTieredComponent(OrePrefixes.stick, 1), CI.getTieredComponent(OrePrefixes.stick, 2), CI.getTieredComponent(OrePrefixes.stick, 3), CI.getTieredComponent(OrePrefixes.stick, 4), CI.getTieredComponent(OrePrefixes.stick, 5), CI.getTieredComponent(OrePrefixes.stick, 6), CI.getTieredComponent(OrePrefixes.stick, 7), CI.getTieredComponent(OrePrefixes.stick, 8), CI.getTieredComponent(OrePrefixes.stick, 9), CI.getTieredComponent(OrePrefixes.stick, 10), CI.getTieredComponent(OrePrefixes.stick, 11)};
        component_Ingot = new String[]{CI.getTieredComponent(OrePrefixes.ingot, 0), CI.getTieredComponent(OrePrefixes.ingot, 1), CI.getTieredComponent(OrePrefixes.ingot, 2), CI.getTieredComponent(OrePrefixes.ingot, 3), CI.getTieredComponent(OrePrefixes.ingot, 4), CI.getTieredComponent(OrePrefixes.ingot, 5), CI.getTieredComponent(OrePrefixes.ingot, 6), CI.getTieredComponent(OrePrefixes.ingot, 7), CI.getTieredComponent(OrePrefixes.ingot, 8), CI.getTieredComponent(OrePrefixes.ingot, 9), CI.getTieredComponent(OrePrefixes.ingot, 10), CI.getTieredComponent(OrePrefixes.ingot, 11)};
    }

    private static Object getMaterialFromTier(int tier) {
        Object object;
        switch (tier) {
            case 0: {
                object = Materials.Wood;
                break;
            }
            case 1: {
                object = Materials.Lead;
                break;
            }
            case 2: {
                object = Materials.Bronze;
                break;
            }
            case 3: {
                object = Materials.Steel;
                break;
            }
            case 4: {
                object = MaterialsAlloy.EGLIN_STEEL;
                break;
            }
            case 5: {
                object = Materials.Aluminium;
                break;
            }
            case 6: {
                object = MaterialsAlloy.MARAGING250;
                break;
            }
            case 7: {
                object = MaterialsAlloy.TANTALLOY_61;
                break;
            }
            case 8: {
                object = MaterialsAlloy.INCONEL_792;
                break;
            }
            case 9: {
                object = MaterialsAlloy.ZERON_100;
                break;
            }
            case 10: {
                object = Materials.NaquadahEnriched;
                break;
            }
            case 11: {
                object = Materials.Neutronium;
                break;
            }
            default: {
                object = Materials._NULL;
            }
        }
        return object;
    }

    public static String getTieredComponent(OrePrefixes type, int tier) {
        Object material = CI.getMaterialFromTier(tier);
        if (material != null) {
            String materialName = material instanceof Materials ? ((Materials)material).mDefaultLocalName : StringUtils.sanitizeString(((Material)material).getLocalizedName());
            Logger.INFO("Searching for a component named " + type.name() + materialName);
            return type.name() + materialName;
        }
        Logger.INFO("[Components] Failed getting a tiered component. " + type.name() + " | " + tier);
        return null;
    }

    public static ItemStack getDataOrb() {
        return ItemList.Tool_DataOrb.get(1L, new Object[0]);
    }

    public static ItemStack getDataStick() {
        return ItemList.Tool_DataStick.get(1L, new Object[0]);
    }

    public static ItemStack getTieredMachineHull(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.Hull_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.Hull_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Hull_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Hull_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Hull_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Hull_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Hull_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Hull_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Hull_UV.get(1L, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Hull_MAX.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = GregtechItemList.Casing_Multi_Use.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    public static ItemStack getTieredMachineCasing(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.Casing_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.Casing_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Casing_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Casing_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Casing_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Casing_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Casing_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Casing_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Casing_UV.get(1L, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Casing_MAX.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = GregtechItemList.Casing_Multi_Use.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    public static void init() {
        explosivePowderKeg = ItemList.Block_Powderbarrel.get(1L, new Object[0]);
        explosiveTNT = new ItemStack(Blocks.field_150335_W).func_77946_l();
        explosiveITNT = Ic2Items.industrialTnt.func_77946_l();
        gearboxCasing_Tier_1 = ItemList.Casing_Gearbox_Bronze.get(1L, new Object[0]);
        gearboxCasing_Tier_2 = ItemList.Casing_Gearbox_Steel.get(1L, new Object[0]);
        gearboxCasing_Tier_3 = ItemList.Casing_Gearbox_Titanium.get(1L, new Object[0]);
        gearboxCasing_Tier_4 = ItemList.Casing_Gearbox_TungstenSteel.get(1L, new Object[0]);
    }

    public static FluidStack getTieredFluid(int aTier, int aAmount) {
        return CI.getTieredFluid(aTier, aAmount, 0);
    }

    public static FluidStack getAlternativeTieredFluid(int aTier, int aAmount) {
        return CI.getTieredFluid(aTier, aAmount, 1);
    }

    public static FluidStack getTertiaryTieredFluid(int aTier, int aAmount) {
        return CI.getTieredFluid(aTier, aAmount, 2);
    }

    public static FluidStack getTieredFluid(int aTier, int aAmount, int aType) {
        ItemStack aCell;
        FluidStack a = aMaster[aType][aTier].getFluidStack(aAmount);
        if (a == null && (aCell = CI.getTieredComponent(OrePrefixes.liquid, aTier, 1)) != null) {
            a = GTUtility.getFluidForFilledItem(aCell, true);
            a.amount = aAmount;
        }
        return a;
    }

    public static ItemStack getEnergyCore(int aTier, int aAmount) {
        ItemStack[] aOutput = new ItemStack[]{GregtechItemList.Energy_Core_ULV.get(1L, new Object[0]), GregtechItemList.Energy_Core_LV.get(1L, new Object[0]), GregtechItemList.Energy_Core_MV.get(1L, new Object[0]), GregtechItemList.Energy_Core_HV.get(1L, new Object[0]), GregtechItemList.Energy_Core_EV.get(1L, new Object[0]), GregtechItemList.Energy_Core_IV.get(1L, new Object[0]), GregtechItemList.Energy_Core_LuV.get(1L, new Object[0]), GregtechItemList.Energy_Core_ZPM.get(1L, new Object[0]), GregtechItemList.Energy_Core_UV.get(1L, new Object[0]), GregtechItemList.Energy_Core_UHV.get(1L, new Object[0])};
        return GTUtility.copyAmount(aAmount, aOutput[MathUtils.balance(aTier, 0, 9)]);
    }

    public static ItemStack getPlate(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.plate, aTier, aAmount);
    }

    public static ItemStack getDoublePlate(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.plateDouble, aTier, aAmount);
    }

    public static ItemStack getGear(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.gearGt, aTier, aAmount);
    }

    public static ItemStack getIngot(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.ingot, aTier, aAmount);
    }

    public static ItemStack getBolt(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.bolt, aTier, aAmount);
    }

    public static ItemStack getScrew(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.screw, aTier, aAmount);
    }

    public static ItemStack getCircuit(int aTier, int aAmount) {
        return CI.getTieredComponent(OrePrefixes.circuit, aTier, aAmount);
    }

    public static ItemStack getTieredComponent(OrePrefixes aPrefix, int aTier, int aAmount) {
        Material m;
        aTier = Math.max(0, aTier);
        if (aPrefix == OrePrefixes.liquid) {
            int aMatID = aTier == 0 || aTier == 2 || aTier == 5 || aTier == 8 ? 0 : (aTier == 1 || aTier == 3 || aTier == 6 || aTier == 9 ? 1 : 2);
            return aMaster[aMatID][aTier].getCell(aAmount);
        }
        if (aPrefix == OrePrefixes.circuit) {
            return GTOreDictUnificator.get(OrePrefixes.circuit, aMaterial_Circuits[aTier], (long)aAmount);
        }
        if (aPrefix == OrePrefixes.cableGt01 || aPrefix == OrePrefixes.cableGt02 || aPrefix == OrePrefixes.cableGt04 || aPrefix == OrePrefixes.cableGt08 || aPrefix == OrePrefixes.cableGt12) {
            if (aTier == 10) {
                switch (aPrefix) {
                    case cableGt01: {
                        aPrefix = OrePrefixes.wireGt02;
                        break;
                    }
                    case cableGt02: {
                        aPrefix = OrePrefixes.wireGt04;
                        break;
                    }
                    case cableGt04: {
                        aPrefix = OrePrefixes.wireGt08;
                        break;
                    }
                    case cableGt08: {
                        aPrefix = OrePrefixes.wireGt12;
                        break;
                    }
                    case cableGt12: {
                        aPrefix = OrePrefixes.wireGt16;
                    }
                }
            } else {
                return ItemUtils.getOrePrefixStack(aPrefix, aMaterial_Cables[aTier], aAmount);
            }
        }
        if (aPrefix == OrePrefixes.wireGt01 || aPrefix == OrePrefixes.wireGt02 || aPrefix == OrePrefixes.wireGt04 || aPrefix == OrePrefixes.wireGt08 || aPrefix == OrePrefixes.wireGt12 || aPrefix == OrePrefixes.wireGt16) {
            return ItemUtils.getOrePrefixStack(aPrefix, aMaterial_Cables[aTier], aAmount);
        }
        if (aPrefix == OrePrefixes.pipeTiny || aPrefix == OrePrefixes.pipeSmall || aPrefix == OrePrefixes.pipe || aPrefix == OrePrefixes.pipeMedium || aPrefix == OrePrefixes.pipeLarge || aPrefix == OrePrefixes.pipeHuge) {
            ItemStack itemStack;
            if (aPrefix == OrePrefixes.pipe) {
                aPrefix = OrePrefixes.pipeMedium;
            }
            switch (aTier) {
                case 0: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.Lead, aAmount);
                    break;
                }
                case 1: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.Steel, aAmount);
                    break;
                }
                case 2: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.StainlessSteel, aAmount);
                    break;
                }
                case 3: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.Tungsten, aAmount);
                    break;
                }
                case 4: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.TungstenSteel, aAmount);
                    break;
                }
                case 5: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, MaterialsAlloy.MARAGING350, aAmount);
                    break;
                }
                case 6: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, MaterialsAlloy.STABALLOY, aAmount);
                    break;
                }
                case 7: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, MaterialsAlloy.HASTELLOY_X, aAmount);
                    break;
                }
                case 8: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.Ultimate, aAmount);
                    break;
                }
                case 9: {
                    itemStack = ItemUtils.getOrePrefixStack(OrePrefixes.pipeMedium, Materials.SuperconductorUHV, aAmount);
                    break;
                }
                case 10: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.Europium, aAmount);
                    break;
                }
                default: {
                    itemStack = ItemUtils.getOrePrefixStack(aPrefix, Materials.Titanium, aAmount);
                }
            }
            return itemStack;
        }
        if (aPrefix == OrePrefixes.rod) {
            aPrefix = OrePrefixes.stick;
        }
        switch (aPrefix) {
            case gear: 
            case gearGt: 
            case rod: 
            case stick: 
            case screw: 
            case plate: 
            case plateDouble: {
                m = aMaster[0][aTier];
                break;
            }
            case stickLong: 
            case ingot: 
            case rotor: 
            case cell: {
                m = aMaster[1][aTier];
                break;
            }
            case bolt: 
            case ring: 
            case frame: 
            case frameGt: {
                m = aMaster[2][aTier];
                break;
            }
            default: {
                m = aMaterial_Main[aTier];
            }
        }
        ItemStack aReturn = ItemUtils.getOrePrefixStack(aPrefix, m, aAmount);
        if (aReturn != null) {
            return aReturn;
        }
        m = aMaster[0][aTier];
        aReturn = ItemUtils.getOrePrefixStack(aPrefix, m, aAmount);
        if (aReturn != null) {
            return aReturn;
        }
        m = aMaster[1][aTier];
        aReturn = ItemUtils.getOrePrefixStack(aPrefix, m, aAmount);
        if (aReturn != null) {
            return aReturn;
        }
        m = aMaster[2][aTier];
        aReturn = ItemUtils.getOrePrefixStack(aPrefix, m, aAmount);
        if (aReturn == null) {
            aReturn = null;
        }
        return aReturn;
    }

    public static ItemStack getElectricMotor(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Electric_Motor_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Electric_Motor_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Electric_Motor_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Electric_Motor_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Electric_Motor_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Electric_Motor_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Electric_Motor_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Electric_Motor_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Electric_Motor_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getFluidRegulator(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.FluidRegulator_LV.get(size, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.FluidRegulator_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.FluidRegulator_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.FluidRegulator_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.FluidRegulator_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.FluidRegulator_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.FluidRegulator_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.FluidRegulator_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.FluidRegulator_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.FluidRegulator_UV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getElectricPiston(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Electric_Piston_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Electric_Piston_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Electric_Piston_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Electric_Piston_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Electric_Piston_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Electric_Piston_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Electric_Piston_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Electric_Piston_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Electric_Piston_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getElectricPump(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Electric_Pump_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Electric_Pump_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Electric_Pump_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Electric_Pump_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Electric_Pump_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Electric_Pump_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Electric_Pump_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Electric_Pump_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Electric_Pump_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getRobotArm(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Robot_Arm_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Robot_Arm_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Robot_Arm_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Robot_Arm_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Robot_Arm_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Robot_Arm_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Robot_Arm_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Robot_Arm_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Robot_Arm_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getConveyor(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Conveyor_Module_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Conveyor_Module_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Conveyor_Module_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Conveyor_Module_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Conveyor_Module_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Conveyor_Module_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Conveyor_Module_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Conveyor_Module_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Conveyor_Module_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getEmitter(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Emitter_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Emitter_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Emitter_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Emitter_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Emitter_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Emitter_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Emitter_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Emitter_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Emitter_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getSensor(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Sensor_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Sensor_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Sensor_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Sensor_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Sensor_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Sensor_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Sensor_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Sensor_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Sensor_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getFieldGenerator(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Field_Generator_LV.get(size, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Field_Generator_MV.get(size, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Field_Generator_HV.get(size, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Field_Generator_EV.get(size, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Field_Generator_IV.get(size, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Field_Generator_LuV.get(size, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Field_Generator_ZPM.get(size, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Field_Generator_UV.get(size, new Object[0]);
                break;
            }
            case 9: {
                itemStack = ItemList.Field_Generator_UHV.get(size, new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getTieredMachineHull(int tier, int size) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_ULV.get(1L, new Object[0]));
                break;
            }
            case 1: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_LV.get(1L, new Object[0]));
                break;
            }
            case 2: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_MV.get(1L, new Object[0]));
                break;
            }
            case 3: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_HV.get(1L, new Object[0]));
                break;
            }
            case 4: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_EV.get(1L, new Object[0]));
                break;
            }
            case 5: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_IV.get(1L, new Object[0]));
                break;
            }
            case 6: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_LuV.get(1L, new Object[0]));
                break;
            }
            case 7: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_ZPM.get(1L, new Object[0]));
                break;
            }
            case 8: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_UV.get(1L, new Object[0]));
                break;
            }
            case 9: {
                itemStack = GTUtility.copyAmount(size, ItemList.Hull_MAX.get(1L, new Object[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return itemStack;
    }

    public static ItemStack getTieredGTPPMachineCasing(int aTier, int aAmount) {
        GregtechItemList[] aHulls = new GregtechItemList[]{GregtechItemList.GTPP_Casing_ULV, GregtechItemList.GTPP_Casing_LV, GregtechItemList.GTPP_Casing_MV, GregtechItemList.GTPP_Casing_HV, GregtechItemList.GTPP_Casing_EV, GregtechItemList.GTPP_Casing_IV, GregtechItemList.GTPP_Casing_LuV, GregtechItemList.GTPP_Casing_ZPM, GregtechItemList.GTPP_Casing_UV, GregtechItemList.GTPP_Casing_UHV};
        return aHulls[aTier].get(aAmount, new Object[0]);
    }

    public static ItemStack getTieredComponentOfMaterial(Materials aMaterial, OrePrefixes aPrefix, int aAmount) {
        return ItemUtils.getOrePrefixStack(aPrefix, aMaterial, aAmount);
    }

    public static ItemStack getTransmissionComponent(int aTier, int aAmount) {
        GregtechItemList[] aTransParts = new GregtechItemList[]{null, GregtechItemList.TransmissionComponent_LV, GregtechItemList.TransmissionComponent_MV, GregtechItemList.TransmissionComponent_HV, GregtechItemList.TransmissionComponent_EV, GregtechItemList.TransmissionComponent_IV, GregtechItemList.TransmissionComponent_LuV, GregtechItemList.TransmissionComponent_ZPM, GregtechItemList.TransmissionComponent_UV, GregtechItemList.TransmissionComponent_UHV};
        return aTransParts[aTier].get(aAmount, new Object[0]);
    }

    public static ItemStack getEmptyCatalyst(int aAmount) {
        return GregtechItemList.EmptyCatalystCarrier.get(aAmount, new Object[0]);
    }

    public static ItemStack getGreenCatalyst(int aAmount) {
        return GregtechItemList.GreenMetalCatalyst.get(aAmount, new Object[0]);
    }

    public static ItemStack getPurpleCatalyst(int aAmount) {
        return GregtechItemList.PurpleMetalCatalyst.get(aAmount, new Object[0]);
    }

    public static ItemStack getPinkCatalyst(int aAmount) {
        return GregtechItemList.PinkMetalCatalyst.get(aAmount, new Object[0]);
    }

    static {
        tieredMaterials = new Materials[]{Materials.Iron, Materials.Steel, Materials.Aluminium, Materials.StainlessSteel, Materials.Titanium, Materials.TungstenSteel, ExternalMaterials.getRhodiumPlatedPalladium(), Materials.Iridium, Materials.Osmium, Materials.Neutronium};
        circuits = new String[]{"circuitPrimitive", "circuitBasic", "circuitGood", "circuitAdvanced", "circuitData", "circuitElite", "circuitMaster", "circuitUltimate", "circuitSuperconductor", "circuitInfinite", "circuitQuantum"};
        aMaterial_Main = new Material[]{MaterialsAlloy.POTIN, MaterialsAlloy.TUMBAGA, MaterialsAlloy.EGLIN_STEEL, MaterialsAlloy.TANTALUM_CARBIDE, MaterialsAlloy.INCOLOY_DS, MaterialsAlloy.INCONEL_625, MaterialsAlloy.ZERON_100, MaterialsAlloy.PIKYONIUM, MaterialsElements.STANDALONE.ADVANCED_NITINOL, MaterialsAlloy.ABYSSAL, MaterialsAlloy.QUANTUM, MaterialsElements.STANDALONE.HYPOGEN};
        aMaterial_Secondary = new Material[]{MaterialsAlloy.STEEL, MaterialsAlloy.SILICON_CARBIDE, MaterialsAlloy.BLOODSTEEL, MaterialsAlloy.TANTALUM_CARBIDE, MaterialsAlloy.INCONEL_792, MaterialsAlloy.ARCANITE, MaterialsAlloy.LAFIUM, MaterialsAlloy.CINOBITE, MaterialsAlloy.TITANSTEEL, MaterialsAlloy.OCTIRON, MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN, MaterialsElements.STANDALONE.HYPOGEN};
        aMaterial_Tertiary = new Material[]{MaterialsElements.getInstance().LEAD, MaterialsElements.getInstance().ALUMINIUM, MaterialsElements.STANDALONE.BLACK_METAL, MaterialsElements.getInstance().TITANIUM, MaterialsAlloy.HASTELLOY_N, MaterialsAlloy.ENERGYCRYSTAL, MaterialsAlloy.TRINIUM_NAQUADAH_CARBON, MaterialsAlloy.TRINIUM_REINFORCED_STEEL, MaterialsAlloy.TITANSTEEL, MaterialsElements.STANDALONE.ASTRAL_TITANIUM, MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN, MaterialsElements.STANDALONE.HYPOGEN};
        aMaterial_Cables = new Materials[]{Materials.Tin, Materials.Cobalt, Materials.AnnealedCopper, Materials.Gold, Materials.Titanium, Materials.Nichrome, Materials.Platinum, Materials.YttriumBariumCuprate, Materials.Naquadah, Materials.Duranium, Materials.SuperconductorUHV};
        aMaterial_Circuits = new Materials[]{Materials.ULV, Materials.LV, Materials.MV, Materials.HV, Materials.EV, Materials.IV, Materials.LuV, Materials.ZPM, Materials.UV, Materials.UHV, Materials.UEV};
        aMaster = new Material[][]{aMaterial_Main, aMaterial_Secondary, aMaterial_Tertiary};
    }
}

