/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.common.items.behaviors.BehaviorTrowel;
import gregtech.common.tools.GTTool;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ToolTrowel
extends GTTool {
    private static final String TYPE_NAME = "trowel";

    @Override
    public float getBaseDamage() {
        return 0.0f;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, int aMetaData) {
        return false;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.TROWEL : Textures.ItemIcons.HANDLE_TROWEL;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public String getToolTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void onStatsAddedToTool(MetaGeneratedTool aItem, int aID) {
        aItem.addItemBehavior(aID, new BehaviorTrowel());
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " was taken to trowel town by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

