/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.metadata.PurificationPlantBaseChanceKey;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockCasingsAbstract;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationPlant;
import gregtech.common.tileentities.machines.multi.purification.PurificationUnitStatus;
import gregtech.common.tileentities.machines.multi.purification.PurifiedWaterHelpers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTEPurificationUnitBase<T extends MTEExtendedPowerMultiBlockBase<T>>
extends MTEExtendedPowerMultiBlockBase<T> {
    public static final float WATER_BOOST_NEEDED_FLUID = 0.1f;
    public static final float WATER_BOOST_BONUS_CHANCE = 0.15f;
    private int controllerX;
    private int controllerY;
    private int controllerZ;
    private boolean controllerSet = false;
    private MTEPurificationPlant controller = null;
    protected GTRecipe currentRecipe = null;
    protected float currentRecipeChance = 0.0f;
    protected int maxParallel = 1;
    protected int effectiveParallel = 1;
    protected ArrayList<FluidStack> storedFluids = null;
    private static final int PARALLEL_WINDOW_ID = 10;

    protected MTEPurificationUnitBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected MTEPurificationUnitBase(String aName) {
        super(aName);
    }

    @Override
    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    protected void setHatchRecipeMap(MTEHatchInput hatch) {
    }

    protected static int getTextureIndex(Block block, int meta) {
        return ((BlockCasingsAbstract)block).getTextureIndex(meta);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        if (aTimer % 100L == 5L && this.controllerSet && this.getController() == null) {
            this.trySetControllerFromCoord(this.controllerX, this.controllerY, this.controllerZ);
        }
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mMaxProgresstime > 0) {
            this.func_70296_d();
            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
        }
    }

    protected CheckRecipeResult findRecipeForInputs(FluidStack[] fluidInputs, ItemStack ... itemInputs) {
        RecipeMap<?> recipeMap = this.getRecipeMap();
        Stream<GTRecipe> recipes = recipeMap.findRecipeQuery().fluids(fluidInputs).items(itemInputs).findAll();
        GTRecipe recipe = recipes.max(Comparator.comparing(r -> r.getMetadataOrDefault(PurificationPlantBaseChanceKey.INSTANCE, Float.valueOf(0.0f)))).orElse(null);
        if (recipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (this.protectsExcessFluid() && !this.canOutputAll(recipe.mFluidOutputs)) {
            return CheckRecipeResultRegistry.FLUID_OUTPUT_FULL;
        }
        if (this.protectsExcessItem() && !this.canOutputAll(recipe.mOutputs)) {
            return CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
        }
        this.currentRecipe = recipe;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.storedFluids = this.getStoredFluids();
        CheckRecipeResult result = this.overrideRecipeCheck();
        if (result == null) {
            result = this.findRecipeForInputs(this.storedFluids.toArray(new FluidStack[0]), new ItemStack[0]);
        }
        if (result.wasSuccessful()) {
            FluidStack waterInput = this.currentRecipe.mFluidInputs[0];
            long amountAvailable = 0L;
            for (FluidStack fluid : this.storedFluids) {
                if (!fluid.isFluidEqual(waterInput)) continue;
                amountAvailable += (long)fluid.amount;
            }
            this.effectiveParallel = (int)Math.min((long)this.maxParallel, Math.floorDiv(amountAvailable, (long)waterInput.amount));
            if (this.effectiveParallel == 0) {
                return CheckRecipeResultRegistry.INTERNAL_ERROR;
            }
        }
        return result;
    }

    public CheckRecipeResult overrideRecipeCheck() {
        return null;
    }

    public boolean doPurificationRecipeCheck() {
        this.effectiveParallel = 1;
        return this.checkRecipe();
    }

    public float calculateBoostedSuccessChance() {
        float recipeChance = this.currentRecipe.getMetadataOrDefault(PurificationPlantBaseChanceKey.INSTANCE, Float.valueOf(0.0f)).floatValue();
        if (this.isWaterBoosted(this.currentRecipe)) {
            recipeChance = Math.min(recipeChance + 15.000001f, 100.0f);
        }
        return recipeChance;
    }

    public float calculateFinalSuccessChance() {
        return this.currentRecipeChance;
    }

    public abstract int getWaterTier();

    public FluidStack getWaterBoostAmount(GTRecipe recipe) {
        FluidStack outputWater = recipe.mFluidOutputs[0];
        int amount = Math.round((float)outputWater.amount * 0.1f * (float)this.effectiveParallel);
        return new FluidStack(outputWater.getFluid(), amount);
    }

    public boolean isWaterBoosted(GTRecipe recipe) {
        FluidStack inputWater = this.getWaterBoostAmount(recipe);
        return this.depleteInput(inputWater, true);
    }

    public void depleteRecipeInputs() {
        for (int i = 0; i < this.currentRecipe.mFluidInputs.length; ++i) {
            FluidStack input = this.currentRecipe.mFluidInputs[i];
            FluidStack copyWithParallel = input.copy();
            if (i == 0) {
                copyWithParallel.amount = input.amount * this.effectiveParallel;
            }
            this.depleteInput(copyWithParallel);
        }
    }

    public void startCycle(int cycleTime, int progressTime) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.startRecipeProcessing();
        this.currentRecipeChance = this.calculateBoostedSuccessChance();
        if (this.isWaterBoosted(this.currentRecipe)) {
            FluidStack inputWater = this.getWaterBoostAmount(this.currentRecipe);
            this.depleteInput(inputWater);
        }
        if (!this.getController().debugModeOn()) {
            this.depleteRecipeInputs();
        }
        this.mMaxProgresstime = cycleTime;
        this.mProgresstime = progressTime;
        this.mEfficiency = 10000;
        FluidStack[] fluidOutputs = new FluidStack[this.currentRecipe.mFluidOutputs.length];
        for (int i = 0; i < this.currentRecipe.mFluidOutputs.length; ++i) {
            fluidOutputs[i] = this.currentRecipe.mFluidOutputs[i].copy();
            fluidOutputs[i].amount = (int)Math.min((long)this.effectiveParallel * (long)fluidOutputs[i].amount, Integer.MAX_VALUE);
        }
        ItemStack[] recipeOutputs = this.currentRecipe.mOutputs;
        ItemStack[] itemOutputs = new ItemStack[recipeOutputs.length];
        int[] mChances = this.currentRecipe.mChances;
        if (mChances != null) {
            for (int i = 0; i < recipeOutputs.length; ++i) {
                int roll = random.nextInt(10000);
                if (roll > mChances[i]) continue;
                itemOutputs[i] = recipeOutputs[i].func_77946_l();
            }
        } else {
            for (int i = 0; i < recipeOutputs.length; ++i) {
                itemOutputs[i] = recipeOutputs[i].func_77946_l();
            }
        }
        this.mOutputFluids = fluidOutputs;
        this.mOutputItems = itemOutputs;
        this.lEUt = -this.getActualPowerUsage();
        this.endRecipeProcessing();
    }

    public void addRecipeOutputs() {
        if (this.mOutputFluids != null) {
            this.addFluidOutputs(this.mOutputFluids);
        }
        if (this.mOutputItems != null) {
            this.addItemOutputs(this.mOutputItems);
        }
    }

    public void endCycle() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (!this.getController().debugModeOn()) {
            float successRoll = (float)random.nextInt(0, 10000) / 100.0f;
            if (successRoll <= this.calculateFinalSuccessChance()) {
                this.addRecipeOutputs();
            } else {
                this.onRecipeFail();
            }
        }
        this.checkRecipeResult = CheckRecipeResultRegistry.CYCLE_IDLE;
        this.mMaxProgresstime = 0;
        this.mProgresstime = 0;
        this.lEUt = 0L;
        this.mEfficiency = 0;
        this.currentRecipe = null;
        this.currentRecipeChance = 0.0f;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        this.effectiveParallel = 1;
    }

    private void onRecipeFail() {
        if (this.mOutputFluids != null) {
            FluidStack outputWater = this.getDegradedOutputWater();
            this.addOutput(outputWater);
        }
    }

    private FluidStack getDegradedOutputWater() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int roll = random.nextInt(0, 2);
        if (roll == 0) {
            return null;
        }
        for (int waterTier = this.getWaterTier(); waterTier > 0; --waterTier) {
            roll = random.nextInt(0, 2);
            if (roll != 1) continue;
            int amount = this.mOutputFluids[0].amount;
            if (waterTier == 1) {
                return GTModHandler.getDistilledWater(amount);
            }
            Materials water = PurifiedWaterHelpers.getPurifiedWaterTier(waterTier - 1);
            return water.getFluid(amount);
        }
        return null;
    }

    public abstract long getBasePowerUsage();

    public long getActualPowerUsage() {
        return this.getBasePowerUsage() * (long)this.effectiveParallel;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCrowbar = true;
        this.mWrench = true;
        this.mHardHammer = true;
        this.mSoftMallet = true;
        this.mSolderingTool = true;
        this.mScrewdriver = true;
        return true;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("controller")) {
            NBTTagCompound controllerNBT = aNBT.func_74775_l("controller");
            this.controllerX = controllerNBT.func_74762_e("x");
            this.controllerY = controllerNBT.func_74762_e("y");
            this.controllerZ = controllerNBT.func_74762_e("z");
            this.controllerSet = true;
        }
        this.currentRecipeChance = aNBT.func_74760_g("currentRecipeChance");
        if (aNBT.func_74764_b("configuredParallel")) {
            this.maxParallel = aNBT.func_74762_e("configuredParallel");
        }
        if (aNBT.func_74764_b("effectiveParallel")) {
            this.effectiveParallel = aNBT.func_74762_e("effectiveParallel");
        }
    }

    public NBTTagCompound saveLinkDataToNBT() {
        NBTTagCompound controllerNBT = new NBTTagCompound();
        controllerNBT.func_74768_a("x", this.controllerX);
        controllerNBT.func_74768_a("y", this.controllerY);
        controllerNBT.func_74768_a("z", this.controllerZ);
        return controllerNBT;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.controllerSet) {
            NBTTagCompound controllerNBT = this.saveLinkDataToNBT();
            aNBT.func_74782_a("controller", (NBTBase)controllerNBT);
        }
        aNBT.func_74776_a("currentRecipeChance", this.currentRecipeChance);
        aNBT.func_74768_a("configuredParallel", this.maxParallel);
        aNBT.func_74768_a("effectiveParallel", this.effectiveParallel);
    }

    private LinkResult trySetControllerFromCoord(int x, int y, int z) {
        IGregTechTileEntity ourBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (Math.abs(ourBaseMetaTileEntity.getXCoord() - x) > 32) {
            return LinkResult.TOO_FAR;
        }
        if (Math.abs(ourBaseMetaTileEntity.getYCoord() - y) > 32) {
            return LinkResult.TOO_FAR;
        }
        if (Math.abs(ourBaseMetaTileEntity.getZCoord() - z) > 32) {
            return LinkResult.TOO_FAR;
        }
        TileEntity tileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, y, z);
        if (tileEntity == null) {
            return LinkResult.NO_VALID_PLANT;
        }
        if (!(tileEntity instanceof IGregTechTileEntity)) {
            return LinkResult.NO_VALID_PLANT;
        }
        IGregTechTileEntity gtTileEntity = (IGregTechTileEntity)tileEntity;
        IMetaTileEntity metaTileEntity = gtTileEntity.getMetaTileEntity();
        if (!(metaTileEntity instanceof MTEPurificationPlant)) {
            return LinkResult.NO_VALID_PLANT;
        }
        MTEPurificationPlant oldController = this.getController();
        if (oldController != null) {
            oldController.unregisterLinkedUnit(this);
            this.unlinkController();
        }
        this.controllerX = x;
        this.controllerY = y;
        this.controllerZ = z;
        this.controllerSet = true;
        this.controller = (MTEPurificationPlant)metaTileEntity;
        this.controller.registerLinkedUnit(this);
        return LinkResult.SUCCESS;
    }

    private boolean tryLinkDataStick(EntityPlayer aPlayer) {
        int z;
        int y;
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return false;
        }
        if (!dataStick.func_77942_o() || !dataStick.field_77990_d.func_74779_i("type").equals("PurificationPlant")) {
            return false;
        }
        NBTTagCompound nbt = dataStick.field_77990_d;
        int x = nbt.func_74762_e("x");
        LinkResult result = this.trySetControllerFromCoord(x, y = nbt.func_74762_e("y"), z = nbt.func_74762_e("z"));
        if (result == LinkResult.SUCCESS) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Link successful"));
        } else if (result == LinkResult.TOO_FAR) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Link failed: Out of range."));
        } else if (result == LinkResult.NO_VALID_PLANT) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Link failed: No Purification Plant found at link location"));
        }
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (this.tryLinkDataStick(aPlayer)) {
            return true;
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer);
    }

    public MTEPurificationPlant getController() {
        if (this.controller == null) {
            return null;
        }
        if (this.controller.getBaseMetaTileEntity() == null) {
            return null;
        }
        return this.controller;
    }

    public void unlinkController() {
        this.controllerSet = false;
        this.controller = null;
        this.controllerX = 0;
        this.controllerY = 0;
        this.controllerZ = 0;
    }

    @Override
    public void onBlockDestroyed() {
        MTEPurificationPlant controller = this.getController();
        if (controller != null) {
            controller.unregisterLinkedUnit(this);
        }
        super.onBlockDestroyed();
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.getController() != null) {
            ret.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_base.linked_at", (Object[])new Object[]{this.controllerX, this.controllerY, this.controllerZ}));
            if (this.mMaxProgresstime != 0) {
                ret.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_base.success_chance", (Object[])new Object[]{EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.calculateFinalSuccessChance()) + "%" + EnumChatFormatting.RESET}));
            }
        } else {
            ret.add(StatCollector.func_74838_a((String)"GT5U.infodata.purification_unit_base.not_linked"));
        }
        ret.add(StatCollector.func_74837_a((String)"GT5U.infodata.parallel.current", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.effectiveParallel}));
        return ret.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("linked")) {
            currenttip.add(EnumChatFormatting.AQUA + "Linked to Purification Plant at " + EnumChatFormatting.WHITE + tag.func_74762_e("controllerX") + ", " + tag.func_74762_e("controllerY") + ", " + tag.func_74762_e("controllerZ") + EnumChatFormatting.RESET);
        } else {
            currenttip.add(EnumChatFormatting.AQUA + "Unlinked");
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        tag.func_74757_a("linked", this.getController() != null);
        if (this.getController() != null) {
            tag.func_74768_a("controllerX", this.controllerX);
            tag.func_74768_a("controllerY", this.controllerY);
            tag.func_74768_a("controllerZ", this.controllerZ);
        }
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    public PurificationUnitStatus status() {
        if (!this.mMachine) {
            return PurificationUnitStatus.INCOMPLETE_STRUCTURE;
        }
        if (!this.isAllowedToWork()) {
            return PurificationUnitStatus.DISABLED;
        }
        return PurificationUnitStatus.ONLINE;
    }

    public Widget makeSyncerWidgets() {
        return new MultiChildWidget().addChild((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, machine -> {
            this.mMachine = machine;
        })).addChild((Widget)new FakeSyncWidget.BooleanSyncer(this::isAllowedToWork, _work -> {}));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(10, this::createParallelWindow);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_BATCH_MODE_ON);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.tpm.parallelwindow")).setTooltipShowUpDelay(5).setPos(174, 112).setSize(16, 16));
        super.addUIWidgets(builder, buildContext);
    }

    protected ModularWindow createParallelWindow(EntityPlayer player) {
        int WIDTH = 158;
        int HEIGHT = 52;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)158, (int)52);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.BottomRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(158, 52)).add(155, 0).subtract(0, 10)));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GTPP.CC.parallel", (Object[])new Object[0]).setPos(3, 4).setSize(150, 20))).widget(new NumericWidget().setSetter(val -> {
            this.maxParallel = (int)val;
        }).setGetter(() -> this.maxParallel).setBounds(1.0, 2.147483647E9).setDefaultValue(1.0).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(150, 18).setPos(4, 25).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.maxParallel, val -> {
            this.maxParallel = val;
        }), (IWidgetBuilder)builder));
        return builder.build();
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return EnumSet.of(VoidingMode.VOID_NONE);
    }

    @Override
    protected boolean supportsCraftingMEBuffer() {
        return false;
    }

    private static enum LinkResult {
        TOO_FAR,
        NO_VALID_PLANT,
        SUCCESS;

    }
}

