/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class CoverSolarPanel
extends CoverLegacyData {
    private final int mVoltage;

    public CoverSolarPanel(CoverContext context, int aVoltage) {
        super(context);
        this.mVoltage = aVoltage;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (this.coverSide != ForgeDirection.UP) {
            this.coverData = 0;
            return;
        }
        int coverState = this.coverData & 3;
        int coverNum = this.coverData >> 2;
        if (aTimer % 100L == 0L) {
            if (coverable.getWorld().func_72911_I()) {
                this.coverData = coverable.getBiome().field_76751_G > 0.0f && coverable.getSkyAtSide(this.coverSide) ? Math.min(20, coverNum) << 2 : coverNum << 2;
                return;
            }
            if (coverable.getWorld().func_72896_J() && coverable.getBiome().field_76751_G > 0.0f) {
                if (coverable.getSkyAtSide(this.coverSide)) {
                    coverNum = Math.min(30, coverNum);
                }
                if (coverable.getWorld().field_73008_k >= 4) {
                    if (!coverable.getWorld().func_72935_r()) {
                        this.coverData = coverNum << 2;
                        return;
                    }
                    coverState = 2;
                }
            } else {
                coverState = coverable.getWorld().func_72935_r() ? 1 : 2;
            }
        }
        if (coverState == 1) {
            coverable.injectEnergyUnits(ForgeDirection.UNKNOWN, (100L - (long)coverNum) * (long)this.mVoltage / 100L, 1L);
        }
        if (aTimer % 28800L == 0L && coverNum < 100 && (coverNum > 10 || XSTR.XSTR_INSTANCE.nextInt(3) == 2)) {
            ++coverNum;
        }
        this.coverData = coverState + (coverNum << 2);
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.field_71075_bZ.field_75098_d) {
            GTUtility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (this.coverData >> 2) + "% dirt");
            this.coverData &= 3;
            return true;
        }
        for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = aPlayer.field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77977_a().equals(new ItemStack(Items.field_151131_as).func_77977_a())) continue;
            aPlayer.field_71071_by.field_70462_a[i] = new ItemStack(Items.field_151133_ar);
            if (aPlayer.field_71069_bz != null) {
                aPlayer.field_71069_bz.func_75142_b();
            }
            GTUtility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (this.coverData >> 2) + "% dirt");
            this.coverData &= 3;
            return true;
        }
        GTUtility.sendChatToPlayer(aPlayer, "You need water bucket in inventory to clean the panel.");
        return false;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }
}

