/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.render;

import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.ISBRInventoryContext;
import gregtech.api.render.ISBRWorldContext;
import gregtech.common.blocks.BlockMachines;
import gregtech.common.render.GTRendererBlock;
import gregtech.mixin.interfaces.accessors.TesselatorAccessor;
import gtPlusPlus.xmod.gregtech.common.helpers.GTMethodHelper;
import java.util.EnumMap;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MachineBlockRenderer
extends GTRendererBlock {
    private static final int mRenderID = RenderingRegistry.getNextAvailableRenderId();

    private static ITexture[] getTexture(IMetaTileEntity tile, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean arg5) {
        IGregTechTileEntity gtTile = tile.getBaseMetaTileEntity();
        return tile.getTexture(gtTile, side, facing, (byte)colorIndex, active, arg5);
    }

    private static ITexture[] getTexture(IMetaTileEntity tile, ForgeDirection side, int facingMask, int colorIndex, boolean active, boolean arg5) {
        MetaPipeEntity gtTile = (MetaPipeEntity)((Object)tile.getBaseMetaTileEntity());
        return gtTile.getTexture((IGregTechTileEntity)((Object)tile), side, facingMask, colorIndex, active, arg5);
    }

    private static void renderNormalInventoryMetaTileEntity(ISBRInventoryContext ctx) {
        IMetaTileEntity tMetaTileEntity;
        if (ctx.getMeta() > 0 && ctx.getMeta() < GregTechAPI.METATILEENTITIES.length && (tMetaTileEntity = GregTechAPI.METATILEENTITIES[ctx.getMeta()]) != null) {
            ctx.getBlock().func_149683_g();
            ctx.setRenderBoundsFromBlock();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            Tessellator tess = Tessellator.field_78398_a;
            IGregTechTileEntity iGregTechTileEntity = tMetaTileEntity.getBaseMetaTileEntity();
            if (iGregTechTileEntity instanceof IPipeRenderedTileEntity) {
                IPipeRenderedTileEntity pipeRenderedTile = (IPipeRenderedTileEntity)((Object)iGregTechTileEntity);
                float tThickness = pipeRenderedTile.getThickNess();
                float sp = (1.0f - tThickness) / 2.0f;
                ctx.getBlock().func_149676_a(0.0f, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                ctx.setRenderBoundsFromBlock();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, -1.0f, 0.0f);
                ctx.renderNegativeYFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.DOWN, 9, -1, false, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 1.0f, 0.0f);
                ctx.renderPositiveYFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.UP, 9, -1, false, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, -1.0f);
                ctx.renderNegativeZFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.NORTH, 9, -1, false, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, 1.0f);
                ctx.renderPositiveZFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.SOUTH, 9, -1, false, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(-1.0f, 0.0f, 0.0f);
                ctx.renderNegativeXFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.WEST, 9, -1, true, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(1.0f, 0.0f, 0.0f);
                ctx.renderPositiveXFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.EAST, 9, -1, true, false));
                tess.func_78381_a();
            } else {
                tess.func_78382_b();
                tess.func_78375_b(0.0f, -1.0f, 0.0f);
                ctx.renderNegativeYFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.DOWN, ForgeDirection.WEST, -1, true, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 1.0f, 0.0f);
                ctx.renderPositiveYFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.UP, ForgeDirection.WEST, -1, true, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, -1.0f);
                ctx.renderNegativeZFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.NORTH, ForgeDirection.WEST, -1, true, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, 1.0f);
                ctx.renderPositiveZFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.SOUTH, ForgeDirection.WEST, -1, true, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(-1.0f, 0.0f, 0.0f);
                ctx.renderNegativeXFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.WEST, ForgeDirection.WEST, -1, true, false));
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(1.0f, 0.0f, 0.0f);
                ctx.renderPositiveXFacing(MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.EAST, ForgeDirection.WEST, -1, true, false));
                tess.func_78381_a();
            }
            ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            ctx.setRenderBoundsFromBlock();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    @Override
    public boolean renderStandardBlock(ISBRWorldContext ctx) {
        TileEntity te = ctx.getBlockAccess().func_147438_o(ctx.getX(), ctx.getY(), ctx.getZ());
        return te instanceof ITexturedTileEntity && this.renderStandardBlock(ctx, new ITexture[][]{GTMethodHelper.getTexture(te, ctx.getBlock(), ForgeDirection.DOWN), GTMethodHelper.getTexture(te, ctx.getBlock(), ForgeDirection.UP), GTMethodHelper.getTexture(te, ctx.getBlock(), ForgeDirection.NORTH), GTMethodHelper.getTexture(te, ctx.getBlock(), ForgeDirection.SOUTH), GTMethodHelper.getTexture(te, ctx.getBlock(), ForgeDirection.WEST), GTMethodHelper.getTexture(te, ctx.getBlock(), ForgeDirection.EAST)});
    }

    @Override
    public boolean renderStandardBlock(ISBRWorldContext ctx, ITexture[][] aTextures) {
        ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ctx.setRenderBoundsFromBlock();
        ctx.renderNegativeYFacing(aTextures[ForgeDirection.DOWN.ordinal()]);
        ctx.renderPositiveYFacing(aTextures[ForgeDirection.UP.ordinal()]);
        ctx.renderNegativeZFacing(aTextures[ForgeDirection.NORTH.ordinal()]);
        ctx.renderPositiveZFacing(aTextures[ForgeDirection.SOUTH.ordinal()]);
        ctx.renderNegativeXFacing(aTextures[ForgeDirection.WEST.ordinal()]);
        ctx.renderPositiveXFacing(aTextures[ForgeDirection.EAST.ordinal()]);
        return true;
    }

    public boolean renderPipeBlock(ISBRWorldContext ctx, IPipeRenderedTileEntity aTileEntity) {
        byte aConnections = aTileEntity.getConnections();
        float tThickness = aTileEntity.getThickNess();
        if (tThickness >= 0.99f) {
            return this.renderStandardBlock(ctx);
        }
        float sp = (1.0f - tThickness) / 2.0f;
        int connexionSidesBits = 0;
        for (int ordinalSide = 0; ordinalSide < 6; ++ordinalSide) {
            if ((aConnections & 1 << ordinalSide) == 0) continue;
            connexionSidesBits |= 1 << (ordinalSide + 2) % 6;
        }
        EnumSet<ForgeDirection> coveredSides = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!aTileEntity.hasCoverAtSide(side)) continue;
            coveredSides.add(side);
        }
        if (coveredSides.containsAll(EnumSet.of(ForgeDirection.DOWN, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}))) {
            return this.renderStandardBlock(ctx);
        }
        EnumMap<ForgeDirection, ITexture[]> texture = new EnumMap<ForgeDirection, ITexture[]>(ForgeDirection.class);
        EnumMap<ForgeDirection, ITexture[]> textureUncovered = new EnumMap<ForgeDirection, ITexture[]>(ForgeDirection.class);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            texture.put(side, GTMethodHelper.getTexture((TileEntity)aTileEntity, ctx.getBlock(), side));
            textureUncovered.put(side, aTileEntity.getTextureUncovered(side));
        }
        switch (connexionSidesBits) {
            case 0: {
                ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                ctx.setRenderBoundsFromBlock();
                ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                break;
            }
            case 3: {
                ctx.getBlock().func_149676_a(0.0f, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                ctx.setRenderBoundsFromBlock();
                ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                if (!coveredSides.contains(ForgeDirection.WEST)) {
                    ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                }
                if (coveredSides.contains(ForgeDirection.EAST)) break;
                ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                break;
            }
            case 12: {
                ctx.getBlock().func_149676_a(sp, 0.0f, sp, sp + tThickness, 1.0f, sp + tThickness);
                ctx.setRenderBoundsFromBlock();
                ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                if (!coveredSides.contains(ForgeDirection.DOWN)) {
                    ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                }
                if (coveredSides.contains(ForgeDirection.UP)) break;
                ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                break;
            }
            case 48: {
                ctx.getBlock().func_149676_a(sp, sp, 0.0f, sp + tThickness, sp + tThickness, 1.0f);
                ctx.setRenderBoundsFromBlock();
                ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                if (!coveredSides.contains(ForgeDirection.NORTH)) {
                    ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                }
                if (coveredSides.contains(ForgeDirection.SOUTH)) break;
                ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                break;
            }
            default: {
                if ((connexionSidesBits & 1) == 0) {
                    ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                } else {
                    ctx.getBlock().func_149676_a(0.0f, sp, sp, sp, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                    ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                    ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                    ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                    if (!coveredSides.contains(ForgeDirection.WEST)) {
                        ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                    }
                }
                if ((connexionSidesBits & 2) == 0) {
                    ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                } else {
                    ctx.getBlock().func_149676_a(sp + tThickness, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                    ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                    ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                    ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                    if (!coveredSides.contains(ForgeDirection.EAST)) {
                        ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                    }
                }
                if ((connexionSidesBits & 4) == 0) {
                    ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                } else {
                    ctx.getBlock().func_149676_a(sp, 0.0f, sp, sp + tThickness, sp, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                    ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                    ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                    ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                    if (!coveredSides.contains(ForgeDirection.DOWN)) {
                        ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                    }
                }
                if ((connexionSidesBits & 8) == 0) {
                    ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                } else {
                    ctx.getBlock().func_149676_a(sp, sp + tThickness, sp, sp + tThickness, 1.0f, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                    ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                    ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                    ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                    if (!coveredSides.contains(ForgeDirection.UP)) {
                        ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                    }
                }
                if ((connexionSidesBits & 0x10) == 0) {
                    ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                } else {
                    ctx.getBlock().func_149676_a(sp, sp, 0.0f, sp + tThickness, sp + tThickness, sp);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                    ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                    ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                    ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                    if (!coveredSides.contains(ForgeDirection.NORTH)) {
                        ctx.renderNegativeZFacing((ITexture[])textureUncovered.get(ForgeDirection.NORTH));
                    }
                }
                if ((connexionSidesBits & 0x20) == 0) {
                    ctx.getBlock().func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    ctx.setRenderBoundsFromBlock();
                    ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
                    break;
                }
                ctx.getBlock().func_149676_a(sp, sp, sp + tThickness, sp + tThickness, sp + tThickness, 1.0f);
                ctx.setRenderBoundsFromBlock();
                ctx.renderNegativeYFacing((ITexture[])textureUncovered.get(ForgeDirection.DOWN));
                ctx.renderPositiveYFacing((ITexture[])textureUncovered.get(ForgeDirection.UP));
                ctx.renderNegativeXFacing((ITexture[])textureUncovered.get(ForgeDirection.WEST));
                ctx.renderPositiveXFacing((ITexture[])textureUncovered.get(ForgeDirection.EAST));
                if (coveredSides.contains(ForgeDirection.SOUTH)) break;
                ctx.renderPositiveZFacing((ITexture[])textureUncovered.get(ForgeDirection.SOUTH));
            }
        }
        if (coveredSides.contains(ForgeDirection.DOWN)) {
            ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            ctx.setRenderBoundsFromBlock();
            ctx.renderNegativeYFacing((ITexture[])texture.get(ForgeDirection.DOWN));
            ctx.renderPositiveYFacing((ITexture[])texture.get(ForgeDirection.DOWN));
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                ctx.renderNegativeZFacing((ITexture[])texture.get(ForgeDirection.DOWN));
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                ctx.renderPositiveZFacing((ITexture[])texture.get(ForgeDirection.DOWN));
            }
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                ctx.renderNegativeXFacing((ITexture[])texture.get(ForgeDirection.DOWN));
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                ctx.renderPositiveXFacing((ITexture[])texture.get(ForgeDirection.DOWN));
            }
        }
        if (coveredSides.contains(ForgeDirection.UP)) {
            ctx.getBlock().func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            ctx.setRenderBoundsFromBlock();
            ctx.renderNegativeYFacing((ITexture[])texture.get(ForgeDirection.UP));
            ctx.renderPositiveYFacing((ITexture[])texture.get(ForgeDirection.UP));
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                ctx.renderNegativeZFacing((ITexture[])texture.get(ForgeDirection.UP));
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                ctx.renderPositiveZFacing((ITexture[])texture.get(ForgeDirection.UP));
            }
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                ctx.renderNegativeXFacing((ITexture[])texture.get(ForgeDirection.UP));
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                ctx.renderPositiveXFacing((ITexture[])texture.get(ForgeDirection.UP));
            }
        }
        if (coveredSides.contains(ForgeDirection.NORTH)) {
            ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
            ctx.setRenderBoundsFromBlock();
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                ctx.renderNegativeYFacing((ITexture[])texture.get(ForgeDirection.NORTH));
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                ctx.renderPositiveYFacing((ITexture[])texture.get(ForgeDirection.NORTH));
            }
            ctx.renderNegativeZFacing((ITexture[])texture.get(ForgeDirection.NORTH));
            ctx.renderPositiveZFacing((ITexture[])texture.get(ForgeDirection.NORTH));
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                ctx.renderNegativeXFacing((ITexture[])texture.get(ForgeDirection.NORTH));
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                ctx.renderPositiveXFacing((ITexture[])texture.get(ForgeDirection.NORTH));
            }
        }
        if (coveredSides.contains(ForgeDirection.SOUTH)) {
            ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            ctx.setRenderBoundsFromBlock();
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                ctx.renderNegativeYFacing((ITexture[])texture.get(ForgeDirection.SOUTH));
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                ctx.renderPositiveYFacing((ITexture[])texture.get(ForgeDirection.SOUTH));
            }
            ctx.renderNegativeZFacing((ITexture[])texture.get(ForgeDirection.SOUTH));
            ctx.renderPositiveZFacing((ITexture[])texture.get(ForgeDirection.SOUTH));
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                ctx.renderNegativeXFacing((ITexture[])texture.get(ForgeDirection.SOUTH));
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                ctx.renderPositiveXFacing((ITexture[])texture.get(ForgeDirection.SOUTH));
            }
        }
        if (coveredSides.contains(ForgeDirection.WEST)) {
            ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            ctx.setRenderBoundsFromBlock();
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                ctx.renderNegativeYFacing((ITexture[])texture.get(ForgeDirection.WEST));
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                ctx.renderPositiveYFacing((ITexture[])texture.get(ForgeDirection.WEST));
            }
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                ctx.renderNegativeZFacing((ITexture[])texture.get(ForgeDirection.WEST));
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                ctx.renderPositiveZFacing((ITexture[])texture.get(ForgeDirection.WEST));
            }
            ctx.renderNegativeXFacing((ITexture[])texture.get(ForgeDirection.WEST));
            ctx.renderPositiveXFacing((ITexture[])texture.get(ForgeDirection.WEST));
        }
        if (coveredSides.contains(ForgeDirection.EAST)) {
            ctx.getBlock().func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            ctx.setRenderBoundsFromBlock();
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                ctx.renderNegativeYFacing((ITexture[])texture.get(ForgeDirection.EAST));
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                ctx.renderPositiveYFacing((ITexture[])texture.get(ForgeDirection.EAST));
            }
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                ctx.renderNegativeZFacing((ITexture[])texture.get(ForgeDirection.EAST));
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                ctx.renderPositiveZFacing((ITexture[])texture.get(ForgeDirection.EAST));
            }
            ctx.renderNegativeXFacing((ITexture[])texture.get(ForgeDirection.EAST));
            ctx.renderPositiveXFacing((ITexture[])texture.get(ForgeDirection.EAST));
        }
        ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ctx.setRenderBoundsFromBlock();
        return true;
    }

    public static void renderNegativeYFacing(ISBRWorldContext ctx, ITexture[] aIcon, boolean aFullBlock) {
        if (ctx.getBlockAccess() != null) {
            if (aFullBlock && !ctx.getRenderBlocks().field_147837_f && !ctx.getBlock().func_149646_a(ctx.getBlockAccess(), ctx.getX(), ctx.getY() - 1, ctx.getZ(), 0)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(ctx.getBlock().func_149677_c(ctx.getBlockAccess(), ctx.getX(), aFullBlock ? ctx.getY() - 1 : ctx.getY(), ctx.getZ()));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderYNeg(ctx);
            }
        }
        ctx.getRenderBlocks().field_147842_e = false;
    }

    public static void renderPositiveYFacing(ISBRWorldContext ctx, ITexture[] aIcon, boolean aFullBlock) {
        if (ctx.getBlockAccess() != null) {
            if (aFullBlock && !ctx.getRenderBlocks().field_147837_f && !ctx.getBlock().func_149646_a(ctx.getBlockAccess(), ctx.getX(), ctx.getY() + 1, ctx.getZ(), 1)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(ctx.getBlock().func_149677_c(ctx.getBlockAccess(), ctx.getX(), aFullBlock ? ctx.getY() + 1 : ctx.getY(), ctx.getZ()));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderYPos(ctx);
            }
        }
        ctx.getRenderBlocks().field_147842_e = false;
    }

    public static void renderNegativeZFacing(ISBRWorldContext ctx, ITexture[] aIcon, boolean aFullBlock) {
        if (ctx.getBlockAccess() != null) {
            if (aFullBlock && !ctx.getRenderBlocks().field_147837_f && !ctx.getBlock().func_149646_a(ctx.getBlockAccess(), ctx.getX(), ctx.getY(), ctx.getZ() - 1, 2)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(ctx.getBlock().func_149677_c(ctx.getBlockAccess(), ctx.getX(), ctx.getY(), aFullBlock ? ctx.getZ() - 1 : ctx.getZ()));
        }
        boolean bl = ctx.getRenderBlocks().field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderZNeg(ctx);
            }
        }
        ctx.getRenderBlocks().field_147842_e = false;
    }

    public static void renderPositiveZFacing(ISBRWorldContext ctx, ITexture[] aIcon, boolean aFullBlock) {
        if (ctx.getBlockAccess() != null) {
            if (aFullBlock && !ctx.getRenderBlocks().field_147837_f && !ctx.getBlock().func_149646_a(ctx.getBlockAccess(), ctx.getX(), ctx.getY(), ctx.getZ() + 1, 3)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(ctx.getBlock().func_149677_c(ctx.getBlockAccess(), ctx.getX(), ctx.getY(), aFullBlock ? ctx.getZ() + 1 : ctx.getZ()));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderZPos(ctx);
            }
        }
        ctx.getRenderBlocks().field_147842_e = false;
    }

    public static void renderNegativeXFacing(ISBRWorldContext ctx, ITexture[] aIcon, boolean aFullBlock) {
        if (ctx.getBlockAccess() != null) {
            if (aFullBlock && !ctx.getRenderBlocks().field_147837_f && !ctx.getBlock().func_149646_a(ctx.getBlockAccess(), ctx.getX() - 1, ctx.getY(), ctx.getZ(), 4)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(ctx.getBlock().func_149677_c(ctx.getBlockAccess(), aFullBlock ? ctx.getX() - 1 : ctx.getX(), ctx.getY(), ctx.getZ()));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderXNeg(ctx);
            }
        }
        ctx.getRenderBlocks().field_147842_e = false;
    }

    @Override
    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        ISBRInventoryContext ctx = this.sbrContextHolder.getSBRInventoryContext(aBlock, aMeta, aModelID, aRenderer);
        if (aBlock instanceof BlockMachines && (aMeta += 30400) > 0 && aMeta < GregTechAPI.METATILEENTITIES.length && GregTechAPI.METATILEENTITIES[aMeta] != null && !GregTechAPI.METATILEENTITIES[aMeta].renderInInventory(ctx)) {
            MachineBlockRenderer.renderNormalInventoryMetaTileEntity(ctx);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        TesselatorAccessor tessAccess = (TesselatorAccessor)Tessellator.field_78398_a;
        ISBRWorldContext ctx = this.sbrContextHolder.getSBRWorldContext(aX, aY, aZ, aBlock, aModelID, aRenderer);
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity != null && (aTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)aTileEntity).getMetaTileEntity() != null && tessAccess.gt5u$hasVertices() && ((IGregTechTileEntity)aTileEntity).getMetaTileEntity().renderInWorld(ctx) || (aTileEntity instanceof IPipeRenderedTileEntity ? this.renderPipeBlock(ctx, (IPipeRenderedTileEntity)aTileEntity) : this.renderStandardBlock(ctx)));
    }

    @Override
    public int getRenderId() {
        return mRenderID;
    }
}

