/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.steam;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachineSteel;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTESteamMaceratorSteel
extends MTEBasicMachineSteel {
    public MTESteamMaceratorSteel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, "Macerating your Ores", 1, 1, true);
    }

    public MTESteamMaceratorSteel(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aDescription, aTextures, 1, 1, true);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamMaceratorSteel(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != ForgeDirection.UP && !aBaseMetaTileEntity.hasCoverAtSide(ForgeDirection.UP) && !aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) {
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setIdentifier((Enum)ParticleFX.SMOKE)).setPosition((float)aBaseMetaTileEntity.getXCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f, (float)aBaseMetaTileEntity.getYCoord() + 0.9f + XSTR.XSTR_INSTANCE.nextFloat() * 0.2f, (float)aBaseMetaTileEntity.getZCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f).setWorld(this.getBaseMetaTileEntity().getWorld()).run();
        }
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.maceratorRecipes;
    }

    @Override
    public int checkRecipe() {
        GTRecipe tRecipe = this.getRecipeMap().findRecipeQuery().caching(false).items(this.getAllInputs()).voltage(TierEU.LV).cachedRecipe(this.mLastRecipe).find();
        if (tRecipe == null) {
            return 0;
        }
        if (tRecipe.mCanBeBuffered) {
            this.mLastRecipe = tRecipe;
        }
        if (!this.canOutput(tRecipe)) {
            ++this.mOutputBlocked;
            return 1;
        }
        if (!tRecipe.isRecipeInputEqual(true, new FluidStack[]{this.getFillableStack()}, this.getAllInputs())) {
            return 1;
        }
        if (tRecipe.getOutput(0) != null) {
            this.mOutputItems[0] = tRecipe.getOutput(0);
        }
        this.calculateCustomOverclock(tRecipe);
        return 2;
    }

    @Override
    public boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && RecipeMaps.maceratorRecipes.containsInput(GTUtility.copyAmount(64, aStack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GTCEU_LOOP_MACERATOR;
    }

    @Override
    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{super.getSideFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{super.getSideFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{super.getFrontFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{super.getFrontFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{super.getTopFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{super.getTopFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{super.getBottomFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{super.getBottomFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR_GLOW).glow().build()};
    }
}

