/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEOilDrillBase;
import net.minecraftforge.fluids.FluidStack;

public class MTEOilDrillInfinite
extends MTEOilDrillBase {
    public MTEOilDrillInfinite(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEOilDrillInfinite(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Pump, FDP").addInfo("Works on " + this.getRangeInChunks() + "x" + this.getRangeInChunks() + " chunks").addInfo("Minimum energy hatch tier: " + GTUtility.getColoredTierNameFromTier((byte)this.getMinTier())).addInfo("Base cycle time: 1 tick").beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch("1x " + GTValues.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes or Circuits, optional, any base casing", 1).addOutputHatch("Any base casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEOilDrillInfinite(this.mName);
    }

    @Override
    protected FluidStack pumpOil(float speed, boolean simulate) {
        return super.pumpOil(speed, true);
    }

    @Override
    protected ItemList getCasingBlockItem() {
        return ItemList.Casing_MiningNeutronium;
    }

    @Override
    protected Materials getFrameMaterial() {
        return Materials.Neutronium;
    }

    @Override
    protected int getCasingTextureIndex() {
        return 178;
    }

    @Override
    protected int getRangeInChunks() {
        return 8;
    }

    @Override
    protected float computeSpeed() {
        return 0.5f + (float)(GTUtility.getTier(this.getMaxInputVoltage()) - this.getMinTier() + 5) * 0.25f;
    }

    @Override
    protected int getMinTier() {
        return 9;
    }
}

