/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.handlers;

import com.gtnewhorizons.modularui.api.math.Color;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerGogglesConfigHandler {
    public static Configuration config;
    public static double hudScale;
    public static int mainOffsetX;
    public static int mainOffsetY;
    public static int rectangleWidth;
    public static int rectangleHeight;
    public static double mainTextScaling;
    public static double subTextScaling;
    public static String gradientPreset;
    public static int formatIndex;
    public static int readingIndex;
    public static int gradientIndex;
    public static boolean showPowerChart;
    public static boolean hideWhenChatOpen;
    public static int gradientBadColor;
    public static int gradientOkColor;
    public static int gradientGoodColor;
    public static int textBadColor;
    public static int textOkColor;
    public static int textGoodColor;
    public static final Logger GOGGLES_LOGGER;

    public static void init(File confFile) {
        config = new Configuration(confFile);
        config.load();
        PowerGogglesConfigHandler.syncConfig();
    }

    public static void syncConfig() {
        try {
            mainOffsetX = config.get("general", "Render Offset X", 10, "").getInt(10);
            mainOffsetY = config.get("general", "Render Offset Y", 40, "").getInt(40);
            rectangleWidth = config.get("general", "Power Rectangle Width", 120, "").getInt(120);
            rectangleHeight = config.get("general", "Power Rectangle Height", 4, "").getInt(4);
            mainTextScaling = config.get("general", "Storage Text Scale", 1, "Text size of the storage EU reading").getDouble(1.0);
            subTextScaling = config.get("general", "Timed Reading Text Scale", 0.75, "Text size of the 5m and 1h readings").getDouble(0.75);
            gradientPreset = config.get("general", "Gradient Preset", "NORMAL", "Available options: NORMAL").getString();
            formatIndex = config.get("general", "Format Index", 0, "Available options: SI, SCIENTIFIC, ENGINEERING").getInt(0);
            readingIndex = config.get("general", "Reading Index", 0, "Available options: TOTAL, EUT, BOTH").getInt(0);
            gradientIndex = config.get("general", "Gradient Index", 0, "Available options: NORMAL, DEUTERANOPIA").getInt(0);
            showPowerChart = config.get("general", "Show Power Chart", false, "").getBoolean(false);
            hudScale = config.get("general", "HUD Scale", 1.0, "").getDouble(1.0);
            hideWhenChatOpen = config.get("general", "Hide HUD", false, "Hide the HUD when the in-game chat is open").getBoolean(false);
            gradientBadColor = config.get("general", "Bad Gradient", Color.rgb((int)255, (int)50, (int)50), "", 0, Integer.MAX_VALUE).getInt();
            gradientOkColor = config.get("general", "Ok Gradient", Color.rgb((int)50, (int)255, (int)50), "", 0, Integer.MAX_VALUE).getInt();
            gradientGoodColor = config.get("general", "Good Gradient", Color.rgb((int)50, (int)50, (int)255), "", 0, Integer.MAX_VALUE).getInt();
            textBadColor = config.get("general", "Bad Text", Color.rgb((int)255, (int)0, (int)0), "", 0, Integer.MAX_VALUE).getInt();
            textOkColor = config.get("general", "Ok Text", Color.rgb((int)255, (int)255, (int)255), "", 0, Integer.MAX_VALUE).getInt();
            textGoodColor = config.get("general", "Good Text", Color.rgb((int)0, (int)255, (int)0), "", 0, Integer.MAX_VALUE).getInt();
        }
        catch (Exception e) {
            GOGGLES_LOGGER.error("Couldn't load goggles config.");
            GOGGLES_LOGGER.debug((Object)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        GOGGLES_LOGGER = LogManager.getLogger((String)"GT5U Power Goggles");
    }
}

