/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import bartworks.common.loaders.ItemRegistry;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTUtility;
import gregtech.common.misc.GTStructureChannels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.block.BlockGodforgeGlass;
import tectech.thing.block.BlockQuantumGlass;

public class GlassTier {
    private static final Comparator<Pair<Integer, Integer>> tierComparator = Comparator.comparing(Pair::getLeft).thenComparing(Pair::getRight);
    private static final Map<Pair<Integer, Integer>, Pair<Block, Integer>> tierToGlass = new TreeMap<Pair<Integer, Integer>, Pair<Block, Integer>>(tierComparator);
    private static final HashMap<Pair<Block, Integer>, Pair<Integer, Integer>> glassToTierAndIndex = new HashMap();
    private static final int minTier = 3;
    private static final int maxTier = 12;
    private static final Pair<Integer, Integer> defaultGlassTier = Pair.of(null, (Object)0);
    private static final List<Pair<Block, Integer>> mainGlass = new ArrayList<Object>(Collections.nCopies(10, null));
    private static final List<Pair<Block, Integer>> glassList = new ArrayList<Pair<Block, Integer>>();

    public static void addCustomGlass(String modname, String unlocalisedBlockName, int meta, int tier, int subtier) {
        Block block = GameRegistry.findBlock((String)modname, (String)unlocalisedBlockName);
        if (block != null) {
            GlassTier.addCustomGlass(block, meta, tier, subtier);
        } else {
            new IllegalArgumentException("Block: " + unlocalisedBlockName + " of the Mod: " + modname + " was NOT found when attempting to register a glass!").printStackTrace();
        }
    }

    public static void addCustomGlass(@NotNull Block block, int meta, int tier, int subtier) {
        Objects.requireNonNull(block, "Glass block cannot be null");
        glassToTierAndIndex.put((Pair<Block, Integer>)Pair.of((Object)block, (Object)meta), (Pair<Integer, Integer>)Pair.of((Object)tier, (Object)-1));
        tierToGlass.put((Pair<Integer, Integer>)Pair.of((Object)tier, (Object)subtier), (Pair<Block, Integer>)Pair.of((Object)block, (Object)meta));
        if (subtier == 0) {
            mainGlass.set(tier - 3, (Pair<Block, Integer>)Pair.of((Object)block, (Object)meta));
        }
    }

    @Nullable
    public static Integer getGlassBlockTier(Block block, int meta) {
        return (Integer)glassToTierAndIndex.getOrDefault(Pair.of((Object)block, (Object)meta), defaultGlassTier).getLeft();
    }

    public static int getGlassChannelValue(Block block, int meta) {
        return (Integer)glassToTierAndIndex.getOrDefault(Pair.of((Object)block, (Object)meta), defaultGlassTier).getRight();
    }

    public static List<Pair<Block, Integer>> getGlassList() {
        if (glassList.isEmpty()) {
            int ctr = 1;
            for (Pair<Block, Integer> pair : mainGlass) {
                glassList.add(pair);
                glassToTierAndIndex.put(pair, (Pair<Integer, Integer>)Pair.of((Object)GlassTier.getGlassBlockTier((Block)pair.getLeft(), (Integer)pair.getRight()), (Object)ctr));
                GTStructureChannels.BOROGLASS.registerAsIndicator(new ItemStack((Block)pair.getLeft(), 1, ((Integer)pair.getRight()).intValue()), ctr);
                ++ctr;
            }
            for (Map.Entry entry : tierToGlass.entrySet()) {
                if ((Integer)((Pair)entry.getKey()).getRight() == 0) continue;
                Pair glass = (Pair)entry.getValue();
                glassList.add((Pair<Block, Integer>)glass);
                glassToTierAndIndex.put((Pair<Block, Integer>)glass, (Pair<Integer, Integer>)Pair.of((Object)((Integer)((Pair)entry.getKey()).getLeft()), (Object)ctr));
                GTStructureChannels.BOROGLASS.registerAsIndicator(new ItemStack((Block)glass.getLeft(), 1, ((Integer)glass.getRight()).intValue()), ctr);
                ++ctr;
            }
            glassList.add(mainGlass.get(mainGlass.size() - 1));
        }
        return glassList;
    }

    @SideOnly(value=Side.CLIENT)
    public static class GlassTooltipHandler {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void getTooltip(ItemTooltipEvent event) {
            int meta;
            if (event == null || event.itemStack == null || event.itemStack.func_77973_b() == null) {
                return;
            }
            Block block = Block.func_149634_a((Item)event.itemStack.func_77973_b());
            Integer tier = GlassTier.getGlassBlockTier(block, meta = event.itemStack.func_77960_j());
            if (tier == null) {
                return;
            }
            event.toolTip.add(StatCollector.func_74838_a((String)"tooltip.glass_tier.0.name") + " " + GTUtility.getColoredTierNameFromTier(tier.byteValue()));
        }
    }

    public static class RegisterGlassTiers {
        public static void run() {
            RegisterGlassTiers.registerGlassAsTiered();
            RegisterGlassTiers.registerGlassOreDicts();
        }

        private static void registerGlassAsTiered() {
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 0, 3, 0);
            if (Mods.EnderIO.isModLoaded()) {
                GlassTier.addCustomGlass(Mods.EnderIO.ID, "blockFusedQuartz", 1, 3, 1);
            }
            if (Mods.Thaumcraft.isModLoaded()) {
                GlassTier.addCustomGlass(Mods.Thaumcraft.ID, "blockCosmeticOpaque", 2, 3, 2);
            }
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 1, 4, 0);
            GlassTier.addCustomGlass(GregTechAPI.sBlockGlass1, 0, 4, 1);
            for (int i = 0; i < 4; ++i) {
                GlassTier.addCustomGlass(GregTechAPI.sBlockTintedGlass, i, 4, i + 2);
            }
            GlassTier.addCustomGlass(Mods.IndustrialCraft2.ID, "blockAlloyGlass", 0, 4, 6);
            if (Mods.BloodArsenal.isModLoaded()) {
                GlassTier.addCustomGlass(Mods.BloodArsenal.ID, "blood_stained_glass", 0, 4, 7);
            }
            if (Mods.Botania.isModLoaded()) {
                GlassTier.addCustomGlass(Mods.Botania.ID, "manaGlass", 0, 4, 8);
            }
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 2, 5, 0);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 12, 5, 1);
            if (Mods.Botania.isModLoaded()) {
                GlassTier.addCustomGlass(Mods.Botania.ID, "elfGlass", 0, 5, 2);
                GlassTier.addCustomGlass(Mods.Botania.ID, "bifrostPerm", 0, 5, 3);
            }
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 3, 6, 0);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 4, 7, 0);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 5, 8, 0);
            GlassTier.addCustomGlass((Block)BlockQuantumGlass.INSTANCE, 0, 8, 1);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 13, 9, 0);
            GlassTier.addCustomGlass(GregTechAPI.sBlockGlass1, 1, 9, 1);
            GlassTier.addCustomGlass(GregTechAPI.sBlockGlass1, 2, 9, 2);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 14, 10, 0);
            GlassTier.addCustomGlass(GregTechAPI.sBlockGlass1, 3, 10, 1);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas, 15, 11, 0);
            GlassTier.addCustomGlass(GregTechAPI.sBlockGlass1, 4, 11, 1);
            GlassTier.addCustomGlass(ItemRegistry.bw_realglas2, 0, 12, 0);
            GlassTier.addCustomGlass((Block)BlockGodforgeGlass.INSTANCE, 0, 12, 1);
            GlassTier.addCustomGlass(Loaders.antimatterContainmentCasing, 0, 12, 2);
            GlassTier.addCustomGlass(GregTechAPI.sBlockGlass1, 5, 12, 3);
        }

        private static void registerGlassOreDicts() {
            for (Map.Entry entry : glassToTierAndIndex.entrySet()) {
                String oreName = "blockGlass" + GTValues.VN[(Integer)((Pair)entry.getValue()).getLeft()];
                ItemStack itemStack = new ItemStack((Block)((Pair)entry.getKey()).getLeft(), 1, ((Integer)((Pair)entry.getKey()).getRight()).intValue());
                OreDictionary.registerOre((String)oreName, (ItemStack)itemStack);
            }
        }
    }
}

