/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.interfaces.internal.IGTCraftingRecipe;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.metatileentity.implementations.MTEBasicMachineWithRecipe;
import gregtech.api.objects.GTHashSet;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.ExternalMaterials;
import gregtech.api.util.GTConfig;
import gregtech.api.util.GTIBoxableWrapper;
import gregtech.api.util.GTItsNotMyFaultException;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTShapedRecipe;
import gregtech.api.util.GTShapelessRecipe;
import gregtech.api.util.GTUtility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.item.ItemWrapper;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import ic2.core.IHasGui;
import ic2.core.item.ItemToolbox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jetbrains.annotations.Nullable;

public class GTModHandler {
    public static final List<IRecipe> sSingleNonBlockDamagableRecipeList = new ArrayList<IRecipe>(1000);
    private static final Map<String, ItemStack> sIC2ItemMap = new HashMap<String, ItemStack>();
    public static final List<IRecipe> sAllRecipeList = new ArrayList<IRecipe>(5000);
    public static final List<IRecipe> sBufferRecipeList = new ArrayList<IRecipe>(1000);
    private static final List<ItemStack> delayedRemovalByOutput = new ArrayList<ItemStack>();
    private static final List<InventoryCrafting> delayedRemovalByRecipe = new ArrayList<InventoryCrafting>();
    public static Collection<String> sNativeRecipeClasses = new HashSet<String>();
    public static Collection<String> sSpecialRecipeClasses = new HashSet<String>();
    public static GTHashSet sNonReplaceableItems = new GTHashSet();
    public static Object sBoxableWrapper = new GTIBoxableWrapper();
    public static Collection<GTItemStack> sBoxableItems = new ArrayList<GTItemStack>();
    private static Set<GTUtility.ItemId> recyclerWhitelist;
    private static Set<GTUtility.ItemId> recyclerBlacklist;
    private static boolean sBufferCraftingRecipes;
    public static List<Integer> sSingleNonBlockDamagableRecipeList_list;
    public static List<Integer> sSingleNonBlockDamagableRecipeList_warntOutput;
    public static List<Integer> sVanillaRecipeList_warntOutput;
    public static List<Integer> sAnySteamFluidIDs;
    public static List<Integer> sSuperHeatedSteamFluidIDs;
    private static List<RecipeInputItemStack> tempRecyclerBlackList;
    private static List<IRecipe> bufferedRecipes;

    public static boolean isWater(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(Materials.Water.getFluid(1L)) || aFluid.isFluidEqual(GTModHandler.getDistilledWater(1L));
    }

    public static FluidStack getWater(long aAmount) {
        return Materials.Water.getFluid(aAmount);
    }

    public static FluidStack getDistilledWater(long aAmount) {
        FluidStack tFluid = FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)((int)aAmount));
        if (tFluid == null) {
            tFluid = Materials.Water.getFluid(aAmount);
        }
        return tFluid;
    }

    public static FluidStack getIC2Coolant(long aAmount) {
        if (Mods.IndustrialCraft2.isModLoaded()) {
            return FluidRegistry.getFluidStack((String)"ic2coolant", (int)((int)aAmount));
        }
        return Materials.Water.getFluid(aAmount);
    }

    public static FluidStack getLiquidDNA(long aAmount) {
        if (Mods.Gendustry.isModLoaded()) {
            return FluidRegistry.getFluidStack((String)"liquiddna", (int)((int)aAmount));
        }
        return Materials.Biomass.getFluid(aAmount);
    }

    public static boolean isLava(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(Materials.Lava.getFluid(1L));
    }

    public static FluidStack getLava(long aAmount) {
        return Materials.Lava.getFluid(aAmount);
    }

    public static boolean isSteam(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(Materials.Steam.getGas(1L));
    }

    public static boolean isAnySteam(FluidStack aFluid) {
        return aFluid != null && (GTModHandler.isSteam(aFluid) || sAnySteamFluidIDs.contains(aFluid.getFluidID()));
    }

    public static boolean isSuperHeatedSteam(FluidStack aFluid) {
        return aFluid != null && sSuperHeatedSteamFluidIDs.contains(aFluid.getFluidID());
    }

    @Deprecated
    public static FluidStack getSteam(long aAmount) {
        return Materials.Steam.getGas(aAmount);
    }

    @Deprecated
    public static FluidStack getMilk(long aAmount) {
        return Materials.Milk.getFluid(aAmount);
    }

    public static int getFuelValue(ItemStack aStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)aStack);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, ItemStack aReplacement) {
        if (GTUtility.isStringInvalid(aItem) || !GregTechAPI.sPreloadStarted) {
            return null;
        }
        if (!sIC2ItemMap.containsKey(aItem)) {
            ItemStack tStack = IC2Items.getItem((String)aItem);
            sIC2ItemMap.put(aItem, tStack);
            if (tStack == null && GTValues.D1) {
                GTLog.err.println(aItem + " is not found in the IC2 Items!");
            }
        }
        return GTUtility.copyAmount(aAmount, sIC2ItemMap.get(aItem), aReplacement);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
        ItemStack rStack = GTModHandler.getIC2Item(aItem, aAmount, aReplacement);
        if (rStack == null) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMeta);
        return rStack;
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, int aMeta) {
        return GTModHandler.getIC2Item(aItem, aAmount, aMeta, null);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount) {
        return GTModHandler.getIC2Item(aItem, aAmount, null);
    }

    public static ItemStack getModItem(String aModID, String aItem) {
        return GTModHandler.getModItem(aModID, aItem, 1L, null);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount) {
        return GTModHandler.getModItem(aModID, aItem, aAmount, null);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, ItemStack aReplacement) {
        ItemStack result = GTUtility.isStringInvalid(aItem) || !GregTechAPI.sPreloadStarted ? null : GTUtility.copyAmount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), aReplacement);
        if (result == null) {
            String reason = GTUtility.isStringInvalid(aItem) ? "the name of the item is an invalid string" : (!GregTechAPI.sPreloadStarted ? "the GT5U preloading phase has not yet started" : "the item was not found in the game registry");
            String log_message = "getModItem call: object \"" + aItem + "\" with mod id \"" + aModID + "\" has returned null because " + reason;
            GTLog.out.println(log_message);
            new Exception().printStackTrace(GTLog.out);
        }
        return result;
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, int aMeta) {
        ItemStack rStack = GTModHandler.getModItem(aModID, aItem, aAmount);
        if (rStack == null) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMeta);
        return rStack;
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
        ItemStack rStack = GTModHandler.getModItem(aModID, aItem, aAmount, aReplacement);
        if (rStack == null) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMeta);
        return rStack;
    }

    public static boolean addScrapboxDrop(float aChance, ItemStack aOutput) {
        if ((aOutput = GTOreDictUnificator.get(true, aOutput)) == null || aChance <= 0.0f) {
            return false;
        }
        aOutput.field_77994_a = 1;
        if (GTConfig.troll && !GTUtility.areStacksEqual(aOutput, new ItemStack(Items.field_151017_I, 1, 0))) {
            return false;
        }
        Recipes.scrapboxDrops.addDrop(GTUtility.copyOrNull(aOutput), aChance);
        return true;
    }

    public static boolean addToRecyclerBlackList(ItemStack aRecycledStack) {
        if (aRecycledStack == null) {
            return false;
        }
        RecipeInputItemStack iRecipeInput = new RecipeInputItemStack(aRecycledStack);
        if (Recipes.recyclerBlacklist == null) {
            tempRecyclerBlackList.add(iRecipeInput);
            return true;
        }
        if (tempRecyclerBlackList != null) {
            for (RecipeInputItemStack recipe : tempRecyclerBlackList) {
                Recipes.recyclerBlacklist.add((IRecipeInput)recipe);
            }
            tempRecyclerBlackList = null;
        }
        Recipes.recyclerBlacklist.add((IRecipeInput)iRecipeInput);
        return true;
    }

    public static boolean addSmeltingRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GTOreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(aInput, GTUtility.copyOrNull(aOutput), 0.0f);
        return true;
    }

    public static boolean addSmeltingAndAlloySmeltingRecipe(ItemStack aInput, ItemStack aOutput, boolean hidden) {
        ItemStack input2;
        boolean temp;
        if (aInput == null || aOutput == null) {
            return false;
        }
        boolean bl = temp = aInput.field_77994_a == 1 && GTModHandler.addSmeltingRecipe(aInput, aOutput);
        Object object = OrePrefixes.ingot.contains(aOutput) ? ItemList.Shape_Mold_Ingot.get(0L, new Object[0]) : (OrePrefixes.block.contains(aOutput) ? ItemList.Shape_Mold_Block.get(0L, new Object[0]) : (input2 = OrePrefixes.nugget.contains(aOutput) ? ItemList.Shape_Mold_Nugget.get(0L, new Object[0]) : null));
        if (Materials.Graphite.contains(aInput)) {
            return false;
        }
        if (input2 == null && (OrePrefixes.ingot.contains(aInput) || OrePrefixes.dust.contains(aInput) || OrePrefixes.gem.contains(aInput))) {
            return false;
        }
        GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
        if (input2 == null) {
            recipeBuilder.itemInputs(aInput);
        } else {
            recipeBuilder.itemInputs(aInput, input2);
        }
        recipeBuilder.itemOutputs(aOutput).duration(130).eut(3).recipeCategory(RecipeCategories.alloySmelterRecycling);
        if (hidden) {
            recipeBuilder.hidden();
        }
        recipeBuilder.addTo(RecipeMaps.alloySmelterRecipes);
        return true;
    }

    public static void removeAllIC2Recipes() {
        GTModHandler.getMaceratorRecipeList().entrySet().clear();
        GTModHandler.getCompressorRecipeList().entrySet().clear();
        GTModHandler.getExtractorRecipeList().entrySet().clear();
        GTModHandler.getOreWashingRecipeList().entrySet().clear();
        GTModHandler.getThermalCentrifugeRecipeList().entrySet().clear();
    }

    public static Map<IRecipeInput, RecipeOutput> getExtractorRecipeList() {
        return Recipes.extractor.getRecipes();
    }

    public static Map<IRecipeInput, RecipeOutput> getCompressorRecipeList() {
        return Recipes.compressor.getRecipes();
    }

    public static Map<IRecipeInput, RecipeOutput> getMaceratorRecipeList() {
        return Recipes.macerator.getRecipes();
    }

    public static Map<IRecipeInput, RecipeOutput> getThermalCentrifugeRecipeList() {
        return Recipes.centrifuge.getRecipes();
    }

    public static Map<IRecipeInput, RecipeOutput> getOreWashingRecipeList() {
        return Recipes.oreWashing.getRecipes();
    }

    public static void stopBufferingCraftingRecipes() {
        sBufferCraftingRecipes = false;
        GTModHandler.bulkRemoveRecipeByOutput(delayedRemovalByOutput);
        GTModHandler.bulkRemoveByRecipe(delayedRemovalByRecipe);
        sBufferRecipeList.forEach(GameRegistry::addRecipe);
        delayedRemovalByOutput.clear();
        delayedRemovalByRecipe.clear();
        sBufferRecipeList.clear();
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GTModHandler.addCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, false, true, false, false, false, false, false, false, false, false, false, false, true, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GTModHandler.addCraftingRecipe(aResult, 0L, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GTModHandler.addCraftingRecipe(aResult, null, null, (aBitMask & RecipeBits.MIRRORED) != 0L, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & RecipeBits.REVERSIBLE) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, aRecipe);
    }

    public static void addMachineCraftingRecipe(ItemStack aResult, Object @Nullable [] aRecipe, int machineTier) {
        GTModHandler.addMachineCraftingRecipe(aResult, RecipeBits.BITSD, aRecipe, machineTier);
    }

    public static void addMachineCraftingRecipe(ItemStack aResult, long aBitMask, Object @Nullable [] aRecipe, int machineTier) {
        if (aRecipe == null) {
            return;
        }
        for (int i = 3; i < aRecipe.length; ++i) {
            Object object;
            if (!(aRecipe[i] instanceof MTEBasicMachineWithRecipe.X)) continue;
            block0 : switch ((MTEBasicMachineWithRecipe.X)((Object)aRecipe[i])) {
                case CIRCUIT: {
                    switch (machineTier) {
                        case 0: {
                            object = OrePrefixes.circuit.get(Materials.ULV);
                            break block0;
                        }
                        case 1: {
                            object = OrePrefixes.circuit.get(Materials.LV);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.circuit.get(Materials.MV);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.circuit.get(Materials.HV);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.circuit.get(Materials.EV);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.circuit.get(Materials.IV);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.circuit.get(Materials.LuV);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.circuit.get(Materials.ZPM);
                            break block0;
                        }
                        case 8: {
                            object = OrePrefixes.circuit.get(Materials.UV);
                            break block0;
                        }
                    }
                    object = OrePrefixes.circuit.get(Materials.UHV);
                    break;
                }
                case BETTER_CIRCUIT: {
                    switch (machineTier) {
                        case 0: {
                            object = OrePrefixes.circuit.get(Materials.LV);
                            break block0;
                        }
                        case 1: {
                            object = OrePrefixes.circuit.get(Materials.MV);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.circuit.get(Materials.HV);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.circuit.get(Materials.EV);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.circuit.get(Materials.IV);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.circuit.get(Materials.LuV);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.circuit.get(Materials.ZPM);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.circuit.get(Materials.UV);
                            break block0;
                        }
                    }
                    object = OrePrefixes.circuit.get(Materials.UHV);
                    break;
                }
                case HULL: {
                    switch (machineTier) {
                        case 0: {
                            object = ItemList.Hull_ULV;
                            break block0;
                        }
                        case 1: {
                            object = ItemList.Hull_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Hull_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Hull_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Hull_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Hull_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Hull_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Hull_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Hull_UV;
                            break block0;
                        }
                    }
                    object = ItemList.Hull_MAX;
                    break;
                }
                case WIRE: {
                    switch (machineTier) {
                        case 0: {
                            object = OrePrefixes.cableGt01.get(Materials.Lead);
                            break block0;
                        }
                        case 1: {
                            object = OrePrefixes.cableGt01.get(Materials.Tin);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.cableGt01.get(Materials.AnyCopper);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.cableGt01.get(Materials.Gold);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.cableGt01.get(Materials.Aluminium);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.cableGt01.get(Materials.Platinum);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.cableGt01.get(Materials.NiobiumTitanium);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.cableGt01.get(Materials.Naquadah);
                            break block0;
                        }
                        case 8: {
                            object = OrePrefixes.cableGt04.get(Materials.NaquadahAlloy);
                            break block0;
                        }
                    }
                    object = OrePrefixes.wireGt01.get(Materials.SuperconductorUHV);
                    break;
                }
                case WIRE4: {
                    switch (machineTier) {
                        case 0: {
                            object = OrePrefixes.cableGt04.get(Materials.Lead);
                            break block0;
                        }
                        case 1: {
                            object = OrePrefixes.cableGt04.get(Materials.Tin);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.cableGt04.get(Materials.AnyCopper);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.cableGt04.get(Materials.Gold);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.cableGt04.get(Materials.Aluminium);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.cableGt04.get(Materials.Platinum);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.cableGt04.get(Materials.NiobiumTitanium);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.cableGt04.get(Materials.Naquadah);
                            break block0;
                        }
                        case 8: {
                            object = OrePrefixes.wireGt01.get(Materials.SuperconductorUHV);
                            break block0;
                        }
                    }
                    object = OrePrefixes.wireGt04.get(Materials.SuperconductorUHV);
                    break;
                }
                case STICK_DISTILLATION: {
                    object = OrePrefixes.stick.get(Materials.Blaze);
                    break;
                }
                case GLASS: {
                    switch (machineTier) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            object = new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE);
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            object = "blockGlass" + GTValues.VN[machineTier];
                            break block0;
                        }
                    }
                    object = "blockGlass" + GTValues.VN[8];
                    break;
                }
                case PLATE: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.plate.get(Materials.Steel);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.plate.get(Materials.Aluminium);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.plate.get(Materials.StainlessSteel);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.plate.get(Materials.Titanium);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.plate.get(Materials.TungstenSteel);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.plate.get(Materials.HSSG);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.plate.get(Materials.HSSE);
                            break block0;
                        }
                    }
                    object = OrePrefixes.plate.get(Materials.Neutronium);
                    break;
                }
                case PIPE: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.pipeMedium.get(Materials.Bronze);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.pipeMedium.get(Materials.Steel);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.pipeMedium.get(Materials.StainlessSteel);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.pipeMedium.get(Materials.Titanium);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.pipeMedium.get(Materials.TungstenSteel);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.pipeSmall.get(Materials.Ultimate);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.pipeMedium.get(Materials.Ultimate);
                            break block0;
                        }
                        case 8: {
                            object = OrePrefixes.pipeLarge.get(Materials.Ultimate);
                            break block0;
                        }
                    }
                    object = OrePrefixes.pipeHuge.get(Materials.Ultimate);
                    break;
                }
                case COIL_HEATING: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.wireGt02.get(Materials.AnyCopper);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.wireGt02.get(Materials.Cupronickel);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.wireGt02.get(Materials.Kanthal);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.wireGt02.get(Materials.Nichrome);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.wireGt02.get(Materials.TPV);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.wireGt02.get(Materials.HSSG);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.wireGt02.get(Materials.Naquadah);
                            break block0;
                        }
                        case 8: {
                            object = OrePrefixes.wireGt02.get(Materials.NaquadahAlloy);
                            break block0;
                        }
                        case 9: {
                            object = OrePrefixes.wireGt04.get(Materials.NaquadahAlloy);
                            break block0;
                        }
                    }
                    object = OrePrefixes.wireGt08.get(Materials.NaquadahAlloy);
                    break;
                }
                case COIL_HEATING_DOUBLE: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.wireGt04.get(Materials.AnyCopper);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.wireGt04.get(Materials.Cupronickel);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.wireGt04.get(Materials.Kanthal);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.wireGt04.get(Materials.Nichrome);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.wireGt04.get(Materials.TPV);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.wireGt04.get(Materials.HSSG);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.wireGt04.get(Materials.Naquadah);
                            break block0;
                        }
                        case 8: {
                            object = OrePrefixes.wireGt04.get(Materials.NaquadahAlloy);
                            break block0;
                        }
                        case 9: {
                            object = OrePrefixes.wireGt08.get(Materials.NaquadahAlloy);
                            break block0;
                        }
                    }
                    object = OrePrefixes.wireGt16.get(Materials.NaquadahAlloy);
                    break;
                }
                case STICK_MAGNETIC: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.stick.get(Materials.IronMagnetic);
                            break block0;
                        }
                        case 2: 
                        case 3: {
                            object = OrePrefixes.stick.get(Materials.SteelMagnetic);
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            object = OrePrefixes.stick.get(Materials.NeodymiumMagnetic);
                            break block0;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            object = OrePrefixes.stick.get(Materials.SamariumMagnetic);
                            break block0;
                        }
                    }
                    object = OrePrefixes.stick.get(Materials.TengamAttuned);
                    break;
                }
                case STICK_ELECTROMAGNETIC: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.stick.get(Materials.AnyIron);
                            break block0;
                        }
                        case 2: 
                        case 3: {
                            object = OrePrefixes.stick.get(Materials.Steel);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.stick.get(Materials.Neodymium);
                            break block0;
                        }
                    }
                    object = OrePrefixes.stick.get(Materials.VanadiumGallium);
                    break;
                }
                case COIL_ELECTRIC: {
                    switch (machineTier) {
                        case 0: {
                            object = OrePrefixes.wireGt01.get(Materials.Lead);
                            break block0;
                        }
                        case 1: {
                            object = OrePrefixes.wireGt02.get(Materials.Tin);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.wireGt02.get(Materials.AnyCopper);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.wireGt04.get(Materials.AnyCopper);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.wireGt08.get(Materials.AnnealedCopper);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.wireGt16.get(Materials.AnnealedCopper);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.wireGt04.get(Materials.YttriumBariumCuprate);
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.wireGt08.get(Materials.Iridium);
                            break block0;
                        }
                    }
                    object = OrePrefixes.wireGt16.get(Materials.Osmium);
                    break;
                }
                case ROBOT_ARM: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Robot_Arm_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Robot_Arm_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Robot_Arm_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Robot_Arm_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Robot_Arm_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Robot_Arm_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Robot_Arm_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Robot_Arm_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Robot_Arm_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Robot_Arm_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Robot_Arm_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Robot_Arm_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Robot_Arm_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Robot_Arm_MAX;
                    break;
                }
                case PUMP: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Electric_Pump_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Electric_Pump_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Electric_Pump_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Electric_Pump_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Electric_Pump_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Electric_Pump_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Electric_Pump_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Electric_Pump_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Electric_Pump_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Electric_Pump_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Electric_Pump_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Electric_Pump_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Electric_Pump_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Electric_Pump_MAX;
                    break;
                }
                case MOTOR: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Electric_Motor_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Electric_Motor_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Electric_Motor_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Electric_Motor_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Electric_Motor_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Electric_Motor_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Electric_Motor_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Electric_Motor_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Electric_Motor_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Electric_Motor_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Electric_Motor_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Electric_Motor_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Electric_Motor_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Electric_Motor_MAX;
                    break;
                }
                case PISTON: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Electric_Piston_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Electric_Piston_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Electric_Piston_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Electric_Piston_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Electric_Piston_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Electric_Piston_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Electric_Piston_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Electric_Piston_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Electric_Piston_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Electric_Piston_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Electric_Piston_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Electric_Piston_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Electric_Piston_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Electric_Piston_MAX;
                    break;
                }
                case CONVEYOR: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Conveyor_Module_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Conveyor_Module_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Conveyor_Module_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Conveyor_Module_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Conveyor_Module_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Conveyor_Module_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Conveyor_Module_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Conveyor_Module_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Conveyor_Module_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Conveyor_Module_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Conveyor_Module_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Conveyor_Module_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Conveyor_Module_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Conveyor_Module_MAX;
                    break;
                }
                case EMITTER: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Emitter_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Emitter_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Emitter_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Emitter_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Emitter_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Emitter_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Emitter_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Emitter_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Emitter_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Emitter_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Emitter_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Emitter_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Emitter_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Emitter_MAX;
                    break;
                }
                case SENSOR: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Sensor_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Sensor_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Sensor_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Sensor_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Sensor_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Sensor_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Sensor_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Sensor_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Sensor_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Sensor_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Sensor_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Sensor_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Sensor_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Sensor_MAX;
                    break;
                }
                case FIELD_GENERATOR: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = ItemList.Field_Generator_LV;
                            break block0;
                        }
                        case 2: {
                            object = ItemList.Field_Generator_MV;
                            break block0;
                        }
                        case 3: {
                            object = ItemList.Field_Generator_HV;
                            break block0;
                        }
                        case 4: {
                            object = ItemList.Field_Generator_EV;
                            break block0;
                        }
                        case 5: {
                            object = ItemList.Field_Generator_IV;
                            break block0;
                        }
                        case 6: {
                            object = ItemList.Field_Generator_LuV;
                            break block0;
                        }
                        case 7: {
                            object = ItemList.Field_Generator_ZPM;
                            break block0;
                        }
                        case 8: {
                            object = ItemList.Field_Generator_UV;
                            break block0;
                        }
                        case 9: {
                            object = ItemList.Field_Generator_UHV;
                            break block0;
                        }
                        case 10: {
                            object = ItemList.Field_Generator_UEV;
                            break block0;
                        }
                        case 11: {
                            object = ItemList.Field_Generator_UIV;
                            break block0;
                        }
                        case 12: {
                            object = ItemList.Field_Generator_UMV;
                            break block0;
                        }
                        case 13: {
                            object = ItemList.Field_Generator_UXV;
                            break block0;
                        }
                    }
                    object = ItemList.Field_Generator_MAX;
                    break;
                }
                case ROTOR: {
                    switch (machineTier) {
                        case 0: 
                        case 1: {
                            object = OrePrefixes.rotor.get(Materials.Tin);
                            break block0;
                        }
                        case 2: {
                            object = OrePrefixes.rotor.get(Materials.Bronze);
                            break block0;
                        }
                        case 3: {
                            object = OrePrefixes.rotor.get(Materials.Steel);
                            break block0;
                        }
                        case 4: {
                            object = OrePrefixes.rotor.get(Materials.StainlessSteel);
                            break block0;
                        }
                        case 5: {
                            object = OrePrefixes.rotor.get(Materials.TungstenSteel);
                            break block0;
                        }
                        case 6: {
                            object = OrePrefixes.rotor.get(ExternalMaterials.getRhodiumPlatedPalladium());
                            break block0;
                        }
                        case 7: {
                            object = OrePrefixes.rotor.get(Materials.Iridium);
                            break block0;
                        }
                    }
                    object = OrePrefixes.rotor.get(Materials.Osmium);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("MISSING TIER MAPPING FOR: " + aRecipe[i] + " AT TIER " + machineTier);
                }
            }
            aRecipe[i] = object;
        }
        if (!GTModHandler.addCraftingRecipe(aResult, aBitMask, aRecipe)) {
            throw new IllegalArgumentException("INVALID CRAFTING RECIPE FOR: " + aResult.func_82833_r());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, Object[] aRecipe) {
        aResult = GTOreDictUnificator.get(true, aResult);
        if (aOnlyAddIfResultIsNotNull && aResult == null) {
            return false;
        }
        if (aResult != null && Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        if (aRecipe == null || aRecipe.length == 0) {
            return false;
        }
        boolean tDoWeCareIfThereWasARecipe = aOnlyAddIfThereIsAnyRecipeOutputtingThis;
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof ItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        StringBuilder shape = new StringBuilder("");
        int idx = 0;
        if (aRecipe[idx] instanceof Boolean) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
        while (aRecipe[idx] instanceof String) {
            StringBuilder s = new StringBuilder((String)aRecipe[idx++]);
            shape.append((CharSequence)s);
            while (s.length() < 3) {
                s.append(" ");
            }
            if (s.length() > 3) {
                throw new IllegalArgumentException();
            }
            block31: for (char c : s.toString().toCharArray()) {
                switch (c) {
                    case 'b': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolBlade.name());
                        continue block31;
                    }
                    case 'c': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolCrowbar.name());
                        continue block31;
                    }
                    case 'd': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolScrewdriver.name());
                        continue block31;
                    }
                    case 'f': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolFile.name());
                        continue block31;
                    }
                    case 'h': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolHardHammer.name());
                        continue block31;
                    }
                    case 'i': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSolderingIron.name());
                        continue block31;
                    }
                    case 'j': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSolderingMetal.name());
                        continue block31;
                    }
                    case 'k': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolKnife.name());
                        continue block31;
                    }
                    case 'm': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolMortar.name());
                        continue block31;
                    }
                    case 'p': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolDrawplate.name());
                        continue block31;
                    }
                    case 'r': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSoftMallet.name());
                        continue block31;
                    }
                    case 's': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSaw.name());
                        continue block31;
                    }
                    case 'w': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolWrench.name());
                        continue block31;
                    }
                    case 'x': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolWireCutter.name());
                    }
                }
            }
        }
        aRecipe = tRecipeList.toArray();
        if (aRecipe[idx] instanceof Boolean) {
            ++idx;
        }
        HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
        HashMap<Character, ItemData> tItemDataMap = new HashMap<Character, ItemData>();
        tItemStackMap.put(Character.valueOf(' '), null);
        boolean tRemoveRecipe = true;
        while (idx < aRecipe.length) {
            if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                if (GTValues.D1) {
                    void var27_41;
                    GTLog.err.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                    Object[] objectArray = aRecipe;
                    int c = objectArray.length;
                    boolean bl = false;
                    while (var27_41 < c) {
                        Object tContent = objectArray[var27_41];
                        GTLog.err.println(tContent);
                        ++var27_41;
                    }
                }
                return false;
            }
            Character chr = (Character)aRecipe[idx];
            Object in = aRecipe[idx + 1];
            if (in instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)in;
                tItemStackMap.put(chr, GTUtility.copyOrNull(itemStack));
                tItemDataMap.put(chr, GTOreDictUnificator.getItemData(itemStack));
            } else if (in instanceof ItemData) {
                String tString;
                switch (tString = in.toString()) {
                    case "plankWood": {
                        tItemDataMap.put(chr, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    case "stoneNetherrack": {
                        tItemDataMap.put(chr, new ItemData(Materials.Netherrack, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    case "stoneObsidian": {
                        tItemDataMap.put(chr, new ItemData(Materials.Obsidian, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    case "stoneEndstone": {
                        tItemDataMap.put(chr, new ItemData(Materials.Endstone, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    default: {
                        tItemDataMap.put(chr, (ItemData)in);
                    }
                }
                ItemStack tStack = GTOreDictUnificator.getFirstOre(in, 1L);
                if (tStack == null) {
                    tRemoveRecipe = false;
                } else {
                    tItemStackMap.put(chr, tStack);
                }
                String string = in.toString();
                aRecipe[idx + 1] = string;
                in = string;
            } else if (in instanceof String) {
                if (in.equals(OreDictNames.craftingChest.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Wood, 29030400L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingBook.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Paper, 10886400L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingPiston.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Stone, 14515200L, Materials.Wood, 10886400L));
                } else if (in.equals(OreDictNames.craftingFurnace.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Stone, 29030400L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingIndustrialDiamond.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Diamond, 3628800L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingAnvil.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Iron, 36288000L, new MaterialStack[0]));
                }
                ItemStack tStack = GTOreDictUnificator.getFirstOre(in, 1L);
                if (tStack == null) {
                    tRemoveRecipe = false;
                } else {
                    tItemStackMap.put(chr, tStack);
                }
            } else {
                throw new IllegalArgumentException();
            }
            idx += 2;
        }
        if (aReversible && aResult != null) {
            ItemData[] tData = new ItemData[9];
            int x = -1;
            for (char chr : shape.toString().toCharArray()) {
                tData[++x] = (ItemData)tItemDataMap.get(Character.valueOf(chr));
            }
            if (GTUtility.arrayContainsNonNull(tData)) {
                GTOreDictUnificator.addItemData(aResult, new ItemData(tData));
            }
        }
        if (aCheckForCollisions && tRemoveRecipe) {
            ItemStack[] tRecipe = new ItemStack[9];
            int x = -1;
            for (char chr : shape.toString().toCharArray()) {
                tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                if (tRecipe[x] == null || Items.field_151008_G.getDamage(tRecipe[x]) != Short.MAX_VALUE) continue;
                Items.field_151008_G.setDamage(tRecipe[x], 0);
            }
            if (tDoWeCareIfThereWasARecipe || !aBuffered) {
                tThereWasARecipe = GTModHandler.removeRecipe(tRecipe) != null;
            } else {
                GTModHandler.removeRecipeDelayed(tRecipe);
            }
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return false;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            if (tDoWeCareIfThereWasARecipe || !aBuffered) {
                tThereWasARecipe = GTModHandler.removeRecipeByOutput(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes) || tThereWasARecipe;
            } else {
                GTModHandler.removeRecipeByOutputDelayed(aResult);
            }
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tDoWeCareIfThereWasARecipe && !tThereWasARecipe) {
            void var27_47;
            ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
            int tList_sS = tList.size();
            boolean bl = false;
            while (var27_47 < tList_sS && !tThereWasARecipe) {
                IRecipe tRecipe = (IRecipe)tList.get((int)var27_47);
                if (!sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) && GTUtility.areStacksEqual(GTOreDictUnificator.get(tRecipe.func_77571_b()), aResult, true)) {
                    tList.remove((int)var27_47--);
                    tList_sS = tList.size();
                    tThereWasARecipe = true;
                }
                ++var27_47;
            }
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GTUtility.updateItemStack(aResult);
        if (tThereWasARecipe || !aOnlyAddIfThereIsAnyRecipeOutputtingThis) {
            if (sBufferCraftingRecipes && aBuffered) {
                sBufferRecipeList.add((IRecipe)new GTShapedRecipe(GTUtility.copyOrNull(aResult), aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            } else {
                GameRegistry.addRecipe((IRecipe)new GTShapedRecipe(GTUtility.copyOrNull(aResult), aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            }
        }
        return true;
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GTModHandler.addShapelessCraftingRecipe(aResult, RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | RecipeBits.BUFFERED, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GTModHandler.addShapelessCraftingRecipe(aResult, null, null, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & RecipeBits.OVERWRITE_NBT) != 0L, aRecipe);
    }

    private static boolean addShapelessCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean overwriteNBT, Object[] aRecipe) {
        aResult = GTOreDictUnificator.get(true, aResult);
        if (aRecipe == null || aRecipe.length == 0) {
            return false;
        }
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        ItemStack[] tRecipe = new ItemStack[9];
        int i = 0;
        for (Object tObject : aRecipe) {
            if (tObject == null) {
                if (GTValues.D1) {
                    GTLog.err.println("WARNING: Missing Item for shapeless Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                }
                for (Object tContent : aRecipe) {
                    GTLog.err.println(tContent);
                }
                return false;
            }
            if (tObject instanceof ItemStack) {
                tRecipe[i] = (ItemStack)tObject;
            } else if (tObject instanceof String) {
                tRecipe[i] = GTOreDictUnificator.getFirstOre(tObject, 1L);
                if (tRecipe[i] == null) break;
            }
            ++i;
        }
        if (sBufferCraftingRecipes && aBuffered) {
            GTModHandler.removeRecipeDelayed(tRecipe);
        } else {
            GTModHandler.removeRecipe(tRecipe);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return false;
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GTUtility.updateItemStack(aResult);
        if (sBufferCraftingRecipes && aBuffered) {
            sBufferRecipeList.add(new GTShapelessRecipe(GTUtility.copyOrNull(aResult), aRemovable, aKeepNBT, overwriteNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        } else {
            GameRegistry.addRecipe((IRecipe)new GTShapelessRecipe(GTUtility.copyOrNull(aResult), aRemovable, aKeepNBT, overwriteNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        }
        return true;
    }

    public static boolean removeFurnaceSmelting(ItemStack aInput) {
        if (aInput != null) {
            for (ItemStack tInput : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
                if (!GTUtility.isStackValid(tInput) || !GTUtility.areStacksEqual(aInput, tInput, true)) continue;
                FurnaceRecipes.func_77602_a().func_77599_b().remove(tInput);
                return true;
            }
        }
        return false;
    }

    public static ItemStack removeRecipe(ItemStack ... aRecipe) {
        if (aRecipe == null) {
            return null;
        }
        if (Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return null;
        }
        ItemStack rReturn = null;
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        int tList_sS = tList.size();
        for (int i = 0; i < tList_sS; ++i) {
            while (i < tList_sS) {
                if ((!(tList.get(i) instanceof IGTCraftingRecipe) || ((IGTCraftingRecipe)tList.get(i)).isRemovable()) && ((IRecipe)tList.get(i)).func_77569_a(aCrafting, GTValues.DW)) {
                    rReturn = ((IRecipe)tList.get(i)).func_77572_b(aCrafting);
                    if (rReturn != null) {
                        tList.remove(i--);
                    }
                    tList_sS = tList.size();
                }
                ++i;
            }
        }
        return rReturn;
    }

    public static void removeRecipeDelayed(ItemStack ... aRecipe) {
        if (!sBufferCraftingRecipes) {
            GTModHandler.removeRecipe(aRecipe);
            return;
        }
        if (aRecipe == null) {
            return;
        }
        if (Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        delayedRemovalByRecipe.add(aCrafting);
    }

    public static void bulkRemoveByRecipe(List<InventoryCrafting> toRemove) {
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        GTMod.GT_FML_LOGGER.info("BulkRemoveByRecipe: tList: " + tList.size() + " toRemove: " + toRemove.size());
        Set tListToRemove = tList.parallelStream().filter(tRecipe -> {
            if (tRecipe instanceof IGTCraftingRecipe && !((IGTCraftingRecipe)tRecipe).isRemovable()) {
                return false;
            }
            return toRemove.stream().anyMatch(aCrafting -> tRecipe.func_77569_a(aCrafting, GTValues.DW));
        }).collect(Collectors.toSet());
        tList.removeIf(tListToRemove::contains);
    }

    public static boolean removeRecipeByOutputDelayed(ItemStack aOutput) {
        if (sBufferCraftingRecipes) {
            return delayedRemovalByOutput.add(aOutput);
        }
        return GTModHandler.removeRecipeByOutput(aOutput);
    }

    public static boolean removeRecipeByOutputDelayed(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers) {
        if (sBufferCraftingRecipes && aIgnoreNBT && !aNotRemoveShapelessRecipes && !aOnlyRemoveNativeHandlers) {
            return delayedRemovalByOutput.add(aOutput);
        }
        return GTModHandler.removeRecipeByOutput(aOutput, aIgnoreNBT, aNotRemoveShapelessRecipes, aOnlyRemoveNativeHandlers);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput) {
        return GTModHandler.removeRecipeByOutput(aOutput, true, false, false);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers) {
        if (aOutput == null) {
            return false;
        }
        boolean rReturn = false;
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        aOutput = GTOreDictUnificator.get(aOutput);
        int tList_sS = tList.size();
        for (int i = 0; i < tList_sS; ++i) {
            IRecipe tRecipe = (IRecipe)tList.get(i);
            if (aNotRemoveShapelessRecipes && (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) || (aOnlyRemoveNativeHandlers ? !sNativeRecipeClasses.contains(tRecipe.getClass().getName()) : sSpecialRecipeClasses.contains(tRecipe.getClass().getName()))) continue;
            ItemStack tStack = tRecipe.func_77571_b();
            if (tRecipe instanceof IGTCraftingRecipe && !((IGTCraftingRecipe)tRecipe).isRemovable() || !GTUtility.areStacksEqual(GTOreDictUnificator.get(tStack), aOutput, aIgnoreNBT)) continue;
            tList.remove(i--);
            tList_sS = tList.size();
            rReturn = true;
        }
        return rReturn;
    }

    public static boolean bulkRemoveRecipeByOutput(List<ItemStack> toRemove) {
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        Set setToRemove = toRemove.parallelStream().map(GTOreDictUnificator::get_nocopy).collect(Collectors.toSet());
        GTMod.GT_FML_LOGGER.info("BulkRemoveRecipeByOutput: tList: " + tList.size() + " setToRemove: " + setToRemove.size());
        Set tListToRemove = tList.parallelStream().filter(tRecipe -> {
            if (tRecipe instanceof IGTCraftingRecipe && !((IGTCraftingRecipe)tRecipe).isRemovable()) {
                return false;
            }
            if (sSpecialRecipeClasses.contains(tRecipe.getClass().getName())) {
                return false;
            }
            ItemStack tStack = GTOreDictUnificator.get_nocopy(tRecipe.func_77571_b());
            return setToRemove.stream().anyMatch(aOutput -> GTUtility.areStacksEqual(tStack, aOutput, true));
        }).collect(Collectors.toSet());
        tList.removeIf(tListToRemove::contains);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack getAllRecipeOutput(World aWorld, ItemStack ... aRecipe) {
        if (aRecipe == null || aRecipe.length == 0) {
            return null;
        }
        if (aWorld == null) {
            aWorld = GTValues.DW;
        }
        boolean temp = false;
        for (ItemStack itemStack : aRecipe) {
            if (itemStack == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        List tList = CraftingManager.func_77594_a().func_77592_b();
        List<IRecipe> list = sAllRecipeList;
        synchronized (list) {
            if (sAllRecipeList.size() != tList.size()) {
                sAllRecipeList.clear();
                sAllRecipeList.addAll(tList);
            }
            int j = sAllRecipeList.size();
            for (int i = 0; i < j; ++i) {
                IRecipe tRecipe = sAllRecipeList.get(i);
                if (!tRecipe.func_77569_a(aCrafting, aWorld)) continue;
                if (i > 10) {
                    sAllRecipeList.remove(i);
                    sAllRecipeList.add(i - 10, tRecipe);
                }
                return tRecipe.func_77572_b(aCrafting);
            }
        }
        int tIndex = 0;
        ItemStack tStack1 = null;
        ItemStack tStack2 = null;
        int j = aCrafting.func_70302_i_();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack = aCrafting.func_70301_a(i);
            if (tStack == null) continue;
            if (tIndex == 0) {
                tStack1 = tStack;
            }
            if (tIndex == 1) {
                tStack2 = tStack;
            }
            ++tIndex;
        }
        if (tIndex == 2 && tStack2 != null && tStack1.func_77973_b() == tStack2.func_77973_b() && tStack1.field_77994_a == 1 && tStack2.field_77994_a == 1 && tStack1.func_77973_b().isRepairable()) {
            int tNewDamage = tStack1.func_77958_k() + tStack1.func_77960_j() - tStack2.func_77960_j() + tStack1.func_77958_k() / 20;
            return new ItemStack(tStack1.func_77973_b(), 1, Math.max(tNewDamage, 0));
        }
        return null;
    }

    public static ItemStack getRecipeOutput(ItemStack ... aRecipe) {
        return GTModHandler.getRecipeOutput(false, false, aRecipe);
    }

    public static ItemStack getRecipeOutputPreferNonOreDict(ItemStack ... aRecipe) {
        return GTModHandler.getRecipeOutput(false, true, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, ItemStack ... aRecipe) {
        return GTModHandler.getRecipeOutput(aUncopiedStack, false, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, boolean aPreferNonOreDict, ItemStack ... aRecipe) {
        if (aRecipe == null || Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        boolean tOreDictRecipeFound = false;
        ItemStack tOreDictOutput = null;
        for (IRecipe iRecipe : tList) {
            ItemStack tOutput;
            if (!iRecipe.func_77569_a(aCrafting, GTValues.DW)) continue;
            ItemStack itemStack = tOutput = aUncopiedStack ? iRecipe.func_77571_b() : iRecipe.func_77572_b(aCrafting);
            if (aPreferNonOreDict && iRecipe instanceof ShapedOreRecipe) {
                if (tOreDictRecipeFound) continue;
                tOreDictOutput = tOutput;
                tOreDictRecipeFound = true;
                continue;
            }
            if (!(tOutput != null && tOutput.field_77994_a > 0 || GregTechAPI.sPostloadFinished)) {
                throw new GTItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
            }
            if (aUncopiedStack) {
                return tOutput;
            }
            return GTUtility.copyOrNull(tOutput);
        }
        if (!tOreDictRecipeFound) {
            return null;
        }
        if (!(tOreDictOutput != null && tOreDictOutput.field_77994_a > 0 || GregTechAPI.sPostloadFinished)) {
            throw new GTItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
        }
        if (aUncopiedStack) {
            return tOreDictOutput;
        }
        return GTUtility.copyOrNull(tOreDictOutput);
    }

    public static List<ItemStack> getRecipeOutputsBuffered(ItemStack ... aRecipe) {
        if (bufferedRecipes == null) {
            bufferedRecipes = CraftingManager.func_77594_a().func_77592_b().stream().filter(tRecipe -> !(tRecipe instanceof ShapelessRecipes) && !(tRecipe instanceof ShapelessOreRecipe) && !(tRecipe instanceof IGTCraftingRecipe)).filter(tRecipe -> {
                try {
                    ItemStack tOutput = tRecipe.func_77571_b();
                    if (tOutput.field_77994_a == 1 && tOutput.func_77958_k() > 0 && tOutput.func_77976_d() == 1) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }).collect(Collectors.toList());
        }
        return GTModHandler.getRecipeOutputs(bufferedRecipes, false, aRecipe);
    }

    public static List<ItemStack> getRecipeOutputs(List<IRecipe> aList, boolean aDeleteFromList, ItemStack ... aRecipe) {
        List<Object> rList = new ArrayList<ItemStack>();
        if (aRecipe == null || Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return rList;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        if (!aDeleteFromList) {
            HashSet stacks = new HashSet();
            aList.stream().filter(tRecipe -> {
                if (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe || tRecipe instanceof IGTCraftingRecipe) {
                    return false;
                }
                return tRecipe.func_77569_a(aCrafting, GTValues.DW);
            }).forEach(tRecipe -> stacks.add(tRecipe.func_77572_b(aCrafting)));
            rList = stacks.stream().filter(tOutput -> tOutput.field_77994_a == 1 && tOutput.func_77958_k() > 0 && tOutput.func_77976_d() == 1).collect(Collectors.toList());
        } else {
            Iterator<IRecipe> iterator = aList.iterator();
            while (iterator.hasNext()) {
                IRecipe tRecipe2 = iterator.next();
                if (!tRecipe2.func_77569_a(aCrafting, GTValues.DW)) continue;
                ItemStack tOutput2 = tRecipe2.func_77572_b(aCrafting);
                if (tOutput2 == null || tOutput2.field_77994_a <= 0) {
                    if (GregTechAPI.sPostloadFinished) continue;
                    throw new GTItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
                }
                if (tOutput2.field_77994_a != 1 || tOutput2.func_77958_k() <= 0 || tOutput2.func_77976_d() != 1 || tRecipe2 instanceof ShapelessRecipes || tRecipe2 instanceof ShapelessOreRecipe || tRecipe2 instanceof IGTCraftingRecipe) continue;
                rList.add(GTUtility.copyOrNull(tOutput2));
                iterator.remove();
            }
        }
        return rList;
    }

    public static ItemStack getSmeltingOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        if (aInput == null || aInput.field_77994_a < 1) {
            return null;
        }
        ItemStack rStack = GTOreDictUnificator.get(FurnaceRecipes.func_77602_a().func_151395_a(aInput));
        if (rStack != null && (aOutputSlot == null || GTUtility.areStacksEqual(rStack, aOutputSlot) && rStack.field_77994_a + aOutputSlot.field_77994_a <= aOutputSlot.func_77976_d())) {
            if (aRemoveInput) {
                --aInput.field_77994_a;
            }
            return rStack;
        }
        return null;
    }

    @Nullable
    public static ItemStack getRecyclerOutput(ItemStack aInput, int aScrapChance) {
        if (aInput == null || aScrapChance != 0) {
            return null;
        }
        if (recyclerWhitelist == null) {
            GTModHandler.generateRecyclerCache();
        }
        if (recyclerWhitelist.isEmpty()) {
            if (GTModHandler.searchRecyclerCache(aInput, recyclerBlacklist)) {
                return null;
            }
            return ItemList.IC2_Scrap.get(1L, new Object[0]);
        }
        if (GTModHandler.searchRecyclerCache(aInput, recyclerWhitelist)) {
            return ItemList.IC2_Scrap.get(1L, new Object[0]);
        }
        return null;
    }

    private static void generateRecyclerCache() {
        recyclerWhitelist = new HashSet<GTUtility.ItemId>();
        for (IRecipeInput input : Recipes.recyclerWhitelist) {
            for (ItemStack stack : input.getInputs()) {
                recyclerWhitelist.add(GTUtility.ItemId.create(stack.func_77973_b(), stack.func_77960_j(), null));
            }
        }
        recyclerBlacklist = new HashSet<GTUtility.ItemId>();
        for (IRecipeInput input : Recipes.recyclerBlacklist) {
            for (ItemStack stack : input.getInputs()) {
                recyclerBlacklist.add(GTUtility.ItemId.create(stack.func_77973_b(), stack.func_77960_j(), null));
            }
        }
    }

    private static boolean searchRecyclerCache(ItemStack stack, Set<GTUtility.ItemId> set) {
        if (set.contains(GTUtility.ItemId.createWithoutNBT(stack))) {
            return true;
        }
        return set.contains(GTUtility.ItemId.createAsWildcard(stack));
    }

    public static ItemStack getRandomScrapboxDrop() {
        return Recipes.scrapboxDrops.getDrop(ItemList.IC2_Scrapbox.get(1L, new Object[0]), false);
    }

    public static int chargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate) {
        int tTier;
        if (GTModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
            if (!aIgnoreLimit && tTier >= 0) {
                aCharge = (int)Math.min((long)aCharge, GTValues.V[Math.max(0, Math.min(GTValues.V.length - 1, tTier))]);
            }
            if (aCharge > 0) {
                int rCharge;
                return rCharge + ((rCharge = (int)Math.max(0.0, ElectricItem.manager.charge(aStack, (double)aCharge, tTier, true, aSimulate))) * 4 > aTier ? aTier : 0);
            }
        }
        return 0;
    }

    public static int dischargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate, boolean aIgnoreDischargability) {
        int tTier;
        if (GTModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
            if (!aIgnoreLimit && tTier >= 0) {
                int tier = Math.max(0, Math.min(GTValues.V.length - 1, tTier));
                aCharge = (int)Math.min((long)aCharge, GTValues.V[tier] + (long)GTValues.B[tier]);
            }
            if (aCharge > 0) {
                int rCharge = (int)Math.max(0.0, ElectricItem.manager.discharge(aStack, (double)(aCharge + (aCharge * 4 > aTier ? aTier : 0)), tTier, true, !aIgnoreDischargability, aSimulate));
                return rCharge - (rCharge * 4 > aTier ? aTier : 0);
            }
        }
        return 0;
    }

    public static boolean canUseElectricItem(ItemStack aStack, int aCharge) {
        if (GTModHandler.isElectricItem(aStack)) {
            return ElectricItem.manager.canUse(aStack, (double)aCharge);
        }
        return false;
    }

    public static boolean useElectricItem(ItemStack aStack, int aCharge, EntityPlayer aPlayer) {
        if (GTModHandler.isElectricItem(aStack)) {
            ElectricItem.manager.use(aStack, 0.0, (EntityLivingBase)aPlayer);
            if (ElectricItem.manager.canUse(aStack, (double)aCharge)) {
                return ElectricItem.manager.use(aStack, (double)aCharge, (EntityLivingBase)aPlayer);
            }
        }
        return false;
    }

    public static boolean damageOrDechargeItem(ItemStack aStack, int aDamage, int aDecharge, EntityLivingBase aPlayer) {
        if (GTUtility.isStackInvalid(aStack) || aStack.func_77976_d() <= 1 && aStack.field_77994_a > 1) {
            return false;
        }
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d) {
            return true;
        }
        if (aStack.func_77973_b() instanceof IDamagableItem) {
            return ((IDamagableItem)aStack.func_77973_b()).doDamageToItem(aStack, aDamage);
        }
        if (GTModHandler.isElectricItem(aStack)) {
            if (GTModHandler.canUseElectricItem(aStack, aDecharge)) {
                if (aPlayer instanceof EntityPlayer) {
                    return GTModHandler.useElectricItem(aStack, aDecharge, (EntityPlayer)aPlayer);
                }
                return GTModHandler.dischargeElectricItem(aStack, aDecharge, Integer.MAX_VALUE, true, false, true) >= aDecharge;
            }
        } else if (aStack.func_77973_b().func_77645_m()) {
            if (aPlayer == null) {
                aStack.func_77964_b(aStack.func_77960_j() + aDamage);
            } else {
                aStack.func_77972_a(aDamage, aPlayer);
            }
            if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                aStack.func_77964_b(aStack.func_77958_k() + 1);
                ItemStack tStack = GTUtility.getContainerItem(aStack, true);
                if (tStack != null) {
                    aStack.func_150996_a(tStack.func_77973_b());
                    aStack.func_77964_b(tStack.func_77960_j());
                    aStack.field_77994_a = tStack.field_77994_a;
                    aStack.func_77982_d(tStack.func_77978_p());
                } else if (aStack.field_77994_a > 0) {
                    --aStack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean useSolderingIron(ItemStack aStack, EntityLivingBase aPlayer, IInventory aExternalInventory) {
        if (aPlayer == null || aStack == null) {
            return false;
        }
        if (GTUtility.isStackInList(aStack, (Collection<GTItemStack>)GregTechAPI.sSolderingToolList)) {
            if (aPlayer instanceof EntityPlayer) {
                EntityPlayer tPlayer = (EntityPlayer)aPlayer;
                if (tPlayer.field_71075_bZ.field_75098_d) {
                    return true;
                }
                if (GTModHandler.isElectricItem(aStack) && ElectricItem.manager.getCharge(aStack) > 1000.0) {
                    if (GTModHandler.consumeSolderingMaterial(tPlayer) || aExternalInventory != null && GTModHandler.consumeSolderingMaterial(aExternalInventory)) {
                        if (GTModHandler.canUseElectricItem(aStack, 10000)) {
                            return GTModHandler.useElectricItem(aStack, 10000, (EntityPlayer)aPlayer);
                        }
                        GTModHandler.useElectricItem(aStack, (int)ElectricItem.manager.getCharge(aStack), (EntityPlayer)aPlayer);
                        return false;
                    }
                    GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, GTUtility.trans("094.1", "Not enough soldering material!"));
                }
            } else {
                GTModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer);
                return true;
            }
        }
        return false;
    }

    public static boolean useSolderingIron(ItemStack aStack, EntityLivingBase aPlayer) {
        return GTModHandler.useSolderingIron(aStack, aPlayer, null);
    }

    public static boolean consumeSolderingMaterial(EntityPlayer aPlayer) {
        if (aPlayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        InventoryPlayer tInventory = aPlayer.field_71071_by;
        if (GTModHandler.consumeSolderingMaterial((IInventory)tInventory)) {
            if (aPlayer.field_71069_bz != null) {
                aPlayer.field_71069_bz.func_75142_b();
            }
            return true;
        }
        for (int i = 0; i < tInventory.func_70302_i_(); ++i) {
            IHasGui tToolboxInventory;
            ItemStack tStack = tInventory.func_70301_a(i);
            if (tStack == null || !(tStack.func_77973_b() instanceof ItemToolbox) || !GTModHandler.consumeSolderingMaterial((IInventory)(tToolboxInventory = ((ItemToolbox)tStack.func_77973_b()).getInventory(aPlayer, tStack)))) continue;
            tInventory.func_70296_d();
            if (aPlayer.field_71069_bz != null) {
                aPlayer.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeSolderingMaterial(IInventory aInventory) {
        for (int i = 0; i < aInventory.func_70302_i_(); ++i) {
            ItemStack tStack = aInventory.func_70301_a(i);
            if (!GTUtility.isStackInList(tStack, (Collection<GTItemStack>)GregTechAPI.sSolderingMetalList)) continue;
            if (tStack.field_77994_a < 1) {
                return false;
            }
            if (tStack.field_77994_a == 1) {
                tStack = null;
            } else {
                --tStack.field_77994_a;
            }
            aInventory.func_70299_a(i, tStack);
            aInventory.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean isChargerItem(ItemStack aStack) {
        if (GTModHandler.isElectricItem(aStack)) {
            return ((IElectricItem)aStack.func_77973_b()).canProvideEnergy(aStack);
        }
        return false;
    }

    public static boolean isElectricItem(ItemStack aStack) {
        IElectricItem electricItem;
        Item item;
        return aStack != null && (item = aStack.func_77973_b()) instanceof IElectricItem && (electricItem = (IElectricItem)item).getTier(aStack) < Integer.MAX_VALUE;
    }

    public static boolean isElectricItem(ItemStack aStack, byte aTier) {
        IElectricItem electricItem;
        Item item;
        return aStack != null && (item = aStack.func_77973_b()) instanceof IElectricItem && (electricItem = (IElectricItem)item).getTier(aStack) == aTier;
    }

    public static Optional<Long[]> getElectricItemCharge(ItemStack aStack) {
        if (aStack == null || !GTModHandler.isElectricItem(aStack)) {
            return Optional.empty();
        }
        Item item = aStack.func_77973_b();
        if (item instanceof MetaBaseItem) {
            MetaBaseItem metaBaseItem = (MetaBaseItem)item;
            Long[] stats = metaBaseItem.getElectricStats(aStack);
            if (stats != null && stats.length > 0) {
                return Optional.of(new Long[]{metaBaseItem.getRealCharge(aStack), stats[0]});
            }
        } else if (item instanceof IElectricItem) {
            IElectricItem ic2ElectricItem = (IElectricItem)item;
            return Optional.of(new Long[]{(long)ElectricItem.manager.getCharge(aStack), (long)ic2ElectricItem.getMaxCharge(aStack)});
        }
        return Optional.empty();
    }

    public static void registerBoxableItemToToolBox(ItemStack aStack) {
        if (aStack != null) {
            ItemWrapper.registerBoxable((Item)aStack.func_77973_b(), (IBoxable)((IBoxable)sBoxableWrapper));
            sBoxableItems.add(new GTItemStack(aStack));
        }
    }

    public static int getCapsuleCellContainerCountMultipliedWithStackSize(ItemStack ... aStacks) {
        int rAmount = 0;
        for (ItemStack tStack : aStacks) {
            if (tStack == null) continue;
            rAmount += GTModHandler.getCapsuleCellContainerCount(tStack) * tStack.field_77994_a;
        }
        return rAmount;
    }

    public static int getCapsuleCellContainerCount(ItemStack aStack) {
        if (aStack == null) {
            return 0;
        }
        if (GTUtility.areStacksEqual(GTUtility.getContainerForFilledItem(aStack, true), ItemList.Cell_Empty.get(1L, new Object[0]))) {
            return 1;
        }
        if (GTUtility.areStacksEqual(aStack, GTModHandler.getIC2Item("waterCell", 1L, Short.MAX_VALUE))) {
            return 1;
        }
        for (OrePrefixes cellType : OrePrefixes.CELL_TYPES) {
            if (!cellType.contains(aStack)) continue;
            return 1;
        }
        return 0;
    }

    static {
        sBufferCraftingRecipes = true;
        sSingleNonBlockDamagableRecipeList_list = new ArrayList<Integer>(100);
        sSingleNonBlockDamagableRecipeList_warntOutput = new ArrayList<Integer>(50);
        sVanillaRecipeList_warntOutput = new ArrayList<Integer>(50);
        sAnySteamFluidIDs = new ArrayList<Integer>();
        sSuperHeatedSteamFluidIDs = new ArrayList<Integer>();
        sNativeRecipeClasses.add(ShapedRecipes.class.getName());
        sNativeRecipeClasses.add(ShapedOreRecipe.class.getName());
        sNativeRecipeClasses.add(GTShapedRecipe.class.getName());
        sNativeRecipeClasses.add(ShapelessRecipes.class.getName());
        sNativeRecipeClasses.add(ShapelessOreRecipe.class.getName());
        sNativeRecipeClasses.add(GTShapelessRecipe.class.getName());
        sNativeRecipeClasses.add(AdvRecipe.class.getName());
        sNativeRecipeClasses.add(AdvShapelessRecipe.class.getName());
        sNativeRecipeClasses.add("appeng.recipes.game.ShapedRecipe");
        sNativeRecipeClasses.add("appeng.recipes.game.ShapelessRecipe");
        sNativeRecipeClasses.add("forestry.core.utils.ShapedRecipeCustom");
        sSpecialRecipeClasses.add(RecipeFireworks.class.getName());
        sSpecialRecipeClasses.add(RecipesArmorDyes.class.getName());
        sSpecialRecipeClasses.add(RecipeBookCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapExtending.class.getName());
        sSpecialRecipeClasses.add("jds.bibliocraft.BiblioSpecialRecipes");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQBlockRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQuantumComputerRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.QBlockRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.FacadeRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.DisassembleRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.carts.LocomotivePaintingRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RotorRepairRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTableCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.TankCartFilterRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.LocomotiveEmblemRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostColorRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostEmblemRecipe");
        sSpecialRecipeClasses.add("mods.immibis.redlogic.interaction.RecipeDyeLumarButton");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesVoidRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe");
        sSpecialRecipeClasses.add("twilightforest.item.TFMapCloningRecipe");
        sSpecialRecipeClasses.add("forestry.lepidopterology.MatingRecipe");
        sSpecialRecipeClasses.add("micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes");
        sSpecialRecipeClasses.add("shedar.mods.ic2.nuclearcontrol.StorageArrayRecipe");
        tempRecyclerBlackList = new ArrayList<RecipeInputItemStack>();
        bufferedRecipes = null;
    }

    public static class RecipeBits {
        public static final long MIRRORED = GTValues.B[0];
        public static final long BUFFERED = GTValues.B[1];
        public static final long KEEPNBT = GTValues.B[2];
        public static final long DISMANTLEABLE = GTValues.B[3];
        public static final long NOT_REMOVABLE = GTValues.B[4];
        public static final long REVERSIBLE = GTValues.B[5];
        public static final long DELETE_ALL_OTHER_RECIPES = GTValues.B[6];
        public static final long DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT = GTValues.B[7];
        public static final long DELETE_ALL_OTHER_SHAPED_RECIPES = GTValues.B[8];
        public static final long DELETE_ALL_OTHER_NATIVE_RECIPES = GTValues.B[9];
        public static final long DO_NOT_CHECK_FOR_COLLISIONS = GTValues.B[10];
        public static final long ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT = GTValues.B[11];
        public static final long ONLY_ADD_IF_RESULT_IS_NOT_NULL = GTValues.B[12];
        public static final long DONT_REMOVE_SHAPELESS = GTValues.B[13];
        public static final long OVERWRITE_NBT = GTValues.B[14];
        public static final long BITS = NOT_REMOVABLE | REVERSIBLE | BUFFERED;
        public static final long BITSD = BITS | DISMANTLEABLE;
        public static final long BITS_STD = DO_NOT_CHECK_FOR_COLLISIONS | BUFFERED | ONLY_ADD_IF_RESULT_IS_NOT_NULL | NOT_REMOVABLE;
    }
}

