/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.render.ISBRInventoryContext;
import gregtech.api.render.ISBRWorldContext;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.covers.Cover;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MetaPipeEntity
extends CommonMetaTileEntity
implements IConnectable {
    public byte mConnections = 0;
    protected boolean mCheckConnections = false;
    private IGregTechTileEntity mBaseMetaTileEntity;

    public MetaPipeEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        this(aID, aBasicName, aRegionalName, aInvSlotCount, true);
    }

    public MetaPipeEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount, boolean aAddInfo) {
        super(aID, aBasicName, aRegionalName, aInvSlotCount);
        this.setBaseMetaTileEntity(new BaseMetaPipeEntity());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
        if (aAddInfo && GTMod.GT.isClientSide()) {
            this.addInfo(aID);
        }
    }

    protected final void addInfo(int aID) {
        if (!GTMod.GT.isClientSide()) {
            return;
        }
        ItemStack tStack = new ItemStack(GregTechAPI.sBlockMachines, 1, aID);
        Objects.requireNonNull(tStack.func_77973_b()).func_77624_a(tStack, null, new ArrayList(), true);
    }

    public MetaPipeEntity(String aName, int aInvSlotCount) {
        super(aName, aInvSlotCount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInInventory(ISBRInventoryContext ctx) {
        float tThickness = this.getThickness();
        float pipeMin = (1.0f - tThickness) / 2.0f;
        float pipeMax = 1.0f - pipeMin;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.func_147782_a(0.0, (double)pipeMin, (double)pipeMin, 1.0, (double)pipeMax, (double)pipeMax);
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        ITexture[] sideTexture = this.getTexture(mte, ForgeDirection.DOWN, 48, -1, false, false);
        ITexture[] endTexture = this.getTexture(mte, ForgeDirection.WEST, 48, -1, true, false);
        ctx.renderNegativeYFacing(sideTexture);
        ctx.renderPositiveYFacing(sideTexture);
        ctx.renderNegativeZFacing(sideTexture);
        ctx.renderPositiveZFacing(sideTexture);
        ctx.renderNegativeXFacing(endTexture);
        ctx.renderPositiveXFacing(endTexture);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(ISBRWorldContext ctx) {
        ITexture[] coverTexture;
        BaseMetaPipeEntity rte = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        if (rte == null) {
            return false;
        }
        byte aConnections = rte.getConnections();
        float thickness = this.getThickness();
        if (thickness >= 1.0f) {
            ctx.renderNegativeYFacing(rte.getTextureCovered(ForgeDirection.DOWN));
            ctx.renderPositiveYFacing(rte.getTextureCovered(ForgeDirection.UP));
            ctx.renderNegativeZFacing(rte.getTextureCovered(ForgeDirection.NORTH));
            ctx.renderPositiveZFacing(rte.getTextureCovered(ForgeDirection.SOUTH));
            ctx.renderNegativeXFacing(rte.getTextureCovered(ForgeDirection.WEST));
            ctx.renderPositiveXFacing(rte.getTextureCovered(ForgeDirection.EAST));
            return true;
        }
        float pipeMin = (1.0f - thickness) / 2.0f;
        float pipeMax = 1.0f - pipeMin;
        ITexture[] textureUp = rte.getTextureUncovered(ForgeDirection.UP);
        ITexture[] textureDown = rte.getTextureUncovered(ForgeDirection.DOWN);
        ITexture[] textureNorth = rte.getTextureUncovered(ForgeDirection.NORTH);
        ITexture[] textureSouth = rte.getTextureUncovered(ForgeDirection.SOUTH);
        ITexture[] textureWest = rte.getTextureUncovered(ForgeDirection.WEST);
        ITexture[] textureEast = rte.getTextureUncovered(ForgeDirection.EAST);
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        switch (aConnections) {
            case 0: {
                renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                ctx.renderNegativeYFacing(textureDown);
                ctx.renderPositiveYFacing(textureUp);
                ctx.renderNegativeZFacing(textureNorth);
                ctx.renderPositiveZFacing(textureSouth);
                ctx.renderNegativeXFacing(textureWest);
                ctx.renderPositiveXFacing(textureEast);
                break;
            }
            case 48: {
                renderBlocks.func_147782_a(0.0, (double)pipeMin, (double)pipeMin, 1.0, (double)pipeMax, (double)pipeMax);
                ctx.renderNegativeYFacing(textureDown);
                ctx.renderPositiveYFacing(textureUp);
                ctx.renderNegativeZFacing(textureNorth);
                ctx.renderPositiveZFacing(textureSouth);
                ctx.renderNegativeXFacing(textureWest);
                ctx.renderPositiveXFacing(textureEast);
                break;
            }
            case 3: {
                renderBlocks.func_147782_a((double)pipeMin, 0.0, (double)pipeMin, (double)pipeMax, 1.0, (double)pipeMax);
                ctx.renderNegativeZFacing(textureNorth);
                ctx.renderPositiveZFacing(textureSouth);
                ctx.renderNegativeXFacing(textureWest);
                ctx.renderPositiveXFacing(textureEast);
                ctx.renderNegativeYFacing(textureDown);
                ctx.renderPositiveYFacing(textureUp);
                break;
            }
            case 12: {
                renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, 0.0, (double)pipeMax, (double)pipeMax, 1.0);
                ctx.renderNegativeYFacing(textureDown);
                ctx.renderPositiveYFacing(textureUp);
                ctx.renderNegativeXFacing(textureWest);
                ctx.renderPositiveXFacing(textureEast);
                ctx.renderNegativeZFacing(textureNorth);
                ctx.renderPositiveZFacing(textureSouth);
                break;
            }
            default: {
                if ((aConnections & 0x10) == 0) {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                } else {
                    renderBlocks.func_147782_a(0.0, (double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax);
                    ctx.renderNegativeYFacing(textureDown);
                    ctx.renderPositiveYFacing(textureUp);
                    ctx.renderNegativeZFacing(textureNorth);
                    ctx.renderPositiveZFacing(textureSouth);
                }
                ctx.renderNegativeXFacing(textureWest);
                if ((aConnections & 0x20) == 0) {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                } else {
                    renderBlocks.func_147782_a((double)pipeMax, (double)pipeMin, (double)pipeMin, 1.0, (double)pipeMax, (double)pipeMax);
                    ctx.renderNegativeYFacing(textureDown);
                    ctx.renderPositiveYFacing(textureUp);
                    ctx.renderNegativeZFacing(textureNorth);
                    ctx.renderPositiveZFacing(textureSouth);
                }
                ctx.renderPositiveXFacing(textureEast);
                if ((aConnections & 1) == 0) {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                } else {
                    renderBlocks.func_147782_a((double)pipeMin, 0.0, (double)pipeMin, (double)pipeMax, (double)pipeMin, (double)pipeMax);
                    ctx.renderNegativeZFacing(textureNorth);
                    ctx.renderPositiveZFacing(textureSouth);
                    ctx.renderNegativeXFacing(textureWest);
                    ctx.renderPositiveXFacing(textureEast);
                }
                ctx.renderNegativeYFacing(textureDown);
                if ((aConnections & 2) == 0) {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                } else {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMax, (double)pipeMin, (double)pipeMax, 1.0, (double)pipeMax);
                    ctx.renderNegativeZFacing(textureNorth);
                    ctx.renderPositiveZFacing(textureSouth);
                    ctx.renderNegativeXFacing(textureWest);
                    ctx.renderPositiveXFacing(textureEast);
                }
                ctx.renderPositiveYFacing(textureUp);
                if ((aConnections & 4) == 0) {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                } else {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, 0.0, (double)pipeMax, (double)pipeMax, (double)pipeMin);
                    ctx.renderNegativeYFacing(textureDown);
                    ctx.renderPositiveYFacing(textureUp);
                    ctx.renderNegativeXFacing(textureWest);
                    ctx.renderPositiveXFacing(textureEast);
                }
                ctx.renderNegativeZFacing(textureNorth);
                if ((aConnections & 8) == 0) {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax);
                } else {
                    renderBlocks.func_147782_a((double)pipeMin, (double)pipeMin, (double)pipeMax, (double)pipeMax, (double)pipeMax, 1.0);
                    ctx.renderNegativeYFacing(textureDown);
                    ctx.renderPositiveYFacing(textureUp);
                    ctx.renderNegativeXFacing(textureWest);
                    ctx.renderPositiveXFacing(textureEast);
                }
                ctx.renderPositiveZFacing(textureSouth);
            }
        }
        boolean hasCoverDown = rte.hasCoverAtSide(ForgeDirection.DOWN);
        boolean hasCoverUp = rte.hasCoverAtSide(ForgeDirection.UP);
        boolean hasCoverNorth = rte.hasCoverAtSide(ForgeDirection.NORTH);
        boolean hasCoverSouth = rte.hasCoverAtSide(ForgeDirection.SOUTH);
        boolean hasCoverWest = rte.hasCoverAtSide(ForgeDirection.WEST);
        boolean hasCoverEast = rte.hasCoverAtSide(ForgeDirection.EAST);
        float coverThickness = Float.min(0.125f, (1.0f - thickness) / 2.0f);
        float coverInnerMin = 0.0f + coverThickness;
        float coverInnerMax = 1.0f - coverThickness;
        if (hasCoverDown) {
            coverTexture = rte.getTexture(ForgeDirection.DOWN);
            renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, (double)coverInnerMin, 1.0);
            if (!hasCoverNorth) {
                ctx.renderNegativeZFacing(coverTexture);
            }
            if (!hasCoverSouth) {
                ctx.renderPositiveZFacing(coverTexture);
            }
            if (!hasCoverWest) {
                ctx.renderNegativeXFacing(coverTexture);
            }
            if (!hasCoverEast) {
                ctx.renderPositiveXFacing(coverTexture);
            }
            ctx.renderPositiveYFacing(coverTexture);
            if ((aConnections & 1) != 0) {
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.0, (double)pipeMin);
                ctx.renderNegativeYFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, 0.0, (double)pipeMax, 1.0, 0.0, 1.0);
                ctx.renderNegativeYFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, 0.0, (double)pipeMin, (double)pipeMin, 0.0, (double)pipeMax);
                ctx.renderNegativeYFacing(coverTexture);
                renderBlocks.func_147782_a((double)pipeMax, 0.0, (double)pipeMin, 1.0, 0.0, (double)pipeMax);
            }
            ctx.renderNegativeYFacing(coverTexture);
        }
        if (hasCoverUp) {
            coverTexture = rte.getTexture(ForgeDirection.UP);
            renderBlocks.func_147782_a(0.0, (double)coverInnerMax, 0.0, 1.0, 1.0, 1.0);
            if (!hasCoverNorth) {
                ctx.renderNegativeZFacing(coverTexture);
            }
            if (!hasCoverSouth) {
                ctx.renderPositiveZFacing(coverTexture);
            }
            if (!hasCoverWest) {
                ctx.renderNegativeXFacing(coverTexture);
            }
            if (!hasCoverEast) {
                ctx.renderPositiveXFacing(coverTexture);
            }
            ctx.renderNegativeYFacing(coverTexture);
            if ((aConnections & 2) != 0) {
                renderBlocks.func_147782_a(0.0, 1.0, 0.0, 1.0, 1.0, (double)pipeMin);
                ctx.renderPositiveYFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, 1.0, (double)pipeMax, 1.0, 1.0, 1.0);
                ctx.renderPositiveYFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, 1.0, (double)pipeMin, (double)pipeMin, 1.0, (double)pipeMax);
                ctx.renderPositiveYFacing(coverTexture);
                renderBlocks.func_147782_a((double)pipeMax, 1.0, (double)pipeMin, 1.0, 1.0, (double)pipeMax);
            }
            ctx.renderPositiveYFacing(coverTexture);
        }
        if (hasCoverNorth) {
            coverTexture = rte.getTexture(ForgeDirection.NORTH);
            renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, (double)coverInnerMin);
            if (!hasCoverDown) {
                ctx.renderNegativeYFacing(coverTexture);
            }
            if (!hasCoverUp) {
                ctx.renderPositiveYFacing(coverTexture);
            }
            if (!hasCoverWest) {
                ctx.renderNegativeXFacing(coverTexture);
            }
            if (!hasCoverEast) {
                ctx.renderPositiveXFacing(coverTexture);
            }
            ctx.renderPositiveZFacing(coverTexture);
            if ((aConnections & 4) != 0) {
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, (double)pipeMin, 0.0);
                ctx.renderNegativeZFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMax, 0.0, 1.0, 1.0, 0.0);
                ctx.renderNegativeZFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMin, 0.0, (double)pipeMin, (double)pipeMax, 0.0);
                ctx.renderNegativeZFacing(coverTexture);
                renderBlocks.func_147782_a((double)pipeMax, (double)pipeMin, 0.0, 1.0, (double)pipeMax, 0.0);
            }
            ctx.renderNegativeZFacing(coverTexture);
        }
        if (hasCoverSouth) {
            coverTexture = rte.getTexture(ForgeDirection.SOUTH);
            renderBlocks.func_147782_a(0.0, 0.0, (double)coverInnerMax, 1.0, 1.0, 1.0);
            if (!hasCoverDown) {
                ctx.renderNegativeYFacing(coverTexture);
            }
            if (!hasCoverUp) {
                ctx.renderPositiveYFacing(coverTexture);
            }
            if (!hasCoverWest) {
                ctx.renderNegativeXFacing(coverTexture);
            }
            if (!hasCoverEast) {
                ctx.renderPositiveXFacing(coverTexture);
            }
            ctx.renderNegativeZFacing(coverTexture);
            if ((aConnections & 8) != 0) {
                renderBlocks.func_147782_a(0.0, 0.0, 1.0, 1.0, (double)pipeMin, 1.0);
                ctx.renderPositiveZFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMax, 1.0, 1.0, 1.0, 1.0);
                ctx.renderPositiveZFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMin, 1.0, (double)pipeMin, (double)pipeMax, 1.0);
                ctx.renderPositiveZFacing(coverTexture);
                renderBlocks.func_147782_a((double)pipeMax, (double)pipeMin, 1.0, 1.0, (double)pipeMax, 1.0);
            }
            ctx.renderPositiveZFacing(coverTexture);
        }
        if (hasCoverWest) {
            coverTexture = rte.getTexture(ForgeDirection.WEST);
            renderBlocks.func_147782_a(0.0, 0.0, 0.0, (double)coverInnerMin, 1.0, 1.0);
            if (!hasCoverDown) {
                ctx.renderNegativeYFacing(coverTexture);
            }
            if (!hasCoverUp) {
                ctx.renderPositiveYFacing(coverTexture);
            }
            if (!hasCoverNorth) {
                ctx.renderNegativeZFacing(coverTexture);
            }
            if (!hasCoverSouth) {
                ctx.renderPositiveZFacing(coverTexture);
            }
            ctx.renderPositiveXFacing(coverTexture);
            if ((aConnections & 0x10) != 0) {
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.0, (double)pipeMin, 1.0);
                ctx.renderNegativeXFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMax, 0.0, 0.0, 1.0, 1.0);
                ctx.renderNegativeXFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMin, 0.0, 0.0, (double)pipeMax, (double)pipeMin);
                ctx.renderNegativeXFacing(coverTexture);
                renderBlocks.func_147782_a(0.0, (double)pipeMin, (double)pipeMax, 0.0, (double)pipeMax, 1.0);
            }
            ctx.renderNegativeXFacing(coverTexture);
        }
        if (hasCoverEast) {
            coverTexture = rte.getTexture(ForgeDirection.EAST);
            renderBlocks.func_147782_a((double)coverInnerMax, 0.0, 0.0, 1.0, 1.0, 1.0);
            if (!hasCoverDown) {
                ctx.renderNegativeYFacing(coverTexture);
            }
            if (!hasCoverUp) {
                ctx.renderPositiveYFacing(coverTexture);
            }
            if (!hasCoverNorth) {
                ctx.renderNegativeZFacing(coverTexture);
            }
            if (!hasCoverSouth) {
                ctx.renderPositiveZFacing(coverTexture);
            }
            ctx.renderNegativeXFacing(coverTexture);
            if ((aConnections & 0x20) != 0) {
                renderBlocks.func_147782_a(1.0, 0.0, 0.0, 1.0, (double)pipeMin, 1.0);
                ctx.renderPositiveXFacing(coverTexture);
                renderBlocks.func_147782_a(1.0, (double)pipeMax, 0.0, 1.0, 1.0, 1.0);
                ctx.renderPositiveXFacing(coverTexture);
                renderBlocks.func_147782_a(1.0, (double)pipeMin, 0.0, 1.0, (double)pipeMax, (double)pipeMin);
                ctx.renderPositiveXFacing(coverTexture);
                renderBlocks.func_147782_a(1.0, (double)pipeMin, (double)pipeMax, 1.0, (double)pipeMax, 1.0);
            }
            ctx.renderPositiveXFacing(coverTexture);
        }
        return true;
    }

    public float getThickness() {
        if (GTMod.GT.isClientSide() && GTMod.clientProxy().shouldHideThings()) {
            return 0.0625f;
        }
        return this.getCollisionThickness();
    }

    public abstract float getCollisionThickness();

    public abstract boolean renderInside(ForgeDirection var1);

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, int connections, int colorIndex, boolean active, boolean redstoneLevel) {
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    @Override
    public IGregTechTileEntity getBaseMetaTileEntity() {
        return this.mBaseMetaTileEntity;
    }

    @Override
    public void setBaseMetaTileEntity(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mBaseMetaTileEntity != null && aBaseMetaTileEntity == null) {
            this.mBaseMetaTileEntity.getMetaTileEntity().inValidate();
            this.mBaseMetaTileEntity.setMetaTileEntity(null);
        }
        this.mBaseMetaTileEntity = aBaseMetaTileEntity;
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.setMetaTileEntity(this);
        }
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(GregTechAPI.sBlockMachines, (int)aAmount, this.getBaseMetaTileEntity().getMetaTileID());
    }

    public boolean isCoverOnSide(BaseMetaPipeEntity aPipe, EntityLivingBase aEntity) {
        boolean tCovered;
        ForgeDirection side = ForgeDirection.UNKNOWN;
        double difference = aEntity.field_70163_u - (double)aPipe.field_145848_d;
        if (difference > 0.6 && difference < 0.99) {
            side = ForgeDirection.UP;
        }
        if (difference < -1.5 && difference > -1.99) {
            side = ForgeDirection.DOWN;
        }
        if ((difference = aEntity.field_70161_v - (double)aPipe.field_145849_e) < -0.05 && difference > -0.4) {
            side = ForgeDirection.NORTH;
        }
        if (difference > 1.05 && difference < 1.4) {
            side = ForgeDirection.SOUTH;
        }
        if ((difference = aEntity.field_70165_t - (double)aPipe.field_145851_c) < -0.05 && difference > -0.4) {
            side = ForgeDirection.WEST;
        }
        if (difference > 1.05 && difference < 1.4) {
            side = ForgeDirection.EAST;
        }
        boolean bl = tCovered = side != ForgeDirection.UNKNOWN && this.mBaseMetaTileEntity.hasCoverAtSide(side);
        if (this.isConnectedAtSide(side)) {
            tCovered = true;
        }
        return tCovered;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        return false;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        return false;
    }

    @Override
    public void onExplosion() {
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return false;
    }

    public int fill_default(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        return this.fill(aFluid, doFill);
    }

    public int fill(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        return this.fill_default(side, aFluid, doFill);
    }

    @Override
    public float getExplosionResistance(ForgeDirection side) {
        return 5.0f;
    }

    public void func_70296_d() {
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        this.setCheckConnections();
    }

    @Override
    public void onColorChangeClient(byte aColor) {
    }

    public void setCheckConnections() {
        this.mCheckConnections = true;
    }

    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return 0L;
    }

    @Override
    public void doExplosion(long aExplosionPower) {
        float tStrength = GTValues.getExplosionPowerForVoltage(aExplosionPower);
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTechAPI.sMachineExplosions) {
            new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
        }
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    protected boolean connectableColor(TileEntity tTileEntity) {
        if (tTileEntity instanceof IColoredTileEntity && this.getBaseMetaTileEntity().getColorization() >= 0) {
            byte tColor = ((IColoredTileEntity)tTileEntity).getColorization();
            return tColor < 0 || tColor == this.getBaseMetaTileEntity().getColorization();
        }
        return true;
    }

    @Override
    public int connect(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return 0;
        }
        ForgeDirection oppositeSide = side.getOpposite();
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        if (baseMetaTile == null || !baseMetaTile.isServerSide()) {
            return 0;
        }
        Cover cover = baseMetaTile.getCoverAtSide(side);
        boolean alwaysLookConnected = cover.alwaysLookConnected();
        boolean letsIn = this.letsIn(cover);
        boolean letsOut = this.letsOut(cover);
        TileEntity tTileEntity = baseMetaTile.getTileEntityAtSide(side);
        if (!this.connectableColor(tTileEntity)) {
            return 0;
        }
        if (alwaysLookConnected || letsIn || letsOut) {
            IMetaTileEntity tPipe;
            IMetaTileEntity iMetaTileEntity = tPipe = tTileEntity instanceof IGregTechTileEntity ? ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() : null;
            if (this.getClass().isInstance(tPipe) || tPipe != null && tPipe.getClass().isInstance(this)) {
                this.connectAtSide(side);
                if (!((IConnectable)((Object)tPipe)).isConnectedAtSide(oppositeSide)) {
                    ((IConnectable)((Object)tPipe)).connect(oppositeSide);
                }
                return 1;
            }
            if (this.getGT6StyleConnection() && baseMetaTile.getAirAtSide(side) || this.canConnect(side, tTileEntity)) {
                this.connectAtSide(side);
                return 1;
            }
            if (!baseMetaTile.getWorld().func_72863_F().func_73149_a(baseMetaTile.getOffsetX(side, 1) >> 4, baseMetaTile.getOffsetZ(side, 1) >> 4)) {
                return -1;
            }
        }
        return 0;
    }

    protected void checkConnections() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getGT6StyleConnection() && !this.isConnectedAtSide(side) || this.connect(side) != 0) continue;
            this.disconnect(side);
        }
        this.mCheckConnections = false;
    }

    private void connectAtSide(ForgeDirection side) {
        this.mConnections = (byte)(this.mConnections | side.flag);
    }

    @Override
    public void disconnect(ForgeDirection side) {
        IMetaTileEntity tPipe;
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        this.mConnections = (byte)(this.mConnections & ~side.flag);
        ForgeDirection oppositeSide = side.getOpposite();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSide(side);
        IMetaTileEntity iMetaTileEntity = tPipe = tTileEntity == null ? null : tTileEntity.getMetaTileEntity();
        if ((this.getClass().isInstance(tPipe) || tPipe != null && tPipe.getClass().isInstance(this)) && ((IConnectable)((Object)tPipe)).isConnectedAtSide(oppositeSide)) {
            ((IConnectable)((Object)tPipe)).disconnect(oppositeSide);
        }
    }

    @Override
    public boolean isConnectedAtSide(ForgeDirection sideDirection) {
        return (this.mConnections & sideDirection.flag) != 0;
    }

    @Override
    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB physicalBoundingBox;
        AxisAlignedBB fullSizeBoundingBox;
        if (this.boundingBoxShouldBeFullBlock() && inputAABB.func_72326_a(fullSizeBoundingBox = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)))) {
            outputAABB.add(fullSizeBoundingBox);
        }
        if (inputAABB.func_72326_a(physicalBoundingBox = this.getPhysicalCollisionBoundingBox(x, y, z))) {
            outputAABB.add(physicalBoundingBox);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (this.boundingBoxShouldBeFullBlock()) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        return this.getPhysicalCollisionBoundingBox(x, y, z);
    }

    private boolean boundingBoxShouldBeFullBlock() {
        return GTMod.GT.isClientSide() && GTMod.clientProxy().forceFullBlockBB() || this.getCollisionThickness() == 1.0f;
    }

    @NotNull
    private AxisAlignedBB getPhysicalCollisionBoundingBox(int x, int y, int z) {
        byte connections;
        float space;
        float yStart = space = (1.0f - this.getCollisionThickness()) / 2.0f;
        float yEnd = 1.0f - space;
        float zStart = space;
        float zEnd = 1.0f - space;
        float xStart = space;
        float xEnd = 1.0f - space;
        BaseMetaPipeEntity baseTE = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        if (baseTE.hasCoverAtSide(ForgeDirection.DOWN)) {
            xStart = 0.0f;
            zStart = 0.0f;
            yStart = 0.0f;
            xEnd = 1.0f;
            zEnd = 1.0f;
        }
        if (baseTE.hasCoverAtSide(ForgeDirection.UP)) {
            xStart = 0.0f;
            zStart = 0.0f;
            xEnd = 1.0f;
            zEnd = 1.0f;
            yEnd = 1.0f;
        }
        if (baseTE.hasCoverAtSide(ForgeDirection.NORTH)) {
            xStart = 0.0f;
            zStart = 0.0f;
            yStart = 0.0f;
            xEnd = 1.0f;
            yEnd = 1.0f;
        }
        if (baseTE.hasCoverAtSide(ForgeDirection.SOUTH)) {
            xStart = 0.0f;
            yStart = 0.0f;
            xEnd = 1.0f;
            zEnd = 1.0f;
            yEnd = 1.0f;
        }
        if (baseTE.hasCoverAtSide(ForgeDirection.WEST)) {
            xStart = 0.0f;
            zStart = 0.0f;
            yStart = 0.0f;
            zEnd = 1.0f;
            yEnd = 1.0f;
        }
        if (baseTE.hasCoverAtSide(ForgeDirection.EAST)) {
            zStart = 0.0f;
            yStart = 0.0f;
            xEnd = 1.0f;
            zEnd = 1.0f;
            yEnd = 1.0f;
        }
        if (((connections = baseTE.mConnections) & ForgeDirection.DOWN.flag) != 0) {
            yStart = 0.0f;
        }
        if ((connections & ForgeDirection.UP.flag) != 0) {
            yEnd = 1.0f;
        }
        if ((connections & ForgeDirection.NORTH.flag) != 0) {
            zStart = 0.0f;
        }
        if ((connections & ForgeDirection.SOUTH.flag) != 0) {
            zEnd = 1.0f;
        }
        if ((connections & ForgeDirection.WEST.flag) != 0) {
            xStart = 0.0f;
        }
        if ((connections & ForgeDirection.EAST.flag) != 0) {
            xEnd = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)x + xStart), (double)((float)y + yStart), (double)((float)z + zStart), (double)((float)x + xEnd), (double)((float)y + yEnd), (double)((float)z + zEnd));
    }

    public boolean letsIn(Cover cover) {
        return false;
    }

    public boolean letsOut(Cover cover) {
        return false;
    }

    public boolean canConnect(ForgeDirection side, TileEntity tTileEntity) {
        return false;
    }

    public boolean getGT6StyleConnection() {
        return false;
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return false;
    }

    public void reloadLocks() {
    }

    @Override
    public int getGUIColorization() {
        Dyes dye = Dyes.dyeWhite;
        if (GregTechAPI.sColoredGUI) {
            if (GregTechAPI.sMachineMetalGUI) {
                dye = Dyes.MACHINE_METAL;
            } else if (this.getBaseMetaTileEntity() != null) {
                dye = Dyes.getOrDefault(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL);
            }
        }
        return dye.toInt();
    }
}

