/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.drone;

import gregtech.GTMod;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.multi.drone.MTEDroneCentre;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class DroneConnection {
    String customName;
    String unlocalizedName;
    MTEMultiBlockBase machine;
    ItemStack machineItem;
    ChunkCoordinates machineCoord;
    MTEDroneCentre centre;
    ChunkCoordinates centreCoord;
    World world;

    public DroneConnection(MTEMultiBlockBase machine, MTEDroneCentre centre) {
        this.machine = machine;
        this.machineItem = machine.getStackForm(1L);
        this.machineCoord = machine.getBaseMetaTileEntity().getCoords();
        this.centre = centre;
        this.centreCoord = centre.getBaseMetaTileEntity().getCoords();
        this.world = centre.getBaseMetaTileEntity().getWorld();
        this.unlocalizedName = machine.mName;
        this.customName = Optional.ofNullable(centre.tempNameList.remove(this.machineCoord.toString())).orElse(machine.getLocalName());
    }

    public DroneConnection(NBTTagCompound aNBT) {
        NBTTagCompound machineTag = aNBT.func_74775_l("machine");
        NBTTagCompound centreTag = aNBT.func_74775_l("centre");
        this.world = !GTMod.proxy.isClientSide() ? DimensionManager.getWorld((int)aNBT.func_74762_e("worldID")) : Minecraft.func_71410_x().field_71439_g.field_70170_p;
        this.machineItem = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("item"));
        this.machineCoord = new ChunkCoordinates(machineTag.func_74762_e("x"), machineTag.func_74762_e("y"), machineTag.func_74762_e("z"));
        this.machine = this.getLoadedGT_BaseMachineAt(this.machineCoord, this.world, true);
        this.centreCoord = new ChunkCoordinates(centreTag.func_74762_e("x"), centreTag.func_74762_e("y"), centreTag.func_74762_e("z"));
        this.centre = (MTEDroneCentre)this.getLoadedGT_BaseMachineAt(this.centreCoord, this.world, true);
        this.customName = aNBT.func_74779_i("name");
        this.unlocalizedName = aNBT.func_74779_i("unlocalizedName");
    }

    public MTEMultiBlockBase getMachine() {
        return this.machine;
    }

    public String getCustomName(boolean localized) {
        if (localized) {
            return GTLanguageManager.getTranslation("gt.blockmachines." + this.unlocalizedName + ".name");
        }
        return this.customName;
    }

    public float getDistanceSquared() {
        return this.centreCoord.func_82371_e(this.machineCoord);
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isMachineShutdown() {
        return this.machine != null && this.machine.shouldDisplayShutDownReason() && !this.machine.getBaseMetaTileEntity().isActive() && GTUtility.isStringValid(this.machine.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()) && this.machine.getBaseMetaTileEntity().wasShutdown();
    }

    public NBTTagCompound transConnectionToNBT() {
        NBTTagCompound aNBT = new NBTTagCompound();
        aNBT.func_74782_a("machine", (NBTBase)this.transCoordsToNBT(this.machineCoord));
        aNBT.func_74782_a("centre", (NBTBase)this.transCoordsToNBT(this.centreCoord));
        aNBT.func_74782_a("item", (NBTBase)this.machineItem.func_77955_b(new NBTTagCompound()));
        aNBT.func_74768_a("worldID", this.centre.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
        aNBT.func_74778_a("name", this.getCustomName(false));
        aNBT.func_74778_a("unlocalizedName", this.unlocalizedName);
        return aNBT;
    }

    public MTEMultiBlockBase getLoadedGT_BaseMachineAt(ChunkCoordinates coords, World world, boolean isLoaded) {
        TileEntity te = GTUtil.getTileEntity(world, coords, isLoaded);
        if (te == null) {
            return null;
        }
        return (MTEMultiBlockBase)((IGregTechTileEntity)te).getMetaTileEntity();
    }

    private NBTTagCompound transCoordsToNBT(ChunkCoordinates coord) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", coord.field_71574_a);
        tag.func_74768_a("y", coord.field_71572_b);
        tag.func_74768_a("z", coord.field_71573_c);
        return tag;
    }

    public boolean isValid() {
        return this.machine != null && this.machine.isValid() && this.centre != null && this.centre.isValid();
    }
}

