/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import ggfab.api.GGFabRecipeMaps;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.objects.GTDualInputPattern;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.tileentities.machines.IDualInputInventoryWithPattern;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSolidifier;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEMultiSolidifier
extends MTEExtendedPowerMultiBlockBase<MTEMultiSolidifier>
implements ISurvivalConstructable {
    private static final String MS_LEFT_MID = "leftmid";
    private static final String MS_RIGHT_MID = "rightmid";
    private static final String MS_END = "end";
    private static final int BASE_PARALLELS = 2;
    private static final int PARALLELS_PER_WIDTH = 3;
    private static final double DECAY_RATE = 0.025;
    private int glassTier = -1;
    protected int width;
    private int casingAmount;
    private float speedup = 1.0f;
    private int runningTickCounter = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEMultiSolidifier> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("leftmid", StructureUtility.transpose((String[][])new String[][]{{"  ", "BB", "BB", "BB"}, {"  ", "AA", "D ", "AA"}, {"  ", "AA", "  ", "AA"}, {"  ", "CC", "FC", "CC"}, {"  ", "BB", "BB", "BB"}})).addShape("rightmid", StructureUtility.transpose((String[][])new String[][]{{"  ", "BB", "BB", "BB"}, {"  ", "AA", " D", "AA"}, {"  ", "AA", "  ", "AA"}, {"  ", "CC", "CF", "CC"}, {"  ", "BB", "BB", "BB"}})).addShape("end", StructureUtility.transpose((String[][])new String[][]{{"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}})).addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "BBBBBBB", "BBBBBBB", "BBBBBBB", "       "}, {"BBBBBBB", "       ", "D D D D", "       ", "BBBBBBB"}, {"AAAAAAA", "       ", "       ", "       ", "AAAAAAA"}, {"CCCBCCC", "       ", "F F F F", "       ", "CCCCCCC"}, {"BBB~BBB", "BBBBBBB", "BBBBBBB", "BBBBBBB", "BBBBBBB"}})).addElement('A', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('B', GTStructureUtility.buildHatchAdder(MTEMultiSolidifier.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(13)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEMultiSolidifier::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)13)))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)14)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).build();

    public MTEMultiSolidifier(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMultiSolidifier(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiSolidifier(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 13)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 13)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 13))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fluid Solidifier").addInfo("Can use " + EnumChatFormatting.YELLOW + "Solidifier Hatches" + EnumChatFormatting.GRAY + " to hold different molds").addStaticParallelInfo(2).addInfo("Gains " + TooltipHelper.parallelText(3) + " Parallels per tier per width expansion").addInfo("Speeds up to a maximum of " + TooltipHelper.speedText(3.0f)).addInfo("Decays at double the rate that it speeds up at").addStaticEuEffInfo(0.8f).addGlassEnergyLimitInfo(12).addInfo(EnumChatFormatting.BLUE + "Pretty \u2c14\u2c41\u2c3e\u2c3b\u2c34, isn't it").beginVariableStructureBlock(9, 33, 5, 5, 5, 5, true).addController("Front Center bottom").addCasingInfoRange("Solidifier Casing", 91, 211, false).addCasingInfoRange("Solidifier Radiator", 13, 73, false).addCasingInfoRange("Heat Proof Machine Casing", 4, 16, false).addCasingInfoRange("Clean Stainless Steel Machine Casing", 4, 16, false).addCasingInfoRange("Any Tiered Glass", 14, 117, true).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(GTValues.AuthorOmdaCZ);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 4, 0);
        int totalWidth = Math.min(stackSize.field_77994_a - 1, 6);
        for (int i = 0; i < totalWidth; ++i) {
            this.buildPiece(MS_LEFT_MID, stackSize, hintsOnly, 5 + 2 * i, 4, 0);
            this.buildPiece(MS_RIGHT_MID, stackSize, hintsOnly, -4 - 2 * i, 4, 0);
        }
        this.buildPiece(MS_END, stackSize, hintsOnly, 4 + 2 * totalWidth, 4, 0);
        this.buildPiece(MS_END, stackSize, hintsOnly, -4 - 2 * totalWidth, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 4, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int totalWidth = Math.min(stackSize.field_77994_a - 1, 6);
        for (int i = 0; i < totalWidth; ++i) {
            built = this.survivalBuildPiece(MS_LEFT_MID, stackSize, 5 + 2 * i, 4, 0, elementBudget, env, false, true);
            if ((built += this.survivalBuildPiece(MS_RIGHT_MID, stackSize, -4 - 2 * i, 4, 0, elementBudget, env, false, true)) < 0) continue;
            return built;
        }
        built = this.survivalBuildPiece(MS_END, stackSize, -4 - 2 * totalWidth, 4, 0, elementBudget, env, false, true);
        return built += this.survivalBuildPiece(MS_END, stackSize, 4 + 2 * totalWidth, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public IStructureDefinition<MTEMultiSolidifier> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.casingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.width = 0;
        this.casingAmount = 0;
        this.glassTier = -1;
        if (this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 4, 0)) {
            while (this.width < 6 && this.checkPiece(MS_RIGHT_MID, -4 - 2 * this.width, 4, 0) && this.checkPiece(MS_LEFT_MID, 5 + 2 * this.width, 4, 0)) {
                ++this.width;
            }
        } else {
            return false;
        }
        if (!this.checkPiece(MS_END, -4 - 2 * this.width, 4, 0) || !this.checkPiece(MS_END, 4 + 2 * this.width, 4, 0)) {
            return false;
        }
        for (MTEHatchEnergy mEnergyHatch : this.mEnergyHatches) {
            if (!(this.glassTier < 12 & mEnergyHatch.mTier > this.glassTier)) continue;
            return false;
        }
        return this.casingAmount >= 91 + this.width * 20;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            public boolean tryCachePossibleRecipesFromPattern(IDualInputInventoryWithPattern inv) {
                if (!inv.shouldBeCached()) {
                    return true;
                }
                if (this.dualInvWithPatternToRecipeCache.containsKey(inv)) {
                    this.activeDualInv = inv;
                    return true;
                }
                GTDualInputPattern inputs = inv.getPatternInputs();
                this.setInputItems(inputs.inputItems);
                this.setInputFluids(inputs.inputFluid);
                Set recipes = this.findRecipeMatches(RecipeMaps.fluidSolidifierRecipes).collect(Collectors.toSet());
                if (recipes.isEmpty()) {
                    recipes = this.findRecipeMatches(GGFabRecipeMaps.toolCastRecipes).collect(Collectors.toSet());
                }
                if (!recipes.isEmpty()) {
                    this.dualInvWithPatternToRecipeCache.put(inv, recipes);
                    this.activeDualInv = inv;
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                this.setSpeedBonus(1.0f / MTEMultiSolidifier.this.speedup);
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getTrueParallel).setEuModifier(0.8f);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        ++this.runningTickCounter;
        if (this.runningTickCounter % 10 == 0 && this.speedup < 3.0f) {
            this.runningTickCounter = 0;
            this.speedup += 0.025f;
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.mMaxProgresstime == 0 && this.speedup > 1.0f && aTick % 5L == 0L) {
            this.speedup = (float)Math.max(1.0, (double)this.speedup - 0.025);
        }
    }

    @Override
    public int getMaxParallelRecipes() {
        return (2 + this.width * 3) * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fluidSolidifierRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("speedup")) {
            this.speedup = aNBT.func_74760_g("speedup");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74776_a("speedup", this.speedup);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74776_a("speedup", this.speedup);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.speed") + ": " + EnumChatFormatting.WHITE + String.format("%.1f%%", Float.valueOf(100.0f * tag.func_74760_g("speedup"))));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    @Nonnull
    protected CheckRecipeResult checkRecipeForCustomHatches(CheckRecipeResult lastResult) {
        for (MTEHatchInput solidifierHatch : this.mInputHatches) {
            if (!(solidifierHatch instanceof MTEHatchSolidifier)) continue;
            MTEHatchSolidifier hatch = (MTEHatchSolidifier)solidifierHatch;
            List<ItemStack> items = hatch.getNonConsumableItems();
            FluidStack fluid = solidifierHatch.getFluid();
            if (items == null || fluid == null) continue;
            this.processingLogic.setInputItems(items);
            this.processingLogic.setInputFluids(fluid);
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            lastResult = foundResult;
        }
        this.processingLogic.clear();
        return lastResult;
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

