/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTELargeTurbineHPSteam
extends MTELargeTurbine {
    public boolean achievement = false;

    public MTELargeTurbineHPSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbineHPSteam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[0][59];
        return iTextureArray;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Steam Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Outputs Steam as well as producing power").addInfo("Power output depends on turbine and fitting").addInfo("Use screwdriver to adjust fitting of turbine").beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Titanium Turbine Casing", 8, 31, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Superheated Steam, Side centered", 2).addOutputHatch("Steam, Side centered", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbineHPSteam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 11;
    }

    @Override
    public int getCasingTextureIndex() {
        return 59;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        this.realOptFlow = this.looseFit ? (double)turbine.getOptimalLooseSteamFlow() : (double)turbine.getOptimalSteamFlow();
        int remainingFlow = GTUtility.safeInt((long)(this.realOptFlow * ((double)(0.5f * (float)turbine.getOverflowEfficiency()) + 1.5)));
        this.storedFluid = 0;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            FluidStack aFluidStack = aFluids.get(i);
            if (GTModHandler.isSuperHeatedSteam(aFluidStack)) {
                flow = Math.min(aFluidStack.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluidStack, flow));
                this.storedFluid += aFluidStack.amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                try {
                    GTMod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "efficientsteam");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.achievement = true;
                continue;
            }
            if (!GTModHandler.isAnySteam(aFluidStack)) continue;
            this.depleteInput(new FluidStack(aFluidStack, aFluidStack.amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        this.addOutput(Materials.Steam.getGas(totalFlow));
        if (totalFlow == GTUtility.safeInt((long)this.realOptFlow)) {
            tEU = GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency())));
        } else {
            float efficiency = this.getOverflowEfficiency(totalFlow, GTUtility.safeInt((long)this.realOptFlow), this.overflowMultiplier);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency()))));
        }
        if ((long)tEU > this.getMaximumOutput()) {
            tEU = GTUtility.safeInt(this.getMaximumOutput());
        }
        return tEU;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier + 2)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && XSTR.XSTR_INSTANCE.nextInt(4) == 0 ? 0 : 1;
    }
}

