/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.common.render.GTRenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WireFrameTesseractRenderer
implements IItemRenderer {
    private final int red;
    private final int green;
    private final int blue;

    public WireFrameTesseractRenderer(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float lineWidth;
        GL11.glPushMatrix();
        GTRenderUtil.undoStandardItemTransform(type);
        switch (type) {
            case EQUIPPED: {
                GL11.glTranslatef((float)0.8f, (float)0.6f, (float)0.6f);
                lineWidth = 4.0f;
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.8f, (float)0.6f, (float)0.6f);
                lineWidth = 10.0f;
                break;
            }
            case INVENTORY: {
                lineWidth = 2.0f;
                break;
            }
            default: {
                lineWidth = 4.0f;
            }
        }
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        this.drawWireframeTesseract(lineWidth);
        GL11.glPopMatrix();
    }

    private void drawWireframeTesseract(float lineWidth) {
        long tick = Minecraft.func_71386_F();
        float angleA = (float)((double)(tick % 8000L) / 8000.0 * Math.PI * 2.0);
        float angleB = (float)((double)(tick % 6000L) / 6000.0 * Math.PI * 2.0);
        double cosA = MathHelper.func_76134_b((float)angleA);
        double sinA = MathHelper.func_76126_a((float)angleA);
        double cosB = MathHelper.func_76134_b((float)angleB);
        double sinB = MathHelper.func_76126_a((float)angleB);
        boolean lighting = GL11.glIsEnabled((int)2896);
        if (lighting) {
            GL11.glDisable((int)2896);
        }
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)lineWidth);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78371_b(1);
        t.func_78376_a(this.red, this.green, this.blue);
        for (int i = 0; i < 16; ++i) {
            double x = (i & 1) == 0 ? -1.0 : 1.0;
            double y = (i & 2) == 0 ? -1.0 : 1.0;
            double z = (i & 4) == 0 ? -1.0 : 1.0;
            double w = (i & 8) == 0 ? -1.0 : 1.0;
            double xRot = x * cosA - w * sinA;
            double wRot = x * sinA + w * cosA;
            double yRot = y * cosB - z * sinB;
            double zRot = y * sinB + z * cosB;
            double distance = 3.0;
            double wp = 1.0 / (3.0 - wRot);
            double px = xRot * wp;
            double py = yRot * wp;
            double pz = zRot * wp;
            for (int j = 0; j < 4; ++j) {
                int neighbor = i ^ 1 << j;
                if (i >= neighbor) continue;
                double xn = (neighbor & 1) == 0 ? -1.0 : 1.0;
                double yn = (neighbor & 2) == 0 ? -1.0 : 1.0;
                double zn = (neighbor & 4) == 0 ? -1.0 : 1.0;
                double wn = (neighbor & 8) == 0 ? -1.0 : 1.0;
                double xRotN = xn * cosA - wn * sinA;
                double wRotN = xn * sinA + wn * cosA;
                double yRotN = yn * cosB - zn * sinB;
                double zRotN = yn * sinB + zn * cosB;
                double wpN = 1.0 / (3.0 - wRotN);
                double pxN = xRotN * wpN;
                double pyN = yRotN * wpN;
                double pzN = zRotN * wpN;
                t.func_78377_a(px, py, pz);
                t.func_78377_a(pxN, pyN, pzN);
            }
        }
        t.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (lighting) {
            GL11.glEnable((int)2896);
        }
    }
}

