/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.api.enums.Dyes;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.common.items.behaviors.BehaviourSprayColorInfinite;
import gregtech.common.render.GTRenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class InfiniteSprayCanRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Dyes dye = BehaviourSprayColorInfinite.getDye(item);
        short[] modulation = dye.getRGBA();
        Item item2 = item.func_77973_b();
        if (!(item2 instanceof MetaGeneratedItem)) {
            return;
        }
        MetaGeneratedItem mgItem = (MetaGeneratedItem)item2;
        IIcon[] iconList = mgItem.mIconList[item.func_77960_j() - mgItem.mOffset];
        if (iconList == null || iconList.length < 4) {
            return;
        }
        IIcon baseLayer = iconList[1];
        IIcon lockLayer = iconList[2];
        IIcon paintRegion = iconList[3];
        if (baseLayer == null || paintRegion == null || lockLayer == null) {
            return;
        }
        boolean locked = false;
        if (item.func_77942_o()) {
            locked = item.func_77978_p().func_74767_n("is_locked");
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GTRenderUtil.renderItem(type, baseLayer);
        GL11.glColor4f((float)((float)modulation[0] / 255.0f), (float)((float)modulation[1] / 255.0f), (float)((float)modulation[2] / 255.0f), (float)1.0f);
        GTRenderUtil.renderItem(type, paintRegion);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (locked) {
            GTRenderUtil.renderItem(type, lockLayer);
        }
        GL11.glDisable((int)3042);
    }
}

