/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.theme;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonObject;

public class ProgressbarWidgetTheme
extends WidgetTheme {
    private final UITexture emptyTexture;
    private final UITexture fullTexture;
    private final int imageSize;

    public ProgressbarWidgetTheme(UITexture emptyTexture, UITexture fullTexture, int imageSize) {
        super(null, null, Color.WHITE.main, -12566464, false);
        this.emptyTexture = emptyTexture;
        this.fullTexture = fullTexture;
        this.imageSize = imageSize;
    }

    public ProgressbarWidgetTheme(UITexture wholeTexture, int imageSize) {
        this(wholeTexture.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), wholeTexture.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), imageSize);
    }

    public ProgressbarWidgetTheme(WidgetTheme parent, JsonObject json, JsonObject fallback) {
        super(parent, json, fallback);
        if (json.has("imageSize")) {
            if (json.has("wholeTexture")) {
                IDrawable wholeTexture = (IDrawable)JsonHelper.deserializeWithFallback((JsonObject)json, (JsonObject)fallback, IDrawable.class, (Object)IDrawable.EMPTY, (String[])new String[]{"wholeTexture"});
                if (wholeTexture instanceof UITexture) {
                    UITexture texture = (UITexture)wholeTexture;
                    this.emptyTexture = texture.getSubArea(0.0f, 0.0f, 1.0f, 0.5f);
                    this.fullTexture = texture.getSubArea(0.0f, 0.5f, 1.0f, 1.0f);
                    this.imageSize = json.get("imageSize").getAsInt();
                    return;
                }
            } else if (json.has("emptyTexture") && json.has("fullTexture")) {
                IDrawable deserializedEmptyTexture = (IDrawable)JsonHelper.deserializeWithFallback((JsonObject)json, (JsonObject)fallback, IDrawable.class, (Object)IDrawable.EMPTY, (String[])new String[]{"emptyTexture"});
                IDrawable deserializedFullTexture = (IDrawable)JsonHelper.deserializeWithFallback((JsonObject)json, (JsonObject)fallback, IDrawable.class, (Object)IDrawable.EMPTY, (String[])new String[]{"fullTexture"});
                if (deserializedEmptyTexture instanceof UITexture) {
                    UITexture emptyUITexture = (UITexture)deserializedEmptyTexture;
                    if (deserializedFullTexture instanceof UITexture) {
                        UITexture fullUITexture = (UITexture)deserializedFullTexture;
                        this.emptyTexture = emptyUITexture;
                        this.fullTexture = fullUITexture;
                        this.imageSize = json.get("imageSize").getAsInt();
                        return;
                    }
                }
            }
        }
        this.emptyTexture = null;
        this.fullTexture = null;
        this.imageSize = 0;
    }

    public UITexture getEmptyTexture() {
        return this.emptyTexture;
    }

    public UITexture getFullTexture() {
        return this.fullTexture;
    }

    public int getImageSize() {
        return this.imageSize;
    }
}

