/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.FluidDrawable;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.ChangeableWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.widgets.StructureErrorSyncer;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IItemLockable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IBindPlayerInventoryUI;
import gregtech.api.interfaces.modularui.IControllerWithOptionalFeatures;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTEHatchVoid;
import gregtech.api.metatileentity.implementations.MTEHatchVoidBus;
import gregtech.api.metatileentity.implementations.gui.MTEMultiBlockBaseGui;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SingleRecipeCheck;
import gregtech.api.util.ExoticEnergyInputHelper;
import gregtech.api.util.GTClientPreference;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTWaila;
import gregtech.api.util.OutputHatchWrapper;
import gregtech.api.util.VoidProtectionHelper;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.client.GTSoundLoop;
import gregtech.common.config.MachineStats;
import gregtech.common.data.GTCoilTracker;
import gregtech.common.gui.modularui.widget.CheckRecipeResultSyncer;
import gregtech.common.gui.modularui.widget.ShutDownReasonSyncer;
import gregtech.common.items.MetaGeneratedTool01;
import gregtech.common.pollution.Pollution;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputHatchWithPattern;
import gregtech.common.tileentities.machines.IDualInputInventory;
import gregtech.common.tileentities.machines.IDualInputInventoryWithPattern;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.ISmartInputHatch;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import gregtech.common.tileentities.machines.multi.drone.MTEHatchDroneDownLink;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSteamBusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.TestOnly;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;

public abstract class MTEMultiBlockBase
extends MetaTileEntity
implements IControllerWithOptionalFeatures,
IAddGregtechLogo,
IGuiHolder<PosGuiData>,
IAddUIWidgets,
IBindPlayerInventoryUI {
    public static boolean disableMaintenance;
    public boolean hasMaintenanceChecks = this.getDefaultHasMaintenanceChecks();
    public boolean mMachine = false;
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftMallet = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mRunningOnLoad = false;
    public boolean mStructureChanged = false;
    private int errorDisplayID;
    public int mPollution = 0;
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;
    public int mEUt = 0;
    public int mEfficiencyIncrease = 0;
    public int mStartUpCheck = 100;
    public int mRuntime = 0;
    public int mEfficiency = 0;
    public volatile boolean mUpdated = false;
    public int mUpdate = 0;
    public ItemStack[] mOutputItems = null;
    public FluidStack[] mOutputFluids = null;
    public String mNEI;
    public int damageFactorLow = 5;
    public float damageFactorHigh = 0.6f;
    public int machineMode = 0;
    protected List<UITexture> machineModeIcons;
    public boolean mLockedToSingleRecipe = this.getDefaultRecipeLockingMode();
    protected boolean inputSeparation = this.getDefaultInputSeparationMode();
    protected VoidingMode voidingMode = this.getDefaultVoidingMode();
    protected boolean batchMode = this.getDefaultBatchMode();
    @Nonnull
    protected CheckRecipeResult checkRecipeResult = CheckRecipeResultRegistry.NONE;
    protected int powerPanelMaxParallel = 1;
    protected boolean alwaysMaxParallel = true;
    protected int maxParallel = 1;
    protected static final String INPUT_SEPARATION_NBT_KEY = "inputSeparation";
    protected static final String VOID_EXCESS_NBT_KEY = "voidExcess";
    protected static final String VOIDING_MODE_NBT_KEY = "voidingMode";
    protected static final String BATCH_MODE_NBT_KEY = "batchMode";
    protected SingleRecipeCheck mSingleRecipeCheck = null;
    public ArrayList<MTEHatchInput> mInputHatches = new ArrayList();
    public ArrayList<MTEHatchOutput> mOutputHatches = new ArrayList();
    public ArrayList<MTEHatchInputBus> mInputBusses = new ArrayList();
    public ArrayList<MTEHatchOutputBus> mOutputBusses = new ArrayList();
    public ArrayList<IDualInputHatch> mDualInputHatches = new ArrayList();
    public ArrayList<ISmartInputHatch> mSmartInputHatches = new ArrayList();
    public ArrayList<MTEHatchDynamo> mDynamoHatches = new ArrayList();
    public ArrayList<MTEHatchMuffler> mMufflerHatches = new ArrayList();
    public ArrayList<MTEHatchEnergy> mEnergyHatches = new ArrayList();
    public ArrayList<MTEHatchMaintenance> mMaintenanceHatches = new ArrayList();
    public LongArrayList mCoils = new LongArrayList();
    private GTCoilTracker.MultiCoilLease coilLease = null;
    protected List<MTEHatch> mExoticEnergyHatches = new ArrayList<MTEHatch>();
    protected final ProcessingLogic processingLogic;
    @SideOnly(value=Side.CLIENT)
    protected GTSoundLoop activitySoundLoop;
    protected long mLastWorkingTick = 0L;
    protected long mTotalRunTime = 0L;
    private static final int CHECK_INTERVAL = 100;
    private final int randomTickOffset = (int)(Math.random() * 100.0 + 1.0);
    private EnumSet<StructureError> structureErrors = EnumSet.noneOf(StructureError.class);
    private NBTTagCompound structureErrorContext = new NBTTagCompound();
    protected static final byte INTERRUPT_SOUND_INDEX = 8;
    protected static final byte PROCESS_START_SOUND_INDEX = 1;
    private boolean wereCoilsActive = false;
    protected final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MTEMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 2);
        this.processingLogic = null;
        disableMaintenance = MachineStats.machines.disableMaintenanceChecks;
        this.damageFactorLow = MachineStats.machines.damageFactorLow;
        this.damageFactorHigh = MachineStats.machines.damageFactorHigh;
        this.mNEI = "";
        if (!this.shouldCheckMaintenance()) {
            this.fixAllIssues();
        }
    }

    public MTEMultiBlockBase(String aName) {
        super(aName, 2);
        this.processingLogic = this.createProcessingLogic();
        disableMaintenance = MachineStats.machines.disableMaintenanceChecks;
        this.damageFactorLow = MachineStats.machines.damageFactorLow;
        this.damageFactorHigh = MachineStats.machines.damageFactorHigh;
        if (!this.shouldCheckMaintenance()) {
            this.fixAllIssues();
        }
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.supportsSingleRecipeLocking()) {
            boolean bl = this.mLockedToSingleRecipe = !this.mLockedToSingleRecipe;
            if (this.mLockedToSingleRecipe) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.mb.locking_on"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.mb.locking_off"));
                this.mSingleRecipeCheck = null;
            }
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    public long getTotalRuntimeInTicks() {
        return this.mTotalRunTime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        return aProgress;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        int i;
        aNBT.func_74768_a("mEUt", this.mEUt);
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        aNBT.func_74768_a("mEfficiencyIncrease", this.mEfficiencyIncrease);
        aNBT.func_74768_a("mEfficiency", this.mEfficiency);
        aNBT.func_74768_a("mPollution", this.mPollution);
        aNBT.func_74768_a("mRuntime", this.mRuntime);
        aNBT.func_74768_a("powerPanelMaxParallel", this.powerPanelMaxParallel);
        aNBT.func_74772_a("mTotalRunTime", this.mTotalRunTime);
        aNBT.func_74772_a("mLastWorkingTick", this.mLastWorkingTick);
        aNBT.func_74778_a("checkRecipeResultID", this.checkRecipeResult.getID());
        aNBT.func_74782_a("checkRecipeResult", (NBTBase)this.checkRecipeResult.writeToNBT(new NBTTagCompound()));
        if (this.supportsMachineModeSwitch()) {
            aNBT.func_74768_a("machineMode", this.machineMode);
        }
        if (this.supportsSingleRecipeLocking()) {
            aNBT.func_74757_a("mLockedToSingleRecipe", this.mLockedToSingleRecipe);
            if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null) {
                aNBT.func_74782_a("mSingleRecipeCheck", (NBTBase)this.mSingleRecipeCheck.writeToNBT());
            }
        }
        if (this.mOutputItems != null) {
            aNBT.func_74768_a("mOutputItemsLength", this.mOutputItems.length);
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                GTUtility.saveItem(aNBT, "mOutputItem" + i, this.mOutputItems[i]);
            }
        }
        if (this.mOutputFluids != null) {
            aNBT.func_74768_a("mOutputFluidsLength", this.mOutputFluids.length);
            for (i = 0; i < this.mOutputFluids.length; ++i) {
                if (this.mOutputFluids[i] == null) continue;
                NBTTagCompound tNBT = new NBTTagCompound();
                this.mOutputFluids[i].writeToNBT(tNBT);
                aNBT.func_74782_a("mOutputFluids" + i, (NBTBase)tNBT);
            }
        }
        aNBT.func_74757_a("mWrench", this.mWrench);
        aNBT.func_74757_a("mScrewdriver", this.mScrewdriver);
        aNBT.func_74757_a("mSoftMallet", this.mSoftMallet);
        aNBT.func_74757_a("mHardHammer", this.mHardHammer);
        aNBT.func_74757_a("mSolderingTool", this.mSolderingTool);
        aNBT.func_74757_a("mCrowbar", this.mCrowbar);
        aNBT.func_74757_a(BATCH_MODE_NBT_KEY, this.batchMode);
        aNBT.func_74757_a(INPUT_SEPARATION_NBT_KEY, this.inputSeparation);
        aNBT.func_74757_a("alwaysMaxParallel", this.alwaysMaxParallel);
        aNBT.func_74778_a(VOIDING_MODE_NBT_KEY, this.voidingMode.name);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int aOutputFluidsLength;
        int aOutputItemsLength;
        this.mEUt = aNBT.func_74762_e("mEUt");
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        if (this.mMaxProgresstime > 0) {
            this.mRunningOnLoad = true;
        }
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mEfficiency = aNBT.func_74762_e("mEfficiency");
        this.mPollution = aNBT.func_74762_e("mPollution");
        this.mRuntime = aNBT.func_74762_e("mRuntime");
        this.mTotalRunTime = aNBT.func_74763_f("mTotalRunTime");
        this.mLastWorkingTick = aNBT.func_74763_f("mLastWorkingTick");
        this.alwaysMaxParallel = !aNBT.func_74764_b("alwaysMaxParallel") || aNBT.func_74767_n("alwaysMaxParallel");
        this.powerPanelMaxParallel = aNBT.func_74762_e("powerPanelMaxParallel");
        String checkRecipeResultID = aNBT.func_74779_i("checkRecipeResultID");
        if (CheckRecipeResultRegistry.isRegistered(checkRecipeResultID)) {
            CheckRecipeResult result = (CheckRecipeResult)CheckRecipeResultRegistry.getSampleFromRegistry(checkRecipeResultID).newInstance();
            result.readFromNBT(aNBT.func_74775_l("checkRecipeResult"));
            this.checkRecipeResult = result;
        }
        if (aNBT.func_74764_b("machineMode")) {
            this.machineMode = aNBT.func_74762_e("machineMode");
        }
        if (this.supportsSingleRecipeLocking()) {
            this.mLockedToSingleRecipe = aNBT.func_74767_n("mLockedToSingleRecipe");
            if (this.mLockedToSingleRecipe && aNBT.func_150297_b("mSingleRecipeCheck", 10)) {
                SingleRecipeCheck c = this.loadSingleRecipeChecker(aNBT.func_74775_l("mSingleRecipeCheck"));
                if (c != null) {
                    this.mSingleRecipeCheck = c;
                } else {
                    this.getBaseMetaTileEntity().disableWorking();
                }
            }
        }
        this.batchMode = aNBT.func_74767_n(BATCH_MODE_NBT_KEY);
        this.inputSeparation = aNBT.func_74767_n(INPUT_SEPARATION_NBT_KEY);
        if (aNBT.func_150297_b(VOIDING_MODE_NBT_KEY, 8)) {
            this.voidingMode = VoidingMode.fromName(aNBT.func_74779_i(VOIDING_MODE_NBT_KEY));
        } else if (aNBT.func_74764_b(VOID_EXCESS_NBT_KEY)) {
            VoidingMode voidingMode = this.voidingMode = aNBT.func_74767_n(VOID_EXCESS_NBT_KEY) ? VoidingMode.VOID_ALL : VoidingMode.VOID_NONE;
        }
        if (!this.getAllowedVoidingModes().contains((Object)this.voidingMode)) {
            this.voidingMode = this.getDefaultVoidingMode();
        }
        if ((aOutputItemsLength = aNBT.func_74762_e("mOutputItemsLength")) > 0) {
            this.mOutputItems = new ItemStack[aOutputItemsLength];
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                this.mOutputItems[i] = GTUtility.loadItem(aNBT, "mOutputItem" + i);
            }
        }
        if ((aOutputFluidsLength = aNBT.func_74762_e("mOutputFluidsLength")) > 0) {
            this.mOutputFluids = new FluidStack[aOutputFluidsLength];
            for (int i = 0; i < this.mOutputFluids.length; ++i) {
                this.mOutputFluids[i] = GTUtility.loadFluid(aNBT, "mOutputFluids" + i);
            }
        }
        if (this.shouldCheckMaintenance()) {
            this.mWrench = aNBT.func_74767_n("mWrench");
            this.mScrewdriver = aNBT.func_74767_n("mScrewdriver");
            this.mSoftMallet = aNBT.func_74767_n("mSoftMallet") || aNBT.func_74767_n("mSoftHammer");
            this.mHardHammer = aNBT.func_74767_n("mHardHammer");
            this.mSolderingTool = aNBT.func_74767_n("mSolderingTool");
            this.mCrowbar = aNBT.func_74767_n("mCrowbar");
        } else {
            this.fixAllIssues();
        }
    }

    protected SingleRecipeCheck loadSingleRecipeChecker(NBTTagCompound aNBT) {
        return SingleRecipeCheck.tryLoad(this.getRecipeMap(), aNBT);
    }

    public boolean saveOtherHatchConfiguration(EntityPlayer player) {
        return true;
    }

    public boolean loadOtherHatchConfiguration(EntityPlayer player) {
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isServerSide() && GTUtil.saveMultiblockInputConfiguration(this, aPlayer)) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.MULTI_MACHINE_CONFIG.SAVE", new Object[0]));
            return;
        }
        super.onLeftclick(aBaseMetaTileEntity, aPlayer);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (GTUtil.hasMultiblockInputConfiguration(aPlayer.func_70694_bm())) {
            if (aBaseMetaTileEntity.isServerSide()) {
                if (GTUtil.loadMultiblockInputConfiguration(this, aPlayer)) {
                    aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.MULTI_MACHINE_CONFIG.LOAD", new Object[0]));
                } else {
                    aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.MULTI_MACHINE_CONFIG.LOAD.FAIL", new Object[0]));
                }
            }
            return true;
        }
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public byte getTileEntityBaseType() {
        return 2;
    }

    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdated = true;
    }

    public void clearHatches() {
        this.mInputHatches.clear();
        this.mInputBusses.clear();
        this.mOutputHatches.clear();
        this.mOutputBusses.clear();
        this.mDynamoHatches.clear();
        this.mEnergyHatches.clear();
        this.setMufflers(false);
        this.mMufflerHatches.clear();
        this.mMaintenanceHatches.clear();
        this.mDualInputHatches.clear();
        this.mSmartInputHatches.clear();
        this.mCoils.clear();
        this.deactivateCoilLease();
    }

    public boolean checkStructure(boolean aForceReset) {
        return this.checkStructure(aForceReset, this.getBaseMetaTileEntity());
    }

    public boolean checkStructure(boolean aForceReset, IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return this.mMachine;
        }
        if (this.mStructureChanged || aForceReset) {
            this.clearHatches();
            this.mMachine = this.checkMachine(aBaseMetaTileEntity, this.mInventory[1]);
            this.doStructureValidation();
        }
        this.mStructureChanged = false;
        return this.mMachine;
    }

    protected final void doStructureValidation() {
        this.structureErrors = EnumSet.noneOf(StructureError.class);
        this.structureErrorContext = new NBTTagCompound();
        if (this.mMachine) {
            this.validateStructure(this.structureErrors, this.structureErrorContext);
            if (this.hasStructureErrors()) {
                this.mMachine = false;
            }
        }
    }

    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
    }

    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
    }

    protected boolean hasStructureErrors() {
        return !this.structureErrors.isEmpty();
    }

    public int getErrorDisplayID() {
        return this.errorDisplayID;
    }

    public void setErrorDisplayID(int errorID) {
        this.errorDisplayID = errorID;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            boolean isActive;
            ++this.mTotalRunTime;
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mUpdated) {
                if (this.mUpdate <= 0) {
                    this.mUpdate = 50;
                }
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    this.checkMaintenance();
                    if (this.getRepairStatus() > 0) {
                        this.runMachine(aBaseMetaTileEntity, aTick);
                    } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                        this.stopMachine(ShutDownReasonRegistry.NO_REPAIR);
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.stopMachine(ShutDownReasonRegistry.STRUCTURE_INCOMPLETE);
                }
            }
            this.setErrorDisplayID(this.getErrorDisplayID() & 0xFFFFFF80 | (this.mWrench ? 0 : 1) | (this.mScrewdriver ? 0 : 2) | (this.mSoftMallet ? 0 : 4) | (this.mHardHammer ? 0 : 8) | (this.mSolderingTool ? 0 : 16) | (this.mCrowbar ? 0 : 32) | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
            this.setMufflers(aBaseMetaTileEntity.isActive() && this.mPollution > 0);
            boolean bl = isActive = this.mMaxProgresstime > 0;
            if (!this.mMachine || !isActive) {
                this.deactivateCoilLease();
            }
            if (this.mMachine && !this.mCoils.isEmpty() && isActive && this.coilLease == null) {
                this.coilLease = GTCoilTracker.activate(this, (LongList)this.mCoils);
            }
        } else {
            this.doActivitySound(this.getActivitySoundLoop());
        }
    }

    @Override
    public void onTickFail(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onTickFail(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.disableWorking();
            this.checkRecipeResult = CheckRecipeResultRegistry.CRASH;
        }
    }

    public void checkMaintenance() {
        if (!this.shouldCheckMaintenance()) {
            return;
        }
        if (this.getRepairStatus() != this.getIdealStatus()) {
            for (MTEHatchMaintenance tHatch : GTUtility.validMTEList(this.mMaintenanceHatches)) {
                boolean tDidRepair = false;
                if (tHatch.mAuto) {
                    tDidRepair = tHatch.autoMaintainance();
                }
                if (tHatch.mWrench && !this.mWrench) {
                    this.mWrench = true;
                    tDidRepair = true;
                }
                if (tHatch.mScrewdriver && !this.mScrewdriver) {
                    this.mScrewdriver = true;
                    tDidRepair = true;
                }
                if (tHatch.mSoftMallet && !this.mSoftMallet) {
                    this.mSoftMallet = true;
                    tDidRepair = true;
                }
                if (tHatch.mHardHammer && !this.mHardHammer) {
                    this.mHardHammer = true;
                    tDidRepair = true;
                }
                if (tHatch.mSolderingTool && !this.mSolderingTool) {
                    this.mSolderingTool = true;
                    tDidRepair = true;
                }
                if (tHatch.mCrowbar && !this.mCrowbar) {
                    this.mCrowbar = true;
                    tDidRepair = true;
                }
                tHatch.mWrench = false;
                tHatch.mScrewdriver = false;
                tHatch.mSoftMallet = false;
                tHatch.mHardHammer = false;
                tHatch.mSolderingTool = false;
                tHatch.mCrowbar = false;
                if (!tDidRepair) continue;
                tHatch.onMaintenancePerformed(this);
            }
        }
    }

    protected final boolean checkRecipe() {
        this.startRecipeProcessing();
        CheckRecipeResult result = this.checkProcessing();
        if (!CheckRecipeResultRegistry.isRegistered(result.getID())) {
            throw new RuntimeException(String.format("Result %s is not registered for registry", result.getID()));
        }
        if (result.wasSuccessful()) {
            this.sendStartMultiBlockSoundLoop();
        }
        this.checkRecipeResult = result;
        this.endRecipeProcessing();
        return this.checkRecipeResult.wasSuccessful();
    }

    private boolean shouldCheckRecipeThisTick(long aTick) {
        boolean shouldCheck = false;
        for (IDualInputHatch craftingInputMe : this.mDualInputHatches) {
            shouldCheck |= craftingInputMe.justUpdated();
        }
        if (shouldCheck) {
            return true;
        }
        for (ISmartInputHatch smartInputHatch : this.mSmartInputHatches) {
            shouldCheck |= smartInputHatch.justUpdated();
        }
        if (shouldCheck) {
            return true;
        }
        long timeElapsed = this.mTotalRunTime - this.mLastWorkingTick;
        if (timeElapsed >= 100L) {
            return (this.mTotalRunTime + (long)this.randomTickOffset) % 100L == 0L;
        }
        if (!this.isBatchModeEnabled()) {
            return timeElapsed == 5L || timeElapsed == 12L || timeElapsed == 20L || timeElapsed == 30L || timeElapsed == 40L || timeElapsed == 55L || timeElapsed == 70L || timeElapsed == 85L;
        }
        return false;
    }

    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mMaxProgresstime > 0 && this.doRandomMaintenanceDamage()) {
            if (this.onRunningTick(this.mInventory[1])) {
                this.func_70296_d();
                if (!this.polluteEnvironment(this.getPollutionPerTick(this.mInventory[1]))) {
                    this.stopMachine(ShutDownReasonRegistry.POLLUTION_FAIL);
                }
                if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                    if (this.mOutputItems != null) {
                        for (ItemStack tStack : this.mOutputItems) {
                            if (tStack == null) continue;
                            this.addOutput(tStack);
                        }
                        this.mOutputItems = null;
                    }
                    if (this.mOutputFluids != null) {
                        this.addFluidOutputs(this.mOutputFluids);
                        this.mOutputFluids = null;
                    }
                    this.outputAfterRecipe();
                    this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.getControllerSlot()) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
                    this.mOutputItems = null;
                    this.mProgresstime = 0;
                    this.mMaxProgresstime = 0;
                    this.mEfficiencyIncrease = 0;
                    this.mLastWorkingTick = this.mTotalRunTime;
                    if (aBaseMetaTileEntity.isAllowedToWork()) {
                        this.checkRecipe();
                    }
                }
            }
        } else {
            if (aBaseMetaTileEntity.isAllowedToWork() && (this.shouldCheckRecipeThisTick(aTick) || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) && this.checkRecipe()) {
                this.func_70296_d();
            }
            if (this.mMaxProgresstime <= 0) {
                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
            }
        }
    }

    protected void outputAfterRecipe() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean polluteEnvironment(int aPollutionLevel) {
        int VENT_AMOUNT = 10000;
        if (!GTMod.proxy.mPollution) {
            return true;
        }
        this.mPollution += aPollutionLevel;
        if (this.mPollution < 10000) {
            return true;
        }
        if (this.mMufflerHatches.size() == 0) {
            return false;
        }
        if (this.mMufflerHatches.size() == 1) {
            MTEHatchMuffler muffler = this.mMufflerHatches.get(0);
            if (muffler == null || !muffler.isValid()) {
                this.mMufflerHatches.remove(0);
                return false;
            }
            if (!muffler.polluteEnvironment(this, 10000)) return false;
            this.mPollution -= 10000;
        } else {
            int mufflerCount = 0;
            int ventAmount = 0;
            for (MTEHatchMuffler muffler : GTUtility.validMTEList(this.mMufflerHatches)) {
                ++mufflerCount;
                if (ventAmount + 10000 > this.mPollution) continue;
                ventAmount += 10000;
            }
            ventAmount /= mufflerCount;
            for (MTEHatchMuffler muffler : GTUtility.validMTEList(this.mMufflerHatches)) {
                if (!muffler.polluteEnvironment(this, ventAmount)) return false;
                this.mPollution -= ventAmount;
            }
        }
        if (this.mPollution >= 10000) return false;
        return true;
    }

    public int getAveragePollutionPercentage() {
        int pollutionPercent = 0;
        int mufflerCount = 0;
        for (MTEHatchMuffler muffler : GTUtility.validMTEList(this.mMufflerHatches)) {
            pollutionPercent += muffler.calculatePollutionReduction(100);
            ++mufflerCount;
        }
        pollutionPercent = mufflerCount > 0 ? (pollutionPercent /= mufflerCount) : 100;
        return pollutionPercent;
    }

    protected void sendStartMultiBlockSoundLoop() {
        if (this.getProcessStartSound() != null) {
            this.sendLoopStart((byte)1);
        }
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        switch (aIndex) {
            case 1: {
                if (this.getProcessStartSound() == null) break;
                GTUtility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
                break;
            }
            case 8: {
                GTUtility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, aX, aY, aZ);
            }
        }
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1 && this.getProcessStartSound() != null) {
            GTUtility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void doActivitySound(SoundResource activitySound) {
        if (this.getBaseMetaTileEntity().isActive() && activitySound != null && !this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            if (this.activitySoundLoop == null) {
                this.activitySoundLoop = new GTSoundLoop(activitySound.resourceLocation, this.getBaseMetaTileEntity(), false, true);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activitySoundLoop);
            }
        } else if (this.activitySoundLoop != null) {
            this.activitySoundLoop.setFadeMe(true);
            this.activitySoundLoop = null;
        }
    }

    protected int getTimeBetweenProcessSounds() {
        return 100;
    }

    protected SoundResource getProcessStartSound() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return null;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            this.addEnergyOutput((long)this.mEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.mEUt < 0 && !this.drainEnergyInput(this.getActualEnergyUsage())) {
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            return false;
        }
        return true;
    }

    protected long getActualEnergyUsage() {
        return (long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency);
    }

    public boolean isCorrectMachinePart(@Nullable ItemStack aStack) {
        return true;
    }

    @Deprecated
    public boolean checkRecipe(ItemStack aStack) {
        return false;
    }

    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (this.processingLogic == null) {
            return this.checkRecipe(this.mInventory[1]) ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.setupProcessingLogic(this.processingLogic);
        CheckRecipeResult result = this.doCheckRecipe();
        result = this.postCheckRecipe(result, this.processingLogic);
        this.updateSlots();
        if (!result.wasSuccessful()) {
            return result;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.processingLogic.getDuration();
        this.setEnergyUsage(this.processingLogic);
        this.mOutputItems = this.processingLogic.getOutputItems();
        this.mOutputFluids = this.processingLogic.getOutputFluids();
        return result;
    }

    protected boolean canUseControllerSlotForRecipe() {
        return true;
    }

    protected void setupProcessingLogic(ProcessingLogic logic) {
        logic.clear();
        logic.setMachine(this);
        logic.setRecipeMapSupplier(this::getRecipeMap);
        logic.setVoidProtection(this.protectsExcessItem(), this.protectsExcessFluid());
        logic.setBatchSize(this.isBatchModeEnabled() ? this.getMaxBatchSize() : 1);
        logic.setRecipeLocking(this, this.isRecipeLockingEnabled());
        this.setProcessingLogicPower(logic);
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        boolean useSingleAmp = this.mEnergyHatches.size() == 1 && this.mExoticEnergyHatches.isEmpty();
        logic.setAvailableVoltage(this.getAverageInputVoltage());
        logic.setAvailableAmperage(useSingleAmp ? 1L : this.getMaxInputAmps());
        logic.setAmperageOC(true);
    }

    protected boolean supportsCraftingMEBuffer() {
        return true;
    }

    @Nonnull
    protected CheckRecipeResult doCheckRecipe() {
        boolean doColorChecking;
        Object result = CheckRecipeResultRegistry.NO_RECIPE;
        for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
            Object[] sharedItems = dualInputHatch.getSharedItems();
            Iterator<? extends IDualInputInventory> it = dualInputHatch.inventories();
            while (it.hasNext()) {
                IDualInputInventoryWithPattern withPattern;
                IDualInputInventory slot = it.next();
                if (slot.isEmpty() || slot instanceof IDualInputInventoryWithPattern && !this.processingLogic.tryCachePossibleRecipesFromPattern(withPattern = (IDualInputInventoryWithPattern)slot)) continue;
                this.processingLogic.setInputItems((ItemStack[])ArrayUtils.addAll((Object[])sharedItems, (Object[])slot.getItemInputs()));
                this.processingLogic.setInputFluids(slot.getFluidInputs());
                CheckRecipeResult foundResult = this.processingLogic.process();
                if (foundResult.wasSuccessful()) {
                    return foundResult;
                }
                if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                result = foundResult;
            }
        }
        if ((result = this.checkRecipeForCustomHatches((CheckRecipeResult)result)).wasSuccessful()) {
            return result;
        }
        short hatchColors = this.getHatchColors();
        boolean bl = doColorChecking = hatchColors != 0;
        if (!doColorChecking) {
            hatchColors = 1;
        }
        for (byte color = 0; color < (doColorChecking ? (byte)16 : 1); color = (byte)(color + 1)) {
            if (MTEMultiBlockBase.isColorAbsent(hatchColors, color)) continue;
            this.processingLogic.setInputFluids(this.getStoredFluidsForColor(Optional.of(color)));
            if (this.isInputSeparationEnabled()) {
                if (this.mInputBusses.isEmpty()) {
                    CheckRecipeResult foundResult = this.processingLogic.process();
                    if (foundResult.wasSuccessful()) {
                        return foundResult;
                    }
                    if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                    result = foundResult;
                    continue;
                }
                for (MTEHatchInputBus bus : this.mInputBusses) {
                    byte busColor;
                    if (bus instanceof MTEHatchCraftingInputME || (busColor = bus.getColor()) != -1 && busColor != color) continue;
                    ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
                    for (int i = bus.func_70302_i_() - 1; i >= 0; --i) {
                        ItemStack stored = bus.func_70301_a(i);
                        if (stored == null) continue;
                        inputItems.add(stored);
                    }
                    if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                        inputItems.add(this.getControllerSlot());
                    }
                    this.processingLogic.setInputItems(inputItems);
                    CheckRecipeResult foundResult = this.processingLogic.process();
                    if (foundResult.wasSuccessful()) {
                        return foundResult;
                    }
                    if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                    result = foundResult;
                }
                continue;
            }
            ArrayList<ItemStack> inputItems = this.getStoredInputsForColor(Optional.of(color));
            if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                inputItems.add(this.getControllerSlot());
            }
            this.processingLogic.setInputItems(inputItems);
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        return result;
    }

    private static boolean isColorAbsent(short hatchColors, byte color) {
        return (hatchColors & 1 << color) == 0;
    }

    private short getHatchColors() {
        short hatchColors = 0;
        for (MTEHatchInputBus bus : this.mInputBusses) {
            hatchColors = (short)(hatchColors | (short)(1 << bus.getColor()));
        }
        for (MTEHatchInput hatch : this.mInputHatches) {
            hatchColors = (short)(hatchColors | (short)(1 << hatch.getColor()));
        }
        MTEMultiBlockBase mTEMultiBlockBase = this;
        if (mTEMultiBlockBase instanceof MTESteamMultiBase) {
            MTESteamMultiBase steamMultiBase = (MTESteamMultiBase)mTEMultiBlockBase;
            for (MTEHatchSteamBusInput bus : steamMultiBase.mSteamInputs) {
                hatchColors = (short)(hatchColors | (short)(1 << bus.getColor()));
            }
            for (MTEHatchCustomFluidBase hatch : steamMultiBase.mSteamInputFluids) {
                hatchColors = (short)(hatchColors | (short)(1 << hatch.getColor()));
            }
        }
        return hatchColors;
    }

    @Nonnull
    protected CheckRecipeResult checkRecipeForCustomHatches(CheckRecipeResult lastResult) {
        return lastResult;
    }

    @Nonnull
    protected CheckRecipeResult postCheckRecipe(@Nonnull CheckRecipeResult result, @Nonnull ProcessingLogic processingLogic) {
        if (result.wasSuccessful() && processingLogic.getCalculatedEut() > Integer.MAX_VALUE) {
            return CheckRecipeResultRegistry.POWER_OVERFLOW;
        }
        return result;
    }

    protected void setEnergyUsage(ProcessingLogic processingLogic) {
        this.mEUt = (int)processingLogic.getCalculatedEut();
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
    }

    protected int getMaxBatchSize() {
        return 128;
    }

    public abstract boolean checkMachine(IGregTechTileEntity var1, ItemStack var2);

    public @Range(from=0L, to=10000L) int getMaxEfficiency(@Nullable ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return this.getPollutionPerSecond(aStack) / 20;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getDamageToComponent(@Nullable ItemStack aStack) {
        return 0;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Deprecated
    public void stopMachine() {
        this.stopMachine(ShutDownReasonRegistry.NONE);
    }

    @Deprecated
    public void criticalStopMachine() {
        this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
    }

    public void stopMachine(@Nonnull ShutDownReason reason) {
        if (!ShutDownReasonRegistry.isRegistered(reason.getID())) {
            throw new RuntimeException(String.format("Reason %s is not registered for registry", reason.getID()));
        }
        this.mLastWorkingTick = this.mTotalRunTime;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        this.mEUt = 0;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
        this.getBaseMetaTileEntity().setShutDownReason(reason);
        this.getBaseMetaTileEntity().setShutdownStatus(true);
        if (reason.wasCritical()) {
            this.sendSound((byte)8);
        }
    }

    public int getRepairStatus() {
        return (this.mWrench ? 1 : 0) + (this.mScrewdriver ? 1 : 0) + (this.mSoftMallet ? 1 : 0) + (this.mHardHammer ? 1 : 0) + (this.mSolderingTool ? 1 : 0) + (this.mCrowbar ? 1 : 0);
    }

    public int getIdealStatus() {
        return 6;
    }

    public int getCurrentEfficiency(ItemStack itemStack) {
        int maxEff = this.getMaxEfficiency(itemStack);
        return maxEff - (this.getIdealStatus() - this.getRepairStatus()) * maxEff / 10;
    }

    public boolean doRandomMaintenanceDamage() {
        if (!this.isCorrectMachinePart(this.getControllerSlot())) {
            this.stopMachine(ShutDownReasonRegistry.NO_MACHINE_PART);
            return false;
        }
        if (this.shouldCheckMaintenance() && this.getRepairStatus() == 0) {
            this.stopMachine(ShutDownReasonRegistry.NO_REPAIR);
            return false;
        }
        if (this.mRuntime++ > 1000) {
            Item item;
            this.mRuntime = 0;
            if (this.shouldCheckMaintenance() && this.getBaseMetaTileEntity().getRandomNumber(6000) == 0) {
                this.causeMaintenanceIssue();
            }
            if (this.mInventory[1] != null && this.getBaseMetaTileEntity().getRandomNumber(2) == 0 && !this.mInventory[1].func_77977_a().startsWith("gt.blockmachines.basicmachine.") && (item = this.mInventory[1].func_77973_b()) instanceof MetaGeneratedTool01) {
                MetaGeneratedTool01 metaGeneratedTool = (MetaGeneratedTool01)item;
                metaGeneratedTool.doDamage(this.mInventory[1], (long)this.getDamageToComponent(this.getControllerSlot()) * (long)Math.min((double)(Math.abs(this.mEUt) / this.damageFactorLow), Math.pow(Math.abs(this.mEUt), this.damageFactorHigh)));
                if (this.mInventory[1].field_77994_a == 0) {
                    this.mInventory[1] = null;
                }
            }
        }
        return true;
    }

    public void causeMaintenanceIssue() {
        switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
            case 0: {
                this.mWrench = false;
                break;
            }
            case 1: {
                this.mScrewdriver = false;
                break;
            }
            case 2: {
                this.mSoftMallet = false;
                break;
            }
            case 3: {
                this.mHardHammer = false;
                break;
            }
            case 4: {
                this.mSolderingTool = false;
                break;
            }
            case 5: {
                this.mCrowbar = false;
            }
        }
    }

    public void explodeMultiblock() {
        GTLog.exp.println("MultiBlockExplosion at: " + this.getBaseMetaTileEntity().getXCoord() + " | " + this.getBaseMetaTileEntity().getYCoord() + " | " + this.getBaseMetaTileEntity().getZCoord() + " DIMID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g + ".");
        Pollution.addPollution(this.getBaseMetaTileEntity(), GTMod.proxy.mPollutionOnExplosion);
        this.mInventory[1] = null;
        Iterable allHatches = Iterables.concat((Iterable[])new Iterable[]{this.mInputBusses, this.mOutputBusses, this.mInputHatches, this.mOutputHatches, this.mDynamoHatches, this.mMufflerHatches, this.mEnergyHatches, this.mMaintenanceHatches});
        for (MetaTileEntity tTileEntity : allHatches) {
            if (tTileEntity == null || tTileEntity.getBaseMetaTileEntity() == null) continue;
            tTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
        }
        this.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (!this.mDynamoHatches.isEmpty()) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (MTEHatchDynamo aDynamo : GTUtility.validMTEList(this.mDynamoHatches)) {
            aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        if (totalOutput < aEU || aFoundMixedDynamos && !aAllowMixedVoltageDynamos) {
            this.explodeMultiblock();
            return false;
        }
        for (MTEHatchDynamo aDynamo : GTUtility.validMTEList(this.mDynamoHatches)) {
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int ampsOnCurrentHatch = (int)Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject);
            for (int i = 0; i < ampsOnCurrentHatch; ++i) {
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aVoltage, false);
            }
            injected = (int)((long)injected + aVoltage * (long)ampsOnCurrentHatch);
            if (aRemainder <= 0 || (long)ampsOnCurrentHatch >= aDynamo.maxAmperesOut()) continue;
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aRemainder, false);
            injected += aRemainder;
        }
        return injected > 0;
    }

    public long getMaxInputVoltage() {
        long rVoltage = 0L;
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            rVoltage += tHatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    public long getAverageInputVoltage() {
        return ExoticEnergyInputHelper.getAverageInputVoltageMulti(this.mEnergyHatches);
    }

    public long getMaxInputAmps() {
        return ExoticEnergyInputHelper.getMaxWorkingInputAmpsMulti(this.mEnergyHatches);
    }

    public long getMaxInputEu() {
        return ExoticEnergyInputHelper.getTotalEuMulti(this.mEnergyHatches);
    }

    public long getMaxInputPower() {
        long eut = 0L;
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            IGregTechTileEntity baseTile = tHatch.getBaseMetaTileEntity();
            eut += baseTile.getInputVoltage() * baseTile.getInputAmperage();
        }
        return eut;
    }

    public long getInputVoltageTier() {
        long rTier = 0L;
        if (!this.mEnergyHatches.isEmpty()) {
            rTier = this.mEnergyHatches.get(0).getInputTier();
            for (int i = 1; i < this.mEnergyHatches.size(); ++i) {
                if (this.mEnergyHatches.get(i).getInputTier() == rTier) continue;
                return 0L;
            }
        }
        return rTier;
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            long tDrain = Math.min(tHatch.getBaseMetaTileEntity().getStoredEU(), aEU);
            tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            if ((aEU -= tDrain) > 0L) continue;
            return true;
        }
        return false;
    }

    protected static boolean dumpFluid(List<MTEHatchOutput> aOutputHatches, FluidStack copiedFluidStack, boolean restrictiveHatchesOnly) {
        for (MTEHatchOutput tHatch : GTUtility.validMTEList(aOutputHatches)) {
            MTEHatchOutputME tMEHatch;
            if (restrictiveHatchesOnly && tHatch.mMode == 0 || !tHatch.canStoreFluid(copiedFluidStack) || tHatch instanceof MTEHatchOutputME && !(tMEHatch = (MTEHatchOutputME)tHatch).canFillFluid()) continue;
            int tAmount = tHatch.fill(copiedFluidStack, false);
            if (tAmount >= copiedFluidStack.amount) {
                boolean filled = tHatch.fill(copiedFluidStack, true) >= copiedFluidStack.amount;
                tHatch.onEmptyingContainerWhenEmpty();
                return filled;
            }
            if (tAmount <= 0) continue;
            copiedFluidStack.amount -= tHatch.fill(copiedFluidStack, true);
            tHatch.onEmptyingContainerWhenEmpty();
        }
        return false;
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack copiedFluidStack = aLiquid.copy();
        if (!MTEMultiBlockBase.dumpFluid(this.mOutputHatches, copiedFluidStack, true)) {
            MTEMultiBlockBase.dumpFluid(this.mOutputHatches, copiedFluidStack, false);
        }
        return false;
    }

    protected void addFluidOutputs(FluidStack[] outputFluids) {
        for (FluidStack outputFluidStack : outputFluids) {
            this.addOutput(outputFluidStack);
        }
    }

    public boolean depleteInput(FluidStack aLiquid) {
        return this.depleteInput(aLiquid, false);
    }

    public boolean depleteInput(FluidStack aLiquid, boolean simulate) {
        if (aLiquid == null) {
            return false;
        }
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            this.setHatchRecipeMap(tHatch);
            FluidStack tLiquid = tHatch.drain(ForgeDirection.UNKNOWN, aLiquid, false);
            if (tLiquid == null || tLiquid.amount < aLiquid.amount) continue;
            if (simulate) {
                return true;
            }
            tLiquid = tHatch.drain(ForgeDirection.UNKNOWN, aLiquid, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        aStack = GTUtility.copyOrNull(aStack);
        List validBusses = GTUtility.filterValidMTEs(this.mOutputBusses);
        if (this.dumpItem(validBusses, aStack, true, false)) {
            return true;
        }
        if (this.dumpItem(validBusses, aStack, false, false)) {
            return true;
        }
        boolean outputSuccess = true;
        List filteredHatches = GTUtility.filterValidMTEs(this.mOutputHatches);
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (MTEHatchOutput tHatch : filteredHatches) {
                if (outputSuccess || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public void addItemOutputs(ItemStack[] outputItems) {
        for (ItemStack outputItemStack : outputItems) {
            this.addOutput(outputItemStack);
        }
    }

    public boolean addOutputPartial(ItemStack stack, boolean simulate) {
        if (GTUtility.isStackInvalid(stack)) {
            return false;
        }
        List validBusses = GTUtility.filterValidMTEs(this.mOutputBusses);
        if (this.dumpItem(validBusses, stack, true, simulate)) {
            return true;
        }
        return this.dumpItem(validBusses, stack, false, simulate);
    }

    protected boolean dumpItem(List<? extends MTEHatchOutputBus> outputBuses, ItemStack itemStack, boolean restrictiveBusesOnly, boolean simulate) {
        for (MTEHatchOutputBus mTEHatchOutputBus : outputBuses) {
            if (restrictiveBusesOnly && !mTEHatchOutputBus.isLocked() || !mTEHatchOutputBus.storePartial(itemStack, simulate)) continue;
            return true;
        }
        return false;
    }

    public boolean depleteInput(ItemStack aStack) {
        IGregTechTileEntity baseMetaTileEntity;
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        FluidStack aLiquid = GTUtility.getFluidForFilledItem(aStack, true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            this.setHatchRecipeMap((MTEHatchInput)tHatch);
            baseMetaTileEntity = tHatch.getBaseMetaTileEntity();
            ItemStack stackInFirstSlot = baseMetaTileEntity.func_70301_a(0);
            if (!GTUtility.areStacksEqual(aStack, stackInFirstSlot) || stackInFirstSlot.field_77994_a < aStack.field_77994_a) continue;
            baseMetaTileEntity.func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mInputBusses)) {
            ((MTEHatchInputBus)tHatch).mRecipeMap = this.getRecipeMap();
            baseMetaTileEntity = tHatch.getBaseMetaTileEntity();
            for (int i = baseMetaTileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack stackInSlot = baseMetaTileEntity.func_70301_a(i);
                if (!GTUtility.areStacksEqual(aStack, stackInSlot) || stackInSlot.field_77994_a < aStack.field_77994_a) continue;
                baseMetaTileEntity.func_70298_a(i, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MTEHatchOutputBus tHatch : GTUtility.validMTEList(this.mOutputBusses)) {
            IGregTechTileEntity baseMetaTileEntity = tHatch.getBaseMetaTileEntity();
            for (int i = baseMetaTileEntity.func_70302_i_() - 1; i >= 0; --i) {
                rList.add(baseMetaTileEntity.func_70301_a(i));
            }
        }
        return rList;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        return this.getStoredFluidsForColor(Optional.empty());
    }

    public ArrayList<FluidStack> getStoredFluidsForColor(Optional<Byte> color) {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        HashMap<Fluid, FluidStack> inputsFromME = new HashMap<Fluid, FluidStack>();
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            byte hatchColor = tHatch.getColor();
            if (color.isPresent() && hatchColor != -1 && hatchColor != color.get()) continue;
            this.setHatchRecipeMap(tHatch);
            if (tHatch instanceof MTEHatchMultiInput) {
                MTEHatchMultiInput multiInputHatch = (MTEHatchMultiInput)tHatch;
                for (FluidStack tFluid : multiInputHatch.getStoredFluid()) {
                    if (tFluid == null) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchInputME) {
                MTEHatchInputME meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack fluidStack : meHatch.getStoredFluids()) {
                    if (fluidStack == null) continue;
                    inputsFromME.put(fluidStack.getFluid(), fluidStack);
                }
                continue;
            }
            FluidStack fillableStack = tHatch.getFillableStack();
            if (fillableStack == null) continue;
            rList.add(fillableStack);
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public boolean drain(MTEHatch hatch, FluidStack fluid, boolean doDrain) {
        Optional<IDualInputInventory> inventory;
        Object tHatch;
        if (fluid == null || hatch == null) {
            return false;
        }
        if (this.supportsCraftingMEBuffer() && hatch instanceof IDualInputHatch && (tHatch = (IDualInputHatch)((Object)hatch)).supportsFluids() && (inventory = tHatch.getFirstNonEmptyInventory()).isPresent()) {
            for (FluidStack storedFluid : Lists.newArrayList((Object[])inventory.get().getFluidInputs())) {
                if (!fluid.isFluidEqual(storedFluid)) continue;
                if (doDrain) {
                    storedFluid.amount = Math.max(storedFluid.amount - fluid.amount, 0);
                }
                return storedFluid.amount >= fluid.amount;
            }
        }
        if (hatch instanceof MTEHatchInput && ((MetaTileEntity)(tHatch = (MTEHatchInput)hatch)).isValid()) {
            FluidStack tFluid;
            if (tHatch instanceof MTEHatchInputME) {
                MTEHatchInputME meHatch = (MTEHatchInputME)tHatch;
                meHatch.startRecipeProcessing();
                tFluid = meHatch.drain(ForgeDirection.UNKNOWN, fluid, doDrain);
                meHatch.endRecipeProcessing(this);
                return tFluid != null && tFluid.amount >= fluid.amount;
            }
            tFluid = ((CommonMetaTileEntity)tHatch).drain(ForgeDirection.UNKNOWN, fluid, doDrain);
            return tFluid != null && tFluid.amount >= fluid.amount;
        }
        return false;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        return this.getStoredInputsForColor(Optional.empty());
    }

    public ArrayList<ItemStack> getStoredInputsForColor(Optional<Byte> color) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        HashMap<GTUtility.ItemId, ItemStack> inputsFromME = new HashMap<GTUtility.ItemId, ItemStack>();
        for (MTEHatchInputBus tHatch : GTUtility.validMTEList(this.mInputBusses)) {
            if (tHatch instanceof MTEHatchCraftingInputME) continue;
            byte busColor = tHatch.getColor();
            if (color.isPresent() && busColor != -1 && busColor != color.get()) continue;
            tHatch.mRecipeMap = this.getRecipeMap();
            IGregTechTileEntity tileEntity = tHatch.getBaseMetaTileEntity();
            boolean isMEBus = tHatch instanceof MTEHatchInputBusME;
            for (int i = tileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = tileEntity.func_70301_a(i);
                if (itemStack == null) continue;
                if (isMEBus) {
                    inputsFromME.put(GTUtility.ItemId.createNoCopy(itemStack), itemStack);
                    continue;
                }
                rList.add(itemStack);
            }
        }
        ItemStack stackInSlot1 = this.func_70301_a(1);
        if (stackInSlot1 != null && stackInSlot1.func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(stackInSlot1);
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public ArrayList<ItemStack> getAllStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (this.supportsCraftingMEBuffer()) {
            for (IDualInputHatch iDualInputHatch : this.mDualInputHatches) {
                rList.addAll(Arrays.asList(iDualInputHatch.getAllItems()));
            }
        }
        HashMap<GTUtility.ItemId, ItemStack> inputsFromME = new HashMap<GTUtility.ItemId, ItemStack>();
        for (MTEHatchInputBus tHatch : GTUtility.validMTEList(this.mInputBusses)) {
            if (tHatch instanceof MTEHatchCraftingInputME) continue;
            tHatch.mRecipeMap = this.getRecipeMap();
            IGregTechTileEntity tileEntity = tHatch.getBaseMetaTileEntity();
            boolean isMEBus = tHatch instanceof MTEHatchInputBusME;
            for (int i = tileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = tileEntity.func_70301_a(i);
                if (itemStack == null) continue;
                if (isMEBus) {
                    inputsFromME.put(GTUtility.ItemId.createNoCopy(itemStack), itemStack);
                    continue;
                }
                rList.add(itemStack);
            }
        }
        ItemStack itemStack = this.func_70301_a(1);
        if (itemStack != null && itemStack.func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(itemStack);
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public Map<GTUtility.ItemId, ItemStack> getStoredInputsFromME() {
        Object2ReferenceOpenHashMap inputsFromME = new Object2ReferenceOpenHashMap();
        for (MTEHatchInputBus tHatch : GTUtility.validMTEList(this.mInputBusses)) {
            if (!(tHatch instanceof MTEHatchInputBusME)) continue;
            MTEHatchInputBusME meBus = (MTEHatchInputBusME)tHatch;
            for (int i = meBus.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = meBus.func_70301_a(i);
                if (itemStack == null) continue;
                inputsFromME.put(GTUtility.ItemId.createNoCopy(itemStack), itemStack);
            }
        }
        return inputsFromME;
    }

    public Map<Fluid, FluidStack> getStoredFluidsFromME() {
        Reference2ReferenceOpenHashMap fluidsFromME = new Reference2ReferenceOpenHashMap();
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            if (!(tHatch instanceof MTEHatchInputME)) continue;
            MTEHatchInputME meHatch = (MTEHatchInputME)tHatch;
            for (FluidStack fluid : meHatch.getStoredFluids()) {
                if (fluid == null) continue;
                fluidsFromME.put(fluid.getFluid(), fluid);
            }
        }
        return fluidsFromME;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return null;
    }

    @ApiStatus.OverrideOnly
    protected ProcessingLogic createProcessingLogic() {
        return null;
    }

    public void updateSlots() {
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            ((MTEHatchInput)tHatch).updateSlots();
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mInputBusses)) {
            ((MTEHatchInputBus)tHatch).updateSlots();
        }
    }

    public void startRecipeProcessing() {
        IRecipeProcessingAwareHatch aware;
        this.mDualInputHatches.removeIf(mte -> mte == null || !((MetaTileEntity)((Object)mte)).isValid());
        for (MTEHatch hatch : GTUtility.validMTEList(this.mInputBusses)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            aware.startRecipeProcessing();
        }
        for (MTEHatch hatch : GTUtility.validMTEList(this.mInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            aware.startRecipeProcessing();
        }
    }

    public void setResultIfFailure(CheckRecipeResult result) {
        if (!result.wasSuccessful()) {
            this.checkRecipeResult = result;
        }
    }

    public void endRecipeProcessing() {
        IRecipeProcessingAwareHatch aware;
        for (MTEHatch hatch : GTUtility.validMTEList(this.mInputBusses)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            this.setResultIfFailure(aware.endRecipeProcessing(this));
        }
        for (MTEHatch hatch : GTUtility.validMTEList(this.mInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            this.setResultIfFailure(aware.endRecipeProcessing(this));
        }
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        Object hatch;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            hatch = (MTEHatch)aMetaTileEntity;
            ((MTEHatch)hatch).updateTexture(aBaseCasingIndex);
            ((MTEHatch)hatch).updateCraftingIcon(this.getMachineCraftingIcon());
        }
        if (aMetaTileEntity instanceof IDualInputHatch) {
            hatch = (IDualInputHatch)((Object)aMetaTileEntity);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            if (hatch instanceof IDualInputHatchWithPattern) {
                IDualInputHatchWithPattern withPattern = (IDualInputHatchWithPattern)hatch;
                withPattern.setProcessingLogic(this.processingLogic);
            }
            return this.mDualInputHatches.add((IDualInputHatch)hatch);
        }
        if (aMetaTileEntity instanceof ISmartInputHatch && (hatch = (ISmartInputHatch)((Object)aMetaTileEntity)).doFastRecipeCheck()) {
            this.mSmartInputHatches.add((ISmartInputHatch)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            hatch = (MTEHatchInput)aMetaTileEntity;
            this.setHatchRecipeMap((MTEHatchInput)hatch);
            return this.mInputHatches.add((MTEHatchInput)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            hatch = (MTEHatchInputBus)aMetaTileEntity;
            ((MTEHatchInputBus)hatch).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((MTEHatchInputBus)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            hatch = (MTEHatchOutput)aMetaTileEntity;
            return this.mOutputHatches.add((MTEHatchOutput)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchOutputBus) {
            hatch = (MTEHatchOutputBus)aMetaTileEntity;
            return this.mOutputBusses.add((MTEHatchOutputBus)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            hatch = (MTEHatchEnergy)aMetaTileEntity;
            return this.mEnergyHatches.add((MTEHatchEnergy)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            hatch = (MTEHatchDynamo)aMetaTileEntity;
            return this.mDynamoHatches.add((MTEHatchDynamo)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            hatch = (MTEHatchMaintenance)aMetaTileEntity;
            if (hatch instanceof MTEHatchDroneDownLink) {
                MTEHatchDroneDownLink droneDownLink = (MTEHatchDroneDownLink)hatch;
                droneDownLink.registerMachineController(this);
            }
            return this.mMaintenanceHatches.add((MTEHatchMaintenance)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchMuffler) {
            hatch = (MTEHatchMuffler)aMetaTileEntity;
            return this.mMufflerHatches.add((MTEHatchMuffler)hatch);
        }
        return false;
    }

    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            MTEHatchMaintenance hatch = (MTEHatchMaintenance)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            if (hatch instanceof MTEHatchDroneDownLink) {
                MTEHatchDroneDownLink droneDownLink = (MTEHatchDroneDownLink)hatch;
                droneDownLink.registerMachineController(this);
            }
            return this.mMaintenanceHatches.add(hatch);
        }
        return false;
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            MTEHatchEnergy hatch = (MTEHatchEnergy)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mEnergyHatches.add(hatch);
        }
        return false;
    }

    public boolean addMultiAmpEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        MTEHatchEnergyMulti hatch;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti && (hatch = (MTEHatchEnergyMulti)aMetaTileEntity).getHatchType() == 1) {
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mExoticEnergyHatches.add(hatch);
        }
        return false;
    }

    public boolean addExoticEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch hatch = (MTEHatch)aMetaTileEntity;
            if (ExoticEnergyInputHelper.isExoticEnergyInput(aMetaTileEntity)) {
                hatch.updateTexture(aBaseCasingIndex);
                hatch.updateCraftingIcon(this.getMachineCraftingIcon());
                return this.mExoticEnergyHatches.add(hatch);
            }
        }
        return false;
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            MTEHatchDynamo hatch = (MTEHatchDynamo)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mDynamoHatches.add(hatch);
        }
        return false;
    }

    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchMuffler) {
            MTEHatchMuffler hatch = (MTEHatchMuffler)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mMufflerHatches.add(hatch);
        }
        return false;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addInputBusToMachineList(aTileEntity, aBaseCasingIndex) || this.addInputHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addOutputBusToMachineList(aTileEntity, aBaseCasingIndex) || this.addOutputHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addInputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        Object hatch;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof IDualInputHatch) {
            IDualInputHatch hatch2 = (IDualInputHatch)((Object)aMetaTileEntity);
            if (!this.supportsCraftingMEBuffer()) {
                return false;
            }
            hatch2.updateTexture(aBaseCasingIndex);
            hatch2.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mDualInputHatches.add(hatch2);
        }
        if (aMetaTileEntity instanceof MTEHatchSteamBusInput) {
            return false;
        }
        if (aMetaTileEntity instanceof ISmartInputHatch) {
            hatch = (ISmartInputHatch)((Object)aMetaTileEntity);
            this.mSmartInputHatches.add((ISmartInputHatch)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            hatch = (MTEHatchInputBus)aMetaTileEntity;
            ((MTEHatch)hatch).updateTexture(aBaseCasingIndex);
            ((MTEHatch)hatch).updateCraftingIcon(this.getMachineCraftingIcon());
            ((MTEHatchInputBus)hatch).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((MTEHatchInputBus)hatch);
        }
        return false;
    }

    public boolean addOutputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutputBus) {
            MTEHatchOutputBus hatch = (MTEHatchOutputBus)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mOutputBusses.add(hatch);
        }
        return false;
    }

    public boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        Object hatch;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof ISmartInputHatch) {
            hatch = (ISmartInputHatch)((Object)aMetaTileEntity);
            this.mSmartInputHatches.add((ISmartInputHatch)hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            hatch = (MTEHatchInput)aMetaTileEntity;
            ((MTEHatch)hatch).updateTexture(aBaseCasingIndex);
            ((MTEHatch)hatch).updateCraftingIcon(this.getMachineCraftingIcon());
            this.setHatchRecipeMap((MTEHatchInput)hatch);
            return this.mInputHatches.add((MTEHatchInput)hatch);
        }
        return false;
    }

    public boolean addOutputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput hatch = (MTEHatchOutput)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mOutputHatches.add(hatch);
        }
        return false;
    }

    protected void setHatchRecipeMap(MTEHatchInput hatch) {
        if (this.filtersFluid()) {
            hatch.mRecipeMap = this.getRecipeMap();
        }
    }

    protected boolean filtersFluid() {
        return true;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            IGregTechTileEntity baseMetaTileEntity = tHatch.getBaseMetaTileEntity();
            storedEnergy += baseMetaTileEntity.getStoredEU();
            maxEnergy += baseMetaTileEntity.getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
    }

    @Override
    public Map<String, String> getInfoMap() {
        long energy = 0L;
        long maxEnergy = 0L;
        long maxEnergyUsage = 0L;
        long minEnergyTier = Long.MAX_VALUE;
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            IGregTechTileEntity energyHatch = tHatch.getBaseMetaTileEntity();
            energy += energyHatch.getStoredEU();
            maxEnergy += energyHatch.getEUCapacity();
            maxEnergyUsage += energyHatch.getInputAmperage() * energyHatch.getInputVoltage();
            minEnergyTier = Math.min(minEnergyTier, energyHatch.getInputVoltage());
        }
        minEnergyTier = minEnergyTier == Long.MAX_VALUE ? 0L : minEnergyTier;
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("progressTime", Integer.toString(this.mProgresstime));
        infoMap.put("maxProgressTime", Integer.toString(this.mMaxProgresstime));
        infoMap.put("energy", Long.toString(energy));
        infoMap.put("maxEnergy", Long.toString(maxEnergy));
        infoMap.put("energyUsage", Long.toString(this.getActualEnergyUsage()));
        infoMap.put("maxEnergyUsage", Long.toString(maxEnergyUsage));
        infoMap.put("minEnergyTier", Long.toString(minEnergyTier));
        infoMap.put("maintenanceIssues", Integer.toString(this.getIdealStatus() - this.getRepairStatus()));
        infoMap.put("energyEfficiency", Double.toString((float)this.mEfficiency / 10000.0f));
        infoMap.put("pollution", Double.toString((float)this.getAveragePollutionPercentage() / 100.0f));
        return infoMap;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.supportsSlotAutomation(aIndex);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.supportsSlotAutomation(aIndex);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int outputFluidLength;
        int outputItemLength;
        int totalOutputs;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.incomplete", (Object[])new Object[0]) + SpecialChars.RESET);
        }
        String efficiency = SpecialChars.RESET + StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.efficiency", (Object[])new Object[]{Float.valueOf(tag.func_74760_g("efficiency"))});
        if (tag.func_74767_n("hasProblems")) {
            currentTip.add(SpecialChars.RED + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.has_problem") + efficiency);
        } else if (!tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.GREEN + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.running_fine") + efficiency);
        }
        boolean isActive = tag.func_74767_n("isActive");
        if (isActive) {
            long energyTier = tag.func_74763_f("energyTier");
            long actualEnergyUsage = tag.func_74763_f("energyUsage");
            if (energyTier > 0L) {
                if (actualEnergyUsage > 0L) {
                    currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use_with_amperage", (Object[])new Object[]{GTUtility.formatNumbers(actualEnergyUsage), GTUtility.getAmperageForTier(actualEnergyUsage, (byte)energyTier), GTUtility.getColoredTierNameFromTier((byte)energyTier)}));
                } else if (actualEnergyUsage < 0L) {
                    currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce_with_amperage", (Object[])new Object[]{GTUtility.formatNumbers(-actualEnergyUsage), GTUtility.getAmperageForTier(-actualEnergyUsage, (byte)energyTier), GTUtility.getColoredTierNameFromTier((byte)energyTier)}));
                }
            } else if (actualEnergyUsage > 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use", (Object[])new Object[]{GTUtility.formatNumbers(actualEnergyUsage), GTUtility.getColoredTierNameFromVoltage(actualEnergyUsage)}));
            } else if (actualEnergyUsage < 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce", (Object[])new Object[]{GTUtility.formatNumbers(-actualEnergyUsage), GTUtility.getColoredTierNameFromVoltage(-actualEnergyUsage)}));
            }
        }
        boolean isLockedToRecipe = tag.func_74767_n("isLockedToRecipe");
        String lockedRecipe = tag.func_74779_i("lockedRecipeName");
        if (!isActive && isLockedToRecipe && !lockedRecipe.isEmpty()) {
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.locked_recipe"));
            String[] lines = lockedRecipe.split("\n");
            currentTip.addAll(Arrays.asList(lines));
        } else if (isActive && (totalOutputs = (outputItemLength = tag.func_74762_e("outputItemLength")) + (outputFluidLength = tag.func_74762_e("outputFluidLength"))) > 0) {
            int i;
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.waila.producing"));
            if (isLockedToRecipe) {
                currentTip.add(StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.locked_recipe"));
            }
            for (i = 0; i < GTUtility.min(3, outputItemLength); ++i) {
                currentTip.add("  " + tag.func_74779_i("outputItem" + i) + " x " + GTUtility.formatNumbers(tag.func_74762_e("outputItemCount" + i)));
            }
            for (i = 0; i < GTUtility.min(3 - outputItemLength, outputFluidLength); ++i) {
                currentTip.add("  " + tag.func_74779_i("outputFluid" + i) + " x " + GTUtility.formatNumbers(tag.func_74762_e("outputFluidCount" + i)) + "L");
            }
            if (totalOutputs > 3) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.producing.andmore", (Object[])new Object[]{GTUtility.formatNumbers(totalOutputs - 3)}));
            }
        }
        currentTip.add(GTWaila.getMachineProgressString(isActive, tag.func_74767_n("isAllowedToWork"), tag.func_74762_e("maxProgress"), tag.func_74762_e("progress")));
        if (GTMod.proxy.wailaAverageNS && tag.func_74764_b("averageNS")) {
            int tAverageTime = tag.func_74762_e("averageNS");
            currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.cpu_load", (Object[])new Object[]{GTUtility.formatNumbers(tAverageTime)}));
        }
        if (tag.func_74762_e("maxParallelRecipes") > 1) {
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + tag.func_74762_e("maxParallelRecipes"));
        }
        if (tag.func_74764_b("mode")) {
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.runningMode") + " " + EnumChatFormatting.WHITE + tag.func_74779_i("mode") + EnumChatFormatting.RESET);
        }
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    public final void getMTEWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        GTClientPreference preference;
        IGregTechTileEntity tileEntity;
        int index;
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("hasProblems", this.getIdealStatus() - this.getRepairStatus() > 0);
        tag.func_74776_a("efficiency", (float)this.mEfficiency / 100.0f);
        tag.func_74768_a("progress", this.mProgresstime);
        tag.func_74768_a("maxProgress", this.mMaxProgresstime);
        tag.func_74757_a("incompleteStructure", (this.getErrorDisplayID() & 0x40) != 0);
        tag.func_74768_a("maxParallelRecipes", this.getMaxParallelRecipes());
        tag.func_74757_a("isLockedToRecipe", this.isRecipeLockingEnabled());
        SingleRecipeCheck lockedRecipe = this.getSingleRecipeCheck();
        tag.func_74778_a("lockedRecipeName", lockedRecipe != null ? SingleRecipeCheck.getDisplayString(lockedRecipe.getRecipe(), false, true, false, true) : "");
        if (this.mOutputItems != null) {
            index = 0;
            for (ItemStack itemStack : this.mOutputItems) {
                if (itemStack == null) continue;
                tag.func_74778_a("outputItem" + index, itemStack.func_82833_r());
                tag.func_74768_a("outputItemCount" + index, itemStack.field_77994_a);
                ++index;
            }
            if (index != 0) {
                tag.func_74768_a("outputItemLength", index);
            }
        }
        if (this.mOutputFluids != null) {
            index = 0;
            for (ItemStack itemStack : this.mOutputFluids) {
                if (itemStack == null) continue;
                tag.func_74778_a("outputFluid" + index, itemStack.getLocalizedName());
                tag.func_74768_a("outputFluidCount" + index, itemStack.amount);
                ++index;
            }
            if (index != 0) {
                tag.func_74768_a("outputFluidLength", index);
            }
        }
        if ((tileEntity = this.getBaseMetaTileEntity()) != null) {
            tag.func_74757_a("isActive", tileEntity.isActive());
            tag.func_74757_a("isAllowedToWork", tileEntity.isAllowedToWork());
            if (tileEntity.isActive()) {
                if (this.mEUt < 0) {
                    tag.func_74772_a("energyUsage", this.getActualEnergyUsage());
                } else {
                    tag.func_74772_a("energyUsage", (long)(-this.mEUt) * (long)this.mEfficiency / 10000L);
                }
                tag.func_74772_a("energyTier", this.getInputVoltageTier());
            }
        }
        if ((preference = GTMod.proxy.getClientPreference(player.func_110124_au())) != null && preference.isWailaAverageNSEnabled()) {
            this.getBaseMetaTileEntity().startTimeStatistics();
            int tAverageTime = 0;
            int amountOfZero = 0;
            for (int tTime : this.getBaseMetaTileEntity().getTimeStatistics()) {
                tAverageTime += tTime;
                if (tTime != 0) continue;
                ++amountOfZero;
            }
            int n = this.getBaseMetaTileEntity().getTimeStatistics().length - amountOfZero;
            if (n > 0) {
                tag.func_74768_a("averageNS", tAverageTime / n);
            }
        }
    }

    protected void setMufflers(boolean state) {
        int size = this.mMufflerHatches.size();
        for (int i = 0; i < size; ++i) {
            MTEHatchMuffler muffler = this.mMufflerHatches.get(i);
            IGregTechTileEntity tile = muffler.getBaseMetaTileEntity();
            if (tile == null || tile.isDead()) continue;
            tile.setActive(state);
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.setMufflers(false);
        this.deactivateCoilLease();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.deactivateCoilLease();
    }

    private void deactivateCoilLease() {
        if (this.coilLease != null) {
            GTCoilTracker.deactivate(this.coilLease);
            this.coilLease = null;
        }
    }

    public List<MTEHatch> getExoticEnergyHatches() {
        return this.mExoticEnergyHatches;
    }

    public boolean checkExoticAndNormalEnergyHatches() {
        if (this.mExoticEnergyHatches.isEmpty() && this.mEnergyHatches.isEmpty()) {
            return false;
        }
        if (!this.mExoticEnergyHatches.isEmpty()) {
            if (!this.mEnergyHatches.isEmpty()) {
                return false;
            }
            if (this.mExoticEnergyHatches.size() != 1) {
                return false;
            }
        }
        return this.mEnergyHatches.size() <= 2;
    }

    protected boolean canOutputAll(@Nonnull GTRecipe recipe) {
        return this.canOutputAll(recipe.mOutputs, recipe.mFluidOutputs);
    }

    protected boolean canOutputAll(ItemStack[] items) {
        return this.canOutputAll(items, null);
    }

    protected boolean canOutputAll(FluidStack[] fluids) {
        return this.canOutputAll(null, fluids);
    }

    protected boolean canOutputAll(@Nullable ItemStack[] items, @Nullable FluidStack[] fluids) {
        if (!this.protectsExcessItem() && !this.protectsExcessFluid()) {
            return true;
        }
        VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper().setMachine(this).setItemOutputs(items).setFluidOutputs(fluids).build();
        return voidProtectionHelper.getMaxParallel() > 0;
    }

    @Override
    public boolean isAllowedToWork() {
        IGregTechTileEntity baseMetaTileEntity = this.getBaseMetaTileEntity();
        return baseMetaTileEntity != null && baseMetaTileEntity.isAllowedToWork();
    }

    @Override
    public void disableWorking() {
        IGregTechTileEntity baseMetaTileEntity = this.getBaseMetaTileEntity();
        if (baseMetaTileEntity != null) {
            baseMetaTileEntity.disableWorking();
        }
    }

    @Override
    public void enableWorking() {
        IGregTechTileEntity baseMetaTileEntity = this.getBaseMetaTileEntity();
        if (baseMetaTileEntity != null) {
            baseMetaTileEntity.enableWorking();
        }
    }

    public ItemStack getControllerSlot() {
        return this.mInventory[this.getControllerSlotIndex()];
    }

    public final int getControllerSlotIndex() {
        return 1;
    }

    protected boolean supportsSlotAutomation(int aSlot) {
        return false;
    }

    @Override
    public Pos2d getPowerSwitchButtonPos() {
        return new Pos2d(174, 148);
    }

    @Override
    public Pos2d getStructureUpdateButtonPos() {
        return new Pos2d(174, 130);
    }

    @Override
    public int getStructureUpdateTime() {
        return this.mUpdate;
    }

    @Override
    public void setStructureUpdateTime(int time) {
        this.mUpdate = time;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Override
    public void setVoidingMode(VoidingMode mode) {
        this.voidingMode = mode;
    }

    @Override
    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (MTEHatch tBus : GTUtility.validMTEList(this.mOutputBusses)) {
            MTEHatchOutputBusME meBus;
            if (tBus instanceof MTEHatchOutputBusME) {
                meBus = (MTEHatchOutputBusME)tBus;
            } else {
                IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
                for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                    IItemLockable lockable;
                    ItemStack stackInSlot = tBus.func_70301_a(i);
                    if (stackInSlot == null && tBus instanceof IItemLockable && (lockable = (IItemLockable)((Object)tBus)).isLocked()) {
                        assert (lockable.getLockedItem() != null);
                        ItemStack fakeItemStack = lockable.getLockedItem().func_77946_l();
                        fakeItemStack.field_77994_a = 0;
                        ret.add(fakeItemStack);
                        continue;
                    }
                    ret.add(stackInSlot);
                }
                continue;
            }
            if (!meBus.isLocked() || !meBus.canAcceptItem()) continue;
            for (ItemStack stack : meBus.getLockedItems()) {
                ItemStack fakeItemStack = stack.func_77946_l();
                fakeItemStack.field_77994_a = 65;
                ret.add(fakeItemStack);
            }
        }
        return ret;
    }

    @Override
    public List<ItemStack> getVoidOutputSlots() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (MTEHatch tBus : GTUtility.validMTEList(this.mOutputBusses)) {
            MTEHatchVoidBus vBus;
            if (!(tBus instanceof MTEHatchVoidBus) || !(vBus = (MTEHatchVoidBus)tBus).isLocked()) continue;
            for (ItemStack lockedItem : vBus.getLockedItems()) {
                if (lockedItem == null) continue;
                ret.add(lockedItem.func_77946_l());
            }
        }
        return ret;
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        ArrayList<MTEHatchOutput> totalHatches = new ArrayList<MTEHatchOutput>(GTUtility.filterValidMTEs(this.mOutputHatches));
        totalHatches.removeIf(hatch -> hatch instanceof MTEHatchVoid && !hatch.isFluidLocked());
        return totalHatches;
    }

    protected <T extends MTEHatchOutput> List<? extends IFluidStore> getFluidOutputSlotsByLayer(FluidStack[] toOutput, List<List<T>> hatchesByLayer) {
        ArrayList<IFluidStore> ret = new ArrayList<IFluidStore>();
        for (int i = 0; i < toOutput.length && i < hatchesByLayer.size(); ++i) {
            FluidStack fluidOutputForLayer = toOutput[i];
            for (MTEHatchOutput hatch : hatchesByLayer.get(i)) {
                if (!hatch.isValid()) continue;
                if (fluidOutputForLayer != null) {
                    ret.add(new OutputHatchWrapper(hatch, f -> GTUtility.areFluidsEqual(f, fluidOutputForLayer)));
                    continue;
                }
                ret.add(hatch);
            }
        }
        return ret;
    }

    @Override
    public boolean canDumpItemToME() {
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mOutputBusses)) {
            if (!(tHatch instanceof MTEHatchOutputBusME)) continue;
            if (((MTEHatchOutputBusME)tHatch).isLocked()) {
                return false;
            }
            if (!((MTEHatchOutputBusME)tHatch).canAcceptItem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDumpFluidToME() {
        for (IFluidStore iFluidStore : this.getFluidOutputSlots(GTValues.emptyFluidStackArray)) {
            if (!(iFluidStore instanceof MTEHatchOutputME)) continue;
            if (((MTEHatchOutputME)iFluidStore).isFluidLocked()) {
                return false;
            }
            if (!((MTEHatchOutputME)iFluidStore).canAcceptFluid()) continue;
            return true;
        }
        return false;
    }

    public int getMaxParallelRecipes() {
        return 1;
    }

    public final int getTrueParallel() {
        return Math.max(1, this.alwaysMaxParallel ? this.getMaxParallelRecipes() : Math.min(this.getMaxParallelRecipes(), this.powerPanelMaxParallel));
    }

    @Override
    public Pos2d getVoidingModeButtonPos() {
        return new Pos2d(8, 91);
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return this.inputSeparation;
    }

    @Override
    public void setInputSeparation(boolean enabled) {
        this.inputSeparation = enabled;
    }

    @Override
    public Pos2d getInputSeparationButtonPos() {
        return new Pos2d(26, 91);
    }

    public void setMachineModeIcons() {
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return false;
    }

    @Override
    public int getMachineMode() {
        return this.machineMode;
    }

    @Override
    public UITexture getMachineModeIcon(int index) {
        if (index > this.machineModeIcons.size() - 1) {
            return null;
        }
        return this.machineModeIcons.get(index);
    }

    @Override
    public void setMachineMode(int index) {
        this.machineMode = index;
    }

    @Override
    public int nextMachineMode() {
        if (this.machineMode == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Pos2d getMachineModeSwitchButtonPos() {
        return new Pos2d(80, 91);
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean isBatchModeEnabled() {
        return this.batchMode;
    }

    @Override
    public void setBatchMode(boolean enabled) {
        this.batchMode = enabled;
    }

    @Override
    public Pos2d getBatchModeButtonPos() {
        return new Pos2d(44, 91);
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean isRecipeLockingEnabled() {
        return this.mLockedToSingleRecipe;
    }

    @Override
    public void setRecipeLocking(boolean enabled) {
        this.mLockedToSingleRecipe = enabled;
        if (!enabled) {
            this.setSingleRecipeCheck(null);
        }
    }

    @Override
    public void setSingleRecipeCheck(SingleRecipeCheck recipeCheck) {
        this.mSingleRecipeCheck = recipeCheck;
    }

    @Override
    public SingleRecipeCheck getSingleRecipeCheck() {
        return this.mSingleRecipeCheck;
    }

    @Override
    public Pos2d getRecipeLockingButtonPos() {
        return new Pos2d(62, 91);
    }

    @Override
    public int getGUIWidth() {
        return 198;
    }

    @Override
    public int getGUIHeight() {
        return 192;
    }

    @Override
    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.bindPlayerInventory(buildContext.getPlayer(), new Pos2d(7, 109), (IDrawable)this.getGUITextureSet().getItemSlot());
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(190, 85));
        SlotWidget inventorySlot = new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1);
        builder.widget(inventorySlot.setPos(173, 167).setBackground(new IDrawable[]{GTUITextures.SLOT_DARK_GRAY}));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, inventorySlot);
        builder.widget(((Scrollable)new Scrollable().setVerticalScroll().widget((Widget)screenElements)).setPos(10, 7).setSize(182, 79));
        if (this.supportsMachineModeSwitch() && this.machineModeIcons == null) {
            this.machineModeIcons = new ArrayList<UITexture>(4);
            this.setMachineModeIcons();
        }
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget((Widget)this.createPowerSwitchButton((IWidgetBuilder)builder))).widget((Widget)this.createVoidExcessButton((IWidgetBuilder)builder))).widget((Widget)this.createInputSeparationButton((IWidgetBuilder)builder))).widget((Widget)this.createModeSwitchButton((IWidgetBuilder)builder))).widget((Widget)this.createBatchModeButton((IWidgetBuilder)builder))).widget((Widget)this.createLockToSingleRecipeButton((IWidgetBuilder)builder))).widget((Widget)this.createStructureUpdateButton((IWidgetBuilder)builder));
        if (this.supportsPowerPanel()) {
            builder.widget((Widget)this.createPowerPanelButton((IWidgetBuilder)builder));
            buildContext.addSyncedWindow(8, this::createPowerPanel);
        }
    }

    @Override
    public boolean supportsPowerPanel() {
        return true;
    }

    @Override
    public Pos2d getPowerPanelButtonPos() {
        return new Pos2d(174, 91);
    }

    @Override
    public ModularWindow createPowerPanel(EntityPlayer player) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.maxParallel = this.getMaxParallelRecipes();
        }
        if (this.alwaysMaxParallel) {
            this.powerPanelMaxParallel = this.maxParallel;
        }
        int w = 120;
        int h = 130;
        int parentW = this.getGUIWidth();
        int parentH = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)120, (int)130);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(parentW, parentH)).add(Alignment.TopRight.getAlignedPos(new Size(parentW, parentH), new Size(120, 130)).add(117, 0)));
        builder.widget(new TextWidget(EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"GT5U.gui.text.power_panel")).setPos(0, 2).setSize(120, 18));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getMaxParallelRecipes, val -> {
            this.maxParallel = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.powerPanelMaxParallel, val -> {
            this.powerPanelMaxParallel = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.alwaysMaxParallel, val -> {
            this.alwaysMaxParallel = val;
        }));
        builder.widget(TextWidget.localised((String)"GTPP.CC.parallel", (Object[])new Object[0]).setPos(0, 24).setSize(120, 18));
        NumericWidget textField = (NumericWidget)new NumericWidget().setSetter(val -> {
            this.powerPanelMaxParallel = (int)val;
        }).setGetter(() -> this.powerPanelMaxParallel).setValidator(val -> {
            this.powerPanelMaxParallel = (int)Math.min((double)this.maxParallel, Math.max(val, (double)(this.alwaysMaxParallel ? this.maxParallel : 1)));
            return this.powerPanelMaxParallel;
        }).setDefaultValue((double)this.powerPanelMaxParallel).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).dynamicTooltip(() -> Collections.singletonList(this.alwaysMaxParallel ? StatCollector.func_74837_a((String)"GT5U.gui.text.lockedvalue", (Object[])new Object[]{this.maxParallel}) : StatCollector.func_74837_a((String)"GT5U.gui.text.rangedvalue", (Object[])new Object[]{1, this.maxParallel}))).setTooltipShowUpDelay(5).setSize(70, 18).setPos(12, 40).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD});
        builder.widget((Widget)textField);
        builder.widget((Widget)this.createMaxParallelCheckBox(textField));
        return builder.build();
    }

    public ButtonWidget createMaxParallelCheckBox(NumericWidget textField) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            textField.notifyTooltipChange();
            if (this.getBaseMetaTileEntity().isClientSide()) {
                return;
            }
            this.alwaysMaxParallel = !this.alwaysMaxParallel;
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.alwaysMaxParallel) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                ret.add(GTUITextures.OVERLAY_BUTTON_CHECKMARK);
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
                ret.add(GTUITextures.OVERLAY_BUTTON_CROSS);
            }
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.max_parallel")).setTooltipShowUpDelay(5).setPos(88, 41).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public boolean shouldDisplayCheckRecipeResult() {
        return true;
    }

    public boolean shouldDisplayShutDownReason() {
        return true;
    }

    public String generateCurrentRecipeInfoString() {
        HashMap<String, Long> nameToAmount;
        StringBuffer ret = new StringBuffer(StatCollector.func_74838_a((String)"GT5U.gui.text.progress"));
        ret.append(" ");
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.format((double)this.mProgresstime / 20.0, ret);
        ret.append("s / ");
        this.numberFormat.format((double)this.mMaxProgresstime / 20.0, ret);
        ret.append("s (");
        this.numberFormat.setMinimumFractionDigits(1);
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.format((double)this.mProgresstime / (double)this.mMaxProgresstime * 100.0, ret);
        ret.append("%)\n");
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        LongConsumer appendRate = amount -> {
            double processPerTick = (double)amount / (double)this.mMaxProgresstime * 20.0;
            ret.append(" (");
            if (processPerTick > 1.0) {
                this.numberFormat.format((double)Math.round(processPerTick * 10.0) / 10.0, ret);
                ret.append("/s)");
            } else {
                this.numberFormat.format((double)Math.round(1.0 / processPerTick * 10.0) / 10.0, ret);
                ret.append("s/ea)");
            }
        };
        int lines = 0;
        int MAX_LINES = 10;
        if (this.mOutputItems != null) {
            nameToAmount = new HashMap<String, Long>();
            for (ItemStack item : this.mOutputItems) {
                if (item == null || item.field_77994_a <= 0) continue;
                nameToAmount.merge(item.func_82833_r(), Long.valueOf(item.field_77994_a), Long::sum);
            }
            for (Map.Entry entry : nameToAmount.entrySet()) {
                if (lines >= MAX_LINES) {
                    ret.append("...");
                    return ret.toString();
                }
                ++lines;
                ret.append(EnumChatFormatting.AQUA).append((String)entry.getKey()).append(EnumChatFormatting.WHITE).append(" x ").append(EnumChatFormatting.GOLD);
                this.numberFormat.format(entry.getValue(), ret);
                ret.append(EnumChatFormatting.WHITE);
                appendRate.accept((Long)entry.getValue());
                ret.append('\n');
            }
        }
        if (this.mOutputFluids != null) {
            nameToAmount = new HashMap();
            for (FluidStack fluid : this.mOutputFluids) {
                if (fluid == null || fluid.amount <= 0) continue;
                nameToAmount.merge(fluid.getLocalizedName(), Long.valueOf(fluid.amount), Long::sum);
            }
            for (Map.Entry entry : nameToAmount.entrySet()) {
                if (lines >= MAX_LINES) {
                    ret.append("...");
                    return ret.toString();
                }
                ++lines;
                ret.append(EnumChatFormatting.AQUA).append((String)entry.getKey()).append(EnumChatFormatting.WHITE).append(" x ").append(EnumChatFormatting.GOLD);
                this.numberFormat.format(entry.getValue(), ret);
                ret.append("L").append(EnumChatFormatting.WHITE);
                appendRate.accept((Long)entry.getValue());
                ret.append('\n');
            }
        }
        return ret.toString();
    }

    protected Widget generateCurrentRecipeInfoWidget() {
        String lineTooltip;
        String lineText;
        String itemAmountString;
        String itemName;
        Long itemCount;
        Object sortedMap;
        HashMap<Object, Long> nameToAmount;
        DynamicPositionedColumn processingDetails = new DynamicPositionedColumn();
        if (this.mOutputItems != null) {
            nameToAmount = new HashMap<Object, Long>();
            for (ItemStack item : this.mOutputItems) {
                if (item == null || item.field_77994_a <= 0) continue;
                nameToAmount.merge(item, Long.valueOf(item.field_77994_a), Long::sum);
            }
            sortedMap = nameToAmount.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
            Iterator iterator = sortedMap.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                itemCount = (Long)entry.getValue();
                itemName = ((ItemStack)entry.getKey()).func_82833_r();
                itemAmountString = EnumChatFormatting.WHITE + " x " + EnumChatFormatting.GOLD + GTUtility.formatShortenedLong(itemCount) + EnumChatFormatting.WHITE + this.appendRate(false, itemCount, true);
                lineText = EnumChatFormatting.AQUA + GTUtility.truncateText(itemName, 40 - itemAmountString.length()) + itemAmountString;
                lineTooltip = EnumChatFormatting.AQUA + itemName + "\n" + this.appendRate(false, itemCount, false);
                processingDetails.widget((Widget)new MultiChildWidget().addChild(new ItemDrawable(((ItemStack)entry.getKey()).func_77946_l()).asWidget().setSize(8, 8).setPos(0, 0)).addChild(new TextWidget(lineText).setTextAlignment(Alignment.CenterLeft).addTooltip(lineTooltip).setPos(10, 1)));
            }
        }
        if (this.mOutputFluids != null) {
            nameToAmount = new HashMap();
            for (FluidStack fluid : this.mOutputFluids) {
                if (fluid == null || fluid.amount <= 0) continue;
                nameToAmount.merge(fluid, Long.valueOf(fluid.amount), Long::sum);
            }
            sortedMap = nameToAmount.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
            Iterator iterator = sortedMap.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                itemCount = (Long)entry.getValue();
                itemName = ((FluidStack)entry.getKey()).getLocalizedName();
                itemAmountString = EnumChatFormatting.WHITE + " x " + EnumChatFormatting.GOLD + GTUtility.formatShortenedLong(itemCount) + "L" + EnumChatFormatting.WHITE + this.appendRate(false, itemCount, true);
                lineText = EnumChatFormatting.AQUA + GTUtility.truncateText(itemName, 40 - itemAmountString.length()) + itemAmountString;
                lineTooltip = EnumChatFormatting.AQUA + itemName + "\n" + this.appendRate(true, itemCount, false);
                processingDetails.widget((Widget)new MultiChildWidget().addChild(new FluidDrawable().setFluid(((FluidStack)entry.getKey()).getFluid()).asWidget().setSize(8, 8).setPos(0, 0)).addChild(new TextWidget(lineText).setTextAlignment(Alignment.CenterLeft).addTooltip(lineTooltip).setPos(10, 1)));
            }
        }
        return processingDetails;
    }

    protected String appendRate(boolean isLiquid, Long amount, boolean isFormatShortened) {
        StringBuffer ret = new StringBuffer();
        DecimalFormat df = new DecimalFormat("0.00");
        double progressTime = (double)this.mMaxProgresstime / 20.0;
        double perSecond = (double)amount.longValue() / progressTime;
        double perMinute = perSecond * 60.0;
        double perHour = perSecond * 3600.0;
        double perDay = perSecond * 86400.0;
        String amountText = StatCollector.func_74838_a((String)"GT5U.gui.text.amount") + " ";
        String perSecondText = StatCollector.func_74838_a((String)"GT5U.gui.text.per_second") + " ";
        String perMinuteText = StatCollector.func_74838_a((String)"GT5U.gui.text.per_minute") + " ";
        String perHourText = StatCollector.func_74838_a((String)"GT5U.gui.text.per_hour") + " ";
        String perDayText = StatCollector.func_74838_a((String)"GT5U.gui.text.per_day") + " ";
        Function<Double, Double> roundNumber = number -> {
            if (Math.abs(number) < 10.0) {
                return (double)Math.round(number * 100.0) / 100.0;
            }
            return Math.floor(number);
        };
        if (isFormatShortened) {
            ret.append(" (");
            ret.append(EnumChatFormatting.GRAY);
            ret.append(perSecond > 1.0 ? GTUtility.formatShortenedLong((long)perSecond) : df.format(perSecond));
            ret.append("/s");
            ret.append(EnumChatFormatting.WHITE);
            ret.append(")");
        } else {
            ret.append(EnumChatFormatting.RESET);
            ret.append(amountText + EnumChatFormatting.GOLD + GTUtility.formatNumbers(amount) + (isLiquid ? "L" : "") + EnumChatFormatting.RESET);
            ret.append("\n");
            ret.append(perSecondText + EnumChatFormatting.GOLD + GTUtility.formatNumbers(roundNumber.apply(perSecond)) + (isLiquid ? "L" : "") + (perSecond > 1000000.0 ? EnumChatFormatting.WHITE + " [" + EnumChatFormatting.GRAY + GTUtility.formatShortenedLong((long)perSecond) + EnumChatFormatting.WHITE + "]" : "") + EnumChatFormatting.RESET);
            ret.append("\n");
            ret.append(perMinuteText + EnumChatFormatting.GOLD + GTUtility.formatNumbers(roundNumber.apply(perMinute)) + (isLiquid ? "L" : "") + (perMinute > 1000000.0 ? EnumChatFormatting.WHITE + " [" + EnumChatFormatting.GRAY + GTUtility.formatShortenedLong((long)perMinute) + EnumChatFormatting.WHITE + "]" : "") + EnumChatFormatting.RESET);
            ret.append("\n");
            ret.append(perHourText + EnumChatFormatting.GOLD + GTUtility.formatNumbers(roundNumber.apply(perHour)) + (isLiquid ? "L" : "") + (perHour > 1000000.0 ? EnumChatFormatting.WHITE + " [" + EnumChatFormatting.GRAY + GTUtility.formatShortenedLong((long)perHour) + EnumChatFormatting.WHITE + "]" : "") + EnumChatFormatting.RESET);
            ret.append("\n");
            ret.append(perDayText + EnumChatFormatting.GOLD + GTUtility.formatNumbers(roundNumber.apply(perDay)) + (isLiquid ? "L" : "") + (perDay > 1000000.0 ? EnumChatFormatting.WHITE + " [" + EnumChatFormatting.GRAY + GTUtility.formatShortenedLong((long)perDay) + EnumChatFormatting.WHITE + "]" : "") + EnumChatFormatting.RESET);
        }
        return ret.toString();
    }

    protected String generateCurrentProgress() {
        StringBuffer ret = new StringBuffer(StatCollector.func_74838_a((String)"GT5U.gui.text.progress"));
        ret.append(" ");
        this.numberFormat.setMinimumFractionDigits(1);
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumIntegerDigits(2);
        this.numberFormat.format((double)this.mProgresstime / (double)this.mMaxProgresstime * 100.0, ret);
        this.numberFormat.setMinimumIntegerDigits(1);
        ret.append("% ");
        ret.append(EnumChatFormatting.GRAY);
        ret.append("(");
        ret.append(EnumChatFormatting.WHITE);
        this.numberFormat.setMinimumFractionDigits(this.mMaxProgresstime / 20 > 1000 ? 0 : 2);
        this.numberFormat.setMaximumFractionDigits(this.mMaxProgresstime / 20 > 1000 ? 0 : 2);
        this.numberFormat.format((double)this.mProgresstime / 20.0, ret);
        ret.append("s");
        ret.append(EnumChatFormatting.GRAY);
        ret.append("/");
        ret.append(EnumChatFormatting.WHITE);
        this.numberFormat.format((double)this.mMaxProgresstime / 20.0, ret);
        ret.append("s");
        ret.append(EnumChatFormatting.GRAY);
        ret.append(")");
        ret.append(EnumChatFormatting.RESET);
        ret.append("\n");
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        return ret.toString();
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0);
        screenElements.widget((Widget)new StructureErrorSyncer(() -> this.structureErrors, value -> {
            this.structureErrors = value;
        }));
        screenElements.widget((Widget)new FakeSyncWidget(() -> this.structureErrorContext, data -> {
            this.structureErrorContext = data;
        }, ByteBufUtils::writeTag, ByteBufUtils::readTag));
        screenElements.widgets(new Widget[]{TextWidget.dynamicString(() -> {
            ArrayList<String> lines = new ArrayList<String>();
            this.localizeStructureErrors(this.structureErrors, this.structureErrorContext, lines);
            return String.join((CharSequence)"\n", lines);
        }).setSynced(false).setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.DARK_RED).setEnabled(w -> this.hasStructureErrors())});
        if (this.supportsMachineModeSwitch()) {
            screenElements.widget((Widget)TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gt.interact.desc.mb.mode", (Object[])new Object[]{this.getMachineModeName()})).setTextAlignment(Alignment.CenterLeft));
        }
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("132", "Pipe is loose. (Wrench)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mWrench && this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("133", "Screws are loose. (Screwdriver)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mScrewdriver && this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("134", "Something is stuck. (Soft Mallet)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSoftMallet && this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftMallet, val -> {
            this.mSoftMallet = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("135", "Platings are dented. (Hammer)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mHardHammer && this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("136", "Circuitry burned out. (Soldering)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSolderingTool && this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("137", "That doesn't belong there. (Crowbar)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mCrowbar && this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.incomplete")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.too_uncertain")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> (this.getErrorDisplayID() & 0x80) != 0));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.invalid_parameters")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> (this.getErrorDisplayID() & 0x100) != 0));
        ((Column)((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.idle.1")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getErrorDisplayID, this::setErrorDisplayID))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.idle.2")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.idle.3")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.running")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> {
            Duration time = Duration.ofSeconds((this.mTotalRunTime - this.mLastWorkingTick) / 20L);
            return StatCollector.func_74837_a((String)"GT5U.gui.text.shutdown_duration", (Object[])new Object[]{time.toHours(), time.toMinutes() % 60L, time.getSeconds() % 60L});
        }).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.mTotalRunTime, time -> {
            this.mTotalRunTime = time;
        }))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.mLastWorkingTick, time -> {
            this.mLastWorkingTick = time;
        }));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && GTUtility.isStringValid(this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()) && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new ShutDownReasonSyncer(() -> this.getBaseMetaTileEntity().getLastShutDownReason(), reason -> this.getBaseMetaTileEntity().setShutDownReason((ShutDownReason)reason)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().wasShutdown(), wasShutDown -> this.getBaseMetaTileEntity().setShutdownStatus((boolean)wasShutDown)));
        ((Column)screenElements.widget(TextWidget.dynamicString(() -> this.checkRecipeResult.getDisplayString()).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayCheckRecipeResult() && GTUtility.isStringValid(this.checkRecipeResult.getDisplayString()) && (this.isAllowedToWork() || this.getBaseMetaTileEntity().isActive() || this.checkRecipeResult.persistsOnShutdown())))).widget((Widget)new CheckRecipeResultSyncer(() -> this.checkRecipeResult, result -> {
            this.checkRecipeResult = result;
        }));
        if (this.showRecipeTextInGUI()) {
            screenElements.widget(TextWidget.dynamicString(this::generateCurrentProgress).setSynced(false).setTextAlignment(new Alignment(-1, -1)).setSize(180, 12).setEnabled(widget -> this.mOutputFluids != null && this.mOutputFluids.length > 0 || this.mOutputItems != null && this.mOutputItems.length > 0 || this.mMaxProgresstime > 0));
            ChangeableWidget recipeOutputItemsWidget = new ChangeableWidget(this::generateCurrentRecipeInfoWidget);
            ((Column)((Column)((Column)screenElements.widget((Widget)new FakeSyncWidget.ListSyncer(() -> this.mOutputFluids != null ? Arrays.stream(this.mOutputFluids).map(fluidStack -> {
                if (fluidStack == null) {
                    return null;
                }
                return new FluidStack((FluidStack)fluidStack, fluidStack.amount){

                    public boolean isFluidEqual(FluidStack other) {
                        return super.isFluidEqual(other) && this.amount == other.amount;
                    }
                };
            }).collect(Collectors.toList()) : Collections.emptyList(), val -> {
                this.mOutputFluids = val.toArray(new FluidStack[0]);
                recipeOutputItemsWidget.notifyChangeNoSync();
            }, NetworkUtils::writeFluidStack, NetworkUtils::readFluidStack))).widget((Widget)new FakeSyncWidget.ListSyncer(() -> this.mOutputItems != null ? Arrays.asList(this.mOutputItems) : Collections.emptyList(), val -> {
                this.mOutputItems = val.toArray(new ItemStack[0]);
                recipeOutputItemsWidget.notifyChangeNoSync();
            }, NetworkUtils::writeItemStack, NetworkUtils::readItemStack))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mProgresstime, val -> {
                this.mProgresstime = val;
            }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mMaxProgresstime, val -> {
                this.mMaxProgresstime = val;
                recipeOutputItemsWidget.notifyChangeNoSync();
            }));
            screenElements.widget((Widget)recipeOutputItemsWidget);
        }
        screenElements.widget(new TextWidget(GTUtility.trans("144", "Missing Turbine Rotor")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> {
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                return false;
            }
            if (this.getErrorDisplayID() == 0 && this instanceof MTELargeTurbine) {
                ItemStack tItem = inventorySlot.getMcSlot().func_75211_c();
                return tItem == null || tItem.func_77973_b() != MetaGeneratedTool01.INSTANCE || tItem.func_77960_j() < 170 || tItem.func_77960_j() > 177;
            }
            return false;
        }));
    }

    public boolean showRecipeTextInGUI() {
        return true;
    }

    @TestOnly
    protected void setEnergyHatches(ArrayList<MTEHatchEnergy> EnergyHatches) {
        this.mEnergyHatches = EnergyHatches;
    }

    @TestOnly
    protected void setExoticEnergyHatches(List<MTEHatch> ExoticEnergyHatches) {
        this.mExoticEnergyHatches = ExoticEnergyHatches;
    }

    public void fixAllIssues() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftMallet = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    @Override
    public final ModularPanel buildUI(PosGuiData guiData, PanelSyncManager syncManager, UISettings uiSettings) {
        return this.getGui().build(guiData, syncManager, uiSettings);
    }

    @NotNull
    protected MTEMultiBlockBaseGui getGui() {
        return new MTEMultiBlockBaseGui(this);
    }

    public boolean getDefaultHasMaintenanceChecks() {
        return true;
    }

    protected boolean requiresMuffler() {
        return this.getPollutionPerSecond(null) > 0;
    }

    public boolean shouldCheckMaintenance() {
        return !disableMaintenance && this.hasMaintenanceChecks;
    }

    public void setMaxParallelForPanel(int parallel) {
        this.maxParallel = parallel;
    }

    @Nonnull
    public CheckRecipeResult getCheckRecipeResult() {
        return this.checkRecipeResult;
    }

    public void setCheckRecipeResult(@Nonnull CheckRecipeResult checkRecipeResult) {
        this.checkRecipeResult = checkRecipeResult;
    }

    public int getRuntime() {
        return this.mRuntime;
    }

    public int getMaxProgresstime() {
        return this.mMaxProgresstime;
    }

    public long getTotalRunTime() {
        return this.mTotalRunTime;
    }

    public void setTotalRunTime(long mTotalRunTime) {
        this.mTotalRunTime = mTotalRunTime;
    }

    public long getLastWorkingTick() {
        return this.mLastWorkingTick;
    }

    public void setLastWorkingTick(long mLastWorkingTick) {
        this.mLastWorkingTick = mLastWorkingTick;
    }

    public EnumSet<StructureError> getStructureErrors() {
        return this.structureErrors;
    }

    public void setStructureErrors(EnumSet<StructureError> structureErrors) {
        this.structureErrors = structureErrors;
    }

    public int getPowerPanelMaxParallel() {
        return this.powerPanelMaxParallel;
    }

    public void setPowerPanelMaxParallel(int powerPanelMaxParallel) {
        this.powerPanelMaxParallel = powerPanelMaxParallel;
    }

    public boolean isAlwaysMaxParallel() {
        return this.alwaysMaxParallel;
    }

    public void setAlwaysMaxParallel(boolean alwaysMaxParallel) {
        this.alwaysMaxParallel = alwaysMaxParallel;
    }
}

