/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.items.GGMaterial;
import goodgenerator.loader.Loaders;
import goodgenerator.main.GGConfigLoader;
import goodgenerator.util.CrackRecipeAdder;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.xmod.thermalfoundation.fluid.TFFluids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class MTEMultiNqGenerator
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    protected IStructureDefinition<MTEMultiNqGenerator> multiDefinition = null;
    protected long trueOutput = 0L;
    protected int trueEff = 0;
    protected FluidStack lockedFluid = null;
    protected int times = 1;
    protected int basicOutput;
    private static final List<Pair<FluidStack, Integer>> excitedLiquid = Arrays.asList(Pair.of((Object)MaterialsUEVplus.Space.getMolten(20L), (Object)GGConfigLoader.ExcitedLiquidCoe[0]), Pair.of((Object)GGMaterial.atomicSeparationCatalyst.getMolten(20), (Object)GGConfigLoader.ExcitedLiquidCoe[1]), Pair.of((Object)Materials.Naquadah.getMolten(20L), (Object)GGConfigLoader.ExcitedLiquidCoe[2]), Pair.of((Object)Materials.Uranium235.getMolten(180L), (Object)GGConfigLoader.ExcitedLiquidCoe[3]), Pair.of((Object)Materials.Caesium.getMolten(180L), (Object)GGConfigLoader.ExcitedLiquidCoe[4]));
    private static final List<Pair<FluidStack, Integer>> coolant = Arrays.asList(Pair.of((Object)MaterialsUEVplus.Time.getMolten(20L), (Object)GGConfigLoader.CoolantEfficiency[0]), Pair.of((Object)new FluidStack(TFFluids.fluidCryotheum, 1000), (Object)GGConfigLoader.CoolantEfficiency[1]), Pair.of((Object)Materials.SuperCoolant.getFluid(1000L), (Object)GGConfigLoader.CoolantEfficiency[2]), Pair.of((Object)GTModHandler.getIC2Coolant(1000L), (Object)GGConfigLoader.CoolantEfficiency[3]));

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 3, 7, 0, itemStack, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("MultiNqGenerator.hint", 8);
    }

    public IStructureDefinition<MTEMultiNqGenerator> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"AAAAAAA", "A     A", "A CCC A", "A CPC A", "A CCC A", "A     A", "AAAAAAA"}, {"ANNNNNA", "N     N", "N CCC N", "N CPC N", "N CCC N", "N     N", "ANNNNNA"}, {"XXX~XXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX"}})).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEMultiNqGenerator.class).atLeast(TTMultiblockBase.HatchElement.DynamoMulti.or(HatchElement.Dynamo), TTMultiblockBase.HatchElement.EnergyMulti.or(HatchElement.Energy), HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance).casingIndex(44).dot(1).build(), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)12)})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)12)).addElement('N', StructureUtility.ofBlock((Block)Loaders.radiationProtectionSteelFrame, (int)0)).addElement('C', StructureUtility.ofBlock((Block)Loaders.MAR_Casing, (int)0)).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).build();
        }
        return this.multiDefinition;
    }

    public MTEMultiNqGenerator(String name) {
        super(name);
    }

    public MTEMultiNqGenerator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.times = aNBT.func_74762_e("mTimes");
        this.basicOutput = aNBT.func_74762_e("mbasicOutput");
        this.lockedFluid = FluidRegistry.getFluid((String)aNBT.func_74779_i("mLockedFluidName")) != null ? new FluidStack(FluidRegistry.getFluid((String)aNBT.func_74779_i("mLockedFluidName")), aNBT.func_74762_e("mLockedFluidAmount")) : null;
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mTimes", this.times);
        aNBT.func_74768_a("mbasicOutput", this.basicOutput);
        if (this.lockedFluid != null) {
            aNBT.func_74778_a("mLockedFluidName", this.lockedFluid.getFluid().getName());
            aNBT.func_74768_a("mLockedFluidAmount", this.lockedFluid.amount);
        }
        super.saveNBTData(aNBT);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.naquadahReactorFuels;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        block0: for (int i = 0; i < tFluids.size() - 1; ++i) {
            for (int j = i + 1; j < tFluids.size(); ++j) {
                if (!GTUtility.areFluidsEqual(tFluids.get(i), tFluids.get(j))) continue;
                if (tFluids.get((int)i).amount >= tFluids.get((int)j).amount) {
                    tFluids.remove(j--);
                    continue;
                }
                tFluids.remove(i--);
                continue block0;
            }
        }
        GTRecipe tRecipe = GoodGeneratorRecipeMaps.naquadahReactorFuels.findRecipeQuery().fluids(tFluids.toArray(new FluidStack[0])).find();
        if (tRecipe != null) {
            int pall;
            Pair<FluidStack, Integer> excitedInfo = this.getExcited(tFluids.toArray(new FluidStack[0]), false);
            int n = pall = excitedInfo == null ? 1 : (Integer)excitedInfo.getValue();
            if (this.consumeFuel(CrackRecipeAdder.copyFluidWithAmount(tRecipe.mFluidInputs[0], pall), tFluids.toArray(new FluidStack[0]))) {
                this.mOutputFluids = new FluidStack[]{CrackRecipeAdder.copyFluidWithAmount(tRecipe.mFluidOutputs[0], pall)};
                this.basicOutput = tRecipe.mSpecialValue;
                this.times = pall;
                this.lockedFluid = excitedInfo == null ? null : (FluidStack)excitedInfo.getKey();
                this.mMaxProgresstime = tRecipe.mDuration;
                return CheckRecipeResultRegistry.GENERATING;
            }
        }
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    @Override
    public boolean onRunningTick(ItemStack stack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mMaxProgresstime != 0 && this.mProgresstime % 20 == 0) {
                this.startRecipeProcessing();
                FluidStack[] input = this.getStoredFluids().toArray(new FluidStack[0]);
                int time = 1;
                if (GGConfigLoader.LiquidAirConsumptionPerSecond != 0 && !this.consumeFuel(Materials.LiquidAir.getFluid(GGConfigLoader.LiquidAirConsumptionPerSecond), input)) {
                    this.mEUt = 0;
                    this.trueEff = 0;
                    this.trueOutput = 0L;
                    this.endRecipeProcessing();
                    return true;
                }
                int eff = this.consumeCoolant(input);
                if (this.consumeFuel(this.lockedFluid, input)) {
                    time = this.times;
                }
                this.mEUt = this.basicOutput * eff * time / 100;
                this.trueEff = eff;
                this.trueOutput = (long)this.basicOutput * (long)eff * (long)time / 100L;
                this.endRecipeProcessing();
            }
            this.addAutoEnergy(this.trueOutput);
        }
        return true;
    }

    @Override
    public String[] getInfoData() {
        String[] info = super.getInfoData();
        info[4] = StatCollector.func_74837_a((String)"gg.scanner.info.generator.generates", (Object[])new Object[]{EnumChatFormatting.RED + GTUtility.formatNumbers(Math.abs(this.trueOutput)) + EnumChatFormatting.RESET});
        info[6] = StatCollector.func_74838_a((String)"gg.scanner.info.generator.problems") + " " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"gg.scanner.info.generator.efficiency") + " " + EnumChatFormatting.YELLOW + this.trueEff + EnumChatFormatting.RESET + " %";
        return info;
    }

    public boolean consumeFuel(FluidStack target, FluidStack[] input) {
        if (target == null) {
            return false;
        }
        for (FluidStack inFluid : input) {
            if (inFluid == null || !inFluid.isFluidEqual(target) || inFluid.amount < target.amount) continue;
            inFluid.amount -= target.amount;
            return true;
        }
        return false;
    }

    public Pair<FluidStack, Integer> getExcited(FluidStack[] input, boolean isConsume) {
        for (Pair<FluidStack, Integer> fluidPair : excitedLiquid) {
            FluidStack tFluid = (FluidStack)fluidPair.getKey();
            for (FluidStack inFluid : input) {
                if (inFluid == null || !inFluid.isFluidEqual(tFluid) || inFluid.amount < tFluid.amount) continue;
                if (isConsume) {
                    inFluid.amount -= tFluid.amount;
                }
                return fluidPair;
            }
        }
        return null;
    }

    private int consumeCoolant(FluidStack[] input) {
        for (Pair<FluidStack, Integer> fluidPair : coolant) {
            FluidStack tFluid = (FluidStack)fluidPair.getKey();
            for (FluidStack inFluid : input) {
                if (inFluid == null || !inFluid.isFluidEqual(tFluid) || inFluid.amount < tFluid.amount) continue;
                inFluid.amount -= tFluid.amount;
                return (Integer)fluidPair.getValue();
            }
        }
        return 100;
    }

    public void addAutoEnergy(long outputPower) {
        MTEHatch tHatch;
        if (!this.eDynamoMulti.isEmpty()) {
            tHatch = (MTEHatchDynamoMulti)this.eDynamoMulti.get(0);
            if (((MTEHatchDynamoMulti)tHatch).maxEUOutput() * ((MTEHatchDynamoMulti)tHatch).maxAmperesOut() >= outputPower) {
                tHatch.setEUVar(Math.min(((MTEHatchDynamoMulti)tHatch).maxEUStore(), tHatch.getBaseMetaTileEntity().getStoredEU() + outputPower));
            } else {
                this.stopMachine(ShutDownReasonRegistry.INSUFFICIENT_DYNAMO);
            }
        }
        if (!this.mDynamoHatches.isEmpty()) {
            tHatch = (MTEHatchDynamo)this.mDynamoHatches.get(0);
            if (((MTEHatchDynamo)tHatch).maxEUOutput() * tHatch.maxAmperesOut() >= outputPower) {
                tHatch.setEUVar(Math.min(((MTEHatchDynamo)tHatch).maxEUStore(), tHatch.getBaseMetaTileEntity().getStoredEU() + outputPower));
            } else {
                this.stopMachine(ShutDownReasonRegistry.INSUFFICIENT_DYNAMO);
            }
        }
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(this.mName, 3, 7, 0) && this.mMaintenanceHatches.size() == 1 && this.mDynamoHatches.size() + this.eDynamoMulti.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiNqGenerator(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Naquadah Reactor, LNR").addInfo("Environmentally Friendly!").addInfo("Generate power from high-energy liquids").addInfo(String.format("Consumes %s%d L/s Liquid Air%s to keep running, otherwise" + EnumChatFormatting.YELLOW + " it will void your fuel" + EnumChatFormatting.GRAY + ".", EnumChatFormatting.AQUA, GGConfigLoader.LiquidAirConsumptionPerSecond, EnumChatFormatting.GRAY)).addInfo("The reactor will explode when there is more than" + EnumChatFormatting.RED + " ONE" + EnumChatFormatting.GRAY + " type of fuel in hatches!").addInfo("Input liquid nuclear fuel or liquid naquadah fuel").addSeparator().addInfo("Can increase " + EnumChatFormatting.LIGHT_PURPLE + "efficiency " + EnumChatFormatting.GRAY + "by " + EnumChatFormatting.WHITE + "consuming " + EnumChatFormatting.BLUE + "coolants:").addInfo(this.getCoolantTextFormatted("IC2 Coolant", "1000", GGConfigLoader.CoolantEfficiency[3])).addInfo(this.getCoolantTextFormatted("Super Coolant", "1000", GGConfigLoader.CoolantEfficiency[2])).addInfo(this.getCoolantTextFormatted("Cryotheum", "1000", GGConfigLoader.CoolantEfficiency[1])).addInfo(this.getCoolantTextFormatted("Tachyon Rich Temporal Fluid", "20", GGConfigLoader.CoolantEfficiency[0])).addSeparator().addInfo("Can increase " + EnumChatFormatting.LIGHT_PURPLE + "output power and fuel usage " + EnumChatFormatting.GRAY + "by " + EnumChatFormatting.WHITE + "consuming " + EnumChatFormatting.RED + "excited liquid:").addInfo(this.getExcitedTextFormatted("Molten Caesium", "180", GGConfigLoader.ExcitedLiquidCoe[4])).addInfo(this.getExcitedTextFormatted("Molten Uranium-235", "180", GGConfigLoader.ExcitedLiquidCoe[3])).addInfo(this.getExcitedTextFormatted("Molten Naquadah", "20", GGConfigLoader.ExcitedLiquidCoe[2])).addInfo(this.getExcitedTextFormatted("Molten Atomic Separation Catalyst", "20", GGConfigLoader.ExcitedLiquidCoe[1])).addInfo(this.getExcitedTextFormatted("Spatially Enlarged Fluid", "20", GGConfigLoader.ExcitedLiquidCoe[0])).addTecTechHatchInfo().beginStructureBlock(7, 8, 7, true).addController("Front bottom").addCasingInfoExactly("Field Restriction Casing", 48, false).addCasingInfoExactly("Radiation Proof Steel Frame Box", 36, false).addCasingInfoExactly("Tungstensteel Pipe Casing", 6, false).addCasingInfoExactly("Radiation Proof Machine Casing", 121, false).addDynamoHatch("Any bottom layer casing, only accept ONE!").addInputHatch("Any bottom layer casing").addOutputHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(44), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(44), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(44)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 3, 7, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }

    public String getCoolantTextFormatted(String fluidType, String litersConsumed, int effBoost) {
        return String.format("%s%s L/s%s : %s%d%% %s: %s%s", EnumChatFormatting.WHITE, litersConsumed, EnumChatFormatting.GRAY, EnumChatFormatting.LIGHT_PURPLE, effBoost, EnumChatFormatting.GRAY, EnumChatFormatting.BLUE, fluidType);
    }

    public String getExcitedTextFormatted(String fluidType, String litersConsumed, int multiplier) {
        return String.format("%s%s L/s %s: %s%dx power %s: %s%s", EnumChatFormatting.WHITE, litersConsumed, EnumChatFormatting.GRAY, EnumChatFormatting.LIGHT_PURPLE, multiplier, EnumChatFormatting.GRAY, EnumChatFormatting.RED, fluidType);
    }
}

