/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.single;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.mixin.interfaces.accessors.EntityPlayerMPAccessor;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import tectech.loader.NetworkDispatcher;
import tectech.mechanics.spark.RendererMessage;
import tectech.mechanics.spark.ThaumSpark;
import tectech.mechanics.tesla.ITeslaConnectable;
import tectech.mechanics.tesla.ITeslaConnectableSimple;
import tectech.thing.metaTileEntity.Textures;
import tectech.util.CommonValues;

public class MTETeslaCoil
extends MTEBasicBatteryBuffer
implements ITeslaConnectable {
    private final Multimap<Integer, ITeslaConnectableSimple> teslaNodeMap = MultimapBuilder.treeKeys().linkedListValues().build();
    private final HashSet<ThaumSpark> sparkList = new HashSet();
    private int sparkCount = 20;
    private static final int transferRadiusMax = 20;
    private static final int transferRadiusMin = 4;
    private int transferRadius = 20;
    public boolean powerPassToggle = false;
    private static final int histSteps = 20;
    private int histSettingLow = 3;
    private int histSettingHigh = 15;
    private static final int histLowLimit = 1;
    private static final int histHighLimit = 19;
    private float histLow = (float)this.histSettingLow / 20.0f;
    private float histHigh = (float)this.histSettingHigh / 20.0f;
    private final long outputVoltage = GTValues.V[this.mTier];
    private boolean overdriveToggle = false;
    private String clientLocale = "en_US";

    public MTETeslaCoil(int aID, String aName, String aNameRegional, int aTier, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, "", aSlotCount);
    }

    public MTETeslaCoil(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    @Override
    public String[] getDescription() {
        Object[] jargon = new String[]{CommonValues.THETA_MOVEMENT, StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.tesla.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.tesla.desc.1")};
        Object[] sDesc = super.getDescription();
        sDesc = Arrays.copyOfRange(sDesc, 1, sDesc.length);
        return (String[])ArrayUtils.addAll((Object[])jargon, (Object[])sDesc);
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.overdriveToggle) {
            this.overdriveToggle = false;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)StatCollector.func_74837_a((String)"tt.keyphrase.Overdrive_disengaged", (Object[])new Object[]{this.clientLocale}));
        } else {
            this.overdriveToggle = true;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)StatCollector.func_74837_a((String)"tt.keyphrase.Overdrive_engaged", (Object[])new Object[]{this.clientLocale}));
        }
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            this.histSettingHigh = this.histSettingHigh < 19 ? ++this.histSettingHigh : this.histSettingLow + 1;
            this.histHigh = (float)this.histSettingHigh / 20.0f;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)(StatCollector.func_74837_a((String)"tt.keyphrase.Hysteresis_high_set_to", (Object[])new Object[]{this.clientLocale}) + " " + Math.round(this.histHigh * 100.0f) + "%"));
        } else {
            this.histSettingLow = this.histSettingLow > 1 ? --this.histSettingLow : this.histSettingHigh - 1;
            this.histLow = (float)this.histSettingLow / 20.0f;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)(StatCollector.func_74837_a((String)"tt.keyphrase.Hysteresis_low_set_to", (Object[])new Object[]{this.clientLocale}) + " " + Math.round(this.histLow * 100.0f) + "%"));
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            if (this.transferRadius > 4) {
                --this.transferRadius;
            }
        } else if (this.transferRadius < 20) {
            ++this.transferRadius;
        }
        PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)(StatCollector.func_74837_a((String)"tt.keyphrase.Tesla_radius_set_to", (Object[])new Object[]{this.clientLocale}) + " " + this.transferRadius + "m"));
        return false;
    }

    @Override
    public boolean hasAlternativeModeText() {
        return true;
    }

    @Override
    public String getAlternativeModeText() {
        long energyMax = this.getStoredEnergy()[1];
        long energyStored = this.getStoredEnergy()[0];
        float energyFrac = (float)energyStored / (float)energyMax;
        this.powerPassToggle = energyFrac > this.histHigh ? true : (energyFrac < this.histLow ? false : !this.powerPassToggle);
        return this.powerPassToggle ? StatCollector.func_74837_a((String)"tt.keyphrase.Sending_power", (Object[])new Object[]{this.clientLocale}) + "!" : StatCollector.func_74837_a((String)"tt.keyphrase.Receiving_power", (Object[])new Object[]{this.clientLocale}) + "!";
    }

    @Override
    public boolean isFacingValid(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[3][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][i + 1]};
            rTextures[1][i + 1] = new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][i + 1], Textures.TESLA_TRANSCEIVER_TOP_BA};
            rTextures[2][i + 1] = new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][i + 1], this.mInventory.length == 16 ? Textures.OVERLAYS_ENERGY_OUT_POWER_TT[this.mTier] : (this.mInventory.length > 4 ? Textures.OVERLAYS_ENERGY_OUT_MULTI_TT[this.mTier] : Textures.OVERLAYS_ENERGY_OUT_TT[this.mTier])};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[side == facing ? 2 : (side == ForgeDirection.UP ? 1 : 0)][colorIndex + 1];
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETeslaCoil(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (!aBaseMetaTileEntity.isClientSide()) {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetAdd(this);
            ITeslaConnectable.TeslaUtil.generateTeslaNodeMap(this);
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getBaseMetaTileEntity().isClientSide()) {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(this);
        }
    }

    @Override
    public void onUnload() {
        if (!this.getBaseMetaTileEntity().isClientSide()) {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(this);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetAdd(this);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide()) {
            return;
        }
        long energyMax = this.getStoredEnergy()[1];
        long energyStored = this.getStoredEnergy()[0];
        float energyFrac = (float)energyStored / (float)energyMax;
        if (!this.powerPassToggle && energyFrac > this.histHigh) {
            this.powerPassToggle = true;
        } else if (this.powerPassToggle && energyFrac < this.histLow) {
            this.powerPassToggle = false;
        }
        ITeslaConnectable.TeslaUtil.powerTeslaNodeMap(this);
        --this.sparkCount;
        if (this.sparkCount == 0) {
            this.sparkCount = 20;
            if (!this.sparkList.isEmpty()) {
                NetworkDispatcher.INSTANCE.sendToAllAround(new RendererMessage.RendererData(this.sparkList), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), 256.0);
                this.sparkList.clear();
            }
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aPlayer instanceof EntityPlayerMPAccessor) {
                this.clientLocale = ((EntityPlayerMPAccessor)aPlayer).gt5u$getTranslator();
            }
            this.openGui(aPlayer);
        }
        return true;
    }

    @Override
    public byte getTeslaReceptionCapability() {
        return 1;
    }

    @Override
    public float getTeslaReceptionCoefficient() {
        return 1.0f;
    }

    @Override
    public Multimap<Integer, ITeslaConnectableSimple> getTeslaNodeMap() {
        return this.teslaNodeMap;
    }

    @Override
    public HashSet<ThaumSpark> getSparkList() {
        return this.sparkList;
    }

    @Override
    public byte getTeslaTransmissionCapability() {
        return 2;
    }

    @Override
    public int getTeslaTransmissionRange() {
        return this.transferRadius;
    }

    @Override
    public boolean isOverdriveEnabled() {
        return this.overdriveToggle;
    }

    @Override
    public int getTeslaEnergyLossPerBlock() {
        return 1;
    }

    @Override
    public float getTeslaOverdriveLossCoefficient() {
        return 0.25f;
    }

    @Override
    public long getTeslaOutputVoltage() {
        return this.outputVoltage;
    }

    @Override
    public long getTeslaOutputCurrent() {
        return this.mBatteryCount;
    }

    @Override
    public boolean teslaDrainEnergy(long teslaVoltageDrained) {
        if (this.getEUVar() < teslaVoltageDrained) {
            return false;
        }
        this.setEUVar(this.getEUVar() - teslaVoltageDrained);
        return true;
    }

    @Override
    public boolean isTeslaReadyToReceive() {
        return !this.powerPassToggle;
    }

    @Override
    public long getTeslaStoredEnergy() {
        return this.getEUVar();
    }

    @Override
    public Vec3Impl getTeslaPosition() {
        return new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    @Override
    public Integer getTeslaDimension() {
        return this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
    }

    @Override
    public boolean teslaInjectEnergy(long teslaVoltageInjected) {
        return this.getBaseMetaTileEntity().injectEnergyUnits(ForgeDirection.UP, teslaVoltageInjected, 1L) > 0L;
    }
}

