/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import gregtech.common.misc.WirelessNetworkManager;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.Textures;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;

public class MTEHatchWirelessDynamoMulti
extends MTEHatchDynamoMulti {
    private UUID owner_uuid;

    public MTEHatchWirelessDynamoMulti(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{AnimatedTooltipHandler.GRAY + "Stores energy globally in a network, up to 2^(2^31) EU.", AnimatedTooltipHandler.GRAY + "Does not connect to wires. This block accepts EU into the network.", GTValues.AuthorColen + AnimatedTooltipHandler.GRAY + AnimatedTooltipHandler.BOLD + " & " + AnimatedTooltipHandler.GREEN + AnimatedTooltipHandler.BOLD + "Chrom", StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.1") + ": " + AnimatedTooltipHandler.YELLOW + GTUtility.formatNumbers((long)aAmp * GTValues.V[aTier]) + AnimatedTooltipHandler.GRAY + " EU/t"}, aAmp);
    }

    public MTEHatchWirelessDynamoMulti(String aName, int aTier, int aAmp, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmp, aDescription, aTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.Amperes != this.maxAmperes) {
            aNBT.func_74768_a("amperes", this.Amperes);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        int savedAmperes = aNBT.func_74762_e("amperes");
        if (savedAmperes != 0) {
            this.Amperes = savedAmperes;
        }
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_IN_WIRELESS_LASER[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_IN_WIRELESS_LASER[this.mTier]};
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return (long)this.Amperes * GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return Long.MAX_VALUE;
    }

    @Override
    public MTEHatch.ConnectionType getConnectionType() {
        return MTEHatch.ConnectionType.WIRELESS;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessDynamoMulti(this.mName, this.mTier, this.Amperes, new String[]{""}, this.mTextures);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aTick == 1L) {
                this.owner_uuid = aBaseMetaTileEntity.getOwnerUuid();
                WirelessNetworkManager.strongCheckOrAddUser(this.owner_uuid);
            }
            if (aTick % WirelessNetworkManager.ticks_between_energy_addition == 0L) {
                WirelessNetworkManager.addEUToGlobalEnergyMap(this.owner_uuid, this.getEUVar());
                this.setEUVar(0L);
            }
        }
    }
}

