/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.Textures;
import tectech.util.CommonValues;

public class MTEHatchEnergyMulti
extends MTEHatch {
    public final int maxAmperes;
    public int Amperes;

    public MTEHatchEnergyMulti(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energymulti.desc.0"), StatCollector.func_74837_a((String)"gt.blockmachines.hatch.energymulti.desc.2", (Object[])new Object[]{aAmp + (aAmp >> 2)}), StatCollector.func_74837_a((String)"gt.blockmachines.hatch.energymulti.desc.3", (Object[])new Object[]{aAmp})}, new ITexture[0]);
        this.Amperes = this.maxAmperes = aAmp;
    }

    public MTEHatchEnergyMulti(String aName, int aTier, int aAmp, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        this.Amperes = this.maxAmperes = aAmp;
    }

    public MTEHatchEnergyMulti(int aID, String aName, String aNameRegional, int aTier, int i, String[] description, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, description, new ITexture[0]);
        this.Amperes = this.maxAmperes = aAmp;
    }

    public int getHatchType() {
        return 1;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier]};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 128L * (long)this.Amperes;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier] * 4L * (long)this.Amperes;
    }

    @Override
    public long maxAmperesIn() {
        return this.Amperes + (this.Amperes >> 2);
    }

    @Override
    public long maxWorkingAmperesIn() {
        return this.Amperes;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("amperage", (long)this.Amperes);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.1") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(accessor.getNBTData().func_74763_f("amperage") * GTValues.V[this.mTier]) + EnumChatFormatting.RESET + " EU/t");
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.1") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.Amperes * GTValues.V[this.mTier]) + EnumChatFormatting.RESET + " EU/t"};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchEnergyMulti(this.mName, this.mTier, this.Amperes, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }
}

