/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.Arrays;
import java.util.List;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.loaders.BlockLoader;
import kubatech.loaders.DEFCRecipes;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTEDEFusionCrafter
extends KubaTechGTMultiBlockBase<MTEDEFusionCrafter>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 191;
    private int mTierCasing = 0;
    private int mFusionTierCasing = 0;
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final List<Pair<Block, Integer>> fusionCasingTiers = Arrays.asList(Pair.of((Object)GregTechAPI.sBlockCasings4, (Object)6), Pair.of((Object)GregTechAPI.sBlockCasings4, (Object)8));
    private static final List<Pair<Block, Integer>> coreTiers = Arrays.asList(Pair.of((Object)BlockLoader.defcCasingBlock, (Object)8), Pair.of((Object)BlockLoader.defcCasingBlock, (Object)9), Pair.of((Object)BlockLoader.defcCasingBlock, (Object)10), Pair.of((Object)BlockLoader.defcCasingBlock, (Object)11), Pair.of((Object)BlockLoader.defcCasingBlock, (Object)12));
    private static final IStructureDefinition<MTEDEFusionCrafter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"nnnnn", "nnnnn", "nnnnn", "nnnnn", "nnnnn"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"RRRRR", "R F R", "RFfFR", "R F R", "RRRRR"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"RRRRR", "R F R", "RFfFR", "R F R", "RRRRR"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"NN~NN", "NNNNN", "NNNNN", "NNNNN", "NNNNN"}})).addElement('N', GTStructureUtility.buildHatchAdder(MTEDEFusionCrafter.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy, HatchElement.Maintenance).casingIndex(191).dot(1).buildAndChain(StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)BlockLoader.defcCasingBlock, (int)7)))).addElement('n', StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)BlockLoader.defcCasingBlock, (int)7))).addElement('f', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)7)).addElement('F', StructureUtility.ofBlocksTiered((b, m) -> {
        if (b != GregTechAPI.sBlockCasings4 || m != 6 && m != 8) {
            return null;
        }
        return m == 6 ? 1 : 2;
    }, fusionCasingTiers, (Object)-1, (e, i) -> {
        e.mFusionTierCasing = i;
    }, e -> e.mFusionTierCasing)).addElement('R', StructureUtility.ofBlocksTiered((b, m) -> {
        if (b != BlockLoader.defcCasingBlock || m < 8 || m > 12) {
            return null;
        }
        return m - 7;
    }, coreTiers, (Object)-1, (e, i) -> {
        e.mTierCasing = i;
    }, e -> e.mTierCasing)).build();

    public MTEDEFusionCrafter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEDEFusionCrafter(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDEFusionCrafter(this.mName);
    }

    @Override
    public IStructureDefinition<MTEDEFusionCrafter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mTierCasing = -1;
        this.mFusionTierCasing = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 9, 0)) {
            return false;
        }
        if (this.mCasing < 19) {
            return false;
        }
        if (this.mTierCasing > 3 && this.mFusionTierCasing < 2) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fusion Crafter, DEFC").addInfo("Gains One perfect overclock per casing tier above recipe").addInfo("Normal EU OC still applies !").beginStructureBlock(5, 10, 5, false).addController("Front bottom center").addCasingInfoMin("Naquadah Alloy Fusion Casing", 19, false).addOtherStructurePart("Fusion Coil Block", "Center pillar").addOtherStructurePart("Fusion Machine Casing", "Touching Fusion Coil Block at every side").addOtherStructurePart("Tiered Fusion Casing", "Rings (5x5 hollow) at layer 4 and 7").addStructureInfo("Bloody Ichorium for tier 1, Draconium for tier 2, etc").addStructureInfo("To use tier 3 + you have to use fusion casing MK II").addInputBus("Any bottom casing", 1).addInputHatch("Any bottom casing", 1).addOutputBus("Any bottom casing", 1).addOutputHatch("Any bottom casing", 1).addEnergyHatch("Any bottom casing", 1).addMaintenanceHatch("Any bottom casing", 1).toolTipFinisher(GTValues.AuthorKuba, "Prometheus0000");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TELEPORTER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TELEPORTER_GLOW).extFacing().glow().build()};
        }
        if (aActive) {
            return new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).extFacing().glow().build()};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return DEFCRecipes.fusionCraftingRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                int recipetier = recipe.getMetadataOrDefault(GTRecipeConstants.DEFC_CASING_TIER, 1);
                return recipetier <= MTEDEFusionCrafter.this.mTierCasing ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientMachineTier(recipetier);
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                int recipetier = recipe.getMetadataOrDefault(GTRecipeConstants.DEFC_CASING_TIER, 1);
                return super.createOverclockCalculator(recipe).setMachineHeat(MTEDEFusionCrafter.this.mTierCasing > recipetier ? 1800 * (MTEDEFusionCrafter.this.mTierCasing - recipetier) : 1).setRecipeHeat(0).setHeatOC(true).setHeatDiscount(false);
            }
        };
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 9, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 9, 0, elementBudget, env, true, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }
}

