/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity;

import codechicken.nei.NEIClientUtils;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.util.StringUtils;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import kubatech.api.Variables;
import kubatech.api.enums.ItemList;
import kubatech.api.tea.TeaNetwork;
import kubatech.loaders.ItemLoader;
import kubatech.loaders.block.kubablock.KubaBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class TeaAcceptorTile
extends TileEntity
implements IInventory,
ITileWithModularUI,
KubaBlock.IModularUIProvider {
    private UUID tileOwner = null;
    private TeaNetwork teaNetwork = null;
    private long averageInput = 0L;
    private long inAmount = 0L;
    private int ticker = 0;
    private static final int minDamage = ItemList.BlackTea.get(1L, new Object[0]).func_77960_j();
    private static final int maxDamage = ItemList.YellowTea.get(1L, new Object[0]).func_77960_j();
    private static final UIInfo<?, ?> UI = KubaBlock.TileEntityUIFactory.apply(ModularUIContainer::new);
    private static final BiFunction<TextWidget, Integer, Widget.PosProvider> posCenteredHorizontallyProvider = (widget, y) -> (screenSize, window, parent) -> new Pos2d(window.getSize().width / 2 - widget.getSize().width / 2, y.intValue());

    public void setTeaOwner(UUID teaOwner) {
        if (this.tileOwner == null) {
            this.tileOwner = teaOwner;
            this.teaNetwork = TeaNetwork.getNetwork(this.tileOwner);
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound NBTData) {
        super.func_145839_a(NBTData);
        try {
            this.tileOwner = UUID.fromString(NBTData.func_74779_i("tileOwner"));
            this.teaNetwork = TeaNetwork.getNetwork(this.tileOwner);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_145841_b(NBTTagCompound NBTData) {
        super.func_145841_b(NBTData);
        NBTData.func_74778_a("tileOwner", this.tileOwner.toString());
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (++this.ticker % 100 == 0) {
            this.averageInput = this.inAmount / 100L;
            this.inAmount = 0L;
        }
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        if (this.teaNetwork != null) {
            this.inAmount += (long)p_70299_2_.field_77994_a;
            this.teaNetwork.addTea(p_70299_2_.field_77994_a);
        }
    }

    public String func_145825_b() {
        return "Tea acceptor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return p_70300_1_.getPersistentID().equals(this.tileOwner);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        if (this.teaNetwork == null) {
            return false;
        }
        if (!this.teaNetwork.canAdd(p_94041_2_.field_77994_a)) {
            return false;
        }
        return p_94041_2_.func_77973_b() == ItemLoader.kubaitems && p_94041_2_.func_77960_j() >= minDamage && p_94041_2_.func_77960_j() <= maxDamage;
    }

    @Override
    public UIInfo<?, ?> getUI() {
        return UI;
    }

    private static TextWidget posCenteredHorizontally(int y, TextWidget textWidget) {
        return (TextWidget)textWidget.setPosProvider(posCenteredHorizontallyProvider.apply(textWidget, y));
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        ModularWindow.Builder builder = ModularWindow.builder((int)170, (int)70);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        EntityPlayer player = buildContext.getPlayer();
        AtomicReference<BigInteger> teaAmount = new AtomicReference<BigInteger>(BigInteger.ZERO);
        Widget[] widgetArray = new Widget[4];
        widgetArray[0] = TeaAcceptorTile.posCenteredHorizontally(10, new TextWidget(new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.tea_acceptor.name")).format(EnumChatFormatting.BOLD).format(EnumChatFormatting.DARK_RED)));
        widgetArray[1] = TeaAcceptorTile.posCenteredHorizontally(30, (TextWidget)new DynamicTextWidget(() -> {
            if (player.getPersistentID().equals(this.tileOwner)) {
                return new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.tea_acceptor.tea")).color(Color.GREEN.normal);
            }
            return new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.tea_acceptor.not_owner")).color(Color.RED.normal);
        }));
        widgetArray[2] = TeaAcceptorTile.posCenteredHorizontally(40, (TextWidget)new DynamicTextWidget(() -> new Text(StringUtils.applyRainbow(NEIClientUtils.shiftKey() ? Variables.numberFormat.format(teaAmount.get()) : Variables.numberFormatScientific.format(teaAmount.get()), (int)(((BigInteger)teaAmount.get()).longValue() / Math.max(1L, this.averageInput * 10L) % Integer.MAX_VALUE), EnumChatFormatting.BOLD.toString())).shadow()).setSynced(false).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BigIntegerSyncer(() -> this.teaNetwork.teaAmount, teaAmount::set), (IWidgetBuilder)builder));
        widgetArray[3] = TeaAcceptorTile.posCenteredHorizontally(50, (TextWidget)new DynamicTextWidget(() -> new Text(StatCollector.func_74837_a((String)"kubatech.gui.text.tea_acceptor.in", (Object[])new Object[]{this.averageInput})).color(Color.BLACK.normal))).addTooltip(new Text(StatCollector.func_74838_a((String)"kubatech.gui.text.tea_acceptor.in.tooltip")).color(Color.GRAY.normal));
        builder.widgets(widgetArray);
        return builder.build();
    }
}

