/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;

public class RecipeGenFluids
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenFluids(Material M) {
        this(M, false);
    }

    public RecipeGenFluids(Material M, boolean dO) {
        this.toGenerate = M;
        this.disableOptional = dO;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    private void generateRecipes(Material material, boolean dO) {
        if (material == null) {
            return;
        }
        if (material.getFluidStack(1) != null && !material.getFluidStack(1).getUnlocalizedName().toLowerCase().contains("plasma")) {
            if (material.getIngot(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(material.getIngot(1)).fluidInputs(material.getFluidStack(144)).duration(32).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("144l fluid molder for 1 ingot Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getPlate(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(material.getPlate(1)).fluidInputs(material.getFluidStack(144)).duration(32).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("144l fluid molder for 1 plate Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getNugget(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Nugget.get(0L, new Object[0])).itemOutputs(material.getNugget(1)).fluidInputs(material.getFluidStack(16)).duration(16).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("16l fluid molder for 1 nugget Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getGear(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Gear.get(0L, new Object[0])).itemOutputs(material.getGear(1)).fluidInputs(material.getFluidStack(576)).duration(128).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("576l fluid molder for 1 gear Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getBlock(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Block.get(0L, new Object[0])).itemOutputs(material.getBlock(1)).fluidInputs(material.getFluidStack(1296)).duration(288).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 block Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getRod(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod.get(0L, new Object[0])).itemOutputs(material.getRod(1)).fluidInputs(material.getFluidStack(72)).duration(150).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 rod Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getLongRod(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0])).itemOutputs(material.getLongRod(1)).fluidInputs(material.getFluidStack(144)).duration(300).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 rod long Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getBolt(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Bolt.get(0L, new Object[0])).itemOutputs(material.getBolt(1)).fluidInputs(material.getFluidStack(18)).duration(50).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 bolt Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getScrew(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Screw.get(0L, new Object[0])).itemOutputs(material.getScrew(1)).fluidInputs(material.getFluidStack(18)).duration(50).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 screw Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getRing(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ring.get(0L, new Object[0])).itemOutputs(material.getRing(1)).fluidInputs(material.getFluidStack(36)).duration(100).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 ring Recipe: " + material.getLocalizedName() + " - Success");
            }
            if (material.getRotor(1) != null) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rotor.get(0L, new Object[0])).itemOutputs(material.getRotor(1)).fluidInputs(material.getFluidStack(612)).duration(100).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidSolidifierRecipes);
                Logger.WARNING("1296l fluid molder from 1 rotor Recipe: " + material.getLocalizedName() + " - Success");
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

