/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamForgeHammer
extends MTESteamMultiBase<MTESteamForgeHammer>
implements ISurvivalConstructable {
    private static final String STRUCTUR_PIECE_MAIN = "main";
    private IStructureDefinition<MTESteamForgeHammer> STRUCTURE_DEFINITION = null;
    private final String[][] shape = new String[][]{{"     ", "     ", "  B  ", "     ", "     "}, {"     ", "  A  ", "AABAA", "  A  ", "     "}, {"     ", "     ", "A C A", "     ", "     "}, {"     ", "     ", "A C A", "     ", "     "}, {"     ", "     ", "A   A", "     ", "     "}, {"     ", " A~A ", "AA AA", " AAA ", "     "}, {" AAA ", "AAAAA", "AAAAA", "AAAAA", " AAA "}};
    private static final int HORIZONTAL_OFF_SET = 2;
    private static final int VERTICAL_OFF_SET = 5;
    private static final int DEPTH_OFF_SET = 1;
    private int tierPipeCasing = -1;
    private int tierMachineCasing = -1;
    private int tCountCasing = 0;
    private int tierMachine = 1;
    private int tierSimpleBlock = -1;

    public MTESteamForgeHammer(String aName) {
        super(aName);
    }

    public MTESteamForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamForgeHammer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Forge Hammer";
    }

    @Nullable
    public static Integer getTierSimpleBlock(Block block, int meta) {
        if (block == Blocks.field_150339_S && meta == 0) {
            return 1;
        }
        if (block == GregTechAPI.sBlockMetal6 && meta == 13) {
            return 2;
        }
        return null;
    }

    @Nullable
    public Integer getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            ++this.tCountCasing;
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            ++this.tCountCasing;
            return 2;
        }
        return null;
    }

    @Nullable
    public static Integer getTierPipeCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 12 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 13 == meta) {
            return 2;
        }
        return null;
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        if (this.tierPipeCasing == 2 || this.tierMachineCasing == 2 || this.tierSimpleBlock == 2) {
            return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
        }
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.tierMachineCasing = aValue;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.tierMachineCasing;
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_FORGE_HAMMER).extFacing().build();
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_FORGE_HAMMER_ACTIVE).extFacing().build();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID())};
    }

    @Override
    public IStructureDefinition<MTESteamForgeHammer> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTUR_PIECE_MAIN, StructureUtility.transpose((String[][])this.shape)).addElement('B', StructureUtility.ofBlocksTiered(MTESteamForgeHammer::getTierPipeCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
                t.tierPipeCasing = m;
            }, t -> t.tierPipeCasing)).addElement('C', StructureUtility.ofBlocksTiered(MTESteamForgeHammer::getTierSimpleBlock, (List)ImmutableList.of((Object)Pair.of((Object)Blocks.field_150339_S, (Object)0), (Object)Pair.of((Object)GregTechAPI.sBlockMetal6, (Object)13)), (Object)-1, (t, m) -> {
                t.tierSimpleBlock = m;
            }, t -> t.tierSimpleBlock)).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamForgeHammer.buildSteamInput(MTESteamForgeHammer.class).casingIndex(10).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamForgeHammer.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam).casingIndex(10).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlocksTiered(this::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTUR_PIECE_MAIN, stackSize, hintsOnly, 2, 5, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTUR_PIECE_MAIN, stackSize, 2, 5, 1, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierPipeCasing = -1;
        this.tierMachineCasing = -1;
        this.tierSimpleBlock = -1;
        this.tCountCasing = 0;
        if (!this.checkPiece(STRUCTUR_PIECE_MAIN, 2, 5, 1)) {
            return false;
        }
        if (this.tierPipeCasing == 1 && this.tierMachineCasing == 1 && this.tierSimpleBlock == 1 && this.tCountCasing >= 35 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 1;
            return true;
        }
        if (this.tierPipeCasing == 2 && this.tierMachineCasing == 2 && this.tierSimpleBlock == 2 && this.tCountCasing >= 35 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 2;
            return true;
        }
        return false;
    }

    private boolean checkHatches() {
        return !this.mSteamInputFluids.isEmpty() && !this.mSteamInputs.isEmpty() && !this.mSteamOutputs.isEmpty() && this.mOutputHatches.isEmpty() && this.mInputHatches.isEmpty();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.hammerRecipes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.RANDOM_ANVIL_USE;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamForgeHammer.this.tierMachine).setDurationModifier(1.6 / (double)MTESteamForgeHammer.this.tierMachine);
            }
        }.noRecipeCaching().setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("25% faster than using single block steam machines of the same pressure").addInfo("Only consumes steam at 62.5% of the steam flowrate normally required").addInfo("Processes up to 8 items at once").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").beginStructureBlock(6, 5, 5, false).addSteamInputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addSteamOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addStructureInfo(EnumChatFormatting.WHITE + "Steam Input Hatch " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "Basic " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "35-39x" + EnumChatFormatting.GRAY + " Bronze Plated Bricks").addStructureInfo(EnumChatFormatting.GOLD + "2x" + EnumChatFormatting.GRAY + " Bronze Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "2x" + EnumChatFormatting.GRAY + " Iron Block").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "High Pressure " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "35-39x" + EnumChatFormatting.GRAY + " Solid Steel Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "2x" + EnumChatFormatting.GRAY + " Steel Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "2x" + EnumChatFormatting.GRAY + " Steel Block" + EnumChatFormatting.RED + " from GregTech").toolTipFinisher(GTValues.AuthorEvgenWarGold);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi.steam.tier", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.tierMachine}));
        info.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi.steam.parallel", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.getMaxParallelRecipes()}));
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamForgeHammer.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.tierMachine);
        tag.func_74768_a("parallel", this.getTrueParallel());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.tierMachine);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.tierMachine = aNBT.func_74762_e("tierMachine");
    }
}

