/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPPUITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.item.DamageHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTECropHarvestor
extends MTEBasicTank {
    private static final int SLOT_WEEDEX_1 = 1;
    private static final int SLOT_WEEDEX_2 = 2;
    private static final int SLOT_FERT_1 = 3;
    private static final int SLOT_FERT_4 = 6;
    private static final int SLOT_OUTPUT_START = 7;
    public boolean mModeAlternative = false;
    public boolean mHarvestEnabled = true;
    public boolean harvestFullGrowth = true;
    private final HashSet<ICropTile> mCropCache = new HashSet();
    private boolean mInvalidCache = false;

    public MTECropHarvestor(int aID, int aTier, String aDescription) {
        super(aID, "basicmachine.cropharvester.0" + aTier, "Crop Manager (" + GTValues.VN[aTier] + ")", aTier, 21, aDescription, new ITexture[0]);
    }

    public MTECropHarvestor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 21, aDescription, aTextures);
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public long maxAmperesIn() {
        return 8L;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * ((long)this.mTier * GTValues.V[this.mTier]);
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public int getCapacity() {
        return 32000 * this.mTier;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECropHarvestor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int func_70302_i_() {
        return 21;
    }

    private static int getRange(int aTier) {
        int n;
        switch (aTier) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 9;
                break;
            }
            case 4: {
                n = 13;
                break;
            }
            case 5: {
                n = 17;
                break;
            }
            case 6: {
                n = 21;
                break;
            }
            case 7: {
                n = 25;
                break;
            }
            case 8: {
                n = 29;
                break;
            }
            case 9: {
                n = 33;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public boolean doesInventoryHaveSpace() {
        for (int i = 7; i < this.func_70302_i_(); ++i) {
            if (this.mInventory[i] != null && this.mInventory[i].field_77994_a >= 64) continue;
            return true;
        }
        return false;
    }

    public long powerUsage() {
        return this.maxEUInput() / 8L;
    }

    public long powerUsageSecondary() {
        return this.maxEUInput() / 32L;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide() || !this.getBaseMetaTileEntity().isAllowedToWork() || !this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() && aTick % 100L != 0L) {
            return;
        }
        if (this.getBaseMetaTileEntity().getUniversalEnergyStored() < this.getMinimumStoredEU()) {
            return;
        }
        int aRadius = 10 + MTECropHarvestor.getRange(this.mTier);
        int aSide = (aRadius - 1) / 2;
        ItemStackMap aAllDrops = new ItemStackMap(true);
        if (this.mCropCache.isEmpty() || aTick % 1200L == 0L || this.mInvalidCache) {
            if (!this.mCropCache.isEmpty()) {
                this.mCropCache.clear();
            }
            this.lookForCrops(aSide);
        }
        if (!this.doesInventoryHaveSpace()) {
            return;
        }
        for (ICropTile iCropTile : this.mCropCache) {
            ItemStack[] aHarvest;
            if (iCropTile == null) {
                this.mInvalidCache = true;
                break;
            }
            CropCard aCrop = iCropTile.getCrop();
            if (this.mModeAlternative) {
                this.processSecondaryFunctions(iCropTile);
            }
            if (aCrop == null || !this.mHarvestEnabled || !aCrop.canBeHarvested(iCropTile) || !this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsage(), true) || (aHarvest = iCropTile.harvest_automated(this.harvestFullGrowth)) == null) continue;
            for (ItemStack aStack : aHarvest) {
                if (aStack == null) continue;
                if (this.mTier * 5 > MathUtils.randInt(1, 100)) {
                    aStack.field_77994_a = (int)((double)aStack.field_77994_a + Math.floor(iCropTile.getGain() / 10));
                    Logger.INFO("Bonus output given for " + aCrop.displayName());
                }
                Logger.INFO("Harvested " + aCrop.displayName());
                aAllDrops.merge(aStack, aStack.field_77994_a, Integer::sum);
            }
        }
        if (aAllDrops.isEmpty()) {
            return;
        }
        Logger.INFO("Handling " + aAllDrops.size() + " Harvests");
        for (Map.Entry entry : aAllDrops.entrySet()) {
            ItemStack dropItem = (ItemStack)entry.getKey();
            int dropAmount = (Integer)entry.getValue();
            if (dropItem == null) continue;
            for (int i = 7; i < this.func_70302_i_() && dropAmount > 0; ++i) {
                ItemStack invStack = this.mInventory[i];
                if (invStack == null || GTUtility.isStackInvalid(invStack) || invStack.field_77994_a == 0) {
                    int stackSize = Math.min(dropAmount, dropItem.func_77976_d());
                    this.getBaseMetaTileEntity().func_70299_a(i, GTUtility.copyAmount(stackSize, dropItem));
                    dropAmount -= stackSize;
                    continue;
                }
                if (!GTUtility.areStacksEqual(invStack, dropItem)) continue;
                int space = Math.min(invStack.func_77976_d(), this.func_70297_j_()) - invStack.field_77994_a;
                if (dropAmount <= space) {
                    this.getBaseMetaTileEntity().addStackToSlot(i, invStack, dropAmount);
                    dropAmount = 0;
                    continue;
                }
                this.getBaseMetaTileEntity().addStackToSlot(i, invStack, space);
                dropAmount -= space;
            }
        }
    }

    private void lookForCrops(int aSide) {
        for (int y = -2; y <= 2; ++y) {
            for (int x = -aSide; x <= aSide; ++x) {
                for (int z = -aSide; z <= aSide; ++z) {
                    TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityOffset(x, y, z);
                    if (!(tTileEntity instanceof ICropTile)) continue;
                    ICropTile tCrop = (ICropTile)tTileEntity;
                    this.mCropCache.add(tCrop);
                }
            }
        }
    }

    public boolean hasFertilizer() {
        for (int i = 3; i <= 6; ++i) {
            if (this.mInventory[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean consumeFertilizer(boolean aSimulate) {
        if (this.hasFertilizer()) {
            for (int i = 3; i <= 6; ++i) {
                if (this.mInventory[i] == null) continue;
                this.consume(i, 1, aSimulate);
                return true;
            }
        }
        return false;
    }

    public boolean consumeWeedEX(boolean aSimulate) {
        for (int i = 1; i <= 2; ++i) {
            if (this.mInventory[i] == null) continue;
            this.damage(i, 1, aSimulate);
            return true;
        }
        return false;
    }

    public void processSecondaryFunctions(ICropTile aCrop) {
        if (!this.mModeAlternative) {
            return;
        }
        if (this.consumeWeedEX(true) && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU() && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsageSecondary(), true) && this.applyWeedEx(aCrop)) {
            this.consumeWeedEX(false);
        }
        if (aCrop.getCrop() == null || aCrop.getCrop().equals(Crops.weed)) {
            return;
        }
        if (this.hasFertilizer() && this.consumeFertilizer(true) && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU() && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsageSecondary(), true) && this.applyFertilizer(aCrop)) {
            this.consumeFertilizer(false);
        }
        if (this.getFluidAmount() <= 0 || this.getBaseMetaTileEntity().getUniversalEnergyStored() < this.getMinimumStoredEU() || !this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsageSecondary(), true) || this.applyHydration(aCrop)) {
            // empty if block
        }
    }

    public boolean applyWeedEx(ICropTile aCrop) {
        boolean applyDose;
        boolean bl = applyDose = aCrop.getWeedExStorage() < 150;
        if (applyDose) {
            aCrop.setWeedExStorage(aCrop.getWeedExStorage() + 50);
        }
        boolean triggerDecline = aCrop.getWorld().field_73012_v.nextInt(3) == 0;
        CropCard cropType = aCrop.getCrop();
        if (!triggerDecline || cropType == null) {
            return applyDose;
        }
        if (cropType.equals(Crops.weed)) {
            if (aCrop.getSize() == 1) {
                aCrop.reset();
            } else {
                aCrop.setSize((byte)(aCrop.getSize() - 1));
            }
            return true;
        }
        if (applyDose && cropType.isWeed(aCrop) && aCrop.getWeedExStorage() >= 75) {
            switch (aCrop.getWorld().field_73012_v.nextInt(5)) {
                case 0: {
                    if (aCrop.getGrowth() > 0) {
                        aCrop.setGrowth((byte)(aCrop.getGrowth() - 1));
                    }
                }
                case 1: {
                    if (aCrop.getGain() <= 0) break;
                    aCrop.setGain((byte)(aCrop.getGain() - 1));
                }
            }
            if (aCrop.getResistance() > 0) {
                aCrop.setResistance((byte)(aCrop.getResistance() - 1));
            }
        }
        return applyDose;
    }

    public boolean applyFertilizer(ICropTile aCrop) {
        if (aCrop.getNutrientStorage() >= 100) {
            return false;
        }
        aCrop.setNutrientStorage(aCrop.getNutrientStorage() + 100);
        return true;
    }

    public boolean applyHydration(ICropTile aCrop) {
        if (aCrop.getHydrationStorage() >= 200 || this.getFluidAmount() == 0) {
            return false;
        }
        int apply = 200 - aCrop.getHydrationStorage();
        if (this.getFluidAmount() >= 0) {
            int drain = 0;
            drain = this.getFluidAmount() >= apply ? apply : this.getFluidAmount();
            this.mFluid.amount -= drain;
            if (this.mFluid.amount <= 0) {
                this.mFluid = null;
            }
            aCrop.setHydrationStorage(aCrop.getHydrationStorage() + drain);
            return true;
        }
        return false;
    }

    public boolean consume(int aSlot, int amount, boolean simulate) {
        ItemStack stack = this.mInventory[aSlot];
        if (stack != null && stack.field_77994_a >= amount) {
            int currentAmount = Math.min(amount, stack.field_77994_a);
            amount -= currentAmount;
            if (!simulate) {
                if (stack.field_77994_a == currentAmount) {
                    this.mInventory[aSlot] = null;
                } else {
                    stack.field_77994_a -= currentAmount;
                }
            } else {
                return amount >= 0;
            }
            return true;
        }
        return false;
    }

    public ItemStack damage(int aSlot, int amount, boolean simulate) {
        ItemStack ret = null;
        int damageApplied = 0;
        ItemStack stack = this.mInventory[aSlot];
        Item item = stack.func_77973_b();
        if (stack != null && item.func_77645_m() && (ret == null || stack.func_77973_b() == ret.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack, ret))) {
            if (simulate) {
                stack = stack.func_77946_l();
            }
            int maxDamage = DamageHandler.getMaxDamage((ItemStack)stack);
            while (amount > 0 && stack.field_77994_a > 0) {
                int currentAmount = Math.min(amount, maxDamage - DamageHandler.getDamage((ItemStack)stack));
                DamageHandler.damage((ItemStack)stack, (int)currentAmount, null);
                damageApplied += currentAmount;
                amount -= currentAmount;
                if (DamageHandler.getDamage((ItemStack)stack) >= maxDamage) {
                    --stack.field_77994_a;
                    DamageHandler.setDamage((ItemStack)stack, (int)0);
                }
                if (ret != null) continue;
                ret = stack.func_77946_l();
            }
            if (stack.field_77994_a == 0 && !simulate) {
                this.mInventory[aSlot] = null;
            }
        }
        if (ret != null) {
            int i = DamageHandler.getMaxDamage(ret);
            ret.field_77994_a = damageApplied / i;
            DamageHandler.setDamage(ret, (int)(damageApplied % i));
        }
        return ret;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aStack != null && aIndex >= 7 && aIndex < this.func_70302_i_();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (aStack != null) {
            if (ItemList.IC2_Fertilizer.isStackEqual(aStack)) {
                return aIndex >= 3 && aIndex <= 6;
            }
            if (ItemList.IC2_Spray_WeedEx.isStackEqual(aStack, true, true)) {
                return aIndex >= 1 && aIndex <= 2;
            }
        }
        return false;
    }

    @Override
    public String[] getDescription() {
        int aRadius = 10 + MTECropHarvestor.getRange(this.mTier);
        int aSide = (aRadius - 1) / 2;
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Secondary mode can Hydrate/Fertilize/Weed-EX", "You can set the mode to harvest any growth stage crop or only fully mature ones", "Consumes " + this.powerUsage() + "eu per harvest", "Consumes " + this.powerUsageSecondary() + "eu per secondary operation", "Can harvest 2 block levels above and below itself", "Radius: " + aSide + " blocks each side (" + aRadius + "x5x" + aRadius + ")", "Has " + this.mTier * 5 + "% chance for extra drops", "Holds " + this.getCapacity() + "L of Water", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getBack(i);
            rTextures[7][i + 1] = this.getBottom(i);
            rTextures[8][i + 1] = this.getTop(i);
            rTextures[9][i + 1] = this.getSides(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
            return this.mTextures[3][aColorIndex + 1];
        }
        return this.mTextures[4][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_CropHarvester_Cutter)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_CropHarvester_Cutter)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_CropHarvester_Boxes)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_CropHarvester_Boxes)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_CropHarvester_Cutter)};
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mModeAlternative", this.mModeAlternative);
        aNBT.func_74757_a("mHarvestEnabled", this.mHarvestEnabled);
        aNBT.func_74757_a("harvestFullGrowth", this.harvestFullGrowth);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mModeAlternative = aNBT.func_74767_n("mModeAlternative");
        if (aNBT.func_74764_b("mHarvestEnabled")) {
            this.mHarvestEnabled = aNBT.func_74767_n("mHarvestEnabled");
        }
        if (aNBT.func_74764_b("harvestFullGrowth")) {
            this.harvestFullGrowth = aNBT.func_74767_n("harvestFullGrowth");
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mModeAlternative, val -> {
            this.mModeAlternative = val;
        }).setTexture(GTPPUITextures.OVERLAY_BUTTON_HARVESTER_MODE).addTooltip(0, "Enable Hydration/Fertilizing/Weed-EX").addTooltip(1, "Disable Hydration/Fertilizing/Weed-EX").setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(47, 63).setSize(18, 18));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mHarvestEnabled, val -> {
            this.mHarvestEnabled = val;
        }).setTexture(GTPPUITextures.OVERLAY_BUTTON_HARVESTER_TOGGLE).addTooltip(0, "Enable Harvest").addTooltip(1, "Disable Harvest").setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(67, 63).setSize(18, 18));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.harvestFullGrowth, val -> {
            this.harvestFullGrowth = val;
        }).setTexture(GTPPUITextures.OVERLAY_BUTTON_HARVESTER_GROWTH_TOGGLE).addTooltip(0, "Enable Full Growth Harvest").addTooltip(1, "Disable Full Growth Harvest").setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(87, 63).setSize(18, 18));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(1).endAtSlot(2).applyForWidget(widget -> widget.setFilter(x -> ItemList.IC2_Spray_WeedEx.isStackEqual(x, true, true)).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPPUITextures.OVERLAY_SLOT_WEED_EX})).build().setPos(7, 13))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(3).endAtSlot(6).applyForWidget(widget -> widget.setFilter(ItemList.IC2_Fertilizer::isStackEqual).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPPUITextures.OVERLAY_SLOT_FERTILIZER})).build().setPos(7, 31))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)6).startFromSlot(7).endAtSlot(25).canInsert(false).build().setPos(61, 7));
        ((ModularWindow.Builder)builder.widget(new ProgressBar().setTexture(GTPPUITextures.PROGRESSBAR_BOILER_EMPTY, GTUITextures.PROGRESSBAR_BOILER_WATER, 54).setDirection(ProgressBar.Direction.UP).setProgress(() -> Float.valueOf((float)this.getFluidAmount() / (float)this.getCapacity())).setSynced(false, false).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74837_a((String)"gtpp.gui.crop_harvestor.tooltip.water", (Object[])new Object[]{this.getFluidAmount(), this.getCapacity()}))).setPos(47, 7).setSize(10, 54))).widget((Widget)new FakeSyncWidget.FluidStackSyncer(this::getDrainableStack, this::setDrainableStack));
    }
}

