/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.items;

import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TCAspects;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.StringUtils;
import gregtech.client.GTTooltipHandler;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.items.GTMetaItemX32;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.covers.CoverOverflowValve;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedItemIDs;

public class MetaGeneratedGregtechItems
extends GTMetaItemX32 {
    public static final MetaGeneratedGregtechItems INSTANCE = new MetaGeneratedGregtechItems();

    public MetaGeneratedGregtechItems() {
        super("MU-metaitem.01", new OrePrefixes[]{null});
    }

    public void generateMetaItems() {
        GregtechItemList.Shape_Extruder_WindmillShaft.set(this.addItem(MetaGeneratedItemIDs.Shape_Extruder_WindmillShaft.ID, "Extruder Shape (Shaft)", "Extruder Shape for making Windmill Shafts", new Object[0]));
        GregtechItemList.Battery_RE_EV_Sodium.set(this.addItem(MetaGeneratedItemIDs.Battery_RE_EV_Sodium.ID, "Quad Cell Sodium Battery", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 2L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 2L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 2L)));
        GregtechItemList.Battery_RE_EV_Cadmium.set(this.addItem(MetaGeneratedItemIDs.Battery_RE_EV_Cadmium.ID, "Quad Cell Cadmium Battery", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 1L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 1L)));
        GregtechItemList.Battery_RE_EV_Lithium.set(this.addItem(MetaGeneratedItemIDs.Battery_RE_EV_Lithium.ID, "Quad Cell Lithium Battery", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 3L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 3L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 3L)));
        GregtechItemList.Battery_Gem_1.set(this.addItem(MetaGeneratedItemIDs.Battery_Gem_1.ID, "Proton Cell", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 8L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 24L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 16L)));
        GregtechItemList.Battery_Gem_2.set(this.addItem(MetaGeneratedItemIDs.Battery_Gem_2.ID, "Electron Cell", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 16L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 32L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 32L)));
        GregtechItemList.Battery_Gem_3.set(this.addItem(MetaGeneratedItemIDs.Battery_Gem_3.ID, "Quark Entanglement", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 32L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 48L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 64L)));
        GregtechItemList.Pellet_RTG_PU238.set(this.addItem(MetaGeneratedItemIDs.Pellet_RTG_PU238.ID, StringUtils.superscript("238") + "Pu Pellet", "", new TCAspects.TC_AspectStack(TCAspects.RADIO, 4L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 2L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 2L)));
        GregtechItemList.Pellet_RTG_SR90.set(this.addItem(MetaGeneratedItemIDs.Pellet_RTG_SR90.ID, StringUtils.superscript("90") + "Sr Pellet", "", new TCAspects.TC_AspectStack(TCAspects.RADIO, 4L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 2L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 2L)));
        GregtechItemList.Pellet_RTG_PO210.set(this.addItem(MetaGeneratedItemIDs.Pellet_RTG_PO210.ID, StringUtils.superscript("210") + "Po Pellet", "", new TCAspects.TC_AspectStack(TCAspects.RADIO, 4L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 2L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 2L)));
        GregtechItemList.Pellet_RTG_AM241.set(this.addItem(MetaGeneratedItemIDs.Pellet_RTG_AM241.ID, StringUtils.superscript("241") + "Am Pellet", "", new TCAspects.TC_AspectStack(TCAspects.RADIO, 4L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 2L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 2L)));
        GregtechItemList.Gregtech_Computer_Cube.set(this.addItem(MetaGeneratedItemIDs.Gregtech_Computer_Cube.ID, "Gregtech Computer Cube", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 8L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 8L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 8L)));
        GregtechItemList.Cover_Overflow_Valve_LV.set(this.addItem(MetaGeneratedItemIDs.Cover_Overflow_Valve_LV.ID, "Overflow Valve (LV)", "Maximum void amount: 64,000", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L), new TCAspects.TC_AspectStack(TCAspects.MACHINA, 1L), new TCAspects.TC_AspectStack(TCAspects.ITER, 1L), new TCAspects.TC_AspectStack(TCAspects.AQUA, 1L)));
        GregtechItemList.Cover_Overflow_Valve_MV.set(this.addItem(MetaGeneratedItemIDs.Cover_Overflow_Valve_MV.ID, "Overflow Valve (MV)", "Maximum void amount: 512,000", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L), new TCAspects.TC_AspectStack(TCAspects.MACHINA, 1L), new TCAspects.TC_AspectStack(TCAspects.ITER, 1L), new TCAspects.TC_AspectStack(TCAspects.AQUA, 1L)));
        GregtechItemList.Cover_Overflow_Valve_HV.set(this.addItem(MetaGeneratedItemIDs.Cover_Overflow_Valve_HV.ID, "Overflow Valve (HV)", "Maximum void amount: 4,096,000", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L), new TCAspects.TC_AspectStack(TCAspects.MACHINA, 1L), new TCAspects.TC_AspectStack(TCAspects.ITER, 1L), new TCAspects.TC_AspectStack(TCAspects.AQUA, 1L)));
        GregtechItemList.Cover_Overflow_Valve_EV.set(this.addItem(MetaGeneratedItemIDs.Cover_Overflow_Valve_EV.ID, "Overflow Valve (EV)", "Maximum void amount: 32,768,000", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L), new TCAspects.TC_AspectStack(TCAspects.MACHINA, 1L), new TCAspects.TC_AspectStack(TCAspects.ITER, 1L), new TCAspects.TC_AspectStack(TCAspects.AQUA, 1L)));
        GregtechItemList.Cover_Overflow_Valve_IV.set(this.addItem(MetaGeneratedItemIDs.Cover_Overflow_Valve_IV.ID, "Overflow Valve (IV)", "Maximum void amount: 262,144,000", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L), new TCAspects.TC_AspectStack(TCAspects.MACHINA, 1L), new TCAspects.TC_AspectStack(TCAspects.ITER, 1L), new TCAspects.TC_AspectStack(TCAspects.AQUA, 1L)));
        GregtechItemList.Compressed_Fusion_Reactor.set(this.addItem(MetaGeneratedItemIDs.Compressed_Fusion_Reactor.ID, "Hypervisor Matrix (Fusion)", "A memory unit containing an RI (Restricted Intelligence)", new Object[0]));
        GregtechItemList.Laser_Lens_Special.set(this.addItem(MetaGeneratedItemIDs.Laser_Lens_Special.ID, "Quantum Anomaly", "Probably should shoot it with lasers", new Object[0]));
        GregtechItemList.Battery_Casing_Gem_1.set(this.addItem(MetaGeneratedItemIDs.Battery_Casing_Gem_1.ID, "Containment Unit I", "Used in crafting", new Object[0]));
        GregtechItemList.Battery_Casing_Gem_2.set(this.addItem(MetaGeneratedItemIDs.Battery_Casing_Gem_2.ID, "Containment Unit II", "Used in crafting", new Object[0]));
        GregtechItemList.Battery_Casing_Gem_3.set(this.addItem(MetaGeneratedItemIDs.Battery_Casing_Gem_3.ID, "Advanced Containment Unit", "Used in crafting", new Object[0]));
        GregtechItemList.Battery_Casing_Gem_4.set(this.addItem(MetaGeneratedItemIDs.Battery_Casing_Gem_4.ID, "Exotic Containment Unit", "Used in crafting", new Object[0]));
        GregtechItemList.Battery_Gem_4.set(this.addItem(MetaGeneratedItemIDs.Battery_Gem_4.ID, "Graviton Anomaly", "Reusable", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 64L), new TCAspects.TC_AspectStack(TCAspects.METALLUM, 64L), new TCAspects.TC_AspectStack(TCAspects.POTENTIA, 64L)));
        GregtechItemList.Laser_Lens_WoodsGlass.set(this.addItem(MetaGeneratedItemIDs.Laser_Lens_WoodsGlass.ID, "Wood's Glass Lens", "Allows UV & IF to pass through, blocks visible light spectrums", new Object[0]));
        GregtechItemList[] aTransParts = new GregtechItemList[]{GregtechItemList.TransmissionComponent_LV, GregtechItemList.TransmissionComponent_MV, GregtechItemList.TransmissionComponent_HV, GregtechItemList.TransmissionComponent_EV, GregtechItemList.TransmissionComponent_IV, GregtechItemList.TransmissionComponent_LuV, GregtechItemList.TransmissionComponent_ZPM, GregtechItemList.TransmissionComponent_UV, GregtechItemList.TransmissionComponent_UHV};
        int[] IDs2 = new int[]{MetaGeneratedItemIDs.TransmissionComponent_LV.ID, MetaGeneratedItemIDs.TransmissionComponent_MV.ID, MetaGeneratedItemIDs.TransmissionComponent_HV.ID, MetaGeneratedItemIDs.TransmissionComponent_EV.ID, MetaGeneratedItemIDs.TransmissionComponent_IV.ID, MetaGeneratedItemIDs.TransmissionComponent_LuV.ID, MetaGeneratedItemIDs.TransmissionComponent_ZPM.ID, MetaGeneratedItemIDs.TransmissionComponent_UV.ID, MetaGeneratedItemIDs.TransmissionComponent_UHV.ID};
        for (int tier = 1; tier < aTransParts.length + 1; ++tier) {
            aTransParts[tier - 1].set(this.addItem(IDs2[tier - 1], "Transmission Component (" + GTValues.VN[tier] + ")", "", new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, tier), new TCAspects.TC_AspectStack(TCAspects.MACHINA, tier), new TCAspects.TC_AspectStack(TCAspects.MAGNETO, tier)));
        }
        GregtechItemList.Distillus_Upgrade_Chip.set(this.addItem(MetaGeneratedItemIDs.Distillus_Upgrade_Chip.ID, "Distillus Upgrade Chip", "Used to upgrade Distillus to Tier 2", new Object[0]));
        GregtechItemList.Maceration_Upgrade_Chip.set(this.addItem(MetaGeneratedItemIDs.Maceration_Upgrade_Chip.ID, "Maceration Upgrade Chip", "Used to upgrade Maceration Stack to Tier 2", new Object[0]));
        this.setAllElectricStats();
        this.registerTieredTooltips();
        this.registerFuelRTGRecipes();
        this.registerCovers();
    }

    private void setAllElectricStats() {
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_RE_EV_Cadmium.ID, 4800000L, GTValues.V[4], 4L, -3L, true);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_RE_EV_Sodium.ID, 3200000L, GTValues.V[4], 4L, -3L, true);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_RE_EV_Lithium.ID, 6400000L, GTValues.V[4], 4L, -3L, true);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_Gem_1.ID, GTValues.V[6] * 20L * 300L / 4L, GTValues.V[6], 6L, -3L, false);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_Gem_2.ID, GTValues.V[7] * 20L * 300L / 4L, GTValues.V[7], 7L, -3L, false);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_Gem_3.ID, GTValues.V[8] * 20L * 300L / 4L, GTValues.V[8], 8L, -3L, false);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Battery_Casing_Gem_4.ID, 1024000000000L, GTValues.V[9], 9L, -3L, false);
        this.setElectricStats(32000 + MetaGeneratedItemIDs.Gregtech_Computer_Cube.ID, GTValues.V[6] * 10L * 60L * 20L, GTValues.V[5], 5L, -3L, false);
    }

    private void registerTieredTooltips() {
        GTTooltipHandler.registerTieredTooltip(GregtechItemList.Battery_RE_EV_Sodium.get(1L, new Object[0]), GTTooltipHandler.Tier.EV);
        GTTooltipHandler.registerTieredTooltip(GregtechItemList.Battery_RE_EV_Cadmium.get(1L, new Object[0]), GTTooltipHandler.Tier.EV);
        GTTooltipHandler.registerTieredTooltip(GregtechItemList.Battery_RE_EV_Lithium.get(1L, new Object[0]), GTTooltipHandler.Tier.EV);
    }

    private void registerFuelRTGRecipes() {
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.Pellet_RTG_PU238.get(1L, new Object[0])).duration(0).eut(64).metadata(GTRecipeConstants.RTG_DURATION_IN_DAYS, MathUtils.roundToClosestInt(87.7f)).addTo(GTPPRecipeMaps.rtgFuels);
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])).duration(0).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.RTG_DURATION_IN_DAYS, MathUtils.roundToClosestInt(28.8f)).addTo(GTPPRecipeMaps.rtgFuels);
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.Pellet_RTG_PO210.get(1L, new Object[0])).duration(0).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.RTG_DURATION_IN_DAYS, 1).addTo(GTPPRecipeMaps.rtgFuels);
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.Pellet_RTG_AM241.get(1L, new Object[0])).duration(0).eut(16).metadata(GTRecipeConstants.RTG_DURATION_IN_DAYS, 216).addTo(GTPPRecipeMaps.rtgFuels);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getIC2Item("RTGPellets", 1L)).duration(0).eut(8).metadata(GTRecipeConstants.RTG_DURATION_IN_DAYS, MathUtils.roundToClosestInt(2.6f)).addTo(GTPPRecipeMaps.rtgFuels);
    }

    private void registerCovers() {
        MetaGeneratedGregtechItems.registerOverflowValveCover(GregtechItemList.Cover_Overflow_Valve_LV, 4, 64000);
        MetaGeneratedGregtechItems.registerOverflowValveCover(GregtechItemList.Cover_Overflow_Valve_MV, 5, 512000);
        MetaGeneratedGregtechItems.registerOverflowValveCover(GregtechItemList.Cover_Overflow_Valve_HV, 5, 4096000);
        MetaGeneratedGregtechItems.registerOverflowValveCover(GregtechItemList.Cover_Overflow_Valve_EV, 8, 32768000);
        MetaGeneratedGregtechItems.registerOverflowValveCover(GregtechItemList.Cover_Overflow_Valve_IV, 8, 0xFA00000);
    }

    private static void registerOverflowValveCover(GregtechItemList cover, int tier, int maxOverflowPoint) {
        CoverRegistry.registerCover(cover.get(1L, new Object[0]), TextureFactory.of(Textures.BlockIcons.MACHINE_CASINGS[tier][0], TextureFactory.of(TexturesGtBlock.Overlay_Overflow_Valve)), context -> new CoverOverflowValve(context, maxOverflowPoint));
    }
}

