/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers.tesseract;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.MTETesseractGenerator;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.MTETesseractTerminal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class TesseractHelper {
    public static boolean isGeneratorOwnedByPlayer(EntityPlayer player, MTETesseractGenerator generator) {
        if (player == null) {
            Logger.WARNING("Failed. [isGeneratorOwnedByPlayer]");
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!GTPPCore.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, MTETesseractGenerator> generators = TesseractHelper.getGeneratorOwnershipByPlayer(player);
            Set<Map.Entry<Integer, MTETesseractGenerator>> players = generators.entrySet();
            for (Map.Entry<Integer, MTETesseractGenerator> current : players) {
                if (!current.getValue().equals(generator)) continue;
                return true;
            }
        }
        Logger.WARNING("Failed. [isGeneratorOwnedByPlayer]");
        return false;
    }

    public static boolean setGeneratorOwnershipByPlayer(EntityPlayer player, int freq, MTETesseractGenerator generator) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        Logger.WARNING("Setting Generator on " + freq + " for " + player.getDisplayName() + ".");
        if (playerIdentifier != null) {
            Map<Integer, MTETesseractGenerator> playerOwned = GTPPCore.sTesseractGeneratorOwnershipMap.get(playerIdentifier);
            if (playerOwned == null || playerOwned.isEmpty()) {
                HashMap<Integer, MTETesseractGenerator> newOwnershipMap = new HashMap<Integer, MTETesseractGenerator>();
                newOwnershipMap.put(freq, generator);
                GTPPCore.sTesseractGeneratorOwnershipMap.put(playerIdentifier, newOwnershipMap);
                Logger.WARNING("Success! [Empty Map]");
                return true;
            }
            if (GTPPCore.sTesseractGeneratorOwnershipMap.containsKey(playerIdentifier)) {
                Map<Integer, MTETesseractGenerator> ownershipMap = GTPPCore.sTesseractGeneratorOwnershipMap.get(playerIdentifier);
                if (!ownershipMap.containsKey(freq)) {
                    ownershipMap.put(freq, generator);
                }
                ownershipMap.put(freq, generator);
                GTPPCore.sTesseractGeneratorOwnershipMap.put(playerIdentifier, ownershipMap);
                Logger.WARNING("Success!");
                return true;
            }
        }
        Logger.WARNING("Failed. [setGeneratorOwnershipByPlayer]");
        return false;
    }

    public static MTETesseractGenerator getGeneratorByFrequency(EntityPlayer player, int freq) {
        if (player == null) {
            return null;
        }
        UUID playerIdentifier = player.func_110124_au();
        Logger.WARNING("Getting Generator on " + freq + " for " + player.getDisplayName() + ".");
        if (!GTPPCore.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, MTETesseractGenerator> generators = TesseractHelper.getGeneratorOwnershipByPlayer(player);
            Set<Map.Entry<Integer, MTETesseractGenerator>> players = generators.entrySet();
            for (Map.Entry<Integer, MTETesseractGenerator> current : players) {
                if (!current.getKey().equals(freq)) continue;
                Logger.WARNING("Success!");
                return current.getValue();
            }
        }
        Logger.WARNING("Failed. [getGeneratorByFrequency]");
        return null;
    }

    public static boolean removeGenerator(EntityPlayer player, int frequency) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!GTPPCore.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            GTPPCore.sTesseractGeneratorOwnershipMap.get(playerIdentifier).remove(frequency);
            return true;
        }
        return false;
    }

    public static boolean isTerminalOwnedByPlayer(EntityPlayer player, MTETesseractTerminal generator) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!GTPPCore.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, MTETesseractTerminal> generators = TesseractHelper.getTerminalOwnershipByPlayer(player);
            Set<Map.Entry<Integer, MTETesseractTerminal>> players = generators.entrySet();
            for (Map.Entry<Integer, MTETesseractTerminal> current : players) {
                if (!current.getValue().equals(generator)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean setTerminalOwnershipByPlayer(EntityPlayer player, int freq, MTETesseractTerminal generator) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (playerIdentifier != null) {
            Logger.WARNING("Setting Terminal on " + freq + " for " + player.getDisplayName() + ".");
            Map<Integer, MTETesseractTerminal> playerOwned = GTPPCore.sTesseractTerminalOwnershipMap.get(playerIdentifier);
            if (playerOwned == null || playerOwned.isEmpty()) {
                HashMap<Integer, MTETesseractTerminal> newOwnershipMap = new HashMap<Integer, MTETesseractTerminal>();
                newOwnershipMap.put(freq, generator);
                GTPPCore.sTesseractTerminalOwnershipMap.put(playerIdentifier, newOwnershipMap);
                Logger.WARNING("Success! [Empty Map]");
                return true;
            }
            if (GTPPCore.sTesseractTerminalOwnershipMap.containsKey(playerIdentifier)) {
                Map<Integer, MTETesseractTerminal> ownershipMap = GTPPCore.sTesseractTerminalOwnershipMap.get(playerIdentifier);
                if (!ownershipMap.containsKey(freq)) {
                    ownershipMap.put(freq, generator);
                }
                GTPPCore.sTesseractTerminalOwnershipMap.put(playerIdentifier, ownershipMap);
                Logger.WARNING("Success!");
                return true;
            }
        }
        Logger.WARNING("Failed. [setTerminalOwnershipByPlayer]");
        return false;
    }

    public static MTETesseractTerminal getTerminalByFrequency(EntityPlayer player, int freq) {
        if (player == null) {
            return null;
        }
        UUID playerIdentifier = player.func_110124_au();
        Logger.WARNING("Getting Terminal on " + freq + " for " + player.getDisplayName() + ".");
        if (!GTPPCore.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, MTETesseractTerminal> generators = TesseractHelper.getTerminalOwnershipByPlayer(player);
            Set<Map.Entry<Integer, MTETesseractTerminal>> players = generators.entrySet();
            for (Map.Entry<Integer, MTETesseractTerminal> current : players) {
                if (!current.getKey().equals(freq)) continue;
                Logger.WARNING("Success!");
                return current.getValue();
            }
        }
        Logger.WARNING("Failed. [getTerminalByFrequency]");
        return null;
    }

    public static boolean removeTerminal(EntityPlayer player, int frequency) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!GTPPCore.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            GTPPCore.sTesseractTerminalOwnershipMap.get(playerIdentifier).remove(frequency);
            return true;
        }
        return false;
    }

    private static Map<Integer, MTETesseractGenerator> getGeneratorOwnershipByPlayer(EntityPlayer player) {
        UUID playerIdentifier = player.func_110124_au();
        if (!GTPPCore.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            Set<Map.Entry<UUID, Map<Integer, MTETesseractGenerator>>> players = GTPPCore.sTesseractGeneratorOwnershipMap.entrySet();
            for (Map.Entry<UUID, Map<Integer, MTETesseractGenerator>> current : players) {
                if (current.getKey().compareTo(playerIdentifier) != 0) continue;
                return current.getValue();
            }
        }
        return null;
    }

    private static Map<Integer, MTETesseractTerminal> getTerminalOwnershipByPlayer(EntityPlayer player) {
        UUID playerIdentifier = player.func_110124_au();
        if (!GTPPCore.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            Set<Map.Entry<UUID, Map<Integer, MTETesseractTerminal>>> players = GTPPCore.sTesseractTerminalOwnershipMap.entrySet();
            for (Map.Entry<UUID, Map<Integer, MTETesseractTerminal>> current : players) {
                if (current.getKey().compareTo(playerIdentifier) != 0) continue;
                return current.getValue();
            }
        }
        return null;
    }
}

