/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.fluids.GTPPFluids;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoaderRocketFuels {
    public static void generate() {
        RecipeLoaderRocketFuels.createKerosene();
        RecipeLoaderRocketFuels.createRP1();
        RecipeLoaderRocketFuels.createNitrogenTetroxide();
        RecipeLoaderRocketFuels.createHydrazine();
        RecipeLoaderRocketFuels.createMonomethylhydrazine();
        RecipeLoaderRocketFuels.createLOH();
        RecipeLoaderRocketFuels.createHydratedAmmoniumNitrateSlurry();
        RecipeLoaderRocketFuels.createAmmoniumNitrateDust();
        RecipeLoaderRocketFuels.createFormaldehyde();
        RecipeLoaderRocketFuels.createFormaldehydeCatalyst();
        RecipeLoaderRocketFuels.createUnsymmetricalDimethylhydrazine();
        RecipeLoaderRocketFuels.createRocketFuels();
        RecipeLoaderRocketFuels.addRocketFuelsToMap();
    }

    private static void createKerosene() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(23)).fluidInputs(Materials.Fuel.getFluid(250L)).fluidOutputs(new FluidStack(GTPPFluids.Kerosene, 150)).duration(16).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.distilleryRecipes);
    }

    private static void createRP1() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(23)).fluidInputs(new FluidStack(GTPPFluids.Kerosene, 20)).fluidOutputs(new FluidStack(GTPPFluids.RP1, 15)).duration(16).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.distilleryRecipes);
    }

    private static void createNitrogenTetroxide() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Copper.getDust(1), GregtechItemList.OrangeMetalCatalyst.get(0L, new Object[0])).itemOutputs(Materials.CupricOxide.getDust(2)).fluidInputs(Materials.NitricAcid.getFluid(2000L)).fluidOutputs(new FluidStack(GTPPFluids.NitrogenTetroxide, 1000)).duration(600).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void createHydrazine() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(21)).fluidInputs(new FluidStack(GTPPFluids.HydrogenPeroxide, 1000), Materials.Ammonia.getGas(2000L)).fluidOutputs(new FluidStack(GTPPFluids.Hydrazine, 1000)).duration(600).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void createMonomethylhydrazine() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(21), Materials.Carbon.getDust(1)).fluidInputs(Materials.Hydrogen.getGas(2000L), new FluidStack(GTPPFluids.Hydrazine, 1000)).fluidOutputs(new FluidStack(GTPPFluids.Monomethylhydrazine, 1000)).duration(960).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void createLOH() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Hydrogen.getCells(1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellLiquidHydrogen", 1)).duration(320).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
    }

    private static void createHydratedAmmoniumNitrateSlurry() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(21)).fluidInputs(Materials.Ammonia.getGas(4000L), Materials.NitricAcid.getFluid(4000L)).fluidOutputs(new FluidStack(GTPPFluids.HydratedAmmoniumNitrateSlurry, 5184)).duration(1200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void createAmmoniumNitrateDust() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8)).itemOutputs(GregtechItemList.AmmoniumNitrateDust.get(8L, new Object[0])).fluidInputs(new FluidStack(GTPPFluids.HydratedAmmoniumNitrateSlurry, 1152)).fluidOutputs(Materials.Water.getFluid(2000L)).eut(TierEU.RECIPE_HV).duration(1800).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    private static void createFormaldehyde() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(21), GregtechItemList.FormaldehydeCatalyst.get(0L, new Object[0])).fluidInputs(Materials.Oxygen.getGas(32000L), Materials.Methanol.getFluid(32000L)).fluidOutputs(new FluidStack(GTPPFluids.Formaldehyde, 32000)).duration(1800).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void createFormaldehydeCatalyst() {
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Iron, 16L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Vanadium, 1L), GTUtility.getIntegratedCircuit(18)).itemOutputs(GregtechItemList.FormaldehydeCatalystDust.get(4L, new Object[0])).duration(160).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
    }

    private static void createUnsymmetricalDimethylhydrazine() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(21), GregtechItemList.FormaldehydeCatalyst.get(0L, new Object[0])).fluidInputs(new FluidStack(GTPPFluids.Hydrazine, 2000), new FluidStack(GTPPFluids.Formaldehyde, 2000), Materials.Hydrogen.getGas(4000L)).fluidOutputs(Materials.Dimethylhydrazine.getFluid(2000L), Materials.Water.getFluid(2000L)).duration(1200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void addRocketFuelsToMap() {
        RecipeLoaderRocketFuels.addFuelRecipe(GTPPFluids.RP1RocketFuel, 512);
        RecipeLoaderRocketFuels.addFuelRecipe(GTPPFluids.DenseHydrazineFuelMixture, 1024);
        RecipeLoaderRocketFuels.addFuelRecipe(GTPPFluids.CN3H7O3RocketFuel, 2048);
        RecipeLoaderRocketFuels.addFuelRecipe(GTPPFluids.H8N4C2O4RocketFuel, 4196);
    }

    private static void addFuelRecipe(Fluid fluid, int fuelValue) {
        GTPPRecipeMaps.rocketFuels.add(new GTRecipe(true, GTValues.emptyItemStackArray, GTValues.emptyItemStackArray, null, GTValues.emptyIntArray, new FluidStack[]{new FluidStack(fluid, 1000)}, GTValues.emptyFluidStackArray, 0, 0, fuelValue));
    }

    private static void createRocketFuels() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.LiquidOxygen.getGas(2000L), new FluidStack(GTPPFluids.RP1, 500)).fluidOutputs(new FluidStack(GTPPFluids.RP1RocketFuel, 1500)).duration(300).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2)).fluidInputs(new FluidStack(GTPPFluids.Hydrazine, 4000), Materials.Methanol.getFluid(6000L)).fluidOutputs(new FluidStack(GTPPFluids.DenseHydrazineFuelMixture, 10000)).duration(600).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 4).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3)).fluidInputs(new FluidStack(GTPPFluids.Monomethylhydrazine, 2000), Materials.NitricAcid.getFluid(1000L)).fluidOutputs(new FluidStack(GTPPFluids.CN3H7O3RocketFuel, 2000)).duration(900).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 5).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4)).fluidInputs(Materials.Dimethylhydrazine.getFluid(2000L), new FluidStack(GTPPFluids.NitrogenTetroxide, 2000)).fluidOutputs(new FluidStack(GTPPFluids.H8N4C2O4RocketFuel, 5000)).duration(1200).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 6).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }
}

