/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.io.Serializable;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPos
implements Serializable {
    private static final long serialVersionUID = -7271947491316682006L;
    public final int xPos;
    public final int yPos;
    public final int zPos;
    public final int dim;

    @NotNull
    public static BlockPos generateBlockPos(@NotNull String sUUID) {
        String[] s2 = sUUID.split("@");
        return new BlockPos(s2);
    }

    public BlockPos(String @NotNull [] s) {
        this(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[0]));
    }

    public BlockPos(int x, int y, int z, int dim) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.dim = dim;
    }

    public BlockPos(int x, int y, int z, @Nullable World world) {
        this(x, y, z, world == null ? 0 : world.field_73011_w.field_76574_g);
    }

    public BlockPos(@NotNull IGregTechTileEntity b) {
        this(b.getXCoord(), (int)b.getYCoord(), b.getZCoord(), b.getWorld());
    }

    @NotNull
    public String getLocationString() {
        return "[X: " + this.xPos + "][Y: " + this.yPos + "][Z: " + this.zPos + "][Dim: " + this.dim + "]";
    }

    @NotNull
    public String getUniqueIdentifier() {
        return this.dim + "@" + this.xPos + "@" + this.yPos + "@" + this.zPos;
    }

    public int hashCode() {
        int hash = 5;
        hash += 13 * this.xPos;
        hash += 19 * this.yPos;
        hash += 31 * this.zPos;
        return hash += 17 * this.dim;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof BlockPos)) {
            return false;
        }
        BlockPos otherPoint = (BlockPos)other;
        return this.xPos == otherPoint.xPos && this.yPos == otherPoint.yPos && this.zPos == otherPoint.zPos && this.dim == otherPoint.dim;
    }

    @NotNull
    public BlockPos getUp() {
        return new BlockPos(this.xPos, this.yPos + 1, this.zPos, this.dim);
    }
}

