/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import gregtech.common.tileentities.machines.multi.purification.MTEHatchPHSensor;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTEPurificationUnitPhAdjustment
extends MTEPurificationUnitBase<MTEPurificationUnitPhAdjustment>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int STRUCTURE_X_OFFSET = 7;
    private static final int STRUCTURE_Y_OFFSET = 4;
    private static final int STRUCTURE_Z_OFFSET = 1;
    private static final String[][] structure = new String[][]{{"E   E     E   E", "EAAAE     EAAAE", "EAGAE     EAHAE", "EAGAE     EAHAE", "EAGAE     EAHAE", "EAAAE     EAAAE"}, {" AAA       AAA ", "A   A     A   A", "A   A     A   A", "A   A     A   A", "A   ABB~BBA   A", "AAAAA     AAAAA"}, {" AXA       AYA ", "A   A     A   A", "G   A     A   H", "G   ABBBBBA   H", "G             H", "AAAAABRBRBAAAAA"}, {" AAA       AAA ", "A   A     A   A", "A   A     A   A", "A   A     A   A", "A   AIIIIIA   A", "AAAAA     AAAAA"}, {"E   E     E   E", "EAAAE     EAAAE", "EAGAE     EAHAE", "EAGAE     EAHAE", "EAGAE     EAHAE", "EAAAE     EAAAE"}};
    private static final int CASING_INDEX_MIDDLE = MTEPurificationUnitPhAdjustment.getTextureIndex(GregTechAPI.sBlockCasings9, 7);
    private static final int CASING_INDEX_TOWER = MTEPurificationUnitPhAdjustment.getTextureIndex(GregTechAPI.sBlockCasings9, 8);
    private float currentpHValue = 0.0f;
    private static final int CONSUME_INTERVAL = 20;
    private static final float INITIAL_PH_DEVIATION = 2.5f;
    private static final float PH_NEUTRAL_VALUE = 7.0f;
    private static final float PH_MAX_DEVIATION = 0.05f;
    public static final float PH_PER_ALKALINE_DUST = 0.01f;
    public static final float PH_PER_10_ACID_LITER = -0.01f;
    public static final Materials ALKALINE_MATERIAL = Materials.SodiumHydroxide;
    public static final Materials ACIDIC_MATERIAL = Materials.HydrochloricAcid;
    private MTEHatchInput acidInputHatch;
    private MTEHatchInputBus alkalineInputBus;
    private final ArrayList<MTEHatchPHSensor> sensorHatches = new ArrayList();
    private static final IStructureDefinition<MTEPurificationUnitPhAdjustment> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)8)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)7)).addElement('E', GTStructureUtility.ofFrame(Materials.NaquadahAlloy)).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)0)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)0)).addElement('I', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).dot(1).casingIndex(CASING_INDEX_MIDDLE).build()), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)7)})).addElement('R', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(SpecialHatchElement.PhSensor).dot(2).cacheHint(() -> "pH Sensor Hatch").casingIndex(CASING_INDEX_MIDDLE).build()), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)7)})).addElement('X', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(HatchElement.InputBus).dot(3).adder(MTEPurificationUnitPhAdjustment::addAlkalineBusToMachineList).cacheHint(() -> "Input Bus (" + MTEPurificationUnitPhAdjustment.ALKALINE_MATERIAL.mLocalizedName + ")").casingIndex(CASING_INDEX_TOWER).allowOnly(ForgeDirection.UP).build())).addElement('Y', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(HatchElement.InputHatch).dot(4).adder(MTEPurificationUnitPhAdjustment::addAcidHatchToMachineList).cacheHint(() -> "Input Hatch (" + MTEPurificationUnitPhAdjustment.ACIDIC_MATERIAL.mLocalizedName + ")").casingIndex(CASING_INDEX_TOWER).allowOnly(ForgeDirection.UP).build())).build();

    private List<IHatchElement<? super MTEPurificationUnitPhAdjustment>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.OutputHatch);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MIDDLE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MIDDLE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MIDDLE)};
    }

    public MTEPurificationUnitPhAdjustment(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationUnitPhAdjustment(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitPhAdjustment(this.mName);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 4, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 4, 1, elementBudget, env, true);
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitPhAdjustment> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationPhAdjustmentRecipes;
    }

    public boolean addAcidHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = null;
            this.acidInputHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addAlkalineBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInputBus)aMetaTileEntity).mRecipeMap = null;
            this.alkalineInputBus = (MTEHatchInputBus)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addSensorHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchPHSensor) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.sensorHatches.add((MTEHatchPHSensor)aMetaTileEntity);
        }
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work.").addSeparator().addInfo("Initial pH value every cycle varies from " + EnumChatFormatting.RED + 4.5f + EnumChatFormatting.GRAY + " - " + EnumChatFormatting.RED + 9.5f + " pH" + EnumChatFormatting.GRAY + ".").addInfo("If the pH value is within " + EnumChatFormatting.RED + 0.05f + " pH " + EnumChatFormatting.GRAY + "of 7.0 pH at the end of the cycle, the recipe always succeeds.").addInfo("Otherwise, the recipe always fails.").addInfo("Use a pH Sensor Hatch to read the current pH value.").addInfo("For safety, the machine will shut down if the pH goes below 0 or exceeds 14.").addSeparator().addInfo("Every " + EnumChatFormatting.RED + 20 + EnumChatFormatting.GRAY + " ticks, consumes ALL " + EnumChatFormatting.WHITE + MTEPurificationUnitPhAdjustment.ALKALINE_MATERIAL.mLocalizedName + EnumChatFormatting.GRAY + " and " + EnumChatFormatting.WHITE + MTEPurificationUnitPhAdjustment.ACIDIC_MATERIAL.mLocalizedName + EnumChatFormatting.GRAY + " in the special hatches.").addInfo(EnumChatFormatting.RED + "Raises " + EnumChatFormatting.GRAY + "the pH value by " + EnumChatFormatting.RED + 0.01f + " pH " + EnumChatFormatting.GRAY + "per piece of " + EnumChatFormatting.WHITE + ALKALINE_MATERIAL.getDust(1).func_82833_r() + EnumChatFormatting.GRAY + ".").addInfo(EnumChatFormatting.RED + "Lowers " + EnumChatFormatting.GRAY + "the pH value by " + EnumChatFormatting.RED + 0.01f + " pH " + EnumChatFormatting.GRAY + "per " + EnumChatFormatting.RED + "10L " + EnumChatFormatting.GRAY + "of " + EnumChatFormatting.WHITE + ACIDIC_MATERIAL.getFluid(1L).getLocalizedName() + EnumChatFormatting.GRAY + ".").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "The fourth step of water purification is to neutralize the solution and bring its pH to exactly 7, rendering").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "the solution inert with no hydrogen ion activity beyond water\u2019s natural amphiproticity. Acids and bases from soils").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "and geology cause natural alkalinity variations in water which can cause corrosive reactions with sensitive").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "materials. This necessitates the use of the corresponding neutralizing agents to pH balance the water.").beginStructureBlock(7, 4, 7, false).addController("Front center").addCasingInfoExactlyColored("Stabilized Naquadah Water Plant Casing", EnumChatFormatting.GRAY, 16, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Chemical Grade Glass", EnumChatFormatting.GRAY, 18, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Naquadah Alloy Frame Box", EnumChatFormatting.GRAY, 48, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Inert Neutralization Water Plant Casing", EnumChatFormatting.GRAY, 134, EnumChatFormatting.GOLD, false).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.input_hatch_water"), EnumChatFormatting.GOLD + "1+", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.output_hatch"), EnumChatFormatting.GOLD + "1", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.ph_sensor_hatch"), EnumChatFormatting.GOLD + "2", 2).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.input_bus_sodium_hydroxide"), EnumChatFormatting.GOLD + "1", 3).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.input_hatch_hydrochloric_acid"), EnumChatFormatting.GOLD + "1", 4).toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public void startCycle(int cycleTime, int progressTime) {
        super.startCycle(cycleTime, progressTime);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int RNG_PRECISION = 1000;
        int rng = random.nextInt(-1000, 1000);
        float deviation = (float)rng / 1000.0f * 2.5f;
        this.currentpHValue = (float)Math.round((7.0f + deviation) * 100.0f) / 100.0f;
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (this.mMaxProgresstime > 0 && aTick % 20L == 0L) {
            long totalAlkalineDrained = 0L;
            for (int i = this.alkalineInputBus.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack stack = this.alkalineInputBus.func_70301_a(i);
                if (stack == null || !stack.func_77969_a(ALKALINE_MATERIAL.getDust(1))) continue;
                totalAlkalineDrained += (long)stack.field_77994_a;
                this.alkalineInputBus.func_70298_a(i, stack.field_77994_a);
            }
            FluidStack stack = this.acidInputHatch.getDrainableStack();
            int numMultiples = 0;
            if (stack != null && stack.isFluidEqual(ACIDIC_MATERIAL.getFluid(1L))) {
                int acidAvailable = stack.amount;
                numMultiples = Math.floorDiv(acidAvailable, 10);
                this.acidInputHatch.drain(acidAvailable, true);
            } else {
                Fluid acid = FluidRegistry.getFluid((String)"fluoroantimonic acid");
                if (stack == null || stack.getFluid().equals(acid)) {
                    // empty if block
                }
            }
            this.currentpHValue = this.currentpHValue + (float)totalAlkalineDrained * 0.01f + (float)numMultiples * -0.01f;
            this.currentpHValue = Math.min(Math.max(this.currentpHValue, 0.0f), 14.0f);
            this.currentpHValue = (float)Math.round(this.currentpHValue * 100.0f) / 100.0f;
            if ((double)Math.abs(this.currentpHValue) < 0.001 || (double)Math.abs(this.currentpHValue - 14.0f) < 0.001) {
                this.stopMachine(SimpleShutDownReason.ofNormal("critical_ph_value"));
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        for (MTEHatchPHSensor hatch : this.sensorHatches) {
            hatch.updateRedstoneOutput(this.currentpHValue);
        }
    }

    @Override
    public float calculateFinalSuccessChance() {
        float distance = Math.abs(this.currentpHValue - 7.0f);
        if (distance <= 0.05f) {
            return 100.0f;
        }
        return 0.0f;
    }

    @Override
    public int getWaterTier() {
        return 4;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_ZPM;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 4, 1)) {
            return false;
        }
        if (this.acidInputHatch == null || this.alkalineInputBus == null) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> infoData = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        infoData.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_ph_adjustment.ph", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.currentpHValue}));
        return infoData.toArray(new String[0]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74776_a("mCurrentpH", this.currentpHValue);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.currentpHValue = aNBT.func_74760_g("mCurrentpH");
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_PURIFICATION_PH_LOOP;
    }

    private static enum SpecialHatchElement implements IHatchElement<MTEPurificationUnitPhAdjustment>
    {
        PhSensor(MTEPurificationUnitPhAdjustment::addSensorHatchToMachineList, new Class[]{MTEHatchPHSensor.class}){

            @Override
            public long count(MTEPurificationUnitPhAdjustment gtMetaTileEntityPurificationUnitPhAdjustment) {
                return gtMetaTileEntityPurificationUnitPhAdjustment.sensorHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEPurificationUnitPhAdjustment> adder;

        @SafeVarargs
        private SpecialHatchElement(IGTHatchAdder<MTEPurificationUnitPhAdjustment> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEPurificationUnitPhAdjustment> adder() {
            return this.adder;
        }
    }
}

