/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings2;
import gregtech.common.misc.GTStructureChannels;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTEMultiLathe
extends MTEExtendedPowerMultiBlockBase<MTEMultiLathe>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_BODY = "body";
    private static final String STRUCTURE_PIECE_BODY_ALT = "body_alt";
    protected int pipeTier = -1;
    private static final IStructureDefinition<MTEMultiLathe> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       "}, {"       "}, {"       "}, {"       "}, {"AAA~AAA"}})).addShape("body", StructureUtility.transpose((String[][])new String[][]{{"       ", "AAAAAAA", "       ", "       "}, {"ABCCCCA", "ABCCCCA", "ABCCCCA", "       "}, {"ABCCCCA", "ABFFFFA", "ABCCCCA", "       "}, {"ABCCCCA", "ABCCCCA", "ABCCCCA", "       "}, {"AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA"}})).addShape("body_alt", StructureUtility.transpose((String[][])new String[][]{{"       ", "AAAAAAA", "       ", "       "}, {"ACCCCBA", "ACCCCBA", "ACCCCBA", "       "}, {"ACCCCBA", "AFFFFBA", "ACCCCBA", "       "}, {"ACCCCBA", "ACCCCBA", "ACCCCBA", "       "}, {"AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA"}})).addElement('A', GTStructureUtility.buildHatchAdder(MTEMultiLathe.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEMultiLathe::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)))).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('C', GTStructureUtility.chainAllGlasses()).addElement('F', GTStructureChannels.ITEM_PIPE_CASING.use(StructureUtility.ofBlocksTiered(MTEMultiLathe::getTierFromMeta, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)0), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)1), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)3), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)4), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)5), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)6), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)7)), (Object)-1, MTEMultiLathe::setPipeTier, MTEMultiLathe::getPipeTier))).build();
    private int mCasingAmount;
    private static final DecimalFormat dfNone = new DecimalFormat("#");

    public MTEMultiLathe(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMultiLathe(String aName) {
        super(aName);
    }

    @Nullable
    private static Integer getTierFromMeta(Block block, Integer metaID) {
        if (block != GregTechAPI.sBlockCasings11) {
            return null;
        }
        if (metaID < 0 || metaID > 7) {
            return null;
        }
        return metaID + 1;
    }

    private void setPipeTier(int tier) {
        this.pipeTier = tier;
    }

    private int getPipeTier() {
        return this.pipeTier;
    }

    @Override
    public IStructureDefinition<MTEMultiLathe> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiLathe(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings2, 0)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_LATHE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_LATHE_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings2, 0)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_LATHE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_LATHE_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings2, 0))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Lathe, IPL").addInfo("300% faster than using single block machines of the same voltage").addInfo("Gains 8 parallel per Pipe Casing Tier").addInfo("Only uses 80% of the EU/t normally required.").beginStructureBlock(7, 5, 5, true).addController("Front Center").addCasingInfoMin("Solid Steel Machine Casing", 42, false).addCasingInfoExactly("Grate Machine Casing", 9, false).addCasingInfoExactly("Any Tiered Glass", 32, false).addInputBus("Any Solid Steel Casing", 1).addOutputBus("Any Solid Steel Casing", 1).addEnergyHatch("Any Solid Steel Casing", 1).addMaintenanceHatch("Any Solid Steel Casing", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.four_item_pipe_casings"), "Center of the glass", 4).addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.ITEM_PIPE_CASING).toolTipFinisher(GTValues.AuthorVolence);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 4, 0);
        this.buildPiece(STRUCTURE_PIECE_BODY, stackSize, hintsOnly, 3, 4, -1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 4, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        build = this.survivalBuildPiece(STRUCTURE_PIECE_BODY, stackSize, 3, 4, -1, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        build = this.survivalBuildPiece(STRUCTURE_PIECE_BODY_ALT, stackSize, 3, 4, -1, elementBudget, env, false, true);
        return build;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_LATHE_LOOP;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.pipeTier = -1;
        this.mEnergyHatches.clear();
        this.mCasingAmount = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 4, 0)) {
            return false;
        }
        this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
        if (!this.checkPiece(STRUCTURE_PIECE_BODY, 3, 4, -1) && !this.checkPiece(STRUCTURE_PIECE_BODY_ALT, 3, 4, -1)) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1 && this.pipeTier > 0 && !this.mEnergyHatches.isEmpty() && this.mCasingAmount >= 42;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().noRecipeCaching().setSpeedBonus(0.25).setEuModifier(0.8f).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.getPipeTier() * 8;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("itemPipeTier", Math.max(0, this.getPipeTier()));
        tag.func_74776_a("speedBonus", 400.0f);
        tag.func_74776_a("getMaxParallelRecipes", (float)Math.max(0, this.getMaxParallelRecipes()));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.itemPipeTier") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("itemPipeTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + dfNone.format(Math.max(0.0f, tag.func_74760_g("getMaxParallelRecipes"))));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.speed") + ": " + EnumChatFormatting.WHITE + dfNone.format(Math.max(0, tag.func_74762_e("speedBonus"))) + "%");
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.latheRecipes;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

