/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.casing.Casings;
import gregtech.api.casing.ICasing;
import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.ISuperChestAcceptor;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.structure.StructureWrapperInstanceInfo;
import gregtech.api.structure.StructureWrapperTooltipBuilder;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class MTEDecayWarehouse
extends MTEExtendedPowerMultiBlockBase<MTEDecayWarehouse>
implements ISurvivalConstructable,
IStructureProvider<MTEDecayWarehouse>,
ISuperChestAcceptor {
    private static final int MODE_NORMAL = 0;
    private static final int MODE_EXPORT = 1;
    public static final double EPSILON = 1.0E-5;
    public static final long EU_PER_IO = 512L;
    public static final int CAPACITY_DIVISOR = 400;
    protected final StructureWrapper<MTEDecayWarehouse> structure;
    protected final StructureWrapperInstanceInfo<MTEDecayWarehouse> structureInstanceInfo;
    private ItemStack isotope;
    private ItemStack product;
    private double storedIsotope;
    private double storedProduct;
    private double decayRate;
    private GTRecipe currentRecipe;
    private final ArrayList<ItemStack> pendingInputs = new ArrayList();
    private MTEDigitalChestBase superChest;

    public MTEDecayWarehouse(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.structure = new StructureWrapper<MTEDecayWarehouse>(this);
        this.structureInstanceInfo = null;
        this.structure.loadStructure();
    }

    protected MTEDecayWarehouse(MTEDecayWarehouse prototype) {
        super(prototype.mName);
        this.structure = prototype.structure;
        this.structureInstanceInfo = new StructureWrapperInstanceInfo<MTEDecayWarehouse>(this.structure);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity igte) {
        return new MTEDecayWarehouse(this);
    }

    @Override
    public String[][] getDefinition() {
        return new String[][]{{"BBBBB", "BB~BB", "BBBBB"}, {"BCCCB", "BCCCB", "BBBBB"}, {"BCCCB", "BCACB", "BBBBB"}, {"BCCCB", "BCCCB", "BBBBB"}, {"BBBBB", "BBBBB", "BBBBB"}};
    }

    @Override
    public IStructureDefinition<MTEDecayWarehouse> compile(String[][] def) {
        this.structure.addCasing('A', Casings.SuperChest).withChannel(GTStructureChannels.SUPER_CHEST);
        this.structure.addCasing('B', Casings.RadiationProofMachineCasing).withHatches(1, 8, Arrays.asList(HatchElement.Maintenance, HatchElement.Energy, HatchElement.InputBus, HatchElement.OutputBus));
        this.structure.addCasing('C', ICasing.ofBlock((ImmutableBlockMeta)new BlockMeta(Blocks.field_150355_j, 0))).wrapElement(GTStructureUtility::noSurvivalAutoplace);
        return this.structure.buildStructure(def);
    }

    @Override
    public boolean onSuperChestAdded(ICasingGroup group, MTEDigitalChestBase chest, int tier) {
        this.superChest = chest;
        return true;
    }

    @Override
    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        this.structureInstanceInfo.validate(errors, context);
    }

    @Override
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        this.structureInstanceInfo.localizeStructureErrors(errors, context, lines);
    }

    @Override
    public IStructureInstance<MTEDecayWarehouse> getStructureInstance() {
        return this.structureInstanceInfo;
    }

    @Override
    public IStructureDefinition<MTEDecayWarehouse> getStructureDefinition() {
        return this.structure.structureDefinition;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.structureInstanceInfo.clearHatches();
        this.superChest = null;
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        this.structure.construct(this, trigger, hintsOnly);
    }

    public int survivalConstruct(ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.structure.survivalConstruct(this, trigger, elementBudget, env);
        if (built == -1) {
            GTUtility.sendChatToPlayer(env.getActor(), EnumChatFormatting.GREEN + "Auto placing done! Now go place the water yourself!");
        }
        return built;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structure.checkStructure(this);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        StructureWrapperTooltipBuilder<MTEDecayWarehouse> tt = new StructureWrapperTooltipBuilder<MTEDecayWarehouse>(this.structure);
        tt.addMachineType("Decay Warehouse").addInfo("Stores a single type of radioactive isotope and allows it to decay over time.").addInfo("Decay speed is dependent on the isotopes' half-lives (lower is faster).").addInfo("Isotopes decay regardless of whether the warehouse is on or powered.").addSeparator().addInfo("The warehouse's capacity equals the super chest's capacity divided by " + AnimatedTooltipHandler.BLUE + 400 + AnimatedTooltipHandler.GRAY + ".").addInfo("The warehouse will pull in up to " + AnimatedTooltipHandler.BLUE + "N / " + 512L + AnimatedTooltipHandler.GRAY + " items per second,").addInfo("where " + AnimatedTooltipHandler.BLUE + "N" + AnimatedTooltipHandler.GRAY + " is the warehouse's EU input (standard energy hatch rules).").addSeparator().addInfo("Right click the controller with a screwdriver to dump stored isotopes into the output bus.").addInfo("Right click the controller with a plunger to empty it.").addInfo("The warehouse's contents are " + AnimatedTooltipHandler.RED + AnimatedTooltipHandler.UNDERLINE + "voided" + AnimatedTooltipHandler.GRAY + " when the controller is broken.");
        tt.addSubChannelUsage(GTStructureChannels.SUPER_CHEST);
        tt.beginStructureBlock(true).addAllCasingInfo();
        tt.toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity igte, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        ArrayList<ITexture> textures = new ArrayList<ITexture>();
        textures.add(Casings.RadiationProofMachineCasing.getCasingTexture());
        if (side == facing) {
            textures.add(TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.DECAY_WAREHOUSE_BACKGROUND).extFacing().build());
            if (active) {
                textures.add(TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.DECAY_WAREHOUSE_GLOW).extFacing().glow().build());
            }
        }
        return textures.toArray(new ITexture[0]);
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_PACKAGER);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_UNPACKAGER);
    }

    @Override
    public String getMachineModeName() {
        return this.machineMode == 0 ? "Normal" : "Exporting";
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.isotopeDecay;
    }

    @Override
    public VoidingMode getDefaultVoidingMode() {
        return VoidingMode.VOID_NONE;
    }

    @Override
    public VoidingMode getVoidingMode() {
        return VoidingMode.VOID_NONE;
    }

    @Override
    public void setVoidingMode(VoidingMode mode) {
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (!this.mMachine) {
            this.decayRate = 0.0;
            return;
        }
        if (aTick % 20L != 0L) {
            return;
        }
        this.decayRate = 0.0;
        if (this.machineMode == 0 && this.currentRecipe != null) {
            double consumed;
            double halfLife = this.currentRecipe.getMetadataOrDefault(GTRecipeConstants.HALF_LIFE, 0.0);
            double ratio = Math.exp(-Math.log(2.0) / halfLife);
            this.decayRate = consumed = this.storedIsotope * (1.0 - ratio);
            this.storedIsotope -= consumed;
            this.storedProduct += consumed;
        }
        if (this.machineMode == 1) {
            if (this.storedIsotope < 1.0E-5) {
                this.isotope = null;
                this.storedIsotope = 0.0;
            }
            if (this.storedProduct < 1.0E-5) {
                this.product = null;
                this.storedProduct = 0.0;
            }
        }
    }

    @Override
    protected void outputAfterRecipe() {
        for (ItemStack pendingInput : this.pendingInputs) {
            if (!GTUtility.areStacksEqual(this.isotope, pendingInput, true)) continue;
            this.storedIsotope += (double)pendingInput.field_77994_a;
        }
        this.pendingInputs.clear();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity base, EntityPlayer player, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack tCurrentItem = player.field_71071_by.func_70448_g();
        if (tCurrentItem != null && tCurrentItem.func_77973_b() instanceof MetaGeneratedTool) {
            int[] aOreID;
            for (int id : aOreID = OreDictionary.getOreIDs((ItemStack)tCurrentItem)) {
                if (!OreDictionary.getOreName((int)id).equals("craftingToolPlunger")) continue;
                if (base.isServerSide()) {
                    this.isotope = null;
                    this.storedIsotope = 0.0;
                    this.product = null;
                    this.storedProduct = 0.0;
                    this.decayRate = 0.0;
                    this.currentRecipe = null;
                }
                GTUtility.sendSoundToPlayers(player.field_70170_p, SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, 1.0f, -1.0f, base.getXCoord(), (int)base.getYCoord(), base.getZCoord());
                return true;
            }
        }
        return super.onRightclick(base, player, side, aX, aY, aZ);
    }

    private int getWarehouseCapacity() {
        return this.superChest == null ? 0 : this.superChest.getItemCapacity() / 400;
    }

    private int getAvailableCapacity() {
        return MathHelper.func_76128_c((double)((double)this.getWarehouseCapacity() - this.storedIsotope - this.storedProduct));
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        int isotopeAmount;
        long availableEUt = this.mEnergyHatches.size() > 1 ? this.getMaxInputPower() : this.getMaxInputVoltage();
        int remainingIOQuota = GTUtility.safeInt(availableEUt / 512L, 0);
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 10000;
        this.lEUt = 0L;
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int productAmount = MathHelper.func_76128_c((double)(this.storedProduct + 1.0E-5));
        if (productAmount > 0 && remainingIOQuota > 0) {
            int toEject;
            ItemStack output = this.product.func_77946_l();
            output.field_77994_a = toEject = Math.min(productAmount, remainingIOQuota);
            this.addOutputPartial(output, true);
            int insertable = toEject - output.field_77994_a;
            if (insertable > 0) {
                output.field_77994_a = insertable;
                this.storedProduct -= (double)insertable;
                remainingIOQuota -= insertable;
                this.lEUt -= 512L * (long)insertable;
                outputs.add(output);
            }
        }
        if (this.machineMode == 1 && outputs.isEmpty() && remainingIOQuota > 0 && this.isotope != null && (isotopeAmount = MathHelper.func_76128_c((double)(this.storedIsotope + 1.0E-5))) > 0) {
            int toEject;
            ItemStack output = this.isotope.func_77946_l();
            output.field_77994_a = toEject = Math.min(isotopeAmount, remainingIOQuota);
            this.addOutputPartial(output, true);
            int insertable = toEject - output.field_77994_a;
            if (insertable > 0) {
                output.field_77994_a = insertable;
                this.storedIsotope -= (double)insertable;
                remainingIOQuota -= insertable;
                this.lEUt -= 512L * (long)insertable;
                outputs.add(output);
            }
        }
        this.mOutputItems = outputs.toArray(new ItemStack[0]);
        if (this.machineMode == 0 && Math.min(this.getAvailableCapacity(), remainingIOQuota) > 0) {
            ArrayList<ItemStack> inputs = this.getStoredInputs();
            if (this.isotope == null) {
                for (ItemStack input : inputs) {
                    GTRecipe recipe = this.getRecipeMap().findRecipeQuery().caching(false).items(input).find();
                    if (recipe == null || this.product != null && !GTUtility.areStacksEqual(this.product, recipe.mOutputs[0])) continue;
                    this.currentRecipe = recipe;
                    this.isotope = recipe.mInputs[0].func_77946_l();
                    this.product = recipe.mOutputs[0].func_77946_l();
                    break;
                }
            }
            for (ItemStack input : inputs) {
                if (!GTUtility.areStacksEqual(this.isotope, input, true)) continue;
                ItemStack toConsume = input.func_77946_l();
                toConsume.field_77994_a = Math.min(toConsume.field_77994_a, Math.min(this.getAvailableCapacity(), remainingIOQuota));
                if (!this.depleteInput(toConsume)) continue;
                this.pendingInputs.add(toConsume);
                this.lEUt -= 512L * (long)toConsume.field_77994_a;
                if ((remainingIOQuota -= toConsume.field_77994_a) > 0) continue;
                break;
            }
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.isotope != null) {
            aNBT.func_74782_a("isotope", (NBTBase)this.isotope.func_77955_b(new NBTTagCompound()));
            aNBT.func_74780_a("storedIsotope", this.storedIsotope);
        }
        if (this.product != null) {
            aNBT.func_74782_a("product", (NBTBase)this.product.func_77955_b(new NBTTagCompound()));
            aNBT.func_74780_a("storedProduct", this.storedProduct);
        }
        aNBT.func_74782_a("pendingInputs", (NBTBase)GTUtility.saveItemList(this.pendingInputs));
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isotope = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("isotope"));
        this.product = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("product"));
        this.storedIsotope = aNBT.func_74769_h("storedIsotope");
        this.storedProduct = aNBT.func_74769_h("storedProduct");
        this.pendingInputs.addAll(GTUtility.loadItemList(aNBT.func_150295_c("pendingInputs", 10)));
        GTRecipe recipe = this.getRecipeMap().findRecipeQuery().caching(false).items(this.isotope).find();
        if (recipe != null && GTUtility.areStacksEqual(recipe.mOutputs[0], this.product)) {
            this.currentRecipe = recipe;
        }
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }

    private String getDecayRate() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        if (this.decayRate > 1.0) {
            sb.append(GTUtility.formatNumbers(this.decayRate)).append("/s)");
        } else {
            sb.append(GTUtility.formatNumbers(1.0 / this.decayRate)).append("s/ea)");
        }
        return sb.toString();
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.storedIsotope, x -> {
            this.storedIsotope = x;
        }));
        screenElements.widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.storedProduct, x -> {
            this.storedProduct = x;
        }));
        screenElements.widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.decayRate, x -> {
            this.decayRate = x;
        }));
        screenElements.widget((Widget)new FakeSyncWidget.ItemStackSyncer(() -> this.isotope, x -> {
            this.isotope = x;
        }));
        screenElements.widget((Widget)new FakeSyncWidget.ItemStackSyncer(() -> this.product, x -> {
            this.product = x;
        }));
        screenElements.widget((Widget)TextWidget.localised((String)"GT5U.gui.text.contents", (Object[])new Object[0]));
        screenElements.widget(TextWidget.dynamicString(() -> GTUtility.translate("GT5U.gui.text.content-entry", this.isotope == null ? "" : this.isotope.func_82833_r(), GTUtility.formatNumbers(this.storedIsotope))).setTextAlignment(Alignment.CenterLeft).setEnabled(w -> this.isotope != null).setSize(179, 10));
        screenElements.widget(TextWidget.dynamicString(() -> GTUtility.translate("GT5U.gui.text.content-entry", this.product == null ? "" : this.product.func_82833_r(), GTUtility.formatNumbers(this.storedProduct))).setTextAlignment(Alignment.CenterLeft).setEnabled(w -> this.product != null).setSize(179, 10));
        screenElements.widget(TextWidget.dynamicString(() -> GTUtility.translate("GT5U.gui.text.decay-rate", GTUtility.formatNumbers(this.decayRate), this.getDecayRate())).setTextAlignment(Alignment.CenterLeft).setEnabled(w -> this.decayRate > 0.0).setSize(179, 10));
        screenElements.widget(TextWidget.localised((String)"GT5U.gui.text.nothing", (Object[])new Object[0]).setTextAlignment(Alignment.CenterLeft).setEnabled(w -> this.isotope == null && this.product == null).setSize(170, 10));
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Isotope: " + AnimatedTooltipHandler.GREEN + (this.isotope == null ? "None" : this.isotope.func_82833_r()));
        info.add("Product: " + AnimatedTooltipHandler.YELLOW + (this.product == null ? "None" : this.product.func_82833_r()));
        info.add("Isotope Amount: " + AnimatedTooltipHandler.GREEN + this.storedIsotope);
        info.add("Product Amount: " + AnimatedTooltipHandler.YELLOW + this.storedProduct);
        info.add("Decay Rate: " + AnimatedTooltipHandler.BLUE + this.decayRate);
        info.add("Capacity: " + AnimatedTooltipHandler.BLUE + this.getWarehouseCapacity());
        return info.toArray(new String[0]);
    }
}

