/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.recipes.FluidRecipe;
import com.glodblock.github.nei.recipes.extractor.GregTech5RecipeExtractor;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.HazardProtection;
import gregtech.api.hazards.HazardProtectionTooltip;
import gregtech.api.interfaces.IBlockOnWalkOver;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.net.GTPacketClientPreference;
import gregtech.api.objects.GTItemStack;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.util.ColorsMetadataSection;
import gregtech.api.util.ColorsMetadataSectionSerializer;
import gregtech.api.util.GTClientPreference;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTMusicSystem;
import gregtech.api.util.GTPlayedSound;
import gregtech.api.util.GTUtility;
import gregtech.client.BlockOverlayRenderer;
import gregtech.client.GTMouseEventHandler;
import gregtech.client.SeekingOggCodec;
import gregtech.client.capes.GTCapesLoader;
import gregtech.common.GTProxy;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.config.Client;
import gregtech.common.pollution.Pollution;
import gregtech.common.pollution.PollutionRenderer;
import gregtech.common.render.BlackholeRenderer;
import gregtech.common.render.DroneRender;
import gregtech.common.render.FlaskRenderer;
import gregtech.common.render.FluidDisplayStackRenderer;
import gregtech.common.render.GTRendererBlock;
import gregtech.common.render.GTRendererCasing;
import gregtech.common.render.LaserRenderer;
import gregtech.common.render.MetaGeneratedToolRenderer;
import gregtech.common.render.NanoForgeRenderer;
import gregtech.common.render.WormholeRenderer;
import gregtech.common.render.items.DataStickRenderer;
import gregtech.common.render.items.InfiniteSprayCanRenderer;
import gregtech.common.render.items.MetaGeneratedItemRenderer;
import gregtech.common.tileentities.debug.MTEAdvDebugStructureWriter;
import gregtech.common.tileentities.render.TileEntityBlackhole;
import gregtech.common.tileentities.render.TileEntityDrone;
import gregtech.common.tileentities.render.TileEntityLaser;
import gregtech.common.tileentities.render.TileEntityNanoForgeRenderer;
import gregtech.common.tileentities.render.TileEntityWormhole;
import gregtech.loaders.ExtraIcons;
import gregtech.loaders.misc.GTBees;
import gregtech.loaders.preload.GTPreLoad;
import gregtech.nei.NEIGTConfig;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;

public class GTClient
extends GTProxy {
    public final PollutionRenderer mPollutionRenderer = new PollutionRenderer();
    public KeyBinding shakeLockKey;
    private final List<Materials> mPosR;
    private final List<Materials> mPosG;
    private final List<Materials> mPosB;
    private final List<Materials> mPosA = Collections.emptyList();
    private final List<Materials> mNegR;
    private final List<Materials> mNegG;
    private final List<Materials> mNegB;
    private final List<Materials> mNegA = Collections.emptyList();
    private final List<Materials> mMoltenPosR;
    private final List<Materials> mMoltenPosG;
    private final List<Materials> mMoltenPosB;
    private final List<Materials> mMoltenPosA = Collections.emptyList();
    private final List<Materials> mMoltenNegR;
    private final List<Materials> mMoltenNegG;
    private final List<Materials> mMoltenNegB;
    private final List<Materials> mMoltenNegA = Collections.emptyList();
    private long mAnimationTick = 0L;
    private long afterSomeTime;
    private boolean mAnimationDirection = false;
    private GTClientPreference mPreference;
    private boolean mFirstTick = false;
    private int mReloadCount;
    private float renderTickTime;
    private int mTicksUntilNextCraftSound = 0;
    private boolean hideThings = false;
    private int changeDetected = 0;
    private boolean isRenderingWorld;
    private boolean isComputingPickBlock;
    private boolean heldItemForcesFullBlockBB;

    public GTClient() {
        this.mPosR = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mPosG = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mPosB = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mNegR = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegG = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegB = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mMoltenPosR = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mMoltenPosG = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mMoltenPosB = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mMoltenNegR = Collections.singletonList(Materials.InfusedEntropy);
        this.mMoltenNegG = Collections.singletonList(Materials.InfusedEntropy);
        this.mMoltenNegB = Collections.singletonList(Materials.InfusedEntropy);
    }

    @Override
    public boolean isClientSide() {
        return true;
    }

    @Override
    public EntityPlayer getThePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void onPreInitialization(FMLPreInitializationEvent event) {
        super.onPreInitialization(event);
        SoundSystemConfig.setNumberNormalChannels((int)Client.preference.maxNumSounds);
        MinecraftForge.EVENT_BUS.register((Object)new ExtraIcons());
        Minecraft.func_71410_x().func_110438_M().field_110621_c.func_110504_a((IMetadataSectionSerializer)new ColorsMetadataSectionSerializer(), ColorsMetadataSection.class);
        new Thread((Runnable)new GTCapesLoader(), "GT Cape Loader").start();
        this.mPreference = new GTClientPreference();
        Materials.initClient();
    }

    @Override
    public void onInitialization(FMLInitializationEvent event) {
        super.onInitialization(event);
        GTRendererBlock.register();
        GTRendererCasing.register();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDrone.class, (TileEntitySpecialRenderer)new DroneRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaser.class, (TileEntitySpecialRenderer)new LaserRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWormhole.class, (TileEntitySpecialRenderer)new WormholeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlackhole.class, (TileEntitySpecialRenderer)new BlackholeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityNanoForgeRenderer.class, (TileEntitySpecialRenderer)new NanoForgeRenderer());
        MetaGeneratedItemRenderer metaItemRenderer = new MetaGeneratedItemRenderer();
        for (MetaGeneratedItem metaGeneratedItem : MetaGeneratedItem.sInstances.values()) {
            metaItemRenderer.registerItem(metaGeneratedItem);
        }
        if (Mods.Forestry.isModLoaded()) {
            metaItemRenderer.registerItem(GTBees.combs);
        }
        MetaGeneratedToolRenderer metaToolRenderer = new MetaGeneratedToolRenderer();
        for (MetaGeneratedTool tItem : MetaGeneratedTool.sInstances.values()) {
            if (tItem == null) continue;
            MinecraftForgeClient.registerItemRenderer((Item)tItem, (IItemRenderer)metaToolRenderer);
        }
        FlaskRenderer flaskRenderer = new FlaskRenderer();
        MinecraftForgeClient.registerItemRenderer((Item)ItemList.VOLUMETRIC_FLASK.getItem(), (IItemRenderer)flaskRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)GregtechItemList.VOLUMETRIC_FLASK_8k.getItem(), (IItemRenderer)flaskRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)GregtechItemList.VOLUMETRIC_FLASK_32k.getItem(), (IItemRenderer)flaskRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)GregtechItemList.KLEIN_BOTTLE.getItem(), (IItemRenderer)flaskRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)ItemList.Display_Fluid.getItem(), (IItemRenderer)new FluidDisplayStackRenderer());
        MetaGeneratedItemRenderer.registerSpecialRenderer(ItemList.Tool_DataStick, new DataStickRenderer());
        MetaGeneratedItemRenderer.registerSpecialRenderer(ItemList.Spray_Color_Infinite, new InfiniteSprayCanRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new NEIGTConfig());
        MinecraftForge.EVENT_BUS.register((Object)this.mPollutionRenderer);
        FMLCommonHandler.instance().bus().register((Object)this.mPollutionRenderer);
        MinecraftForge.EVENT_BUS.register((Object)new GTMouseEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockOverlayRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new MTEAdvDebugStructureWriter.EventHandler());
        this.shakeLockKey = new KeyBinding("GTPacketInfiniteSpraycan.Action.TOGGLE_SHAKE_LOCK", 0, "Gregtech");
        ClientRegistry.registerKeyBinding((KeyBinding)this.shakeLockKey);
    }

    @Override
    public void onPostInitialization(FMLPostInitializationEvent event) {
        super.onPostInitialization(event);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager l) {
                GUIColorOverride.onResourceManagerReload();
                FallbackableSteamTexture.reload();
                CoverRegistry.reloadCoverColorOverrides();
            }
        });
        Pollution.onPostInitClient();
    }

    @Override
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        super.onLoadComplete(event);
        for (RecipeCategory category : RecipeCategory.ALL_RECIPE_CATEGORIES.values()) {
            if (!category.recipeMap.getFrontend().getNEIProperties().registerNEI) continue;
            FluidRecipe.addRecipeMap((String)category.unlocalizedName, (IRecipeExtractor)new GregTech5RecipeExtractor(category.unlocalizedName.equals("gt.recipe.scanner") || category.unlocalizedName.equals("gt.recipe.fakeAssemblylineProcess")));
        }
    }

    @Override
    @SubscribeEvent
    public void applyBlockWalkOverEffects(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityClientPlayerMP && entity.field_70122_E) {
            int tZ;
            int tY;
            int tX = MathHelper.func_76128_c((double)entity.field_70165_t);
            Block tBlock = entity.field_70170_p.func_147439_a(tX, tY = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72338_b - (double)0.001f)), tZ = MathHelper.func_76128_c((double)entity.field_70161_v));
            if (tBlock instanceof IBlockOnWalkOver) {
                ((IBlockOnWalkOver)tBlock).onWalkOver(entity, entity.field_70170_p, tX, tY, tZ);
            }
        } else {
            super.applyBlockWalkOverEffects(event);
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundSetupEvent event) {
        try {
            SoundSystemConfig.setCodec((String)"gt5oggseek", SeekingOggCodec.class);
        }
        catch (SoundSystemException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
        this.mFirstTick = true;
        ++this.mReloadCount;
        GTMusicSystem.ClientSystem.reset();
    }

    @Override
    public void reloadNEICache() {
        ++this.mReloadCount;
    }

    @Override
    public int getNEIReloadCount() {
        return this.mReloadCount;
    }

    @SubscribeEvent
    public void onPlayerTickEventClient(TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient() && aEvent.phase == TickEvent.Phase.END && !aEvent.player.field_70128_L) {
            if (this.mFirstTick) {
                this.mFirstTick = false;
                GTValues.NW.sendToServer(new GTPacketClientPreference(this.mPreference));
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    GTModHandler.removeAllIC2Recipes();
                }
            }
            ++this.afterSomeTime;
            if (this.afterSomeTime >= 100L) {
                this.afterSomeTime = 0L;
            }
            Iterator<Map.Entry<GTPlayedSound, Integer>> iterator = GTUtility.sPlayedSoundMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GTPlayedSound, Integer> tEntry = iterator.next();
                if (tEntry.getValue() < 0) {
                    iterator.remove();
                    continue;
                }
                tEntry.setValue(tEntry.getValue() - 1);
            }
            if (!GregTechAPI.mServerStarted) {
                GregTechAPI.mServerStarted = true;
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (Mods.GregTech.ID.equals(e.modID)) {
            this.mPreference = new GTClientPreference();
            GTPreLoad.loadClientConfig();
            if (e.isWorldRunning) {
                GTValues.NW.sendToServer(new GTPacketClientPreference(this.mPreference));
            }
        }
    }

    @SubscribeEvent
    public void receiveRenderEvent(RenderPlayerEvent.Pre aEvent) {
        if (GTUtility.getFullInvisibility(aEvent.entityPlayer)) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent aEvent) {
        if (aEvent.phase == TickEvent.Phase.END) {
            boolean newHideValue;
            --this.mTicksUntilNextCraftSound;
            GTMusicSystem.ClientSystem.tick();
            if (this.changeDetected > 0) {
                --this.changeDetected;
            }
            if ((newHideValue = GTClient.shouldHeldItemHideThings()) != this.hideThings) {
                this.hideThings = newHideValue;
                this.changeDetected = 5;
            }
            this.heldItemForcesFullBlockBB = GTClient.shouldHeldItemForceFullBlockBB();
            ++this.mAnimationTick;
            if (this.mAnimationTick % 50L == 0L) {
                this.mAnimationDirection = !this.mAnimationDirection;
            }
            int tDirection = this.mAnimationDirection ? 1 : -1;
            for (Materials tMaterial : this.mPosR) {
                tMaterial.mRGBa[0] = this.getSafeRGBValue(tMaterial.mRGBa[0], tDirection);
            }
            for (Materials tMaterial : this.mPosG) {
                tMaterial.mRGBa[1] = this.getSafeRGBValue(tMaterial.mRGBa[1], tDirection);
            }
            for (Materials tMaterial : this.mPosB) {
                tMaterial.mRGBa[2] = this.getSafeRGBValue(tMaterial.mRGBa[2], tDirection);
            }
            for (Materials tMaterial : this.mPosA) {
                tMaterial.mRGBa[3] = this.getSafeRGBValue(tMaterial.mRGBa[3], tDirection);
            }
            for (Materials tMaterial : this.mNegR) {
                tMaterial.mRGBa[0] = this.getSafeRGBValue(tMaterial.mRGBa[0], -tDirection);
            }
            for (Materials tMaterial : this.mNegG) {
                tMaterial.mRGBa[1] = this.getSafeRGBValue(tMaterial.mRGBa[1], -tDirection);
            }
            for (Materials tMaterial : this.mNegB) {
                tMaterial.mRGBa[2] = this.getSafeRGBValue(tMaterial.mRGBa[2], -tDirection);
            }
            for (Materials tMaterial : this.mNegA) {
                tMaterial.mRGBa[3] = this.getSafeRGBValue(tMaterial.mRGBa[3], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosR) {
                tMaterial.mMoltenRGBa[0] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[0], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosG) {
                tMaterial.mMoltenRGBa[1] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[1], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosB) {
                tMaterial.mMoltenRGBa[2] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[2], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosA) {
                tMaterial.mMoltenRGBa[3] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[3], tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegR) {
                tMaterial.mMoltenRGBa[0] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[0], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegG) {
                tMaterial.mMoltenRGBa[1] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[1], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegB) {
                tMaterial.mMoltenRGBa[2] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[2], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegA) {
                tMaterial.mMoltenRGBa[3] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[3], -tDirection);
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (HazardProtection.providesFullHazmatProtection(event.itemStack)) {
            this.addHazmatTooltip(event, HazardProtectionTooltip.FULL_PROTECTION_TRANSLATION_KEY);
            return;
        }
        TreeSet<Hazard> protections = new TreeSet<Hazard>();
        for (Hazard hazard : Hazard.values()) {
            if (!HazardProtection.protectsAgainstHazard(event.itemStack, hazard)) continue;
            protections.add(hazard);
        }
        if (protections.containsAll(HazardProtectionTooltip.CBRN_HAZARDS)) {
            protections.removeAll(HazardProtectionTooltip.CBRN_HAZARDS);
            this.addHazmatTooltip(event, HazardProtectionTooltip.CBRN_TRANSLATION_KEY);
        }
        if (protections.containsAll(HazardProtectionTooltip.TEMPERATURE_HAZARDS)) {
            protections.removeAll(HazardProtectionTooltip.TEMPERATURE_HAZARDS);
            this.addHazmatTooltip(event, HazardProtectionTooltip.EXTREME_TEMP_TRANSLATION_KEY);
        }
        for (Hazard hazard : protections) {
            this.addHazmatTooltip(event, HazardProtectionTooltip.singleHazardTranslationKey(hazard));
        }
    }

    private void addHazmatTooltip(ItemTooltipEvent event, String translationKey) {
        event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)translationKey));
    }

    @SubscribeEvent
    public void onPlayerCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (!MetaGeneratedTool.playSound) {
            return;
        }
        if (this.mTicksUntilNextCraftSound > 0) {
            return;
        }
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            Item item;
            ItemStack stack = event.craftMatrix.func_70301_a(i);
            if (stack == null || !((item = stack.func_77973_b()) instanceof MetaGeneratedTool)) continue;
            MetaGeneratedTool mgt = (MetaGeneratedTool)item;
            IToolStats tStats = mgt.getToolStats(stack);
            boolean playBreak = MetaGeneratedTool.getToolDamage(stack) + (long)tStats.getToolDamagePerContainerCraft() >= MetaGeneratedTool.getToolMaxDamage(stack);
            String sound = playBreak ? tStats.getBreakingSound() : tStats.getCraftingSound();
            GTUtility.doSoundAtClient(sound, 1, 1.0f);
            this.mTicksUntilNextCraftSound = 10;
            return;
        }
    }

    public short getSafeRGBValue(short aRBG, int aDelta) {
        int tmp = aRBG + aDelta;
        if (tmp > 255) {
            tmp = 255;
        }
        if (tmp < 0) {
            tmp = 0;
        }
        return (short)tmp;
    }

    public long getAnimationTicks() {
        return this.mAnimationTick;
    }

    public float getPartialRenderTicks() {
        return this.renderTickTime;
    }

    public boolean shouldHideThings() {
        return this.hideThings;
    }

    public int changeDetected() {
        return this.changeDetected;
    }

    private static boolean shouldHeldItemHideThings() {
        int[] ids;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        ItemStack tCurrentItem = player.func_71045_bC();
        if (tCurrentItem == null) {
            return false;
        }
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)tCurrentItem)) {
            String oreName = OreDictionary.getOreName((int)i);
            if (oreName == null || !oreName.equals("craftingToolSolderingIron")) continue;
            return true;
        }
        return false;
    }

    public void setComputingPickBlock(boolean b) {
        this.isComputingPickBlock = b;
    }

    @SubscribeEvent
    public void onRenderStart(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.renderTickTime = event.renderTickTime;
            this.isRenderingWorld = true;
        } else if (event.phase == TickEvent.Phase.END) {
            this.isRenderingWorld = false;
        }
    }

    public boolean forceFullBlockBB() {
        return this.heldItemForcesFullBlockBB && (this.isRenderingWorld || this.isComputingPickBlock);
    }

    private static boolean shouldHeldItemForceFullBlockBB() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack == null) {
            return false;
        }
        return GTUtility.isStackInList(stack, (Collection<GTItemStack>)GregTechAPI.sWrenchList) || GTUtility.isStackInList(stack, (Collection<GTItemStack>)GregTechAPI.sHardHammerList) || GTUtility.isStackInList(stack, (Collection<GTItemStack>)GregTechAPI.sSoftMalletList) || GTUtility.isStackInList(stack, (Collection<GTItemStack>)GregTechAPI.sWireCutterList) || GTUtility.isStackInList(stack, (Collection<GTItemStack>)GregTechAPI.sSolderingToolList) || GTUtility.isStackInList(stack, (Collection<GTItemStack>)GregTechAPI.sCrowbarList) || CoverRegistry.isCover(stack) || stack.func_77973_b() instanceof ItemMachines && GregTechAPI.METATILEENTITIES[stack.func_77960_j()] instanceof MetaPipeEntity && player.func_70093_af();
    }

    public void processChunkPollutionPacket(ChunkCoordIntPair chunk, int pollution) {
        this.mPollutionRenderer.processPacket(chunk, pollution);
    }
}

