/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import appeng.api.util.DimensionalCoord;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.handlers.PowerGogglesEventHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.IBlockAccess;

public class GTPacketLinkPowerGoggles
extends GTPacket {
    private DimensionalCoord coords = null;
    private EntityPlayerMP player;

    public GTPacketLinkPowerGoggles() {
    }

    public GTPacketLinkPowerGoggles(DimensionalCoord coords) {
        this.coords = coords;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.LINK_GOGGLES.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeBoolean(this.coords == null);
        if (this.coords == null) {
            return;
        }
        buffer.writeInt(this.coords.x);
        buffer.writeInt(this.coords.y);
        buffer.writeInt(this.coords.z);
        buffer.writeInt(this.coords.getDimension());
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        if (buffer.readBoolean()) {
            return new GTPacketLinkPowerGoggles(null);
        }
        DimensionalCoord coords = new DimensionalCoord(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
        return new GTPacketLinkPowerGoggles(coords);
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        if (aHandler instanceof NetHandlerPlayServer) {
            this.player = ((NetHandlerPlayServer)aHandler).field_147369_b;
        }
    }

    @Override
    public void process(IBlockAccess world) {
        PowerGogglesEventHandler.setLscLink(this.player, this.coords);
        PowerGogglesEventHandler.forceUpdate = true;
        PowerGogglesEventHandler.forceRefresh = true;
    }
}

