/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTClientPreference;
import gregtech.api.util.GTUtility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEHatchInput
extends MTEHatch {
    public RecipeMap<?> mRecipeMap = null;
    public boolean disableFilter = true;

    public MTEHatchInput(int aID, String aName, String aNameRegional, int aTier) {
        this(aID, aName, aNameRegional, aTier, new String[]{"Fluid Input for Multiblocks", "Right click with screwdriver to toggle input filter", "Capacity: " + GTUtility.formatNumbers(8000L * (1L << aTier)) + "L"});
    }

    public MTEHatchInput(int aID, String aName, String aNameRegional, int aTier, String[] aDescription) {
        this(aID, 3, aName, aNameRegional, aTier, aDescription);
    }

    public MTEHatchInput(int aID, int aSlot, String aName, String aNameRegional, int aTier) {
        this(aID, aSlot, aName, aNameRegional, aTier, new String[]{"Fluid Input for Multiblocks", "", "Can hold " + aSlot + " types of fluid."});
        this.mDescriptionArray[1] = "Capacity: " + GTUtility.formatNumbers(this.getCapacityPerTank(aTier, aSlot)) + "L";
    }

    public MTEHatchInput(int aID, int aSlot, String aName, String aNameRegional, int aTier, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, aSlot, aDescription, new ITexture[0]);
    }

    public int getCapacityPerTank(int aTier, int aSlot) {
        return (int)(8000L * (1L << aTier) / (long)aSlot);
    }

    public MTEHatchInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public MTEHatchInput(String aName, int aSlots, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aSlots, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        byte color = this.getBaseMetaTileEntity().getColorization();
        ITexture coloredPipeOverlay = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_COLORS[color + 1]);
        if (GTMod.proxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[4];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray2[2] = coloredPipeOverlay;
            iTextureArray = iTextureArray2;
            iTextureArray2[3] = TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[3];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray3;
            iTextureArray3[2] = coloredPipeOverlay;
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        byte color = this.getBaseMetaTileEntity().getColorization();
        ITexture coloredPipeOverlay = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_COLORS[color + 1]);
        if (GTMod.proxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[4];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray2[2] = coloredPipeOverlay;
            iTextureArray = iTextureArray2;
            iTextureArray2[3] = TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[3];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray3;
            iTextureArray3[2] = coloredPipeOverlay;
        }
        return iTextureArray;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchInput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("disableFilter", this.disableFilter);
        if (this.mRecipeMap != null) {
            aNBT.func_74778_a("recipeMap", this.mRecipeMap.unlocalizedName);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.disableFilter = aNBT.func_74767_n("disableFilter");
        this.mRecipeMap = RecipeMap.getFromOldIdentifier(aNBT.func_74779_i("recipeMap"));
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        GTClientPreference preference;
        if (!this.getBaseMetaTileEntity().getWorld().field_72995_K && (preference = GTMod.proxy.getClientPreference(this.getBaseMetaTileEntity().getOwnerUuid())) != null) {
            this.disableFilter = !preference.isInputHatchInitialFilterEnabled();
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74774_a("color", this.getBaseMetaTileEntity().getColorization());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        byte color = accessor.getNBTData().func_74771_c("color");
        if (color >= 0 && color < 16) {
            currenttip.add("Color Channel: " + Dyes.VALUES[color].formatting + Dyes.VALUES[color].mName + EnumChatFormatting.GRAY);
        }
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[this.getInputSlot()] != null && this.mInventory[this.getInputSlot()].field_77994_a <= 0) {
            this.mInventory[this.getInputSlot()] = null;
        }
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.mRecipeMap == null || this.disableFilter || this.mRecipeMap.containsInput(aFluid);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0 && (this.mRecipeMap == null || this.disableFilter || this.mRecipeMap.containsInput(aStack) || this.mRecipeMap.containsInput(GTUtility.getFluidForFilledItem(aStack, true)));
    }

    @Override
    public int getCapacity() {
        return 8000 * (1 << this.mTier);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!this.getBaseMetaTileEntity().getCoverAtSide(side).isGUIClickable()) {
            return;
        }
        this.disableFilter = !this.disableFilter;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableFilter." + this.disableFilter)));
    }
}

