/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.Lock;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.interfaces.ITemporaryTE;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.metatileentity.CommonBaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.net.GTPacketCreateTE;
import gregtech.api.net.GTPacketTileEntity;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseMetaPipeEntity
extends CommonBaseMetaTileEntity
implements IGregTechTileEntity,
IPipeRenderedTileEntity,
IDebugableTileEntity {
    public byte mConnections = 0;
    protected MetaPipeEntity mMetaTileEntity;
    private boolean mWorkUpdate = false;
    private boolean mWorks = true;
    private byte mColor = 0;
    private byte oldColor = 0;
    private byte oldStrongRedstone = 0;
    private byte oldRedstoneData = (byte)63;
    private byte oldConnections = 0;
    private byte oldUpdateData = 0;
    private int oldX = 0;
    private int oldY = 0;
    private int oldZ = 0;
    protected Node node;
    protected NodePath nodePath;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodePath getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(NodePath nodePath) {
        this.nodePath = nodePath;
    }

    public void addToLock(TileEntity tileEntity, ForgeDirection side) {
        if (this.node != null) {
            Lock lock = this.node.locks[side.ordinal()];
            if (lock != null) {
                lock.addTileEntity(tileEntity);
            }
        } else if (this.nodePath != null) {
            this.nodePath.lock.addTileEntity(tileEntity);
        }
    }

    public void removeFromLock(TileEntity tileEntity, ForgeDirection side) {
        if (this.node != null) {
            Lock lock = this.node.locks[side.ordinal()];
            if (lock != null) {
                lock.removeTileEntity(tileEntity);
            }
        } else if (this.nodePath != null) {
            this.nodePath.lock.removeTileEntity(tileEntity);
        }
    }

    public void reloadLocks() {
        IMetaTileEntity meta = this.getMetaTileEntity();
        if (meta instanceof MetaPipeEntity) {
            ((MetaPipeEntity)meta).reloadLocks();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        try {
            super.func_145841_b(nbt);
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity", e);
        }
        try {
            nbt.func_74768_a("mID", (int)this.mID);
            this.writeCoverNBT(nbt, false);
            nbt.func_74774_a("mConnections", this.mConnections);
            nbt.func_74774_a("mColor", this.mColor);
            nbt.func_74757_a("mWorks", !this.mWorks);
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity", e);
        }
        this.saveMetaTileNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.setInitialValuesAsNBT(aNBT, (short)0);
    }

    @Override
    public void setInitialValuesAsNBT(NBTTagCompound aNBT, short aID) {
        if (aNBT == null) {
            if (aID > 0) {
                this.mID = aID;
            } else {
                short s = this.mID = this.mID > 0 ? this.mID : (short)0;
            }
            if (this.mID != 0) {
                this.createNewMetatileEntity(this.mID);
            }
        } else {
            this.mID = aID <= 0 ? (short)aNBT.func_74762_e("mID") : aID;
            this.mConnections = aNBT.func_74771_c("mConnections");
            this.mColor = aNBT.func_74771_c("mColor");
            this.mWorks = !aNBT.func_74767_n("mWorks");
            this.readCoverNBT(aNBT);
            this.loadMetaTileNBT(aNBT);
        }
    }

    @Override
    public void updateEntityProfiled() {
        if (!this.hasValidMetaTileEntity()) {
            if (this.mMetaTileEntity == null) {
                return;
            }
            this.mMetaTileEntity.setBaseMetaTileEntity(this);
        }
        boolean isServerSide = this.isServerSide();
        if (this.hasValidMetaTileEntity()) {
            if (this.mTickTimer++ == 0L) {
                this.oldX = this.field_145851_c;
                this.oldY = this.field_145848_d;
                this.oldZ = this.field_145849_e;
                if (isServerSide) {
                    this.checkDropCover();
                } else {
                    this.requestCoverDataIfNeeded();
                }
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                this.mMetaTileEntity.onFirstTick(this);
                if (!this.hasValidMetaTileEntity()) {
                    return;
                }
            }
            if (this.isClientSide()) {
                if (this.mColor != this.oldColor) {
                    this.oldColor = this.mColor;
                    this.mMetaTileEntity.onColorChangeClient(this.oldColor);
                    this.issueTextureUpdate();
                }
                if (this.mNeedsUpdate) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.mMetaTileEntity.onTextureUpdate();
                    this.mNeedsUpdate = false;
                }
            }
            if (isServerSide && this.mTickTimer > 10L) {
                if (!this.doCoverThings()) {
                    return;
                }
                if (this.mTickTimer > 12L && this.mConnections != this.mMetaTileEntity.mConnections) {
                    this.mConnections = this.mMetaTileEntity.mConnections;
                    GregTechAPI.causeCableUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            this.mMetaTileEntity.onPreTick(this, this.mTickTimer);
            if (!this.hasValidMetaTileEntity()) {
                return;
            }
            if (isServerSide) {
                if (this.mTickTimer == 10L) {
                    this.issueBlockUpdate();
                    this.joinEnet();
                }
                if (this.field_145851_c != this.oldX || this.field_145848_d != this.oldY || this.field_145849_e != this.oldZ) {
                    this.oldX = this.field_145851_c;
                    this.oldY = this.field_145848_d;
                    this.oldZ = this.field_145849_e;
                    this.issueClientUpdate();
                    this.clearTileEntityBuffer();
                }
            }
            this.mMetaTileEntity.onPostTick(this, this.mTickTimer);
            if (!this.hasValidMetaTileEntity()) {
                return;
            }
            if (isServerSide) {
                if (this.mTickTimer % 10L == 0L) {
                    this.sendClientData();
                }
                if (this.mTickTimer > 10L) {
                    byte redstone;
                    byte updateData;
                    if (this.mConnections != this.oldConnections) {
                        this.oldConnections = this.mConnections;
                        this.sendBlockEvent((byte)0, this.oldConnections);
                    }
                    if ((updateData = this.mMetaTileEntity.getUpdateData()) != this.oldUpdateData) {
                        this.oldUpdateData = updateData;
                        this.sendBlockEvent((byte)1, this.oldUpdateData);
                    }
                    if (this.mColor != this.oldColor) {
                        this.oldColor = this.mColor;
                        this.sendBlockEvent((byte)2, this.oldColor);
                    }
                    if ((redstone = this.getSidedRedstoneMask()) != this.oldRedstoneData) {
                        this.oldRedstoneData = redstone;
                        this.sendBlockEvent((byte)3, this.oldRedstoneData);
                    }
                }
                if (this.mNeedsBlockUpdate) {
                    this.updateNeighbours(this.mStrongRedstone, this.oldStrongRedstone);
                    this.oldStrongRedstone = this.mStrongRedstone;
                    this.mNeedsBlockUpdate = false;
                }
                if (this.mNeedsTileUpdate) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.mNeedsTileUpdate = false;
                }
            }
        }
        this.mInventoryChanged = false;
        this.mWorkUpdate = false;
    }

    @Override
    protected void onTickFail() {
        this.mMetaTileEntity.onTickFail(this, this.mTickTimer);
    }

    private void sendClientData() {
        if (this.mSendClientData) {
            this.oldConnections = this.mConnections;
            this.oldUpdateData = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getUpdateData() : (byte)0;
            this.oldRedstoneData = this.getSidedRedstoneMask();
            this.oldColor = this.mColor;
            if (this.mMetaTileEntity instanceof ITemporaryTE) {
                GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GTPacketCreateTE(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mID, this.getCoverAtSide(ForgeDirection.DOWN).getCoverID(), this.getCoverAtSide(ForgeDirection.UP).getCoverID(), this.getCoverAtSide(ForgeDirection.NORTH).getCoverID(), this.getCoverAtSide(ForgeDirection.SOUTH).getCoverID(), this.getCoverAtSide(ForgeDirection.WEST).getCoverID(), this.getCoverAtSide(ForgeDirection.EAST).getCoverID(), this.oldConnections, this.oldUpdateData, this.oldRedstoneData, this.oldColor, 1), this.field_145851_c, this.field_145849_e);
            } else {
                GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GTPacketTileEntity(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mID, this.getCoverAtSide(ForgeDirection.DOWN).getCoverID(), this.getCoverAtSide(ForgeDirection.UP).getCoverID(), this.getCoverAtSide(ForgeDirection.NORTH).getCoverID(), this.getCoverAtSide(ForgeDirection.SOUTH).getCoverID(), this.getCoverAtSide(ForgeDirection.WEST).getCoverID(), this.getCoverAtSide(ForgeDirection.EAST).getCoverID(), this.oldConnections, this.oldUpdateData, this.oldRedstoneData, this.oldColor), this.field_145851_c, this.field_145849_e);
                this.mSendClientData = false;
            }
        }
        this.sendCoverDataIfNeeded();
    }

    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aConnections, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (aID > 0 && this.mID != aID) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        CoverRegistry.cover(this, aCover0, aCover1, aCover2, aCover3, aCover4, aCover5);
        this.func_145842_c(0, aConnections);
        this.func_145842_c(1, aUpdateData);
        this.func_145842_c(2, aColorData);
        this.func_145842_c(3, aRedstoneData);
    }

    public boolean func_145842_c(int aEventID, int aValue) {
        super.func_145842_c(aEventID, aValue);
        if (this.hasValidMetaTileEntity()) {
            try {
                this.mMetaTileEntity.receiveClientEvent((byte)aEventID, (byte)aValue);
            }
            catch (Throwable e) {
                GTMod.GT_FML_LOGGER.error("Encountered Exception while receiving Data from the Server", e);
            }
        }
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.mConnections = (byte)aValue;
                    break;
                }
                case 1: {
                    if (!this.hasValidMetaTileEntity()) break;
                    this.mMetaTileEntity.onValueUpdate((byte)aValue);
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.setRedstoneOutput(aValue);
                    break;
                }
                case 4: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.doSound((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 5: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.startSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 6: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.stopSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 3) {
            tList.add("Meta-ID: " + EnumChatFormatting.BLUE + this.mID + EnumChatFormatting.RESET + (this.hasValidMetaTileEntity() ? EnumChatFormatting.GREEN + " valid" + EnumChatFormatting.RESET : EnumChatFormatting.RED + " invalid" + EnumChatFormatting.RESET) + (this.mMetaTileEntity == null ? EnumChatFormatting.RED + " MetaTileEntity == null!" + EnumChatFormatting.RESET : " "));
        }
        if (aLogLevel > 1) {
            this.addProfilingInformation(tList);
            if (this.mMetaTileEntity != null) {
                tList.add("Is" + (this.mMetaTileEntity.isAccessAllowed(aPlayer) ? " " : EnumChatFormatting.RED + " not " + EnumChatFormatting.RESET) + "accessible for you");
            }
        }
        if (this.joinedIc2Enet) {
            tList.add("Joined IC2 ENet");
        }
        return this.mMetaTileEntity != null ? this.mMetaTileEntity.getSpecialDebugInfo(this, aPlayer, aLogLevel, tList) : new ArrayList<String>();
    }

    @Override
    public boolean isGivingInformation() {
        return this.canAccessData() && this.mMetaTileEntity.isGivingInformation();
    }

    @Override
    public String[] getInfoData() {
        return this.canAccessData() ? this.getMetaTileEntity().getInfoData() : GTValues.emptyStringArray;
    }

    @Override
    public Map<String, String> getInfoMap() {
        return this.canAccessData() ? this.getMetaTileEntity().getInfoMap() : Collections.emptyMap();
    }

    @Override
    public ForgeDirection getBackFacing() {
        return this.getFrontFacing().getOpposite();
    }

    @Override
    public ForgeDirection getFrontFacing() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void setFrontFacing(ForgeDirection aFacing) {
        this.doEnetUpdate();
    }

    public int func_70302_i_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70301_a(aIndex);
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        this.func_70296_d();
        this.mInventoryChanged = true;
        if (this.canAccessData()) {
            this.mMetaTileEntity.func_70299_a(aIndex, this.field_145850_b.field_72995_K ? aStack : GTOreDictUnificator.setStack(true, aStack));
        }
    }

    public String func_145825_b() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_145825_b();
        }
        if (GregTechAPI.METATILEENTITIES[this.mID] != null) {
            return GregTechAPI.METATILEENTITIES[this.mID].func_145825_b();
        }
        return "";
    }

    public int func_70297_j_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70297_j_();
        }
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.hasValidMetaTileEntity() && this.mTickTimer > 1L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0 && this.mMetaTileEntity.isAccessAllowed(aPlayer);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.mTickTimer = 0L;
    }

    @Override
    public void func_145843_s() {
        this.field_145846_f = false;
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.onRemoval();
            this.mMetaTileEntity.setBaseMetaTileEntity(null);
        }
        this.leaveEnet();
        super.func_145843_s();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    @Override
    public void onMachineBlockUpdate() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onMachineBlockUpdate();
        }
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return this.canAccessData() && this.mMetaTileEntity.isMachineBlockUpdateRecursive();
    }

    @Override
    public int getProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.getProgresstime() : 0;
    }

    @Override
    public int getMaxProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.maxProgresstime() : 0;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.canAccessData() && this.mMetaTileEntity.increaseProgress(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
        this.reloadLocks();
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
        this.reloadLocks();
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public int getMetaTileID() {
        return this.mID;
    }

    @Override
    public int setMetaTileID(short aID) {
        this.mID = aID;
        return this.mID;
    }

    @Nullable
    public <T> T getCapability(@NotNull Class<T> capability, @NotNull ForgeDirection side) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getCapability(capability, side);
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void setActive(boolean aActive) {
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return false;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side, boolean waitForActive) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side, boolean waitForActive) {
        return false;
    }

    @Override
    public long getOutputAmperage() {
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    @Override
    public long getUniversalEnergyStored() {
        return Math.max(this.getStoredEU(), this.getStoredSteam());
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return Math.max(this.getEUCapacity(), this.getSteamCapacity());
    }

    @Override
    public long getStoredEU() {
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        return 0L;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, ForgeDirection side) {
        ITexture rIcon = this.getCoverTexture(side);
        if (rIcon != null) {
            return new ITexture[]{rIcon};
        }
        return this.getTextureUncovered(side);
    }

    @Override
    public ITexture[] getTextureCovered(ForgeDirection side) {
        ITexture coverTexture = this.getCoverTexture(side);
        ITexture[] textureUncovered = this.getTextureUncovered(side);
        if (coverTexture != null) {
            ITexture[] textureCovered = Arrays.copyOf(textureUncovered, textureUncovered.length + 1);
            textureCovered[textureUncovered.length] = coverTexture;
            return textureCovered;
        }
        return textureUncovered;
    }

    @Override
    public ITexture[] getTextureUncovered(ForgeDirection sideDirection) {
        int tConnections = this.mConnections;
        if (tConnections == 16 || tConnections == 32) {
            tConnections = 48;
        } else if (tConnections == 1 || tConnections == 2) {
            tConnections = 3;
        } else if (tConnections == 4 || tConnections == 8) {
            tConnections = 12;
        }
        if (this.hasValidMetaTileEntity()) {
            return this.mMetaTileEntity.getTexture((IGregTechTileEntity)this, sideDirection, tConnections, this.mColor - 1, tConnections == 0 || (tConnections & sideDirection.flag) != 0, this.getOutputRedstoneSignal(sideDirection) > 0);
        }
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    @Override
    protected boolean hasValidMetaTileEntity() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.getBaseMetaTileEntity() == this;
    }

    @Override
    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onExplosion();
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops() {
        ItemStack rStack = new ItemStack(GregTechAPI.sBlockMachines, 1, (int)this.mID);
        NBTTagCompound tNBT = new NBTTagCompound();
        this.writeCoverNBT(tNBT, true);
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.setItemNBT(tNBT);
        }
        if (!tNBT.func_82582_d()) {
            rStack.func_77982_d(tNBT);
        }
        this.onBaseTEDestroyed();
        return new ArrayList<ItemStack>(Collections.singletonList(rStack));
    }

    @Override
    public boolean onRightclick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ForgeDirection wrenchingSide = GTUtility.determineWrenchingSide(side, aX, aY, aZ);
        ForgeDirection effectiveSide = !this.hasCoverAtSide(side) ? wrenchingSide : side;
        Cover effectiveSideCover = this.getCoverAtSide(effectiveSide);
        if (this.isClientSide() && aPlayer.func_70093_af()) {
            return effectiveSideCover.hasCoverGUI();
        }
        if (this.isServerSide()) {
            ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
            if (tCurrentItem != null) {
                if (this.getColorization() >= 0 && GTUtility.areStacksEqual(new ItemStack(Items.field_151131_as, 1), tCurrentItem)) {
                    this.mMetaTileEntity.func_70296_d();
                    tCurrentItem.func_150996_a(Items.field_151133_ar);
                    this.setColorization((byte)-1);
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sWrenchList)) {
                    if (this.mMetaTileEntity.onWrenchRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, tCurrentItem)) {
                        this.mMetaTileEntity.func_70296_d();
                        GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        this.sendSoundToPlayers(SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1);
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sScrewdriverList)) {
                    if (!this.hasCoverAtSide(side) && this.hasCoverAtSide(wrenchingSide)) {
                        if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
                            this.getCoverAtSide(wrenchingSide).onCoverScrewdriverClick(aPlayer, 0.5f, 0.5f, 0.5f);
                            this.mMetaTileEntity.onScrewdriverRightClick(wrenchingSide, aPlayer, aX, aY, aZ, tCurrentItem);
                            this.mMetaTileEntity.func_70296_d();
                            this.sendSoundToPlayers(SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1);
                        }
                    } else if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        this.getCoverAtSide(side).onCoverScrewdriverClick(aPlayer, aX, aY, aZ);
                        this.mMetaTileEntity.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, tCurrentItem);
                        this.mMetaTileEntity.func_70296_d();
                        this.sendSoundToPlayers(SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1);
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sHardHammerList)) {
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sSoftMalletList)) {
                    if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        if (this.mWorks) {
                            this.disableWorking();
                        } else {
                            this.enableWorking();
                        }
                        this.mMetaTileEntity.func_70296_d();
                        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("090", "Machine Processing: ") + (this.isAllowedToWork() ? GTUtility.trans("088", "Enabled") : GTUtility.trans("087", "Disabled")));
                        this.sendSoundToPlayers(SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, 1.0f, -1);
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sWireCutterList)) {
                    if (this.mMetaTileEntity.onWireCutterRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, tCurrentItem)) {
                        this.mMetaTileEntity.func_70296_d();
                        this.sendSoundToPlayers(SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1);
                    }
                    this.doEnetUpdate();
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sSolderingToolList)) {
                    if (this.mMetaTileEntity.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, tCurrentItem)) {
                        this.mMetaTileEntity.func_70296_d();
                        this.sendSoundToPlayers(SoundResource.IC2_TOOLS_BATTERY_USE, 1.0f, -1);
                    } else if (GTModHandler.useSolderingIron(tCurrentItem, (EntityLivingBase)aPlayer)) {
                        this.mMetaTileEntity.func_70296_d();
                        this.mStrongRedstone = (byte)(this.mStrongRedstone ^ wrenchingSide.flag);
                        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("091", "Redstone Output at Side ") + wrenchingSide + GTUtility.trans("092", " set to: ") + ((this.mStrongRedstone & wrenchingSide.flag) != 0 ? GTUtility.trans("093", "Strong") : GTUtility.trans("094", "Weak")));
                        this.sendSoundToPlayers(SoundResource.IC2_TOOLS_BATTERY_USE, 3.0f, -1);
                        this.issueBlockUpdate();
                    }
                    this.doEnetUpdate();
                    return true;
                }
                if (!this.hasCoverAtSide(effectiveSide)) {
                    if (aPlayer.func_70093_af() && CoverRegistry.isCover(tCurrentItem)) {
                        if (CoverRegistry.getCoverPlacer(tCurrentItem).isCoverPlaceable(effectiveSide, tCurrentItem, this) && this.mMetaTileEntity.allowCoverOnSide(effectiveSide, tCurrentItem)) {
                            CoverRegistry.getCoverPlacer(tCurrentItem).placeCover(aPlayer, tCurrentItem, this, effectiveSide);
                            this.mMetaTileEntity.func_70296_d();
                            if (!aPlayer.field_71075_bZ.field_75098_d) {
                                --tCurrentItem.field_77994_a;
                            }
                            this.sendSoundToPlayers(SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1);
                            this.sendClientData();
                        }
                        return true;
                    }
                } else if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sCrowbarList)) {
                    if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        this.sendSoundToPlayers(SoundResource.RANDOM_BREAK, 1.0f, -1);
                        this.dropCover(effectiveSide, side);
                        this.mMetaTileEntity.func_70296_d();
                    }
                    return true;
                }
            } else if (aPlayer.func_70093_af()) {
                return effectiveSideCover.isValid() && effectiveSideCover.onCoverShiftRightClick(aPlayer);
            }
            if (this.getCoverAtSide(side).onCoverRightClick(aPlayer, aX, aY, aZ)) {
                return true;
            }
        }
        if (!this.getCoverAtSide(side).isGUIClickable()) {
            return false;
        }
        try {
            if (!aPlayer.func_70093_af() && this.hasValidMetaTileEntity()) {
                boolean value = this.mMetaTileEntity.onRightclick(this, aPlayer, side, aX, aY, aZ);
                this.mMetaTileEntity.func_70296_d();
                return value;
            }
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered Exception while right clicking TileEntity", e);
        }
        return false;
    }

    @Override
    public void onLeftclick(EntityPlayer aPlayer) {
        try {
            if (aPlayer != null && this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.onLeftclick(this, aPlayer);
            }
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered Exception while left clicking TileEntity", e);
        }
    }

    @Override
    public boolean isDigitalChest() {
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return null;
    }

    @Override
    public void setItemCount(int aCount) {
    }

    @Override
    public int getMaxItemCount() {
        return 0;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mMetaTileEntity.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int ordinalSide) {
        Cover cover = this.getCoverAtSide(ForgeDirection.getOrientation((int)ordinalSide));
        if (this.canAccessData() && (cover.letsItemsOut(-1) || cover.letsItemsIn(-1))) {
            return this.mMetaTileEntity.func_94128_d(ordinalSide);
        }
        return GTValues.emptyIntArray;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.canAccessData() && this.getCoverAtSide(ForgeDirection.getOrientation((int)ordinalSide)).letsItemsIn(aIndex) && this.mMetaTileEntity.func_102007_a(aIndex, aStack, ordinalSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        return this.canAccessData() && this.getCoverAtSide(side).letsItemsOut(aIndex) && this.mMetaTileEntity.func_102008_b(aIndex, aStack, ordinalSide);
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
    }

    @Override
    public IMetaTileEntity getMetaTileEntity() {
        return this.hasValidMetaTileEntity() ? this.mMetaTileEntity : null;
    }

    @Override
    public void setMetaTileEntity(IMetaTileEntity aMetaTileEntity) {
        this.mMetaTileEntity = (MetaPipeEntity)aMetaTileEntity;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public long getAverageElectricInput() {
        return 0L;
    }

    @Override
    public long getAverageElectricOutput() {
        return 0L;
    }

    @Override
    public String getOwnerName() {
        return "Player";
    }

    @Override
    public String setOwnerName(String aName) {
        return "Player";
    }

    @Override
    public UUID getOwnerUuid() {
        return GTUtility.defaultUuid;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(side) : (byte)0;
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mMetaTileEntity.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.injectEnergyUnits(side, aVoltage, aAmperage);
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return false;
    }

    private boolean canMoveFluidOnSide(ForgeDirection side, Fluid fluid, boolean isFill) {
        if (side == ForgeDirection.UNKNOWN) {
            return true;
        }
        IFluidHandler tTileEntity = this.getITankContainerAtSide(side);
        if (tTileEntity != null && !this.mMetaTileEntity.isConnectedAtSide(side)) {
            return false;
        }
        if (isFill && this.mMetaTileEntity.isLiquidInput(side) && this.getCoverAtSide(side).letsFluidIn(fluid)) {
            return true;
        }
        return !isFill && this.mMetaTileEntity.isLiquidOutput(side) && this.getCoverAtSide(side).letsFluidOut(fluid);
    }

    public int fill(ForgeDirection side, FluidStack aFluidStack, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluidStack == null ? null : aFluidStack.getFluid(), true)) {
            return this.mMetaTileEntity.fill(side, aFluidStack, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection side, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, this.mMetaTileEntity.getFluid() == null ? null : this.mMetaTileEntity.getFluid().getFluid(), false)) {
            return this.mMetaTileEntity.drain(side, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection side, FluidStack aFluidStack, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluidStack == null ? null : aFluidStack.getFluid(), false)) {
            return this.mMetaTileEntity.drain(side, aFluidStack, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection side, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluid, true)) {
            return this.mMetaTileEntity.canFill(side, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection side, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluid, false)) {
            return this.mMetaTileEntity.canDrain(side, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        if (this.canAccessData() && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput(side) && cover.letsFluidIn(null) || this.mMetaTileEntity.isLiquidOutput(side) && cover.letsFluidOut(null))) {
            return this.mMetaTileEntity.getTankInfo(side);
        }
        return GTValues.emptyFluidTankInfo;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (GTUtility.isStackInvalid(tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (GTUtility.areStacksEqual(tStack, aStack = GTOreDictUnificator.get(aStack)) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(aStack.func_77976_d(), this.func_70297_j_())) {
            this.func_70296_d();
            tStack.field_77994_a += aStack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GTUtility.copyAmount(aAmount, aStack));
    }

    @Override
    public byte getColorization() {
        return (byte)(this.mColor - 1);
    }

    @Override
    public byte setColorization(byte aColor) {
        if (aColor > 15 || aColor < -1) {
            aColor = (byte)-1;
        }
        this.mColor = (byte)(aColor + 1);
        if (this.canAccessData()) {
            this.mMetaTileEntity.onColorChangeServer(aColor);
        }
        return this.mColor;
    }

    @Override
    public float getThickNess() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getThickness();
        }
        return 1.0f;
    }

    public boolean renderInside(ForgeDirection side) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.renderInside(side);
        }
        return false;
    }

    @Override
    public boolean isMufflerUpgradable() {
        return false;
    }

    @Override
    public boolean addMufflerUpgrade() {
        return false;
    }

    @Override
    public boolean hasMufflerUpgrade() {
        return false;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return this.getUniversalEnergyStored() >= aEnergyAmount;
    }

    @Override
    public byte getConnections() {
        return this.mConnections;
    }

    public void onNeighborBlockChange(int aX, int aY, int aZ) {
        IMetaTileEntity meta;
        if (this.canAccessData() && (meta = this.getMetaTileEntity()) instanceof MetaPipeEntity) {
            ((MetaPipeEntity)meta).setCheckConnections();
        }
    }

    @Override
    public int getLightOpacity() {
        return this.mMetaTileEntity == null ? 0 : this.mMetaTileEntity.getLightOpacity();
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.hasValidMetaTileEntity()) {
            this.getMetaTileEntity().getWailaBody(itemStack, currentTip, accessor, config);
        }
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.hasValidMetaTileEntity()) {
            this.getMetaTileEntity().getWailaNBTData(player, tile, tag, world, x, y, z);
        }
    }
}

