/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEManualTrafo
extends MTEEnhancedMultiBlockBase<MTEManualTrafo> {
    private byte mode;
    private int mTiers;
    private boolean upstep = true;
    private static final int CASING_INDEX = 2;
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_LAYER = "layer";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_TAP_LAYER = "taplayer";
    private static final IStructureDefinition<MTEManualTrafo> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape("layer", StructureUtility.transpose((String[][])new String[][]{{"ttt", "tft", "ttt"}})).addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ooo", "ooo", "ooo"}})).addShape("taplayer", StructureUtility.transpose((String[][])new String[][]{{" TTT ", "TtttT", "TtftT", "TtttT", " TTT "}})).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, 2, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 2, 1), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)2)})).addElement('o', GTStructureUtility.ofHatchAdderOptional(MTEMultiBlockBase::addDynamoToMachineList, 2, 2, GregTechAPI.sBlockCasings1, 2)).addElement('t', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement('f', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement('T', (IStructureElement)new IStructureElementNoPlacement<MTEManualTrafo>(){

        public boolean check(MTEManualTrafo te, World world, int x, int y, int z) {
            if (world.func_147437_c(x, y, z)) {
                return true;
            }
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return true;
            }
            IMetaTileEntity mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (mte instanceof MTEHatchDynamo || mte instanceof MTEHatchEnergy) {
                byte intier = ((MTEHatchEnergy)te.mEnergyHatches.get((int)0)).mTier;
                if (((MTETieredMachineBlock)mte).mTier == intier + (te.upstep ? te.mTiers : -te.mTiers)) {
                    te.addToMachineList((IGregTechTileEntity)tileEntity, 2);
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean spawnHint(MTEManualTrafo te, World world, int x, int y, int z, ItemStack itemStack) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)2);
            return true;
        }
    }).build();

    public MTEManualTrafo(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEManualTrafo(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEManualTrafo> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Transformer").addInfo("Operates in 4 diffrent modes:").addInfo("Mode 1: Circuit 0 in controller: Direct-Upstep").addInfo("Mode 2: Circuit 1 in controller: Direct-Downstep").addInfo("Mode 3: Circuit 2 in controller: Tapped-Upstep (currently disabled)").addInfo("Mode 4: Circuit 2 in controller: Tapped-Downstep (currently disabled)").beginVariableStructureBlock(3, 3, 3, 10, 3, 3, false).addController("Front bottom center").addCasingInfoMin("MV Machine Casing", 0, false).addOtherStructurePart("Transformer-Winding Blocks", "1 Layer for each tier transformed").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Middle of Transformer-Winding Blocks").addMaintenanceHatch("Any bottom layer casing", 1).addEnergyHatch("Any bottom layer casing", 1).addDynamoHatch("Any top layer casing", 2).addStructureInfo("").addStructureInfo("Tapped Mode :").addEnergyHatch("Touching Transformer-Winding Blocks", 3).addDynamoHatch("Touching Transformer-Winding Blocks", 3).addStructureInfo("Hatches touching Transformer-Winding Blocks must be tiered from bottom to top").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
            return false;
        }
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        if (this.getBaseMetaTileEntity().getTimer() % 40L == 0L) {
            this.mEfficiency = this.mEfficiency < this.getMaxEfficiency(null) ? (this.mEfficiency += 100) : this.getMaxEfficiency(null);
        }
        if (this.mode > 1) {
            return false;
        }
        return this.drainEnergyInput(this.getInputTier() * 2L * (long)this.mEnergyHatches.size()) && this.addEnergyOutput(this.getInputTier() * 2L * (long)this.mEnergyHatches.size() * (long)this.mEfficiency / (long)this.getMaxEfficiency(null));
    }

    @Override
    public long getInputTier() {
        if (!this.mEnergyHatches.isEmpty()) {
            return GTUtility.getTier(((MTEHatchEnergy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage());
        }
        return 0L;
    }

    @Override
    public long getOutputTier() {
        if (!this.mDynamoHatches.isEmpty()) {
            return GTUtility.getTier(((MTEHatchDynamo)this.mDynamoHatches.get(0)).getBaseMetaTileEntity().getOutputVoltage());
        }
        return 0L;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
            return CheckRecipeResultRegistry.NONE;
        }
        ItemStack itemStack = this.getControllerSlot();
        this.mode = itemStack == null || !itemStack.func_77977_a().startsWith("gt.integrated_circuit") ? (byte)0 : (byte)Math.min(3, itemStack.func_77960_j());
        this.upstep = this.mode % 2 == 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        this.mEfficiency = Math.max(this.mEfficiency, 100);
        if (this.upstep ? this.getOutputTier() - this.getInputTier() == (long)this.mTiers : this.getInputTier() - this.getOutputTier() == (long)this.mTiers) {
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int mHeight;
        boolean tapmode;
        this.mode = itemStack == null || !itemStack.func_77977_a().startsWith("gt.integrated_circuit") ? (byte)0 : (byte)Math.min(3, itemStack.func_77960_j());
        this.upstep = this.mode % 2 == 0;
        boolean bl = tapmode = this.mode > 1;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0) || this.mEnergyHatches.isEmpty()) {
            return false;
        }
        byte intier = ((MTEHatchEnergy)this.mEnergyHatches.get((int)0)).mTier;
        for (MTEHatchEnergy in : this.mEnergyHatches) {
            if (in.mTier == intier) continue;
            return false;
        }
        for (mHeight = 1; mHeight <= 8; ++mHeight) {
            if (tapmode) {
                this.mTiers = mHeight;
                if (this.checkPiece(STRUCTURE_PIECE_TAP_LAYER, 2, mHeight, 1)) continue;
                break;
            }
            if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 1, mHeight, 0)) break;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_TOP, 1, mHeight, 0)) {
            return false;
        }
        this.mTiers = mHeight - 1;
        if (this.mDynamoHatches.isEmpty() || this.mMaintenanceHatches.size() != 1 || this.mTiers == 0) {
            return false;
        }
        byte outtier = ((MTEHatchDynamo)this.mDynamoHatches.get((int)0)).mTier;
        for (MTEHatchDynamo out : this.mDynamoHatches) {
            if (out.mTier == outtier) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEManualTrafo(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound ntag) {
        super.saveNBTData(ntag);
        ntag.func_74768_a("mTiers", this.mTiers);
        ntag.func_74774_a("mMode", this.mode);
        ntag.func_74757_a("upstep", this.upstep);
    }

    @Override
    public void loadNBTData(NBTTagCompound ntag) {
        super.loadNBTData(ntag);
        this.mTiers = ntag.func_74762_e("mTiers");
        this.mode = ntag.func_74771_c("mMode");
        this.upstep = ntag.func_74767_n("upstep");
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(2), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(2), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(2)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.mode = this.mInventory[1] == null || !this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") ? (byte)0 : (byte)Math.min(3, this.mInventory[1].func_77960_j());
        int mHeight = Math.min(itemStack.field_77994_a, 8);
        boolean tapmode = this.mode > 1;
        this.buildPiece(STRUCTURE_PIECE_BASE, itemStack, b, 1, 0, 0);
        for (int i = 0; i < mHeight; ++i) {
            if (tapmode) {
                this.buildPiece(STRUCTURE_PIECE_TAP_LAYER, itemStack, b, 2, i + 1, 1);
                continue;
            }
            this.buildPiece(STRUCTURE_PIECE_LAYER, itemStack, b, 1, i + 1, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, itemStack, b, 1, mHeight + 1, 0);
    }
}

