/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API;

import bartworks.util.BioCulture;
import bartworks.util.BioDNA;
import bartworks.util.BioData;
import bartworks.util.BioPlasmid;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.fluid.GTFluidFactory;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import java.awt.Color;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class BioObjectAdder {
    @Nullable
    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, EnumRarity rarity, boolean breedable) {
        if (BioCulture.BIO_CULTURE_ARRAY_LIST.size() > 1) {
            return BioCulture.createAndRegisterBioCulture(color, name, plasmid, dna, rarity, breedable);
        }
        new Exception("Too Early to register a BioCulture! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    @Nullable
    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, boolean breedable) {
        if (BioCulture.BIO_CULTURE_ARRAY_LIST.size() > 1) {
            return BioCulture.createAndRegisterBioCulture(color, name, plasmid, dna, breedable);
        }
        new Exception("Too Early to register a BioCulture! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    @Nullable
    public static BioData createAndRegisterBioData(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioData.createAndRegisterBioData(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    @Nullable
    public static BioDNA createAndRegisterBioDNA(String aName, EnumRarity rarity) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioDNA.createAndRegisterBioDNA(aName, rarity);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    @Nullable
    public static BioPlasmid createAndRegisterBioPlasmid(String aName, EnumRarity rarity) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioPlasmid.createAndRegisterBioPlasmid(aName, rarity);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    @Nullable
    public static BioDNA createAndRegisterBioDNA(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioDNA.createAndRegisterBioDNA(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    @Nullable
    public static BioPlasmid createAndRegisterBioPlasmid(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioPlasmid.createAndRegisterBioPlasmid(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static int getBacteriaTierFromVoltageTier(int voltageTier) {
        return Math.max(voltageTier - 6, 0);
    }

    public static void regenerateBioFluids() {
        FluidStack dnaFluid = Mods.Gendustry.isModLoaded() ? GTModHandler.getLiquidDNA(100L) : Materials.Biomass.getFluid(100L);
        for (BioCulture B : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            if (!B.getFluidNotSet()) continue;
            B.setFluid(GTFluidFactory.builder(B.getName().replace(" ", "").toLowerCase() + "fluid").withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)B.getColor().getRed(), (short)B.getColor().getBlue(), (short)B.getColor().getGreen()}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid());
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10)).fluidInputs(new FluidStack(B.getFluid(), 1000)).fluidOutputs(dnaFluid).duration(500).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.centrifugeRecipes);
        }
    }
}

