/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MTEHatchNbtConsumable
extends MTEHatch
implements IAddGregtechLogo {
    private final int mInputslotCount = this.getInputSlotCount();
    private final int mTotalSlotCount = this.getInputSlotCount() * 2;
    private final boolean mAllowDuplicateUsageTypes;

    public MTEHatchNbtConsumable(int aID, String aName, String aNameRegional, int aTier, int aInputSlots, String aDescription, boolean aAllowDuplicateTypes) {
        super(aID, aName, aNameRegional, aTier, aInputSlots * 2, aDescription, new ITexture[0]);
        this.mAllowDuplicateUsageTypes = aAllowDuplicateTypes;
    }

    public MTEHatchNbtConsumable(String aName, int aTier, int aInputSlots, String[] aDescription, boolean aAllowDuplicateTypes, ITexture[][][] aTextures) {
        super(aName, aTier, aInputSlots * 2, aDescription, aTextures);
        this.mAllowDuplicateUsageTypes = aAllowDuplicateTypes;
    }

    @Override
    public abstract ITexture[] getTexturesActive(ITexture var1);

    @Override
    public abstract ITexture[] getTexturesInactive(ITexture var1);

    public abstract int getInputSlotCount();

    @Override
    public final boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public final boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public final boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public final boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    public abstract String getNameGUI();

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        this.validateUsageSlots();
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
            this.tryFillUsageSlots();
        }
    }

    public final void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] != null && this.mInventory[i].field_77994_a <= 0) {
                this.mInventory[i] = null;
            }
            if (i > this.getSlotID_LastInput()) continue;
            this.fillStacksIntoFirstSlots();
        }
    }

    protected void validateUsageSlots() {
        for (int i = this.getSlotID_FirstUsage(); i <= this.getSlotID_LastUsage(); ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a >= 1) continue;
            this.mInventory[i] = null;
            this.func_70296_d();
        }
    }

    protected final void fillStacksIntoFirstSlots() {
        for (int i = 0; i <= this.getSlotID_LastInput(); ++i) {
            for (int j = i + 1; j <= this.getSlotID_LastInput(); ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GTUtility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                GTUtility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    public final void tryFillUsageSlots() {
        int aSlotSpace = this.mInputslotCount - this.getContentUsageSlots().size();
        if (aSlotSpace > 0) {
            Logger.INFO("We have empty usage slots. " + aSlotSpace);
            for (int i = this.getSlotID_FirstInput(); i <= this.getSlotID_LastInput(); ++i) {
                ItemStack aStackToTryMove = this.mInventory[i];
                if (aStackToTryMove == null || !this.isItemValidForUsageSlot(aStackToTryMove)) continue;
                Logger.INFO("Trying to move stack from input slot " + i);
                if (!this.moveItemFromStockToUsageSlots(aStackToTryMove)) continue;
                Logger.INFO("Updating Slots.");
                this.updateSlots();
            }
        }
    }

    private int getSlotID_FirstInput() {
        return 0;
    }

    private int getSlotID_LastInput() {
        return this.mInputslotCount - 1;
    }

    private int getSlotID_FirstUsage() {
        return this.mInputslotCount;
    }

    private int getSlotID_LastUsage() {
        return this.mTotalSlotCount - 1;
    }

    public final ArrayList<ItemStack> getContentUsageSlots() {
        ArrayList<ItemStack> aItems = new ArrayList<ItemStack>();
        for (int i = this.mInputslotCount; i < this.mTotalSlotCount; ++i) {
            if (this.mInventory[i] == null) continue;
            aItems.add(this.mInventory[i]);
        }
        return aItems;
    }

    public final boolean moveItemFromStockToUsageSlots(ItemStack aStack) {
        return this.moveItemFromStockToUsageSlots(aStack, this.mAllowDuplicateUsageTypes);
    }

    public final boolean moveItemFromStockToUsageSlots(ItemStack aStack, boolean aAllowMultiOfSameTypeInUsageSlots) {
        if (aStack != null && aStack.field_77994_a > 0) {
            int i;
            if (!this.isItemValidForUsageSlot(aStack)) {
                Logger.INFO("Stack not valid: " + ItemUtils.getItemName(aStack));
                return false;
            }
            ItemStack aStackToMove = aStack.func_77946_l();
            aStackToMove.field_77994_a = 1;
            boolean aDidSet = false;
            boolean aFoundMatching = false;
            for (i = this.getSlotID_FirstUsage(); i <= this.getSlotID_LastUsage(); ++i) {
                if (this.mInventory[i] == null || !GTUtility.areStacksEqual(aStackToMove, this.mInventory[i], true)) continue;
                Logger.INFO("Found matching stack in slot " + i + ".");
                aFoundMatching = true;
                break;
            }
            for (i = this.getSlotID_FirstUsage(); i <= this.getSlotID_LastUsage(); ++i) {
                if (this.mInventory[i] != null || aFoundMatching && !aAllowMultiOfSameTypeInUsageSlots) continue;
                this.mInventory[i] = aStackToMove;
                aDidSet = true;
                Logger.INFO("Moving new stack to usage slots.");
                break;
            }
            if (aDidSet) {
                Logger.INFO("Depleting input stack size by 1.");
                --aStack.field_77994_a;
            }
            return aDidSet;
        }
        return false;
    }

    @Override
    public final boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public final boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == this.getBaseMetaTileEntity().getFrontFacing() && this.isItemValidForUsageSlot(aStack) && aIndex < this.mInputslotCount;
    }

    public abstract ArrayList<ItemStack> getItemsValidForUsageSlots();

    public boolean isItemValidForUsageSlot(ItemStack aStack) {
        if (aStack != null) {
            for (ItemStack aValid : this.getItemsValidForUsageSlots()) {
                if (!GTUtility.areStacksEqual(aStack, aValid, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        switch (this.mTotalSlotCount) {
            case 8: 
            case 18: {
                builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 63));
                break;
            }
            case 32: {
                builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(79, 35));
            }
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        switch (this.mTotalSlotCount) {
            case 8: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).build().setPos(25, 25));
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(4).endAtSlot(7).canInsert(false).build().setPos(115, 25));
                ((ModularWindow.Builder)builder.widget(new TextWidget("Stock").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(25, 16))).widget(new TextWidget("Active").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(115, 16));
                break;
            }
            case 18: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(0).endAtSlot(8).build().setPos(25, 19));
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(9).endAtSlot(17).canInsert(false).build().setPos(97, 19));
                ((ModularWindow.Builder)builder.widget(new TextWidget("Stock").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(25, 14))).widget(new TextWidget("Active").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(15, 14));
                break;
            }
            case 32: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).build().setPos(7, 7));
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(16).endAtSlot(31).canInsert(false).build().setPos(96, 7));
            }
        }
    }
}

