/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IProjectileItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class GTGenericItem
extends Item
implements IProjectileItem {
    private final String mName;
    private final String mTooltip;
    protected IIcon mIcon;

    public GTGenericItem(String aUnlocalized, String aEnglish, String aEnglishTooltip) {
        this(aUnlocalized, aEnglish, aEnglishTooltip, true);
    }

    public GTGenericItem(String aUnlocalized, String aEnglish, String aEnglishTooltip, boolean aWriteToolTipIntoLangFile) {
        this.mName = aUnlocalized;
        GTLanguageManager.addStringLocalization(this.mName + ".name", aEnglish);
        if (GTUtility.isStringValid(aEnglishTooltip)) {
            this.mTooltip = this.mName + ".tooltip_main";
            GTLanguageManager.addStringLocalization(this.mTooltip, aEnglishTooltip, aWriteToolTipIntoLangFile);
        } else {
            this.mTooltip = null;
        }
        this.func_77637_a(AddToCreativeTab.tabMachines);
        GameRegistry.registerItem((Item)this, (String)this.mName, (String)Mods.GTPlusPlus.ID);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new GT_Item_Dispense());
    }

    public final Item func_77655_b(String aName) {
        return this;
    }

    public final String func_77658_a() {
        return this.mName;
    }

    public String func_77667_c(ItemStack aStack) {
        return this.func_77614_k() ? this.mName + "." + this.getDamage(aStack) : this.mName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        this.mIcon = aIconRegister.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.mName);
    }

    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return true;
    }

    public IIcon func_77617_a(int par1) {
        return this.mIcon;
    }

    public int getTier(ItemStack aStack) {
        return 0;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        if (this.func_77612_l() > 0 && !this.func_77614_k()) {
            aList.add(aStack.func_77958_k() - this.getDamage(aStack) + " / " + aStack.func_77958_k());
        }
        if (this.mTooltip != null) {
            aList.add(GTLanguageManager.getTranslation(this.mTooltip));
        }
        if (GTModHandler.isElectricItem(aStack)) {
            aList.add("Tier: " + this.getTier(aStack));
        }
        this.addAdditionalToolTips(aList, aStack);
    }

    protected void addAdditionalToolTips(List aList, ItemStack aStack) {
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.isItemStackUsable(aStack);
    }

    public boolean isItemStackUsable(ItemStack aStack) {
        return true;
    }

    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        ItemStack itemstack1 = aStack.func_77979_a(1);
        BehaviorDefaultDispenseItem.func_82486_a((World)aSource.func_82618_k(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        return aStack;
    }

    @Override
    public EntityArrow getProjectile(SubTag aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        return null;
    }

    @Override
    public EntityArrow getProjectile(SubTag aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        return null;
    }

    @Override
    public boolean hasProjectile(SubTag aProjectileType, ItemStack aStack) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        HEX_OxFFFFFF = stack.func_82833_r().contains("LuV") ? 0xFFFFCC : (stack.func_82833_r().contains("ZPM") ? 11331072 : (stack.func_82833_r().contains("UV") ? 0xFFFF00 : (stack.func_82833_r().contains("MAX") ? 0xFF0000 : (stack.func_82833_r().contains("Sodium") ? Utils.rgbtoHexValue(0, 0, 150) : (stack.func_82833_r().contains("Cadmium") ? Utils.rgbtoHexValue(50, 50, 60) : (stack.func_82833_r().contains("Lithium") ? Utils.rgbtoHexValue(225, 220, 255) : 0xFFFFFF))))));
        return HEX_OxFFFFFF;
    }

    public static class GT_Item_Dispense
    extends BehaviorProjectileDispense {
        public ItemStack func_82487_b(IBlockSource aSource, ItemStack aStack) {
            return ((GTGenericItem)aStack.func_77973_b()).onDispense(aSource, aStack);
        }

        protected IProjectile func_82499_a(World aWorld, IPosition aPosition) {
            return null;
        }
    }
}

