/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.overclockdescriber.FusionOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.drone.MTEHatchDroneDownLink;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTEFusionComputer
extends MTEEnhancedMultiBlockBase<MTEFusionComputer>
implements ISurvivalConstructable,
IAddUIWidgets,
IOverclockDescriptionProvider {
    private final OverclockDescriber overclockDescriber = this.createOverclockDescriber();
    public static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<MTEFusionComputer>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTEFusionComputer>>(){

        @Override
        protected IStructureDefinition<MTEFusionComputer> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTEFusionComputer.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"               ", "      ihi      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " i           i ", " h           h ", " i           i ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      ihi      ", "               "}, {"      xhx      ", "    hhccchh    ", "   eccxdxcce   ", "  eceh   hece  ", " hce       ech ", " hch       hch ", "xcx         xcx", "hch         hch", "xcx         xcx", " hch       hch ", " hce       ech ", "  eceh   hece  ", "   eccx~xcce   ", "    hhccchh    ", "      xhx      "}, {"               ", "      ihi      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " i           i ", " h           h ", " i           i ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      ihi      ", "               "}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getFusionCoil(), (int)t.getFusionCoilMeta()))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasing(), (int)t.getCasingMeta()))).addElement('i', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTEFusionComputer.class).atLeast((Map<IHatchElement<MTEFusionComputer>, Number>)ImmutableMap.of(HatchElement.InputHatch.withAdder((rec$, x$0, x$1) -> ((MTEFusionComputer)rec$).addInjector(x$0, x$1)), (Object)1)).hatchItemFilterAnd(t2 -> GTStructureUtility.filterByMTETier(t2.tier(), Integer.MAX_VALUE)).casingIndex(53).dot(1).buildAndChain(t.getCasing(), t.getCasingMeta()))).addElement('e', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTEFusionComputer.class).atLeast((Map<IHatchElement<MTEFusionComputer>, Number>)ImmutableMap.of(HatchElement.Energy.withAdder((rec$, x$0, x$1) -> ((MTEFusionComputer)rec$).addEnergyInjector(x$0, x$1)), (Object)16)).hatchItemFilterAnd(t2 -> GTStructureUtility.filterByMTETier(t2.tier(), Integer.MAX_VALUE)).casingIndex(53).dot(2).buildAndChain(t.getCasing(), t.getCasingMeta()))).addElement('x', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTEFusionComputer.class).atLeast(HatchElement.OutputHatch.withAdder((rec$, x$0, x$1) -> ((MTEFusionComputer)rec$).addExtractor(x$0, x$1))).hatchItemFilterAnd(t2 -> GTStructureUtility.filterByMTETier(t2.tier(), Integer.MAX_VALUE)).casingIndex(53).dot(3).buildAndChain(t.getCasing(), t.getCasingMeta()))).addElement('d', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTEFusionComputer.class).adder((rec$, x$0, x$1) -> ((MTEFusionComputer)rec$).addDroneHatch(x$0, x$1)).hatchId(9401).casingIndex(53).dot(4).buildAndChain(t.getCasing(), t.getCasingMeta()))).build();
        }
    };
    public GTRecipe mLastRecipe;
    public long mEUStore;
    protected static final NumberFormatMUI numberFormat;
    protected long clientEU;

    public MTEFusionComputer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEFusionComputer(String aName) {
        super(aName);
    }

    protected OverclockDescriber createOverclockDescriber() {
        return new FusionOverclockDescriber((byte)this.tier(), this.capableStartupCanonical());
    }

    @Override
    @Nonnull
    public OverclockDescriber getOverclockDescriber() {
        return this.overclockDescriber;
    }

    public abstract int tier();

    @Override
    public abstract long maxEUStore();

    public abstract long capableStartupCanonical();

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aStack) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
    }

    @Override
    public IStructureDefinition<MTEFusionComputer> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addController("Fusion Reactor").addInfo("Some kind of fusion reactor, maybe").addStructureInfo("Should probably be built similar to other fusions").addStructureInfo("See controller tooltip for details").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 1, 12) && !this.mOutputHatches.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof MTEHatchEnergy)) {
            return false;
        }
        MTEHatchEnergy tHatch = (MTEHatchEnergy)aMetaTileEntity;
        if (tHatch.mTier < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mEnergyHatches.add(tHatch);
    }

    private boolean addInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof MTEHatchInput)) {
            return false;
        }
        MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
        if (tHatch.getTierForStructure() < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        tHatch.mRecipeMap = this.getRecipeMap();
        return this.mInputHatches.add(tHatch);
    }

    private boolean addExtractor(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        if (aBaseMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof MTEHatchOutput)) {
            return false;
        }
        MTEHatchOutput tHatch = (MTEHatchOutput)aMetaTileEntity;
        if (tHatch.getTierForStructure() < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatches.add(tHatch);
    }

    private boolean addDroneHatch(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        if (aBaseMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof MTEHatchDroneDownLink)) {
            return false;
        }
        MTEHatchDroneDownLink tHatch = (MTEHatchDroneDownLink)aMetaTileEntity;
        tHatch.updateTexture(aBaseCasingIndex);
        return this.addToMachineList(aBaseMetaTileEntity, aBaseCasingIndex);
    }

    public abstract Block getCasing();

    public abstract int getCasingMeta();

    public abstract Block getFusionCoil();

    public abstract int getFusionCoilMeta();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(52)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build()};
    }

    public abstract ITexture getTextureOverlay();

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fusionRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(recipe).setConsumption(!MTEFusionComputer.this.mRunningOnLoad);
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return MTEFusionComputer.this.overclockDescriber.createCalculator(super.createOverclockCalculator(recipe), recipe);
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (!MTEFusionComputer.this.mRunningOnLoad && (long)recipe.mSpecialValue > MTEFusionComputer.this.maxEUStore()) {
                    return CheckRecipeResultRegistry.insufficientStartupPower(recipe.mSpecialValue);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (MTEFusionComputer.this.mRunningOnLoad) {
                    MTEFusionComputer.this.mRunningOnLoad = false;
                }
                MTEFusionComputer.this.turnCasingActive(result.wasSuccessful());
                MTEFusionComputer.this.mLastRecipe = result.wasSuccessful() ? this.lastRecipe : null;
                return result;
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.tier()]);
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (MTEHatch hatch : this.mEnergyHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (MTEHatch hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (MTEHatch hatch : this.mInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ++this.mTotalRunTime;
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                this.checkRecipe();
            }
            if (this.mUpdated) {
                this.mUpdate = 50;
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                    if (this.mEnergyHatches != null) {
                        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
                            long energyToMove = GTValues.V[this.tier()] / 16L;
                            if (aBaseMetaTileEntity.getStoredEU() + energyToMove >= this.maxEUStore() || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(energyToMove, false)) continue;
                            aBaseMetaTileEntity.increaseStoredEnergyUnits(energyToMove, true);
                        }
                    }
                    if (this.mEUStore <= 0L && this.mMaxProgresstime > 0) {
                        this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                    }
                    if (this.mMaxProgresstime > 0) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(-this.mEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputItems != null) {
                                for (ItemStack itemStack : this.mOutputItems) {
                                    if (itemStack == null) continue;
                                    this.addOutput(itemStack);
                                }
                            }
                            if (this.mOutputFluids != null) {
                                for (ItemStack itemStack : this.mOutputFluids) {
                                    if (itemStack == null) continue;
                                    this.addOutput((FluidStack)itemStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
                            this.mOutputItems = null;
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            this.mLastWorkingTick = this.mTotalRunTime;
                            if (this.mOutputFluids != null && this.mOutputFluids.length > 0) {
                                try {
                                    GTMod.achievements.issueAchivementHatchFluid(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), this.mOutputFluids[0]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe();
                            }
                        }
                    } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                        this.turnCasingActive(this.mMaxProgresstime > 0);
                        if (aBaseMetaTileEntity.isAllowedToWork()) {
                            this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                            if (this.checkRecipe()) {
                                if (this.mEUStore < (long)(this.mLastRecipe.mSpecialValue + this.mEUt)) {
                                    this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                                }
                                aBaseMetaTileEntity.decreaseStoredEnergyUnits(this.mLastRecipe.mSpecialValue + this.mEUt, true);
                            }
                        }
                        if (this.mMaxProgresstime <= 0) {
                            this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                        }
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.mLastRecipe = null;
                    this.stopMachine(ShutDownReasonRegistry.STRUCTURE_INCOMPLETE);
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        } else {
            this.doActivitySound(this.getActivitySoundLoop());
        }
    }

    @Override
    public boolean drainEnergyInput(long aEU) {
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        super.stopMachine(reason);
        this.turnCasingActive(false);
    }

    @Override
    public String[] getInfoData() {
        String tier = this.tier() == 6 ? EnumChatFormatting.RED + "I" + EnumChatFormatting.RESET : (this.tier() == 7 ? EnumChatFormatting.YELLOW + "II" + EnumChatFormatting.RESET : (this.tier() == 8 ? EnumChatFormatting.GRAY + "III" + EnumChatFormatting.RESET : "IV"));
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{EnumChatFormatting.BLUE + "Fusion Reactor MK " + EnumChatFormatting.RESET + tier, StatCollector.func_74838_a((String)"GT5U.fusion.req") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(powerRequired) + EnumChatFormatting.RESET + "EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mEUStore) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.maxEUStore()) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.fusion.plasma") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(plasmaOut) + EnumChatFormatting.RESET + "L/t"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 1, 12);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 1, 12, elementBudget, env, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_FUSION_LOOP;
    }

    @Override
    public boolean doesBindPlayerInventory() {
        return false;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(155, 145));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setMainBackground(GTUITextures.BACKGROUND_FUSION_COMPUTER);
    }

    @Override
    public int getGUIWidth() {
        return 176;
    }

    @Override
    public int getGUIHeight() {
        return 166;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine).setPos(10, 8))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }))).widget(new TextWidget("Hit with Soft Mallet to (re-)start the Machine if it doesn't start.").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.Center).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()).setPos(-this.getGUIWidth() / 2, 170).setSize(this.getGUIWidth() * 2, 9))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)))).widget(new TextWidget("Running perfectly.").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.Center).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()).setPos(0, 170).setSize(this.getGUIWidth(), 9))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.getBaseMetaTileEntity().getStoredEU() / (float)this.getBaseMetaTileEntity().getEUCapacity())).setDirection(ProgressBar.Direction.RIGHT).setTexture(GTUITextures.PROGRESSBAR_STORED_EU, 147).setPos(5, 156).setSize(147, 5))).widget(new TextWidget().setStringSupplier(() -> {
            if (this.clientEU > 160000000L && this.clientEU < 160010000L) {
                this.clientEU = 160000000L;
            }
            if (this.clientEU > 320000000L && this.clientEU < 320010000L) {
                this.clientEU = 320000000L;
            }
            if (this.clientEU > 640000000L && this.clientEU < 640010000L) {
                this.clientEU = 640000000L;
            }
            if (this.clientEU > 5120000000L && this.clientEU < 5120080000L) {
                this.clientEU = 5120000000L;
            }
            return numberFormat.format(this.clientEU) + " EU";
        }).setDefaultColor(((Integer)this.COLOR_TEXT_RED.get()).intValue()).setTextAlignment(Alignment.Center).setScale(0.5f).setPos(5, 157).setSize(147, 5))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().getStoredEU(), val -> {
            this.clientEU = val;
        }))).widget(new ButtonWidget().setNEITransferRect(RecipeMaps.fusionRecipes.getFrontend().getUIProperties().neiTransferRectId).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_NEI}).setPos(154, 4).setSize(18, 18));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return VoidingMode.FLUID_ONLY_MODES;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    static {
        Textures.BlockIcons.setCasingTextureForId(52, TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW).extFacing().glow().build()));
        numberFormat = new NumberFormatMUI();
    }
}

