/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.upgrade;

import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import tectech.thing.metaTileEntity.multi.godforge.upgrade.ForgeOfGodsUpgrade;

public class UpgradeStorage {
    private final EnumMap<ForgeOfGodsUpgrade, UpgradeData> unlockedUpgrades = new EnumMap(ForgeOfGodsUpgrade.class);

    public UpgradeStorage() {
        for (ForgeOfGodsUpgrade upgrade : ForgeOfGodsUpgrade.VALUES) {
            this.unlockedUpgrades.put(upgrade, new UpgradeData());
        }
    }

    public boolean isUpgradeActive(ForgeOfGodsUpgrade upgrade) {
        return this.getData(upgrade).isActive();
    }

    public boolean isCostPaid(ForgeOfGodsUpgrade upgrade) {
        return this.getData(upgrade).isCostPaid();
    }

    public short[] getPaidCosts(ForgeOfGodsUpgrade upgrade) {
        return this.getData(upgrade).amountsPaid;
    }

    public void payCost(ForgeOfGodsUpgrade upgrade, ItemStackHandler handler) {
        int i;
        UpgradeData data = this.getData(upgrade);
        if (!upgrade.hasExtraCost()) {
            data.costPaid = true;
            return;
        }
        ItemStack[] extraCost = upgrade.getExtraCost();
        for (i = 0; i < handler.getSlots(); ++i) {
            ItemStack inputStack = handler.getStackInSlot(i);
            if (inputStack == null) continue;
            for (int j = 0; j < extraCost.length; ++j) {
                int maxExtract;
                ItemStack extractedStack;
                ItemStack costStack = extraCost[j];
                short alreadyPaid = data.amountsPaid[j];
                if (alreadyPaid >= costStack.field_77994_a || !GTUtility.areStacksEqual(inputStack, costStack) || (extractedStack = handler.extractItem(i, maxExtract = costStack.field_77994_a - alreadyPaid, false)) == null) continue;
                short[] sArray = data.amountsPaid;
                int n = j;
                sArray[n] = (short)(sArray[n] + extractedStack.field_77994_a);
            }
        }
        for (i = 0; i < extraCost.length; ++i) {
            ItemStack costStack = extraCost[i];
            if (costStack == null || data.amountsPaid[i] >= costStack.field_77994_a) continue;
            return;
        }
        data.costPaid = true;
    }

    public void unlockUpgrade(ForgeOfGodsUpgrade upgrade) {
        this.getData(upgrade).active = true;
    }

    public void respecUpgrade(ForgeOfGodsUpgrade upgrade) {
        this.getData(upgrade).active = false;
    }

    public boolean checkPrerequisites(ForgeOfGodsUpgrade upgrade) {
        ForgeOfGodsUpgrade[] prereqs = upgrade.getPrerequisites();
        if (prereqs.length == 0) {
            return true;
        }
        Stream<UpgradeData> prereqStream = Arrays.stream(prereqs).map(this.unlockedUpgrades::get);
        if (upgrade.requiresAllPrerequisites()) {
            return prereqStream.allMatch(UpgradeData::isActive);
        }
        return prereqStream.anyMatch(UpgradeData::isActive);
    }

    public boolean checkSplit(ForgeOfGodsUpgrade upgrade, int maxSplitUpgrades) {
        if (ForgeOfGodsUpgrade.SPLIT_UPGRADES.contains((Object)upgrade)) {
            return ForgeOfGodsUpgrade.SPLIT_UPGRADES.stream().map(this.unlockedUpgrades::get).filter(UpgradeData::isActive).count() < (long)maxSplitUpgrades;
        }
        return true;
    }

    public boolean checkCost(ForgeOfGodsUpgrade upgrade, int availableShards) {
        if (upgrade.getShardCost() > availableShards) {
            return false;
        }
        return !upgrade.hasExtraCost() || this.isCostPaid(upgrade);
    }

    public boolean checkDependents(ForgeOfGodsUpgrade upgrade) {
        for (ForgeOfGodsUpgrade dependent : upgrade.getDependents()) {
            if (!this.isUpgradeActive(dependent)) continue;
            if (dependent.requiresAllPrerequisites()) {
                return false;
            }
            if (Arrays.stream(dependent.getPrerequisites()).map(this.unlockedUpgrades::get).filter(UpgradeData::isActive).count() > 1L) continue;
            return false;
        }
        return true;
    }

    private UpgradeData getData(ForgeOfGodsUpgrade upgrade) {
        return this.unlockedUpgrades.computeIfAbsent(upgrade, $ -> new UpgradeData());
    }

    private boolean hasAnyProgress() {
        if (this.isUpgradeActive(ForgeOfGodsUpgrade.START)) {
            return true;
        }
        for (Map.Entry<ForgeOfGodsUpgrade, UpgradeData> entry : this.unlockedUpgrades.entrySet()) {
            ForgeOfGodsUpgrade upgrade = entry.getKey();
            if (!upgrade.hasExtraCost()) continue;
            UpgradeData data = entry.getValue();
            if (data.isCostPaid()) {
                return true;
            }
            for (int i = 0; i < data.amountsPaid.length; ++i) {
                if (data.amountsPaid[i] == 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getTotalActiveUpgrades() {
        return (int)this.unlockedUpgrades.values().stream().map(UpgradeData::isActive).count();
    }

    public Collection<ForgeOfGodsUpgrade> getAllUpgrades() {
        return this.unlockedUpgrades.keySet();
    }

    public void resetAll() {
        for (UpgradeData data : this.unlockedUpgrades.values()) {
            data.active = false;
            data.costPaid = false;
        }
    }

    public void unlockAll() {
        for (UpgradeData data : this.unlockedUpgrades.values()) {
            data.active = true;
        }
    }

    public void serializeToNBT(NBTTagCompound NBT2, boolean force) {
        if (!force && !this.hasAnyProgress()) {
            return;
        }
        NBTTagCompound upgradeTag = new NBTTagCompound();
        for (ForgeOfGodsUpgrade upgrade : ForgeOfGodsUpgrade.VALUES) {
            UpgradeData data = this.unlockedUpgrades.get((Object)upgrade);
            upgradeTag.func_74757_a("upgrade" + upgrade.ordinal(), data.isActive());
            if (!upgrade.hasExtraCost()) continue;
            NBTTagCompound costTag = new NBTTagCompound();
            costTag.func_74757_a("paid", data.isCostPaid());
            for (int i = 0; i < data.amountsPaid.length; ++i) {
                costTag.func_74777_a("costPaid" + i, data.amountsPaid[i]);
            }
            upgradeTag.func_74782_a("extraCost" + upgrade.ordinal(), (NBTBase)costTag);
        }
        NBT2.func_74782_a("upgrades", (NBTBase)upgradeTag);
    }

    public void rebuildFromNBT(NBTTagCompound NBT2) {
        if (!NBT2.func_74764_b("upgrades")) {
            return;
        }
        NBTTagCompound upgradeTag = NBT2.func_74775_l("upgrades");
        for (int i = 0; i < ForgeOfGodsUpgrade.VALUES.length; ++i) {
            ForgeOfGodsUpgrade upgrade = ForgeOfGodsUpgrade.VALUES[i];
            UpgradeData data = this.unlockedUpgrades.get((Object)upgrade);
            data.active = upgradeTag.func_74767_n("upgrade" + upgrade.ordinal());
            if (!upgrade.hasExtraCost() || !upgradeTag.func_74764_b("extraCost" + upgrade.ordinal())) continue;
            NBTTagCompound costTag = upgradeTag.func_74775_l("extraCost" + upgrade.ordinal());
            data.costPaid = costTag.func_74767_n("paid");
            for (int j = 0; j < data.amountsPaid.length; ++j) {
                ((UpgradeData)data).amountsPaid[j] = costTag.func_74765_d("costPaid" + j);
            }
        }
    }

    public FakeSyncWidget<?> getSyncer(ForgeOfGodsUpgrade upgrade) {
        return new FakeSyncWidget(() -> this.unlockedUpgrades.get((Object)upgrade), val -> this.unlockedUpgrades.put(upgrade, (UpgradeData)val), (x$0, x$1) -> UpgradeData.writeToBuffer(x$0, (UpgradeData)x$1), x$0 -> UpgradeData.readFromBuffer(x$0));
    }

    public FakeSyncWidget<?> getFullSyncer() {
        return new FakeSyncWidget.ListSyncer(() -> new ArrayList<UpgradeData>(this.unlockedUpgrades.values()), val -> {
            for (int i = 0; i < val.size(); ++i) {
                this.unlockedUpgrades.put(ForgeOfGodsUpgrade.VALUES[i], (UpgradeData)val.get(i));
            }
        }, (x$0, x$1) -> UpgradeData.writeToBuffer(x$0, (UpgradeData)x$1), x$0 -> UpgradeData.readFromBuffer(x$0));
    }

    private static class UpgradeData {
        private boolean active;
        private boolean costPaid;
        private final short[] amountsPaid = new short[12];

        private UpgradeData() {
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isCostPaid() {
            return this.costPaid;
        }

        private static void writeToBuffer(PacketBuffer buf, UpgradeData data) {
            buf.writeBoolean(data.isActive());
            buf.writeBoolean(data.isCostPaid());
            for (int i = 0; i < data.amountsPaid.length; ++i) {
                buf.writeShort((int)data.amountsPaid[i]);
            }
        }

        private static UpgradeData readFromBuffer(PacketBuffer buf) {
            UpgradeData data = new UpgradeData();
            data.active = buf.readBoolean();
            data.costPaid = buf.readBoolean();
            for (int i = 0; i < data.amountsPaid.length; ++i) {
                data.amountsPaid[i] = buf.readShort();
            }
            return data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpgradeData that = (UpgradeData)o;
            if (this.active != that.active) {
                return false;
            }
            if (this.costPaid != that.costPaid) {
                return false;
            }
            return Arrays.equals(this.amountsPaid, that.amountsPaid);
        }
    }
}

