/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockApicultureType;
import forestry.apiculture.genetics.Bee;
import forestry.plugins.PluginApiculture;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kubatech.api.DynamicInventory;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.api.utils.ItemUtils;
import kubatech.client.effect.MegaApiaryBeesRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEMegaIndustrialApiary
extends KubaTechGTMultiBlockBase<MTEMegaIndustrialApiary>
implements ISurvivalConstructable {
    private byte mGlassTier = 0;
    private int mCasing = 0;
    private int mMaxSlots = 0;
    private int mPrimaryMode = 0;
    private int mSecondaryMode = 0;
    private final ArrayList<BeeSimulator> mStorage = new ArrayList();
    private static final ItemStack royalJelly = PluginApiculture.items.royalJelly.getItemStack(1);
    private static final int CASING_INDEX = 10;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "mainsurvival";
    private static final int CONFIGURATION_WINDOW_ID = 999;
    private static final int MEGA_APIARY_STORAGE_VERSION = 2;
    private static final String[][] struct = StructureUtility.transpose((String[][])new String[][]{{"               ", "               ", "               ", "      HHH      ", "    HHAAAHH    ", "    HAPLPAH    ", "   HAPAAAPAH   ", "   HALAAALAH   ", "   HAPAAAPAH   ", "    HAPLPAH    ", "    HHAAAHH    ", "      HHH      ", "               ", "               ", "               "}, {"               ", "               ", "      GGG      ", "   GGG   GG    ", "   G       G   ", "   G       G   ", "  G         G  ", "  G         G  ", "  G         G  ", "   G       G   ", "   G       G   ", "    GG   GG    ", "      GGG      ", "               ", "               "}, {"               ", "      HHH      ", "   HHH   HHH   ", "  H        GH  ", "  H         H  ", "  H         H  ", " H           H ", " H           H ", " H           H ", "  H         H  ", "  H         H  ", "  HG       GH  ", "   HHH   HHH   ", "      HHH      ", "               "}, {"      GGG      ", "   GGG   GGG   ", "  G         G  ", " G           G ", " G           G ", " G           G ", "G             G", "G             G", "G             G", " G           G ", " G           G ", " G           G ", "  G         G  ", "   GGG   GGG   ", "      GGG      "}, {"      AAA      ", "   OLA   ALO   ", "  P         P  ", " O           O ", " L           L ", " A           A ", "A             A", "A             A", "A             A", " A           A ", " L           L ", " O           O ", "  P         P  ", "   OLA   ALO   ", "      AAA      "}, {"     AAAAA     ", "   NA     AO   ", "  P         P  ", " N           O ", " A           A ", "A             A", "A     III     A", "A     III     A", "A     III     A", "A             A", " A           A ", " N           N ", "  P         P  ", "   NA     AN   ", "     AAAAA     "}, {"     AAAAA     ", "   NA FFF AO   ", "  PFF     FFP  ", " NF        FFO ", " AF         FA ", "A             A", "AF    JJJ    FA", "AF    JKJ    FA", "AF    JJJ    FA", "A             A", " AF         FA ", " NFF       FFN ", "  PFF     FFP  ", "   NA FFF AN   ", "     AAAAA     "}, {"      AAA      ", "   OLAFFFALO   ", "  PFFFFFFFFFP  ", " OFFFF   FFFFO ", " LFF       FFL ", " AFF FFFFF  FA ", "AFF  FKKKFF FFA", "AFF FFKKKFF FFA", "AFF FFKKKF  FFA", " AF  FFFFF  FA ", " LFF   FF  FFL ", " OFFFF    FFFO ", "  PFFFFFFFFFP  ", "   OLAFFFALO   ", "      AAA      "}, {"      G~G      ", "   GGGBBBGGG   ", "  GBBFFFFFBBG  ", " GBFFF   FFBBG ", " GBF       FBG ", " GFF FFFFF  FG ", "GBF  FKKKFF FBG", "GBF FFKJKFF FBG", "GBF FFKKKF  FBG", " GF  FFFFF  FG ", " GBF   FF  FBG ", " GBBFF    FBBG ", "  GBBFFFFFBBG  ", "   GGGBBBGGG   ", "      GGG      "}, {"      HHH      ", "    HHBBBHH    ", "  HHBBBBBBBHH  ", "  HBBBWWWBBBH  ", " HBBWWWWWWWBBH ", " HBBWBBBBBWWBH ", "HBBWWBBBBBBWBBH", "HBBWBBBBBBBWBBH", "HBBWBBBBBBWWBBH", " HBWWBBBBBWWBH ", " HBBWWWBBWWBBH ", "  HBBBWWWWBBH  ", "  HHBBBBBBBHH  ", "    HHBBBHH    ", "      HHH      "}, {"               ", "     GGGGG     ", "   GGGBBBBGG   ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", "   GGBBBBBGG   ", "     GGGGG     ", "               "}, {"               ", "      HHH      ", "    HHBBBHH    ", "   HBBBBBBBH   ", "  HBBBBBBBBBH  ", "  HBBBBBBBBBH  ", " HBBBBBBBBBBBH ", " HBBBBBBBBBBBH ", " HBBBBBBBBBBBH ", "  HBBBBBBBBBH  ", "  HBBBBBBBBBH  ", "   HBBBBBBBH   ", "    HHBBBHH    ", "      HHH      ", "               "}, {"               ", "               ", "      GGG      ", "    GGBBBGG    ", "   GBBBBBBBG   ", "   GBBBBBBBG   ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", "   GBBBBBBBG   ", "   GBBBBBBBG   ", "    GGBBBGG    ", "      GGG      ", "               ", "               "}, {"               ", "               ", "       H       ", "     HHBHH     ", "    HBBBBBH    ", "   HBBBBBBBH   ", "   HBBBBBBBH   ", "  HBBBBBBBBBH  ", "   HBBBBBBBH   ", "   HBBBBBBBH   ", "    HBBBBBH    ", "     HHBHH     ", "       H       ", "               ", "               "}, {"               ", "               ", "               ", "       G       ", "     GGBGG     ", "    GBBBBBG    ", "    GBBBBBG    ", "   GBBBBBBBG   ", "    GBBBBBG    ", "    GBBBBBG    ", "     GGBGG     ", "       G       ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "      HHH      ", "     HHHHH     ", "    HHBBBHH    ", "    HHBBBHH    ", "    HHBBBHH    ", "     HHBHH     ", "      HHH      ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "      GGG      ", "      GHG      ", "      GGG      ", "               ", "               ", "               ", "               ", "               ", "               "}});
    private static final IStructureDefinition<MTEMegaIndustrialApiary> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", struct).addShape("mainsurvival", (String[][])Arrays.stream(struct).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("W", " ").replaceAll("F", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('A', BorosilicateGlass.ofBoroGlass((byte)0, (t, v) -> {
        t.mGlassTier = v;
    }, t -> t.mGlassTier)).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150346_d, (int)0), StructureUtility.ofBlock((Block)Blocks.field_150349_c, (int)0)})).addElement('G', GTStructureUtility.buildHatchAdder(MTEMegaIndustrialApiary.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy, HatchElement.Maintenance).casingIndex(10).dot(1).buildAndChain(StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)))).addElement('H', StructureUtility.ofBlocksMap(Collections.singletonMap(Blocks.field_150344_f, (Collection)IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList())), (Block)Blocks.field_150344_f, (int)5)).addElement('I', StructureUtility.ofBlocksMap(Collections.singletonMap(Blocks.field_150376_bx, (Collection)IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList())), (Block)Blocks.field_150376_bx, (int)5)).addElement('J', StructureUtility.ofBlock((Block)PluginApiculture.blocks.apiculture, (int)BlockApicultureType.APIARY.getMeta())).addElement('K', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.PLAIN.ordinal())).addElement('L', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.HYGRO.ordinal())).addElement('N', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.STABILIZER.ordinal())).addElement('O', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.HEATER.ordinal())).addElement('P', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.FAN.ordinal())).addElement('W', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)Blocks.field_150355_j, (int)0), StructureUtility.ofBlock((Block)BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater), (int)0)})).addElement('F', (IStructureElement)new IStructureElementNoPlacement<MTEMegaIndustrialApiary>(){

        public boolean check(MTEMegaIndustrialApiary mte, World world, int x, int y, int z) {
            mte.flowerCheck(world, x, y, z);
            return true;
        }

        public boolean spawnHint(MTEMegaIndustrialApiary mte, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)1);
            return true;
        }
    }).build();
    private boolean isCacheDirty = true;
    private final HashMap<String, String> flowersCache = new HashMap();
    private final HashSet<String> flowersCheck = new HashSet();
    private boolean flowersError = false;
    private boolean needsTVarUpdate = false;
    private int megaApiaryStorageVersion = 0;
    private static final UIInfo<?, ?> MegaApiaryUI = MTEMegaIndustrialApiary.createKTMetaTileEntityUI(KT_ModulaUIContainer_MegaIndustrialApiary::new);
    DynamicInventory<BeeSimulator> dynamicInventory = new DynamicInventory<BeeSimulator>(128, 60, () -> this.mMaxSlots, this.mStorage, s -> s.queenStack).allowInventoryInjection(input -> {
        World w = this.getBaseMetaTileEntity().getWorld();
        float t = (float)this.getVoltageTierExact();
        BeeSimulator bs = new BeeSimulator(input, w, t);
        if (bs.isValid) {
            this.mStorage.add(bs);
            return input;
        }
        return null;
    }).allowInventoryExtraction(this.mStorage::remove).allowInventoryReplace((i, stack) -> {
        if (stack.field_77994_a != 1) {
            return null;
        }
        World w = this.getBaseMetaTileEntity().getWorld();
        float t = (float)this.getVoltageTierExact();
        BeeSimulator bs = new BeeSimulator(stack, w, t);
        if (bs.isValid) {
            BeeSimulator removed = this.mStorage.remove(i);
            this.mStorage.add(i, bs);
            return removed.queenStack;
        }
        return null;
    }).setEnabled(() -> this.mMaxProgresstime == 0);
    private boolean isInInventory = true;
    private HashMap<ItemStack, Double> GUIDropProgress = new HashMap();
    final HashMap<GTUtility.ItemId, Double> dropProgress = new HashMap();

    public MTEMegaIndustrialApiary(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMegaIndustrialApiary(String aName) {
        super(aName);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.tryOutputAll(this.mStorage, s -> Collections.singletonList(s.queenStack));
        }
    }

    private void flowerCheck(World world, int x, int y, int z) {
        if (!this.flowersCheck.isEmpty() && !world.func_147437_c(x, y, z)) {
            this.flowersCheck.removeIf(s -> FlowerManager.flowerRegistry.isAcceptedFlower(s, world, x, y, z));
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 8, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 7, 8, 0, elementBudget, env, true);
        if (built == -1) {
            GTUtility.sendChatToPlayer(env.getActor(), EnumChatFormatting.GREEN + "Auto placing done ! Now go place the water and flowers yourself !");
            return 0;
        }
        return built;
    }

    @Override
    public IStructureDefinition<MTEMegaIndustrialApiary> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Mega Apiary").addInfo("The ideal home for your bees").addInfo("Use screwdriver to change primary mode (INPUT/OUTPUT/OPERATING)").addInfo("Use screwdriver + shift to change operation mode (NORMAL/SWARMER)").addSeparator().addInfo(EnumChatFormatting.GOLD + "Input Mode:").addInfo("- Does not take power").addInfo("- Put your queens in the input bus to put them in the internal buffer").addSeparator().addInfo(EnumChatFormatting.GOLD + "Output Mode:").addInfo("- Does not take power").addInfo("- Will give your bees back to output bus").addSeparator().addInfo(EnumChatFormatting.GOLD + "Operating Mode:").addInfo("- NORMAL:").addInfo("  - For each " + MTEMegaIndustrialApiary.voltageTooltipFormatted(6) + " amp you can insert 1 bee").addInfo("  - Processing time: 5 seconds").addInfo("  - Uses 1 " + MTEMegaIndustrialApiary.voltageTooltipFormatted(6) + " amp per queen").addInfo("  - All bees are accelerated 64 times").addInfo("  - 8 production upgrades are applied").addInfo("  - Genetic Stabilizer upgrade applied").addInfo("  - Simulates perfect environment for your bees").addInfo("  - Additionally you can provide royal jelly to increase the outputs:").addInfo("    - 1 royal jelly grants 5% bonus per bee").addInfo("    - They will be consumed on each start of operation").addInfo("    - and be applied to that operation only").addInfo("    - Max bonus: 200%").addInfo("- SWARMER:").addInfo("  - You can only insert 1 queen").addInfo("  - It will slowly produce ignoble princesses").addInfo("  - Consumes 100 royal jelly per operation").addInfo("  - Base processing time: 1 minute").addInfo("  - Uses 1 amp " + MTEMegaIndustrialApiary.voltageTooltipFormatted(5)).addInfo("  - Can overclock").beginStructureBlock(15, 17, 15, false).addController("Front Bottom Center").addCasingInfoMin("Bronze Plated Bricks", 190, false).addOtherStructurePart("Borosilicate Glass", "Look at the hologram").addStructureInfo("The glass tier limits the Energy Input tier").addStructureInfo("Regular water and IC2 Distilled Water are accepted").addOtherStructurePart("Flowers", "On dirt/grass", 2).addInputBus("Any casing", 1).addOutputBus("Any casing", 1).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).toolTipFinisher(GTValues.AuthorKuba, "Runakai");
        return tt;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mGlassTier", this.mGlassTier);
        aNBT.func_74768_a("mPrimaryMode", this.mPrimaryMode);
        aNBT.func_74768_a("mSecondaryMode", this.mSecondaryMode);
        aNBT.func_74768_a("mStorageSize", this.mStorage.size());
        for (int i = 0; i < this.mStorage.size(); ++i) {
            aNBT.func_74782_a("mStorage." + i, (NBTBase)this.mStorage.get(i).toNBTTagCompound());
        }
        aNBT.func_74768_a("MEGA_APIARY_STORAGE_VERSION", 2);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mGlassTier = aNBT.func_74771_c("mGlassTier");
        this.mPrimaryMode = aNBT.func_74762_e("mPrimaryMode");
        this.mSecondaryMode = aNBT.func_74762_e("mSecondaryMode");
        int isize = aNBT.func_74762_e("mStorageSize");
        for (int i = 0; i < isize; ++i) {
            this.mStorage.add(new BeeSimulator(aNBT.func_74775_l("mStorage." + i)));
        }
        this.megaApiaryStorageVersion = aNBT.func_74762_e("MEGA_APIARY_STORAGE_VERSION");
        this.flowersCache.clear();
        this.mStorage.forEach(s -> this.flowersCache.put(s.flowerType, s.flowerTypeDescription));
        this.flowersCache.remove("");
        this.isCacheDirty = false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, "Can't change mode when running !");
            return;
        }
        if (!aPlayer.func_70093_af()) {
            ++this.mPrimaryMode;
            if (this.mPrimaryMode == 3) {
                this.mPrimaryMode = 0;
            }
            switch (this.mPrimaryMode) {
                case 0: {
                    GTUtility.sendChatToPlayer(aPlayer, "Changed primary mode to: Input mode");
                    break;
                }
                case 1: {
                    GTUtility.sendChatToPlayer(aPlayer, "Changed primary mode to: Output mode");
                    break;
                }
                case 2: {
                    GTUtility.sendChatToPlayer(aPlayer, "Changed primary mode to: Operating mode");
                }
            }
        } else {
            if (!this.mStorage.isEmpty()) {
                GTUtility.sendChatToPlayer(aPlayer, "Can't change operating mode when the multi is not empty !");
                return;
            }
            ++this.mSecondaryMode;
            if (this.mSecondaryMode == 2) {
                this.mSecondaryMode = 0;
            }
            switch (this.mSecondaryMode) {
                case 0: {
                    GTUtility.sendChatToPlayer(aPlayer, "Changed secondary mode to: Normal mode");
                    break;
                }
                case 1: {
                    GTUtility.sendChatToPlayer(aPlayer, "Changed secondary mode to: Swarmer mode");
                }
            }
        }
    }

    private void updateMaxSlots() {
        int mOld = this.mMaxSlots;
        long v = this.getMaxInputEu();
        this.mMaxSlots = v < GTValues.V[6] ? 0 : (this.mSecondaryMode == 0 ? (int)(v / GTValues.V[6]) : 1);
        if (mOld != 0 && mOld != this.mMaxSlots) {
            this.needsTVarUpdate = true;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdate < -550) {
                this.mUpdate = 50;
            }
        } else if (aBaseMetaTileEntity.isActive() && aTick % 100L == 0L) {
            int[] abc = new int[]{0, -2, 7};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + aBaseMetaTileEntity.getXCoord();
            xyz[1] = xyz[1] + aBaseMetaTileEntity.getYCoord();
            xyz[2] = xyz[2] + aBaseMetaTileEntity.getZCoord();
            this.showBees(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], 100);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showBees(World world, int x, int y, int z, int age) {
        MegaApiaryBeesRenderer bee = new MegaApiaryBeesRenderer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)bee);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.updateMaxSlots();
        if (this.mPrimaryMode < 2) {
            if (this.mPrimaryMode == 0 && this.mStorage.size() < this.mMaxSlots) {
                World w = this.getBaseMetaTileEntity().getWorld();
                float t = (float)this.getVoltageTierExact();
                ArrayList<ItemStack> inputs = this.getStoredInputs();
                for (ItemStack input : inputs) {
                    if (BeeManager.beeRoot.getType(input) == EnumBeeType.QUEEN) {
                        BeeSimulator bs = new BeeSimulator(input, w, t);
                        if (bs.isValid) {
                            this.mStorage.add(bs);
                            this.isCacheDirty = true;
                        }
                    }
                    if (this.mStorage.size() < this.mMaxSlots) continue;
                    break;
                }
                this.updateSlots();
            } else if (this.mPrimaryMode == 1 && !this.mStorage.isEmpty()) {
                if (this.tryOutputAll(this.mStorage, s -> Collections.singletonList(s.queenStack))) {
                    this.isCacheDirty = true;
                }
            } else {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            this.mMaxProgresstime = 10;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.lEUt = 0L;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        if (this.mPrimaryMode == 2 && this.mMaxSlots > 0 && !this.mStorage.isEmpty()) {
            if (this.mSecondaryMode == 0) {
                int maxConsume;
                if (this.megaApiaryStorageVersion != 2) {
                    this.megaApiaryStorageVersion = 2;
                    World w = this.getBaseMetaTileEntity().getWorld();
                    float t = (float)this.getVoltageTierExact();
                    this.mStorage.forEach(s -> s.generate(w, t));
                }
                if (this.mStorage.size() > this.mMaxSlots) {
                    return SimpleCheckRecipeResult.ofFailure("MegaApiary_slotoverflow");
                }
                if (this.flowersError) {
                    return SimpleCheckRecipeResult.ofFailure("MegaApiary_noflowers");
                }
                if (this.needsTVarUpdate) {
                    float t = (float)this.getVoltageTierExact();
                    this.needsTVarUpdate = false;
                    World w = this.getBaseMetaTileEntity().getWorld();
                    this.mStorage.forEach(s -> s.updateTVar(w, t));
                }
                int toConsume = maxConsume = Math.min(this.mStorage.size(), this.mMaxSlots) * 40;
                ArrayList<ItemStack> inputs = this.getStoredInputs();
                for (ItemStack input : inputs) {
                    if (!input.func_77969_a(royalJelly)) continue;
                    int consumed = Math.min(input.field_77994_a, toConsume);
                    input.field_77994_a -= consumed;
                    if ((toConsume -= consumed) != 0) continue;
                    break;
                }
                double boosted = 1.0;
                if (toConsume != maxConsume) {
                    boosted += ((double)maxConsume - (double)toConsume) / (double)maxConsume * 2.0;
                    this.updateSlots();
                }
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                int mStorageSize = Math.min(this.mStorage.size(), this.mMaxSlots);
                for (int i = 0; i < mStorageSize; ++i) {
                    BeeSimulator beeSimulator = this.mStorage.get(i);
                    stacks.addAll(beeSimulator.getDrops(this, 6400.0 * boosted));
                }
                this.lEUt = -((int)((double)GTValues.V[6] * (double)this.mMaxSlots * 0.99));
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.mMaxProgresstime = 100;
                this.mOutputItems = stacks.toArray(new ItemStack[0]);
            } else {
                if (!this.depleteInput(PluginApiculture.items.royalJelly.getItemStack(64)) || !this.depleteInput(PluginApiculture.items.royalJelly.getItemStack(36))) {
                    this.updateSlots();
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                this.calculateOverclock(GTValues.V[5] - 2L, 1200);
                if (this.lEUt > 0L) {
                    this.lEUt = -this.lEUt;
                }
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.mOutputItems = new ItemStack[]{this.mStorage.get(0).createIgnobleCopy()};
                this.updateSlots();
            }
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Running in mode: " + EnumChatFormatting.GOLD + (this.mPrimaryMode == 0 ? "Input mode" : (this.mPrimaryMode == 1 ? "Output mode" : (this.mSecondaryMode == 0 ? "Operating mode (NORMAL)" : "Operating mode (SWARMER)"))));
        info.add("Bee storage (" + EnumChatFormatting.GOLD + this.mStorage.size() + EnumChatFormatting.RESET + "/" + (this.mStorage.size() > this.mMaxSlots ? EnumChatFormatting.DARK_RED.toString() : EnumChatFormatting.GOLD.toString()) + this.mMaxSlots + EnumChatFormatting.RESET + "):");
        HashMap<String, Integer> infos = new HashMap<String, Integer>();
        for (int i = 0; i < this.mStorage.size(); ++i) {
            StringBuilder builder = new StringBuilder();
            if (i > this.mMaxSlots) {
                builder.append(EnumChatFormatting.DARK_RED);
            }
            builder.append(EnumChatFormatting.GOLD);
            builder.append(this.mStorage.get((int)i).queenStack.func_82833_r());
            infos.merge(builder.toString(), 1, Integer::sum);
        }
        infos.forEach((key, value) -> info.add("x" + value + ": " + key));
        return info.toArray(new String[0]);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mGlassTier = 0;
        this.mCasing = 0;
        if (this.isCacheDirty) {
            this.flowersCache.clear();
            this.mStorage.forEach(s -> this.flowersCache.put(s.flowerType, s.flowerTypeDescription));
            this.flowersCache.remove("");
            this.isCacheDirty = false;
        }
        this.flowersCheck.clear();
        this.flowersCheck.addAll(this.flowersCache.keySet());
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 8, 0)) {
            return false;
        }
        if (this.mGlassTier < 10 && !this.mEnergyHatches.isEmpty()) {
            for (MTEHatchEnergy hatchEnergy : this.mEnergyHatches) {
                if (this.mGlassTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        boolean valid = this.mMaintenanceHatches.size() == 1 && !this.mEnergyHatches.isEmpty() && this.mCasing >= 190;
        boolean bl = this.flowersError = valid && !this.flowersCheck.isEmpty();
        if (valid) {
            this.updateMaxSlots();
        }
        return valid;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMegaIndustrialApiary(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(10), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(10), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(10)};
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        MegaApiaryUI.open(aPlayer, aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
        return true;
    }

    @Override
    public void createInventorySlots() {
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.isInInventory = !this.getBaseMetaTileEntity().isActive();
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(190, 85).setEnabled(w -> !this.isInInventory));
        builder.widget(this.dynamicInventory.asWidget(builder, buildContext).setPos(10, 16).setBackground(new IDrawable[]{new Rectangle().setColor(Color.rgb((int)163, (int)163, (int)198))}).setEnabled(w -> this.isInInventory));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.isInInventory, i -> {
            this.isInInventory = i;
        }).setTextureGetter(i -> i == 0 ? new Text("Inventory") : new Text("Status")).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(140, 91).setSize(55, 16));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, null);
        builder.widget(((Scrollable)new Scrollable().setVerticalScroll().widget(screenElements.setPos(10, 0))).setPos(0, 7).setSize(190, 79).setEnabled(w -> !this.isInInventory));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget((Widget)this.createPowerSwitchButton((IWidgetBuilder)builder))).widget((Widget)this.createVoidExcessButton((IWidgetBuilder)builder))).widget((Widget)this.createInputSeparationButton((IWidgetBuilder)builder))).widget((Widget)this.createBatchModeButton((IWidgetBuilder)builder))).widget((Widget)this.createLockToSingleRecipeButton((IWidgetBuilder)builder))).widget((Widget)this.createStructureUpdateButton((IWidgetBuilder)builder));
        DynamicPositionedRow configurationElements = new DynamicPositionedRow();
        this.addConfigurationWidgets(configurationElements, buildContext);
        builder.widget(configurationElements.setSpace(2).setAlignment(MainAxisAlignment.SPACE_BETWEEN).setPos(this.getRecipeLockingButtonPos().add(18, 0)));
    }

    @Override
    protected void addConfigurationWidgets(DynamicPositionedRow configurationElements, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(999, this::createConfigurationWindow);
        configurationElements.setSynced(false);
        configurationElements.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(999);
            }
        }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_CYCLIC}).addTooltip("Configuration").setSize(16, 16));
    }

    protected ModularWindow createConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)100);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setPos(5, 5).setSize(16, 16))).widget(new TextWidget("Configuration").setPos(25, 9))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(185, 3))).widget(((Column)((Column)new Column().widget(new CycleButtonWidget().setLength(3).setGetter(() -> this.mPrimaryMode).setSetter(val -> {
            if (this.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer(player, "Can't change mode when running !");
                return;
            }
            this.mPrimaryMode = val;
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            switch (this.mPrimaryMode) {
                case 0: {
                    GTUtility.sendChatToPlayer(player, "Changed primary mode to: Input mode");
                    break;
                }
                case 1: {
                    GTUtility.sendChatToPlayer(player, "Changed primary mode to: Output mode");
                    break;
                }
                case 2: {
                    GTUtility.sendChatToPlayer(player, "Changed primary mode to: Operating mode");
                }
            }
        }).addTooltip(0, new Text("Input").color(Color.YELLOW.dark(3))).addTooltip(1, new Text("Output").color(Color.YELLOW.dark(3))).addTooltip(2, new Text("Operating").color(Color.GREEN.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Input").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : (i == 1 ? new Text("Output").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Operating").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f))).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GTUITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("Primary mode"))).widget(new CycleButtonWidget().setLength(2).setGetter(() -> this.mSecondaryMode).setSetter(val -> {
            if (this.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer(player, "Can't change mode when running !");
                return;
            }
            this.mSecondaryMode = val;
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            switch (this.mSecondaryMode) {
                case 0: {
                    GTUtility.sendChatToPlayer(player, "Changed secondary mode to: Normal mode");
                    break;
                }
                case 1: {
                    GTUtility.sendChatToPlayer(player, "Changed secondary mode to: Swarmer mode");
                }
            }
        }).addTooltip(0, new Text("Normal").color(Color.GREEN.dark(3))).addTooltip(1, new Text("Swarmer").color(Color.YELLOW.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Normal").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Swarmer").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f)).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GTUITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("Secondary mode"))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(10, 30))).widget(((Column)((Column)new Column().widget(new TextWidget("Primary mode").setSize(100, 18))).widget(new TextWidget("Secondary mode").setSize(100, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(80, 30))).widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CROSS).setSize(18, 18).setPos(10, 30).addTooltip(new Text("Can't change configuration when running !").color(Color.RED.dark(3))).setEnabled(widget -> this.getBaseMetaTileEntity().isActive()));
        return builder.build();
    }

    @Override
    protected String generateCurrentRecipeInfoString() {
        if (this.mSecondaryMode == 1) {
            return super.generateCurrentRecipeInfoString();
        }
        StringBuilder ret = new StringBuilder(EnumChatFormatting.WHITE + "Progress: ").append(String.format("%,.2f", (double)this.mProgresstime / 20.0)).append("s / ").append(String.format("%,.2f", (double)this.mMaxProgresstime / 20.0)).append("s (").append(String.format("%,.1f", (double)this.mProgresstime / (double)this.mMaxProgresstime * 100.0)).append("%)\n");
        for (Map.Entry<ItemStack, Double> drop : this.GUIDropProgress.entrySet()) {
            int outputSize = Arrays.stream(this.mOutputItems).filter(s -> s.func_77969_a((ItemStack)drop.getKey())).mapToInt(i -> i.field_77994_a).sum();
            ret.append(EnumChatFormatting.AQUA).append(drop.getKey().func_82833_r()).append(EnumChatFormatting.WHITE).append(": ");
            if (outputSize == 0) {
                ret.append(String.format("%.2f", drop.getValue() * 100.0)).append("%\n");
                continue;
            }
            ret.append(EnumChatFormatting.GOLD).append(String.format("x%d %s(+%.2f/sec)\n", outputSize, EnumChatFormatting.WHITE, (double)outputSize / (double)(this.mMaxProgresstime / 20)));
        }
        return ret.toString();
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mSecondaryMode, b -> {
            this.mSecondaryMode = b;
        }));
        screenElements.widget((Widget)new FakeSyncWidget(() -> {
            HashMap<ItemStack, Double> ret = new HashMap<ItemStack, Double>();
            HashMap<GTUtility.ItemId, Double> dropProgress = new HashMap<GTUtility.ItemId, Double>();
            for (Map.Entry<GTUtility.ItemId, Double> entry : this.dropProgress.entrySet()) {
                dropProgress.merge(entry.getKey(), entry.getValue(), Double::sum);
            }
            for (Map.Entry<GTUtility.ItemId, Double> entry : dropProgress.entrySet()) {
                ret.put(BeeSimulator.dropstacks.get(entry.getKey()), entry.getValue());
            }
            return ret;
        }, h -> {
            this.GUIDropProgress = h;
        }, (buffer, h) -> {
            buffer.func_150787_b(h.size());
            for (Map.Entry itemStackDoubleEntry : h.entrySet()) {
                try {
                    buffer.func_150788_a((ItemStack)itemStackDoubleEntry.getKey());
                    buffer.writeDouble(((Double)itemStackDoubleEntry.getValue()).doubleValue());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, buffer -> {
            int len = buffer.func_150792_a();
            HashMap<ItemStack, Double> ret = new HashMap<ItemStack, Double>(len);
            for (int i = 0; i < len; ++i) {
                try {
                    ret.put(buffer.func_150791_c(), buffer.readDouble());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        }));
        super.drawTexts(screenElements, inventorySlot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MEGA_INDUSTRIAL_APIARY_LOOP;
    }

    private static class BeeSimulator {
        final ItemStack queenStack;
        boolean isValid;
        List<BeeDrop> drops = new ArrayList<BeeDrop>();
        List<BeeDrop> specialDrops = new ArrayList<BeeDrop>();
        float beeSpeed;
        float maxBeeCycles;
        String flowerType;
        String flowerTypeDescription;
        private static IBeekeepingMode mode;
        static final Map<GTUtility.ItemId, ItemStack> dropstacks;

        public BeeSimulator(ItemStack queenStack, World world, float t) {
            this.isValid = false;
            this.queenStack = queenStack.func_77946_l();
            this.queenStack.field_77994_a = 1;
            this.generate(world, t);
            this.isValid = true;
            --queenStack.field_77994_a;
        }

        public void generate(World world, float t) {
            if (mode == null) {
                mode = BeeManager.beeRoot.getBeekeepingMode(world);
            }
            this.drops.clear();
            this.specialDrops.clear();
            if (BeeManager.beeRoot.getType(this.queenStack) != EnumBeeType.QUEEN) {
                return;
            }
            IBee queen = BeeManager.beeRoot.getMember(this.queenStack);
            IBeeModifier beeModifier = mode.getBeeModifier();
            float mod = beeModifier.getLifespanModifier(null, null, 1.0f);
            int h = queen.getMaxHealth();
            this.maxBeeCycles = (float)h / (1.0f / mod);
            IBeeGenome genome = queen.getGenome();
            this.flowerType = genome.getFlowerProvider().getFlowerType();
            this.flowerTypeDescription = genome.getFlowerProvider().getDescription();
            IAlleleBeeSpecies primary = genome.getPrimary();
            this.beeSpeed = genome.getSpeed();
            genome.getPrimary().getProductChances().forEach((key, value) -> this.drops.add(new BeeDrop((ItemStack)key, value.floatValue(), this.beeSpeed, t)));
            genome.getSecondary().getProductChances().forEach((key, value) -> this.drops.add(new BeeDrop((ItemStack)key, value.floatValue() / 2.0f, this.beeSpeed, t)));
            primary.getSpecialtyChances().forEach((key, value) -> this.specialDrops.add(new BeeDrop((ItemStack)key, value.floatValue(), this.beeSpeed, t)));
        }

        public BeeSimulator(NBTTagCompound tag) {
            int i;
            this.queenStack = ItemUtils.readItemStackFromNBT(tag.func_74775_l("queenStack"));
            this.isValid = tag.func_74767_n("isValid");
            this.drops = new ArrayList<BeeDrop>();
            this.specialDrops = new ArrayList<BeeDrop>();
            int isize = tag.func_74762_e("dropssize");
            for (i = 0; i < isize; ++i) {
                this.drops.add(new BeeDrop(tag.func_74775_l("drops" + i)));
            }
            isize = tag.func_74762_e("specialDropssize");
            for (i = 0; i < isize; ++i) {
                this.specialDrops.add(new BeeDrop(tag.func_74775_l("specialDrops" + i)));
            }
            this.beeSpeed = tag.func_74760_g("beeSpeed");
            this.maxBeeCycles = tag.func_74760_g("maxBeeCycles");
            if (tag.func_74764_b("flowerType") && tag.func_74764_b("flowerTypeDescription")) {
                this.flowerType = tag.func_74779_i("flowerType");
                this.flowerTypeDescription = tag.func_74779_i("flowerTypeDescription");
            } else {
                IBee queen = BeeManager.beeRoot.getMember(this.queenStack);
                IBeeGenome genome = queen.getGenome();
                this.flowerType = genome.getFlowerProvider().getFlowerType();
                this.flowerTypeDescription = genome.getFlowerProvider().getDescription();
            }
        }

        public NBTTagCompound toNBTTagCompound() {
            int i;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("queenStack", (NBTBase)ItemUtils.writeItemStackToNBT(this.queenStack));
            tag.func_74757_a("isValid", this.isValid);
            tag.func_74768_a("dropssize", this.drops.size());
            for (i = 0; i < this.drops.size(); ++i) {
                tag.func_74782_a("drops" + i, (NBTBase)this.drops.get(i).toNBTTagCompound());
            }
            tag.func_74768_a("specialDropssize", this.specialDrops.size());
            for (i = 0; i < this.specialDrops.size(); ++i) {
                tag.func_74782_a("specialDrops" + i, (NBTBase)this.specialDrops.get(i).toNBTTagCompound());
            }
            tag.func_74776_a("beeSpeed", this.beeSpeed);
            tag.func_74776_a("maxBeeCycles", this.maxBeeCycles);
            tag.func_74778_a("flowerType", this.flowerType);
            tag.func_74778_a("flowerTypeDescription", this.flowerTypeDescription);
            return tag;
        }

        public List<ItemStack> getDrops(MTEMegaIndustrialApiary MTE, double timePassed) {
            this.drops.forEach(d -> {
                MTE.dropProgress.merge(d.id, d.getAmount(timePassed / 550.0), Double::sum);
                if (!dropstacks.containsKey(d.id)) {
                    dropstacks.put(d.id, d.stack);
                }
            });
            this.specialDrops.forEach(d -> {
                MTE.dropProgress.merge(d.id, d.getAmount(timePassed / 550.0), Double::sum);
                if (!dropstacks.containsKey(d.id)) {
                    dropstacks.put(d.id, d.stack);
                }
            });
            ArrayList<ItemStack> currentDrops = new ArrayList<ItemStack>();
            MTE.dropProgress.entrySet().forEach(e -> {
                double v = (Double)e.getValue();
                while (v > 1.0) {
                    int size = Math.min((int)v, 64);
                    ItemStack stack = dropstacks.get(e.getKey()).func_77946_l();
                    stack.field_77994_a = size;
                    currentDrops.add(stack);
                    e.setValue(v -= (double)size);
                }
            });
            return currentDrops;
        }

        public ItemStack createIgnobleCopy() {
            IBee princess = BeeManager.beeRoot.getMember(this.queenStack);
            princess.setIsNatural(false);
            return BeeManager.beeRoot.getMemberStack((IIndividual)princess, EnumBeeType.PRINCESS.ordinal());
        }

        public void updateTVar(World world, float t) {
            if (mode == null) {
                mode = BeeManager.beeRoot.getBeekeepingMode(world);
            }
            this.drops.forEach(d -> d.updateTVar(t));
            this.specialDrops.forEach(d -> d.updateTVar(t));
        }

        static {
            dropstacks = new HashMap<GTUtility.ItemId, ItemStack>();
        }

        private static class BeeDrop {
            private static final float MAX_PRODUCTION_MODIFIER_FROM_UPGRADES = 17.199268f;
            final ItemStack stack;
            double amount;
            final GTUtility.ItemId id;
            final float chance;
            final float beeSpeed;
            float t;

            public BeeDrop(ItemStack stack, float chance, float beeSpeed, float t) {
                this.stack = stack;
                this.chance = chance;
                this.beeSpeed = beeSpeed;
                this.t = t;
                this.id = GTUtility.ItemId.createNoCopy(this.stack);
                this.evaluate();
            }

            public void updateTVar(float t) {
                if (this.t != t) {
                    this.t = t;
                    this.evaluate();
                }
            }

            public void evaluate() {
                this.amount = Bee.getFinalChance((float)this.chance, (float)this.beeSpeed, (float)(17.199268f + mode.getBeeModifier().getProductionModifier(null, 17.199268f)), (float)this.t);
            }

            public double getAmount(double speedModifier) {
                return this.amount * speedModifier;
            }

            public ItemStack get(int amount) {
                ItemStack r = this.stack.func_77946_l();
                r.field_77994_a = amount;
                return r;
            }

            public BeeDrop(NBTTagCompound tag) {
                this.stack = ItemUtils.readItemStackFromNBT(tag.func_74775_l("stack"));
                this.chance = tag.func_74760_g("chance");
                this.beeSpeed = tag.func_74760_g("beeSpeed");
                this.t = tag.func_74760_g("t");
                this.amount = tag.func_74769_h("amount");
                this.id = GTUtility.ItemId.createNoCopy(this.stack);
            }

            public NBTTagCompound toNBTTagCompound() {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("stack", (NBTBase)ItemUtils.writeItemStackToNBT(this.stack));
                tag.func_74776_a("chance", this.chance);
                tag.func_74776_a("beeSpeed", this.beeSpeed);
                tag.func_74776_a("t", this.t);
                tag.func_74780_a("amount", this.amount);
                return tag;
            }

            public int hashCode() {
                return this.id.hashCode();
            }
        }
    }

    private static class KT_ModulaUIContainer_MegaIndustrialApiary
    extends ModularUIContainer {
        final WeakReference<MTEMegaIndustrialApiary> parent;

        public KT_ModulaUIContainer_MegaIndustrialApiary(ModularUIContext context, ModularWindow mainWindow, MTEMegaIndustrialApiary mte) {
            super(context, mainWindow);
            this.parent = new WeakReference<MTEMegaIndustrialApiary>(mte);
        }

        public ItemStack func_82846_b(EntityPlayer aPlayer, int aSlotIndex) {
            if (!(aPlayer instanceof EntityPlayerMP)) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            Slot s = this.func_75139_a(aSlotIndex);
            if (s == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (aSlotIndex >= 36) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            ItemStack aStack = s.func_75211_c();
            if (aStack == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            MTEMegaIndustrialApiary mte = (MTEMegaIndustrialApiary)this.parent.get();
            if (mte == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (mte.mStorage.size() >= mte.mMaxSlots) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (BeeManager.beeRoot.getType(aStack) == EnumBeeType.QUEEN) {
                if (mte.mMaxProgresstime > 0) {
                    GTUtility.sendChatToPlayer(aPlayer, EnumChatFormatting.RED + "Can't insert while running !");
                    return super.func_82846_b(aPlayer, aSlotIndex);
                }
                World w = mte.getBaseMetaTileEntity().getWorld();
                float t = (float)mte.getVoltageTierExact();
                BeeSimulator bs = new BeeSimulator(aStack, w, t);
                if (bs.isValid) {
                    mte.mStorage.add(bs);
                    s.func_75215_d(null);
                    this.func_75142_b();
                    mte.isCacheDirty = true;
                    return null;
                }
            }
            return super.func_82846_b(aPlayer, aSlotIndex);
        }
    }
}

